/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui.profile.filter;

import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Scene;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.stage.Stage;
import jrm.fx.ui.misc.Settings;
import jrm.profile.data.Anyware;
import jrm.profile.data.AnywareList;
import jrm.profile.filter.Keywords;
import jrm.security.Session;
import jrm.security.Sessions;

public class KeywordsController
implements Initializable {
    @FXML
    Scene sceneKW;
    @FXML
    ListView<String> listAvailKW;
    @FXML
    ListView<String> listUsedKW;
    private Session session;
    Keywords.KFCallBack callback;
    AnywareList<? extends Anyware> awlist;
    private final ObjectProperty<ListCell<String>> dragSource = new SimpleObjectProperty();

    public void initialize(URL location, ResourceBundle resources) {
        this.session = Sessions.getSingleSession();
        EventHandler dragDetected = event -> {
            ListView list = (ListView)event.getSource();
            Dragboard db = list.startDragAndDrop(TransferMode.ANY);
            ClipboardContent content = new ClipboardContent();
            content.putString((String)list.getSelectionModel().getSelectedItem());
            db.setContent((Map)content);
            event.consume();
        };
        EventHandler dragOver = event -> {
            if (event.getGestureSource() != event.getTarget() && event.getDragboard().hasString()) {
                event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            }
            event.consume();
        };
        EventHandler dragDropped = event -> {
            ListView list = (ListView)event.getGestureTarget();
            Dragboard db = event.getDragboard();
            boolean success = false;
            if (db.hasString()) {
                list.getItems().add((Object)db.getString());
                success = true;
            }
            event.setDropCompleted(success);
            event.consume();
        };
        EventHandler dragDone = event -> {
            if (event.getTransferMode() == TransferMode.MOVE) {
                ListView list = (ListView)event.getGestureSource();
                list.getItems().remove((Object)event.getDragboard().getString());
            }
            event.consume();
        };
        this.listAvailKW.setOnDragDetected(dragDetected);
        this.listAvailKW.setOnDragOver(dragOver);
        this.listAvailKW.setOnDragDropped(dragDropped);
        this.listAvailKW.setOnDragDone(dragDone);
        this.listUsedKW.setOnDragDetected(dragDetected);
        this.listUsedKW.setOnDragOver(dragOver);
        this.listUsedKW.setOnDragDropped(dragDropped);
        this.listUsedKW.setOnDragDone(dragDone);
    }

    @FXML
    public void onClose() {
        Stage stage = (Stage)this.sceneKW.getWindow();
        this.session.getUser().getSettings().setProperty("Keywords.Bounds", Settings.toJson(stage));
        stage.hide();
    }

    @FXML
    public void onFilter() {
        this.callback.call(this.awlist, (List)this.listUsedKW.getItems());
        this.sceneKW.getWindow().hide();
    }

    void initKeywords(String[] keywords) {
        this.listAvailKW.setItems(FXCollections.observableArrayList((Object[])keywords));
    }
}

