/*
 * Decompiled with CFR 0.152.
 */
package jtrrntzip;

import java.io.IOException;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import jtrrntzip.LogCallback;
import jtrrntzip.TrrntZipStatus;
import jtrrntzip.ZippedFile;
import jtrrntzip.supportedfiles.ICompress;
import org.apache.commons.io.FilenameUtils;

public final class TorrentZipRebuild {
    private TorrentZipRebuild() {
        throw new IllegalStateException("Utility class");
    }

    public static final Set<TrrntZipStatus> reZipFiles(List<ZippedFile> zippedFiles, ICompress originalZipFile, byte[] buffer, LogCallback logCallback) {
        if (originalZipFile == null) {
            throw new IllegalArgumentException("original zip file is <null>");
        }
        Path filename = Path.of(originalZipFile.zipFilename(), new String[0]);
        Path tmpFilename = filename.getParent().resolve(FilenameUtils.getBaseName((String)filename.getFileName().toString()) + ".tmp");
        Path outfilename = filename.getParent().resolve(FilenameUtils.getBaseName((String)filename.getFileName().toString()) + ".zip");
        try {
            return TorrentZipRebuild.reZipFiles(zippedFiles, originalZipFile, buffer, logCallback, filename, tmpFilename, outfilename);
        }
        catch (Exception e) {
            Optional.ofNullable(originalZipFile).ifPresent(t -> {
                try {
                    t.zipFileClose();
                    t.close();
                }
                catch (IOException e1) {
                    System.err.println(e1.getMessage());
                }
            });
            return EnumSet.of(TrrntZipStatus.CORRUPTZIP);
        }
    }

    /*
     * Exception decompiling
     */
    private static Set<TrrntZipStatus> reZipFiles(List<ZippedFile> zippedFiles, ICompress originalZipFile, byte[] buffer, LogCallback logCallback, Path filename, Path tmpFilename, Path outfilename) throws IOException, Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[FORLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

