/*
 * Decompiled with CFR 0.152.
 */
package jtrrntzip.supportedfiles.zipfile;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import jtrrntzip.ZipReturn;
import jtrrntzip.supportedfiles.EnhancedSeekableByteChannel;
import jtrrntzip.supportedfiles.UnsignedTypes;
import org.apache.commons.io.input.BoundedInputStream;

public final class LocalFile
implements Closeable,
AutoCloseable {
    private BigInteger compressedSize;
    private int compressionMethod;
    private long crc32Location;
    private long dataLocation;
    private long extraLocation;
    private int generalPurposeBitFlag;
    private int lastModFileDate;
    private int lastModFileTime;
    private InputStream readStream;
    private boolean trrntZip;
    private BigInteger uncompressedSize;
    private OutputStream writeStream;
    private byte[] crc;
    private final EnhancedSeekableByteChannel esbc;
    private String fileName;
    private ZipReturn fileStatus = ZipReturn.ZIPUNTESTED;
    private BigInteger relativeOffsetOfLocalHeader;
    private boolean zip64;

    public LocalFile(EnhancedSeekableByteChannel esbc) {
        this.esbc = esbc;
    }

    public LocalFile(EnhancedSeekableByteChannel esbc, String filename) {
        this.zip64 = false;
        this.esbc = esbc;
        this.generalPurposeBitFlag = 2;
        this.compressionMethod = 8;
        this.lastModFileTime = 48128;
        this.lastModFileDate = 8600;
        this.fileName = filename;
    }

    /*
     * WARNING - void declaration
     */
    public final void centeralDirectoryWrite(EnhancedSeekableByteChannel esbc) throws IOException {
        void var11_23;
        long cdRelativeOffsetOfLocalHeader;
        long cdCompressedSize;
        long cdUncompressedSize;
        int header = 33639248;
        ArrayList<Byte> extraField = new ArrayList<Byte>();
        if (this.getUncompressedSize().compareTo(BigInteger.valueOf(0xFFFFFFFFL)) >= 0) {
            this.zip64 = true;
            cdUncompressedSize = 0xFFFFFFFFL;
            for (byte b : ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(UnsignedTypes.fromULong(this.getUncompressedSize())).array()) {
                extraField.add(b);
            }
        } else {
            cdUncompressedSize = UnsignedTypes.fromULong(this.getUncompressedSize());
        }
        if (this.compressedSize.compareTo(BigInteger.valueOf(0xFFFFFFFFL)) >= 0) {
            this.zip64 = true;
            cdCompressedSize = 0xFFFFFFFFL;
            for (byte by : ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(UnsignedTypes.fromULong(this.compressedSize)).array()) {
                extraField.add(by);
            }
        } else {
            cdCompressedSize = UnsignedTypes.fromULong(this.compressedSize);
        }
        if (this.getRelativeOffsetOfLocalHeader().compareTo(BigInteger.valueOf(0xFFFFFFFFL)) >= 0) {
            this.zip64 = true;
            cdRelativeOffsetOfLocalHeader = 0xFFFFFFFFL;
            for (byte by : ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(UnsignedTypes.fromULong(this.getRelativeOffsetOfLocalHeader())).array()) {
                extraField.add(by);
            }
        } else {
            cdRelativeOffsetOfLocalHeader = UnsignedTypes.fromULong(this.getRelativeOffsetOfLocalHeader());
        }
        if (!extraField.isEmpty()) {
            int exfl = extraField.size();
            boolean bl = false;
            for (byte b : ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(UnsignedTypes.fromUShort(1)).array()) {
                void var11_19;
                extraField.add((int)(++var11_19), b);
            }
            for (byte b : ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(UnsignedTypes.fromUShort(exfl)).array()) {
                void var11_20;
                extraField.add((int)(++var11_20), b);
            }
        }
        int extraFieldLength = extraField.size();
        if (!StandardCharsets.US_ASCII.newEncoder().canEncode(this.getFileName())) {
            this.generalPurposeBitFlag = this.getGeneralPurposeBitFlag() | 0x800;
            byte[] byArray = this.getFileName().getBytes(StandardCharsets.UTF_8);
        } else {
            byte[] byArray = this.getFileName().getBytes(StandardCharsets.US_ASCII);
        }
        int fileNameLength = ((void)var11_23).length;
        int n = this.isZip64() ? 45 : 20;
        esbc.putInt(33639248);
        esbc.putUShort(0);
        esbc.putUShort(n);
        esbc.putUShort(this.getGeneralPurposeBitFlag());
        esbc.putUShort(this.compressionMethod);
        esbc.putUShort(this.lastModFileTime);
        esbc.putUShort(this.lastModFileDate);
        esbc.put(this.getCrc());
        esbc.putUInt(cdCompressedSize);
        esbc.putUInt(cdUncompressedSize);
        esbc.putUShort(fileNameLength);
        esbc.putUShort(extraFieldLength);
        esbc.putUShort(0);
        esbc.putUShort(0);
        esbc.putUShort(0);
        esbc.putUInt(0L);
        esbc.putUInt(cdRelativeOffsetOfLocalHeader);
        esbc.put((byte[])var11_23);
        Iterator iterator = extraField.iterator();
        while (iterator.hasNext()) {
            byte b;
            b = (Byte)iterator.next();
            esbc.put(b);
        }
    }

    public final ZipReturn centralDirectoryRead() {
        try {
            int thisSignature = this.esbc.getInt();
            if (thisSignature != 33639248) {
                return ZipReturn.ZIPCENTRALDIRERROR;
            }
            this.esbc.getUShort();
            this.esbc.getUShort();
            this.generalPurposeBitFlag = this.esbc.getUShort();
            this.compressionMethod = this.esbc.getUShort();
            if (this.compressionMethod != 8 && this.compressionMethod != 0) {
                return ZipReturn.ZIPUNSUPPORTEDCOMPRESSION;
            }
            this.lastModFileTime = this.esbc.getUShort();
            this.lastModFileDate = this.esbc.getUShort();
            this.crc = this.readCRC(this.esbc);
            this.compressedSize = BigInteger.valueOf(this.esbc.getUInt());
            this.uncompressedSize = BigInteger.valueOf(this.esbc.getUInt());
            int fileNameLength = this.esbc.getUShort();
            int extraFieldLength = this.esbc.getUShort();
            int fileCommentLength = this.esbc.getUShort();
            this.esbc.getUShort();
            this.esbc.getUShort();
            this.esbc.getUInt();
            this.relativeOffsetOfLocalHeader = BigInteger.valueOf(this.esbc.getUInt());
            byte[] bFileName = new byte[fileNameLength];
            this.esbc.get(bFileName);
            this.fileName = (this.getGeneralPurposeBitFlag() & 0x800) == 0 ? new String(bFileName, StandardCharsets.US_ASCII) : new String(bFileName, StandardCharsets.UTF_8);
            byte[] extraField = new byte[extraFieldLength];
            this.esbc.get(extraField);
            this.esbc.position(this.esbc.position() + (long)fileCommentLength);
            ByteBuffer bb = ByteBuffer.wrap(extraField).order(ByteOrder.LITTLE_ENDIAN);
            block6: while (extraFieldLength > bb.position()) {
                int type = UnsignedTypes.toUShort(bb.getShort());
                int blockLength = UnsignedTypes.toUShort(bb.getShort());
                switch (type) {
                    case 1: {
                        this.zip64 = true;
                        if (this.getUncompressedSize().longValue() == 0xFFFFFFFFL) {
                            this.uncompressedSize = UnsignedTypes.toULong(bb.getLong());
                        }
                        if (this.compressedSize.longValue() == 0xFFFFFFFFL) {
                            this.compressedSize = UnsignedTypes.toULong(bb.getLong());
                        }
                        if (this.getRelativeOffsetOfLocalHeader().longValue() != 0xFFFFFFFFL) continue block6;
                        this.relativeOffsetOfLocalHeader = UnsignedTypes.toULong(bb.getLong());
                        continue block6;
                    }
                    case 28789: {
                        byte version = bb.get();
                        long nameCRC32 = UnsignedTypes.toUInt(bb.getInt());
                        CRC32 crcTest = new CRC32();
                        crcTest.update(bFileName);
                        long fCRC = crcTest.getValue();
                        if (nameCRC32 != fCRC) {
                            return ZipReturn.ZIPCENTRALDIRERROR;
                        }
                        int charLen = blockLength - 5;
                        byte[] dst = new byte[charLen];
                        bb.get(dst);
                        this.fileName = new String(dst, StandardCharsets.UTF_8);
                        continue block6;
                    }
                }
                bb.position(bb.position() + blockLength);
            }
            return ZipReturn.ZIPGOOD;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return ZipReturn.ZIPCENTRALDIRERROR;
        }
    }

    @Override
    public final void close() throws IOException {
        if (this.esbc != null) {
            this.esbc.close();
        }
    }

    public final void localFileAddDirectory() throws IOException {
        this.esbc.put((byte)3);
        this.esbc.put((byte)0);
    }

    public final void localFileCheck() {
        if (this.getFileStatus() != ZipReturn.ZIPUNTESTED) {
            return;
        }
        try {
            InputStream sInput = null;
            this.esbc.position(this.dataLocation);
            switch (this.compressionMethod) {
                case 8: {
                    sInput = new InflaterInputStream(this.esbc.getInputStream(), new Inflater(true));
                    break;
                }
                default: {
                    sInput = this.esbc.getInputStream();
                }
            }
            if (sInput == null) {
                this.fileStatus = ZipReturn.ZIPERRORGETTINGDATASTREAM;
                return;
            }
            int Buffersize = 8192;
            byte[] buffer = new byte[8192];
            BigInteger sizetogo = this.getUncompressedSize();
            CRC32 tcrc32 = new CRC32();
            int sizeNext = sizetogo.compareTo(BigInteger.valueOf(8192L)) > 0 ? 8192 : sizetogo.intValue();
            int sizebuffer = sInput.read(buffer, 0, sizeNext);
            sizetogo = sizetogo.subtract(BigInteger.valueOf(sizebuffer));
            while (sizebuffer > 0) {
                sizeNext = sizetogo.compareTo(BigInteger.valueOf(8192L)) > 0 ? 8192 : sizetogo.intValue();
                if (sizeNext <= 0 || (sizebuffer = sInput.read(buffer, 0, sizeNext)) <= 0) continue;
                tcrc32.update(buffer, 0, sizebuffer);
                sizetogo = sizetogo.subtract(BigInteger.valueOf(sizebuffer));
            }
            if (sizetogo.longValue() > 0L) {
                this.fileStatus = ZipReturn.ZIPDECODEERROR;
                return;
            }
            byte[] testcrc = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(UnsignedTypes.fromUInt(tcrc32.getValue())).array();
            this.fileStatus = Arrays.equals(this.getCrc(), testcrc) ? ZipReturn.ZIPGOOD : ZipReturn.ZIPCRCDECODEERROR;
        }
        catch (Exception e) {
            this.fileStatus = ZipReturn.ZIPDECODEERROR;
        }
    }

    public final ZipReturn localFileCloseReadStream() throws IOException {
        InputStream dfStream = this.readStream;
        if (dfStream != null) {
            // empty if block
        }
        return ZipReturn.ZIPGOOD;
    }

    public final ZipReturn localFileCloseWriteStream(byte[] crc32) throws IOException {
        OutputStream dfStream = this.writeStream;
        if (dfStream != null) {
            dfStream.flush();
        }
        this.compressedSize = BigInteger.valueOf(this.esbc.position() - this.dataLocation);
        if (this.compressedSize.longValue() == 0L && this.getUncompressedSize().longValue() == 0L) {
            this.localFileAddDirectory();
            this.compressedSize = BigInteger.valueOf(this.esbc.position() - this.dataLocation);
        }
        this.crc = crc32;
        this.writeCompressedSize();
        return ZipReturn.ZIPGOOD;
    }

    public final ZipReturn localFileHeaderRead() {
        try {
            int tshort;
            this.trrntZip = true;
            this.esbc.position(this.getRelativeOffsetOfLocalHeader().longValueExact());
            int thisSignature = this.esbc.getInt();
            if (thisSignature != 67324752) {
                return ZipReturn.ZIPLOCALFILEHEADERERROR;
            }
            this.esbc.getUShort();
            int generalPurposeBitFlagLocal = this.esbc.getUShort();
            if (generalPurposeBitFlagLocal != this.getGeneralPurposeBitFlag()) {
                this.trrntZip = false;
            }
            if ((tshort = this.esbc.getUShort()) != this.compressionMethod) {
                return ZipReturn.ZIPLOCALFILEHEADERERROR;
            }
            tshort = this.esbc.getUShort();
            if (tshort != this.lastModFileTime) {
                return ZipReturn.ZIPLOCALFILEHEADERERROR;
            }
            tshort = this.esbc.getUShort();
            if (tshort != this.lastModFileDate) {
                return ZipReturn.ZIPLOCALFILEHEADERERROR;
            }
            byte[] tCRC = this.readCRC(this.esbc);
            if ((this.getGeneralPurposeBitFlag() & 8) == 0 && !Arrays.equals(tCRC, this.getCrc())) {
                return ZipReturn.ZIPLOCALFILEHEADERERROR;
            }
            long tCompressedSize = this.esbc.getUInt();
            if (this.isZip64() && tCompressedSize != 0xFFFFFFFFL && tCompressedSize != this.compressedSize.longValue()) {
                return ZipReturn.ZIPLOCALFILEHEADERERROR;
            }
            if ((this.getGeneralPurposeBitFlag() & 8) == 8 && tCompressedSize != 0L) {
                return ZipReturn.ZIPLOCALFILEHEADERERROR;
            }
            if (!this.isZip64() && (this.getGeneralPurposeBitFlag() & 8) != 8 && tCompressedSize != this.compressedSize.longValue()) {
                return ZipReturn.ZIPLOCALFILEHEADERERROR;
            }
            long tUnCompressedSize = this.esbc.getUInt();
            if (this.isZip64() && tUnCompressedSize != 0xFFFFFFFFL && tUnCompressedSize != this.getUncompressedSize().longValue()) {
                return ZipReturn.ZIPLOCALFILEHEADERERROR;
            }
            if ((this.getGeneralPurposeBitFlag() & 8) == 8 && tUnCompressedSize != 0L) {
                return ZipReturn.ZIPLOCALFILEHEADERERROR;
            }
            if (!this.isZip64() && (this.getGeneralPurposeBitFlag() & 8) != 8 && tUnCompressedSize != this.getUncompressedSize().longValue()) {
                return ZipReturn.ZIPLOCALFILEHEADERERROR;
            }
            int fileNameLength = this.esbc.getUShort();
            int extraFieldLength = this.esbc.getUShort();
            byte[] bFileName = new byte[fileNameLength];
            this.esbc.get(bFileName);
            String tFileName = (generalPurposeBitFlagLocal & 0x800) == 0 ? new String(bFileName, StandardCharsets.US_ASCII) : new String(bFileName, StandardCharsets.UTF_8);
            byte[] extraField = new byte[extraFieldLength];
            this.esbc.get(extraField);
            this.zip64 = false;
            ByteBuffer bb = ByteBuffer.wrap(extraField).order(ByteOrder.LITTLE_ENDIAN);
            block6: while (extraFieldLength > bb.position()) {
                int type = UnsignedTypes.toUShort(bb.getShort());
                int blockLength = UnsignedTypes.toUShort(bb.getShort());
                switch (type) {
                    case 1: {
                        BigInteger tLong;
                        this.zip64 = true;
                        if (tUnCompressedSize == 0xFFFFFFFFL && (tLong = UnsignedTypes.toULong(bb.getLong())).compareTo(this.getUncompressedSize()) != 0) {
                            return ZipReturn.ZIPLOCALFILEHEADERERROR;
                        }
                        if (tCompressedSize != 0xFFFFFFFFL || (tLong = UnsignedTypes.toULong(bb.getLong())).compareTo(this.compressedSize) == 0) continue block6;
                        return ZipReturn.ZIPLOCALFILEHEADERERROR;
                    }
                    case 28789: {
                        byte version = bb.get();
                        long nameCRC32 = UnsignedTypes.toUInt(bb.getInt());
                        CRC32 crcTest = new CRC32();
                        crcTest.update(bFileName);
                        long fCRC = crcTest.getValue();
                        if (nameCRC32 != fCRC) {
                            return ZipReturn.ZIPLOCALFILEHEADERERROR;
                        }
                        int charLen = blockLength - 5;
                        byte[] dst = new byte[charLen];
                        bb.get(dst);
                        this.fileName = new String(dst, StandardCharsets.UTF_8);
                        break;
                    }
                    default: {
                        bb.position(bb.position() + blockLength);
                    }
                }
            }
            if (!this.getFileName().equals(tFileName)) {
                return ZipReturn.ZIPLOCALFILEHEADERERROR;
            }
            this.dataLocation = this.esbc.position();
            if ((this.getGeneralPurposeBitFlag() & 8) == 0) {
                return ZipReturn.ZIPGOOD;
            }
            this.esbc.position(this.esbc.position() + this.compressedSize.longValue());
            tCRC = this.readCRC(this.esbc);
            if (Arrays.equals(tCRC, new byte[]{80, 75, 7, 8})) {
                tCRC = this.readCRC(this.esbc);
            }
            if (!Arrays.equals(tCRC, this.getCrc())) {
                return ZipReturn.ZIPLOCALFILEHEADERERROR;
            }
            long tint = this.esbc.getUInt();
            if (tint != this.compressedSize.longValue()) {
                return ZipReturn.ZIPLOCALFILEHEADERERROR;
            }
            tint = this.esbc.getUInt();
            if (tint != this.getUncompressedSize().longValue()) {
                return ZipReturn.ZIPLOCALFILEHEADERERROR;
            }
            return ZipReturn.ZIPGOOD;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return ZipReturn.ZIPLOCALFILEHEADERERROR;
        }
    }

    public final ZipReturn localFileHeaderReadQuick() {
        try {
            this.trrntZip = true;
            this.esbc.position(this.getRelativeOffsetOfLocalHeader().longValue());
            int thisSignature = this.esbc.getInt();
            if (thisSignature != 67324752) {
                return ZipReturn.ZIPLOCALFILEHEADERERROR;
            }
            this.esbc.getShort();
            this.generalPurposeBitFlag = this.esbc.getUShort();
            if ((this.getGeneralPurposeBitFlag() & 8) == 8) {
                return ZipReturn.ZIPCANNOTFASTOPEN;
            }
            this.compressionMethod = this.esbc.getUShort();
            this.lastModFileTime = this.esbc.getUShort();
            this.lastModFileDate = this.esbc.getUShort();
            this.crc = this.readCRC(this.esbc);
            this.compressedSize = BigInteger.valueOf(this.esbc.getUInt());
            this.uncompressedSize = BigInteger.valueOf(this.esbc.getUInt());
            int fileNameLength = this.esbc.getUShort();
            int extraFieldLength = this.esbc.getUShort();
            byte[] bFileName = new byte[fileNameLength];
            this.esbc.get(bFileName);
            String tFileName = (this.getGeneralPurposeBitFlag() & 0x800) == 0 ? new String(bFileName, StandardCharsets.US_ASCII) : new String(bFileName, StandardCharsets.UTF_8);
            byte[] extraField = new byte[extraFieldLength];
            this.esbc.get(extraField);
            this.zip64 = false;
            ByteBuffer bb = ByteBuffer.wrap(extraField).order(ByteOrder.LITTLE_ENDIAN);
            block6: while (extraFieldLength > bb.position()) {
                int type = UnsignedTypes.toUShort(bb.getShort());
                int blockLength = UnsignedTypes.toUShort(bb.getShort());
                switch (type) {
                    case 1: {
                        this.zip64 = true;
                        if (this.getUncompressedSize().compareTo(BigInteger.valueOf(0xFFFFFFFFL)) == 0) {
                            this.uncompressedSize = UnsignedTypes.toULong(bb.getLong());
                        }
                        if (this.compressedSize.compareTo(BigInteger.valueOf(0xFFFFFFFFL)) != 0) continue block6;
                        this.compressedSize = UnsignedTypes.toULong(bb.getLong());
                        continue block6;
                    }
                    case 28789: {
                        byte version = bb.get();
                        long nameCRC32 = UnsignedTypes.toUInt(bb.getInt());
                        CRC32 crcTest = new CRC32();
                        crcTest.update(bFileName);
                        long fCRC = crcTest.getValue();
                        if (nameCRC32 != fCRC) {
                            return ZipReturn.ZIPLOCALFILEHEADERERROR;
                        }
                        int charLen = blockLength - 5;
                        byte[] dst = new byte[charLen];
                        bb.get(dst);
                        this.fileName = new String(dst, StandardCharsets.UTF_8);
                        continue block6;
                    }
                }
                bb.position(bb.position() + blockLength);
            }
            this.dataLocation = this.esbc.position();
            return ZipReturn.ZIPGOOD;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return ZipReturn.ZIPLOCALFILEHEADERERROR;
        }
    }

    private final void localFileHeaderWrite() throws IOException {
        byte[] bFileName;
        ArrayList<Byte> extraField = new ArrayList<Byte>();
        boolean bl = this.zip64 = this.getUncompressedSize().compareTo(BigInteger.valueOf(0xFFFFFFFFL)) >= 0;
        if (!StandardCharsets.US_ASCII.newEncoder().canEncode(this.getFileName())) {
            this.generalPurposeBitFlag = this.getGeneralPurposeBitFlag() | 0x800;
            bFileName = this.getFileName().getBytes(StandardCharsets.UTF_8);
        } else {
            bFileName = this.getFileName().getBytes(StandardCharsets.US_ASCII);
        }
        int versionNeededToExtract = this.isZip64() ? 45 : 20;
        this.relativeOffsetOfLocalHeader = BigInteger.valueOf(this.esbc.position());
        int header = 67324752;
        this.esbc.putUInt(67324752L);
        this.esbc.putUShort(versionNeededToExtract);
        this.esbc.putUShort(this.getGeneralPurposeBitFlag());
        this.esbc.putUShort(this.compressionMethod);
        this.esbc.putUShort(this.lastModFileTime);
        this.esbc.putUShort(this.lastModFileDate);
        this.crc32Location = this.esbc.position();
        this.esbc.putUInt(0xFFFFFFFFL);
        this.esbc.putUInt(0xFFFFFFFFL);
        this.esbc.putUInt(0xFFFFFFFFL);
        if (this.isZip64()) {
            for (int i = 0; i < 20; ++i) {
                extraField.add((byte)0);
            }
        }
        int fileNameLength = bFileName.length;
        this.esbc.putUShort(fileNameLength);
        int extraFieldLength = extraField.size();
        this.esbc.putUShort(extraFieldLength);
        this.esbc.put(bFileName);
        this.extraLocation = this.esbc.position();
        Iterator iterator = extraField.iterator();
        while (iterator.hasNext()) {
            byte b = (Byte)iterator.next();
            this.esbc.put(b);
        }
    }

    public final ZipReturn localFileOpenReadStream(boolean raw, AtomicReference<InputStream> stream, AtomicReference<BigInteger> streamSize, AtomicInteger cMethod, AtomicReference<Inflater> inflater) throws IOException {
        streamSize.set(BigInteger.valueOf(0L));
        cMethod.set(this.compressionMethod);
        this.readStream = null;
        this.esbc.position(this.dataLocation);
        switch (this.compressionMethod) {
            case 8: {
                if (raw) {
                    this.readStream = new BoundedInputStream(this.esbc.getInputStream(), this.compressedSize.longValue());
                    streamSize.set(this.compressedSize);
                    break;
                }
                if (inflater.get() == null) {
                    inflater.set(new Inflater(true));
                } else {
                    inflater.get().reset();
                }
                this.readStream = new InflaterInputStream(this.esbc.getInputStream(), inflater.get());
                streamSize.set(this.getUncompressedSize());
                break;
            }
            default: {
                this.readStream = new BoundedInputStream(this.esbc.getInputStream(), this.compressedSize.longValue());
                streamSize.set(this.compressedSize);
            }
        }
        stream.set(this.readStream);
        return stream.get() == null ? ZipReturn.ZIPERRORGETTINGDATASTREAM : ZipReturn.ZIPGOOD;
    }

    public final ZipReturn localFileOpenWriteStream(boolean raw, boolean tZip, BigInteger uSize, int cMethod, AtomicReference<OutputStream> stream, AtomicReference<Deflater> deflater) throws IOException {
        this.uncompressedSize = uSize;
        this.compressionMethod = cMethod;
        this.localFileHeaderWrite();
        this.dataLocation = this.esbc.position();
        if (raw) {
            this.writeStream = this.esbc.getOutputStream();
            this.trrntZip = tZip;
        } else if (cMethod == 0) {
            this.writeStream = this.esbc.getOutputStream();
            this.trrntZip = false;
        } else {
            if (deflater.get() == null) {
                deflater.set(new Deflater(9, true));
            } else {
                deflater.get().reset();
            }
            this.writeStream = new DeflaterOutputStream(this.esbc.getOutputStream(), deflater.get(), false);
            this.trrntZip = true;
        }
        stream.set(this.writeStream);
        return stream.get() == null ? ZipReturn.ZIPERRORGETTINGDATASTREAM : ZipReturn.ZIPGOOD;
    }

    public final BigInteger localFilePos() {
        return this.getRelativeOffsetOfLocalHeader();
    }

    public final void localFilePos(BigInteger value) {
        this.relativeOffsetOfLocalHeader = value;
    }

    private final byte[] readCRC(EnhancedSeekableByteChannel esbc) throws IOException {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(esbc.getInt()).array();
    }

    private final void writeCompressedSize() throws IOException {
        long tUncompressedSize;
        long tCompressedSize;
        long posNow = this.esbc.position();
        this.esbc.position(this.crc32Location);
        if (this.isZip64()) {
            tCompressedSize = 0xFFFFFFFFL;
            tUncompressedSize = 0xFFFFFFFFL;
        } else {
            tCompressedSize = this.compressedSize.longValue();
            tUncompressedSize = this.getUncompressedSize().longValue();
        }
        this.esbc.put(this.getCrc());
        this.esbc.putUInt(tCompressedSize);
        this.esbc.putUInt(tUncompressedSize);
        if (this.isZip64()) {
            this.esbc.position(this.extraLocation);
            this.esbc.putUShort(1);
            this.esbc.putUShort(16);
            this.esbc.putULong(this.getUncompressedSize());
            this.esbc.putULong(this.compressedSize);
        }
        this.esbc.position(posNow);
    }

    public byte[] getCrc() {
        return this.crc;
    }

    public String getFileName() {
        return this.fileName;
    }

    public ZipReturn getFileStatus() {
        return this.fileStatus;
    }

    public int getGeneralPurposeBitFlag() {
        return this.generalPurposeBitFlag;
    }

    public BigInteger getRelativeOffsetOfLocalHeader() {
        return this.relativeOffsetOfLocalHeader;
    }

    public BigInteger getUncompressedSize() {
        return this.uncompressedSize;
    }

    public boolean isZip64() {
        return this.zip64;
    }

    public boolean isTrrntZip() {
        return this.trrntZip;
    }
}

