/*
 * Decompiled with CFR 0.152.
 */
package jtrrntzip.supportedfiles.zipfile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import jtrrntzip.Messages;
import jtrrntzip.ZipOpenType;
import jtrrntzip.ZipReturn;
import jtrrntzip.ZipStatus;
import jtrrntzip.supportedfiles.EnhancedSeekableByteChannel;
import jtrrntzip.supportedfiles.ICompress;
import jtrrntzip.supportedfiles.zipfile.LocalFile;

public final class ZipFile
implements ICompress {
    static final int CENTRALDIRECTORYHEADERSIGNATURE = 33639248;
    private static final int ENDOFCENTRALDIRSIGNATURE = 101010256;
    static final int LOCALFILEHEADERSIGNATURE = 67324752;
    private static final int ZIP64ENDOFCENTRALDIRECTORYLOCATOR = 117853008;
    private static final int ZIP64ENDOFCENTRALDIRSIGNATURE = 101075792;
    private BigInteger centerDirSize;
    private BigInteger centerDirStart;
    private BigInteger endOfCenterDir64;
    private EnhancedSeekableByteChannel esbc;
    private byte[] fileComment;
    private final List<LocalFile> localFiles = new ArrayList<LocalFile>();
    private BigInteger localFilesCount;
    private EnumSet<ZipStatus> pZipStatus = EnumSet.noneOf(ZipStatus.class);
    private int readIndex;
    private boolean zip64;
    private File zipFileInfo = null;
    private final AtomicReference<Deflater> deflater = new AtomicReference();
    private final AtomicReference<Inflater> inflater = new AtomicReference();
    private ZipOpenType zipOpen = ZipOpenType.CLOSED;

    private static final void createDirForFile(File sFilename) {
        sFilename.getParentFile().mkdirs();
    }

    public static final String zipErrorMessageText(ZipReturn zS) {
        return switch (zS) {
            case ZipReturn.ZIPGOOD -> Messages.getString("ZipFile.ZIPGood");
            case ZipReturn.ZIPFILECOUNTERROR -> Messages.getString("ZipFile.ZIPFileCountError");
            case ZipReturn.ZIPSIGNATUREERROR -> Messages.getString("ZipFile.ZipSignatureError");
            case ZipReturn.ZIPEXTRADATAONENDOFZIP -> Messages.getString("ZipFile.ZipExtraDataOnEndOfZip");
            case ZipReturn.ZIPUNSUPPORTEDCOMPRESSION -> Messages.getString("ZipFile.ZipUnsipportedCompression");
            case ZipReturn.ZIPLOCALFILEHEADERERROR -> Messages.getString("ZipFile.ZipLocalFileHeaderError");
            case ZipReturn.ZIPCENTRALDIRERROR -> Messages.getString("ZipFile.ZipCentralDirError");
            case ZipReturn.ZIPREADINGFROMOUTPUTFILE -> Messages.getString("ZipFile.ZipReadingFromOutputFile");
            case ZipReturn.ZIPWRITINGTOINPUTFILE -> Messages.getString("ZipFile.ZipWritingToInputFile");
            case ZipReturn.ZIPERRORGETTINGDATASTREAM -> Messages.getString("ZipFile.ZipErrorGettingDataStream");
            case ZipReturn.ZIPCRCDECODEERROR -> Messages.getString("ZipFile.ZipCRCDecodeError");
            case ZipReturn.ZIPDECODEERROR -> Messages.getString("ZipFile.ZipDecodeError");
            default -> zS.toString();
        };
    }

    @Override
    public final void close() {
        if (this.deflater.get() != null) {
            this.deflater.get().end();
        }
        if (this.inflater.get() != null) {
            this.inflater.get().end();
        }
        if (this.esbc != null) {
            try {
                this.esbc.close();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    @Override
    public final byte[] crc32(int i) {
        return this.localFiles.get(i).getCrc();
    }

    @Override
    public final void deepScan() {
        for (LocalFile lfile : this.localFiles) {
            lfile.localFileCheck();
        }
    }

    private final ZipReturn endOfCentralDirRead() throws IOException {
        long thisSignature = this.esbc.getInt();
        if (thisSignature != 101010256L) {
            return ZipReturn.ZIPENDOFCENTRALDIRECTORYERROR;
        }
        int tushort = this.esbc.getUShort();
        if (tushort != 0) {
            return ZipReturn.ZIPENDOFCENTRALDIRECTORYERROR;
        }
        tushort = this.esbc.getUShort();
        if (tushort != 0) {
            return ZipReturn.ZIPENDOFCENTRALDIRECTORYERROR;
        }
        this.localFilesCount = BigInteger.valueOf(this.esbc.getUShort());
        tushort = this.esbc.getUShort();
        if (BigInteger.valueOf(tushort).compareTo(this.localFilesCount) != 0) {
            return ZipReturn.ZIPENDOFCENTRALDIRECTORYERROR;
        }
        this.centerDirSize = BigInteger.valueOf(this.esbc.getUInt());
        this.centerDirStart = BigInteger.valueOf(this.esbc.getUInt());
        int zipFileCommentLength = this.esbc.getUShort();
        this.fileComment = new byte[zipFileCommentLength];
        this.esbc.get(this.fileComment);
        if (this.esbc.position() != this.esbc.size()) {
            this.pZipStatus.add(ZipStatus.EXTRADATA);
        }
        return ZipReturn.ZIPGOOD;
    }

    private final void endOfCentralDirWrite() throws IOException {
        this.esbc.putUInt(101010256L);
        this.esbc.putUShort(0);
        this.esbc.putUShort(0);
        this.esbc.putUShort(this.localFiles.size() >= 65535 ? 65535 : this.localFiles.size());
        this.esbc.putUShort(this.localFiles.size() >= 65535 ? 65535 : this.localFiles.size());
        this.esbc.putUInt((this.centerDirSize.compareTo(BigInteger.valueOf(0xFFFFFFFFL)) >= 0 ? Long.valueOf(0xFFFFFFFFL) : this.centerDirSize).longValue());
        this.esbc.putUInt((this.centerDirStart.compareTo(BigInteger.valueOf(0xFFFFFFFFL)) >= 0 ? Long.valueOf(0xFFFFFFFFL) : this.centerDirStart).longValue());
        this.esbc.putUShort(this.fileComment.length);
        this.esbc.put(this.fileComment, 0, this.fileComment.length);
    }

    @Override
    public final String filename(int i) {
        return this.localFiles.get(i).getFileName();
    }

    @Override
    public final ZipReturn fileStatus(int i) {
        return this.localFiles.get(i).getFileStatus();
    }

    private final ZipReturn findEndOfCentralDirSignature() throws IOException {
        long fileSize = this.esbc.size();
        long maxBackSearch = 65535L;
        if (this.esbc.size() < maxBackSearch) {
            maxBackSearch = fileSize;
        }
        int buffSize = 1024;
        byte[] buffer = new byte[1028];
        long backPosition = 4L;
        while (backPosition < maxBackSearch) {
            if ((backPosition += 1024L) > maxBackSearch) {
                backPosition = maxBackSearch;
            }
            long readSize = backPosition > 1028L ? 1028L : backPosition;
            this.esbc.position(fileSize - backPosition);
            this.esbc.get(buffer, 0, (int)readSize);
            for (int i = (int)readSize - 4; i >= 0; --i) {
                if (buffer[i] != 80 || buffer[i + 1] != 75 || buffer[i + 2] != 5 || buffer[i + 3] != 6) continue;
                this.esbc.position(fileSize - backPosition + (long)i);
                return ZipReturn.ZIPGOOD;
            }
        }
        return ZipReturn.ZIPCENTRALDIRERROR;
    }

    @Override
    public final int localFilesCount() {
        return this.localFiles.size();
    }

    @Override
    public final BigInteger localHeader(int i) {
        return (this.localFiles.get(i).getGeneralPurposeBitFlag() & 8) == 0 ? this.localFiles.get(i).getRelativeOffsetOfLocalHeader() : null;
    }

    @Override
    public final long timeStamp() {
        return this.zipFileInfo != null ? this.zipFileInfo.lastModified() : 0L;
    }

    @Override
    public final BigInteger uncompressedSize(int i) {
        return this.localFiles.get(i).getUncompressedSize();
    }

    private final ZipReturn zip64EndOfCentralDirectoryLocatorRead() throws IOException {
        this.zip64 = true;
        long thisSignature = this.esbc.getUInt();
        if (thisSignature != 117853008L) {
            return ZipReturn.ZIPENDOFCENTRALDIRECTORYERROR;
        }
        long tuint = this.esbc.getUInt();
        if (tuint != 0L) {
            return ZipReturn.ZIP64ENDOFCENTRALDIRECTORYLOCATORERROR;
        }
        this.endOfCenterDir64 = this.esbc.getULong();
        tuint = this.esbc.getUInt();
        if (tuint != 1L) {
            return ZipReturn.ZIP64ENDOFCENTRALDIRECTORYLOCATORERROR;
        }
        return ZipReturn.ZIPGOOD;
    }

    private final void zip64EndOfCentralDirectoryLocatorWrite() throws IOException {
        this.esbc.putInt(117853008);
        this.esbc.putUInt(0L);
        this.esbc.putULong(this.endOfCenterDir64);
        this.esbc.putUInt(1L);
    }

    private final ZipReturn zip64EndOfCentralDirRead() throws IOException {
        this.zip64 = true;
        long thisSignature = this.esbc.getInt();
        if (thisSignature != 101075792L) {
            return ZipReturn.ZIPENDOFCENTRALDIRECTORYERROR;
        }
        BigInteger tulong = this.esbc.getULong();
        if (tulong.compareTo(BigInteger.valueOf(44L)) != 0) {
            return ZipReturn.ZIP64ENDOFCENTRALDIRERROR;
        }
        this.esbc.getShort();
        int tushort = this.esbc.getUShort();
        if (tushort != 45) {
            return ZipReturn.ZIP64ENDOFCENTRALDIRERROR;
        }
        long tuint = this.esbc.getUInt();
        if (tuint != 0L) {
            return ZipReturn.ZIP64ENDOFCENTRALDIRERROR;
        }
        tuint = this.esbc.getUInt();
        if (tuint != 0L) {
            return ZipReturn.ZIP64ENDOFCENTRALDIRERROR;
        }
        this.localFilesCount = this.esbc.getULong();
        tulong = this.esbc.getULong();
        if (tulong.compareTo(this.localFilesCount) != 0) {
            return ZipReturn.ZIP64ENDOFCENTRALDIRERROR;
        }
        this.centerDirSize = this.esbc.getULong();
        this.centerDirStart = this.esbc.getULong();
        return ZipReturn.ZIPGOOD;
    }

    private final void zip64EndOfCentralDirWrite() throws IOException {
        this.esbc.putInt(101075792);
        this.esbc.putULong(BigInteger.valueOf(44L));
        this.esbc.putUShort(45);
        this.esbc.putUShort(45);
        this.esbc.putUInt(0L);
        this.esbc.putUInt(0L);
        this.esbc.putULong(BigInteger.valueOf(this.localFiles.size()));
        this.esbc.putULong(BigInteger.valueOf(this.localFiles.size()));
        this.esbc.putULong(this.centerDirSize);
        this.esbc.putULong(this.centerDirStart);
    }

    @Override
    public final void zipFileAddDirectory() throws IOException {
        this.localFiles.get(this.localFiles.size() - 1).localFileAddDirectory();
    }

    @Override
    public final void zipFileClose() throws IOException {
        if (this.zipOpen == ZipOpenType.CLOSED) {
            return;
        }
        if (this.zipOpen == ZipOpenType.OPENREAD) {
            this.close();
            this.zipOpen = ZipOpenType.CLOSED;
            return;
        }
        this.zip64 = false;
        boolean lTrrntzip = true;
        this.centerDirStart = BigInteger.valueOf(this.esbc.position());
        if (this.centerDirStart.compareTo(BigInteger.valueOf(0xFFFFFFFFL)) >= 0) {
            this.zip64 = true;
        }
        this.esbc.startChecksum();
        for (LocalFile t : this.localFiles) {
            t.centeralDirectoryWrite(this.esbc);
            this.zip64 |= t.isZip64();
            lTrrntzip &= t.isTrrntZip();
        }
        this.centerDirSize = BigInteger.valueOf(this.esbc.position() - this.centerDirStart.longValue());
        this.fileComment = lTrrntzip ? String.format("TORRENTZIPPED-%08X", this.esbc.endChecksum()).getBytes(StandardCharsets.US_ASCII) : new byte[]{};
        EnumSet<ZipStatus> enumSet = this.pZipStatus = lTrrntzip ? EnumSet.of(ZipStatus.TRRNTZIP) : EnumSet.noneOf(ZipStatus.class);
        if (this.zip64) {
            this.endOfCenterDir64 = BigInteger.valueOf(this.esbc.position());
            this.zip64EndOfCentralDirWrite();
            this.zip64EndOfCentralDirectoryLocatorWrite();
        }
        this.endOfCentralDirWrite();
        this.esbc.truncate(this.esbc.position());
        this.close();
        this.zipOpen = ZipOpenType.CLOSED;
    }

    @Override
    public final void zipFileCloseFailed() throws IOException {
        if (this.zipOpen == ZipOpenType.CLOSED) {
            return;
        }
        if (this.zipOpen == ZipOpenType.OPENREAD) {
            this.close();
            this.zipOpen = ZipOpenType.CLOSED;
            return;
        }
        this.close();
        Files.deleteIfExists(this.zipFileInfo.toPath());
        this.zipFileInfo = null;
        this.zipOpen = ZipOpenType.CLOSED;
    }

    @Override
    public final ZipReturn zipFileCloseReadStream() throws IOException {
        return this.localFiles.get(this.readIndex).localFileCloseReadStream();
    }

    @Override
    public final ZipReturn zipFileCloseWriteStream(byte[] crc32) throws IOException {
        return this.localFiles.get(this.localFiles.size() - 1).localFileCloseWriteStream(crc32);
    }

    @Override
    public final ZipReturn zipFileCreate(File newFilename) throws IOException {
        if (this.zipOpen != ZipOpenType.CLOSED) {
            return ZipReturn.ZIPFILEALREADYOPEN;
        }
        ZipFile.createDirForFile(newFilename);
        this.zipFileInfo = newFilename;
        this.esbc = new EnhancedSeekableByteChannel(Files.newByteChannel(newFilename.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ), ByteOrder.LITTLE_ENDIAN);
        this.zipOpen = ZipOpenType.OPENWRITE;
        return ZipReturn.ZIPGOOD;
    }

    @Override
    public final String zipFilename() {
        return this.zipFileInfo != null ? this.zipFileInfo.getAbsolutePath() : "";
    }

    @Override
    public final ZipReturn zipFileOpen(File newFilename, long timestamp, boolean readHeaders) throws IOException {
        this.zipFileClose();
        this.pZipStatus = EnumSet.noneOf(ZipStatus.class);
        this.zip64 = false;
        this.centerDirStart = BigInteger.valueOf(0L);
        this.centerDirSize = BigInteger.valueOf(0L);
        this.zipFileInfo = null;
        try {
            if (!newFilename.exists()) {
                this.zipFileClose();
                return ZipReturn.ZIPERRORFILENOTFOUND;
            }
            this.zipFileInfo = newFilename;
            if (this.zipFileInfo.lastModified() != timestamp) {
                this.zipFileClose();
                return ZipReturn.ZIPERRORTIMESTAMP;
            }
            this.esbc = new EnhancedSeekableByteChannel(Files.newByteChannel(newFilename.toPath(), StandardOpenOption.READ), ByteOrder.LITTLE_ENDIAN);
        }
        catch (IOException e) {
            this.zipFileClose();
            return ZipReturn.ZIPERROROPENINGFILE;
        }
        this.zipOpen = ZipOpenType.OPENREAD;
        if (!readHeaders) {
            return ZipReturn.ZIPGOOD;
        }
        try {
            ZipReturn zRet = this.findEndOfCentralDirSignature();
            if (zRet != ZipReturn.ZIPGOOD) {
                this.zipFileClose();
                return zRet;
            }
            long endOfCentralDir = this.esbc.position();
            zRet = this.endOfCentralDirRead();
            if (zRet != ZipReturn.ZIPGOOD) {
                this.zipFileClose();
                return zRet;
            }
            if (this.centerDirStart.compareTo(BigInteger.valueOf(0xFFFFFFFFL)) == 0 || this.centerDirSize.compareTo(BigInteger.valueOf(0xFFFFFFFFL)) == 0 || this.localFilesCount.compareTo(BigInteger.valueOf(65535L)) == 0) {
                this.zip64 = true;
                this.esbc.position(endOfCentralDir - 20L);
                zRet = this.zip64EndOfCentralDirectoryLocatorRead();
                if (zRet != ZipReturn.ZIPGOOD) {
                    this.zipFileClose();
                    return zRet;
                }
                this.esbc.position(this.endOfCenterDir64.longValue());
                zRet = this.zip64EndOfCentralDirRead();
                if (zRet != ZipReturn.ZIPGOOD) {
                    this.zipFileClose();
                    return zRet;
                }
            }
            boolean trrntzip = false;
            if (this.fileComment.length == 22 && new String(this.fileComment, StandardCharsets.US_ASCII).substring(0, 14).equals("TORRENTZIPPED-")) {
                byte[] buffer = new byte[this.centerDirSize.intValue()];
                this.esbc.position(this.centerDirStart.longValue());
                this.esbc.startChecksum();
                this.esbc.get(buffer);
                long r = this.esbc.endChecksum();
                String tcrc = new String(this.fileComment, StandardCharsets.US_ASCII).substring(14, 22);
                String zcrc = String.format("%08X", r);
                if (tcrc.equalsIgnoreCase(zcrc)) {
                    trrntzip = true;
                }
            }
            this.esbc.position(this.centerDirStart.longValue());
            this.localFiles.clear();
            int i = 0;
            while ((long)i < this.localFilesCount.longValue()) {
                LocalFile lc = new LocalFile(this.esbc);
                zRet = lc.centralDirectoryRead();
                if (zRet != ZipReturn.ZIPGOOD) {
                    this.zipFileClose();
                    lc.close();
                    return zRet;
                }
                this.zip64 |= lc.isZip64();
                this.localFiles.add(lc);
                ++i;
            }
            for (i = 0; i < this.localFilesCount.intValue(); ++i) {
                zRet = this.localFiles.get(i).localFileHeaderRead();
                if (zRet != ZipReturn.ZIPGOOD) {
                    this.zipFileClose();
                    return zRet;
                }
                trrntzip &= this.localFiles.get(i).isTrrntZip();
            }
            if (trrntzip) {
                for (i = 0; i < this.localFilesCount.intValue() - 1; ++i) {
                    if (this.localFiles.get(i).getFileName().compareToIgnoreCase(this.localFiles.get(i + 1).getFileName()) < 0) continue;
                    trrntzip = false;
                    break;
                }
            }
            if (trrntzip) {
                for (i = 0; i < this.localFilesCount.intValue() - 1; ++i) {
                    String filename1;
                    String filename0 = this.localFiles.get(i).getFileName();
                    if (filename0.charAt(filename0.length() - 1) != '/' || (filename1 = this.localFiles.get(i + 1).getFileName()).length() <= filename0.length() || filename0.compareToIgnoreCase(filename1.substring(0, filename0.length())) != 0) continue;
                    trrntzip = false;
                    break;
                }
            }
            if (trrntzip) {
                this.pZipStatus.add(ZipStatus.TRRNTZIP);
            }
            return ZipReturn.ZIPGOOD;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            this.zipFileClose();
            return ZipReturn.ZIPERRORREADINGFILE;
        }
    }

    public final ZipReturn zipFileOpenReadStream(int index, boolean raw, AtomicReference<InputStream> stream, AtomicReference<BigInteger> streamSize, AtomicInteger compressionMethod) throws IOException {
        streamSize.set(BigInteger.valueOf(0L));
        compressionMethod.set(0);
        this.readIndex = index;
        stream.set(null);
        if (this.zipOpen != ZipOpenType.OPENREAD) {
            return ZipReturn.ZIPREADINGFROMOUTPUTFILE;
        }
        ZipReturn zRet = this.localFiles.get(index).localFileHeaderRead();
        if (zRet != ZipReturn.ZIPGOOD) {
            this.zipFileClose();
            return zRet;
        }
        return this.localFiles.get(index).localFileOpenReadStream(raw, stream, streamSize, compressionMethod, this.inflater);
    }

    public final ZipReturn zipFileOpenReadStreamQuick(BigInteger pos, boolean raw, AtomicReference<InputStream> stream, AtomicReference<BigInteger> streamSize, AtomicInteger compressionMethod) throws IOException {
        LocalFile tmpFile = new LocalFile(this.esbc);
        tmpFile.localFilePos(pos);
        this.localFiles.clear();
        this.localFiles.add(tmpFile);
        ZipReturn zr = tmpFile.localFileHeaderReadQuick();
        if (zr != ZipReturn.ZIPGOOD) {
            stream.set(null);
            streamSize.set(BigInteger.valueOf(0L));
            compressionMethod.set(0);
            return zr;
        }
        this.readIndex = 0;
        return tmpFile.localFileOpenReadStream(raw, stream, streamSize, compressionMethod, this.inflater);
    }

    @Override
    public final ZipReturn zipFileOpenWriteStream(boolean raw, boolean trrntzip, String filename, BigInteger uncompressedSize, short compressionMethod, AtomicReference<OutputStream> stream) throws IOException {
        stream.set(null);
        if (this.zipOpen != ZipOpenType.OPENWRITE) {
            return ZipReturn.ZIPWRITINGTOINPUTFILE;
        }
        LocalFile lf = new LocalFile(this.esbc, filename);
        ZipReturn retVal = lf.localFileOpenWriteStream(raw, trrntzip, uncompressedSize, compressionMethod, stream, this.deflater);
        this.localFiles.add(lf);
        return retVal;
    }

    @Override
    public final ZipReturn zipFileRollBack() throws IOException {
        if (this.zipOpen != ZipOpenType.OPENWRITE) {
            return ZipReturn.ZIPWRITINGTOINPUTFILE;
        }
        int fileCount = this.localFiles.size();
        if (fileCount == 0) {
            return ZipReturn.ZIPERRORROLLBACKFILE;
        }
        LocalFile lf = this.localFiles.get(fileCount - 1);
        this.localFiles.remove(fileCount - 1);
        this.esbc.position(lf.localFilePos().longValueExact());
        return ZipReturn.ZIPGOOD;
    }

    @Override
    public final ZipOpenType zipOpen() {
        return this.zipOpen;
    }

    @Override
    public final EnumSet<ZipStatus> zipStatus() {
        return this.pZipStatus;
    }
}

