/*
 * Decompiled with CFR 0.152.
 */
package jrm.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.eclipsesource.json.Json;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jrm.aui.basic.AbstractSrcDstResult;
import jrm.aui.basic.ResultColUpdater;
import jrm.aui.basic.SDRList;
import jrm.aui.basic.SrcDstResult;
import jrm.aui.progress.ProgressHandler;
import jrm.aui.status.PlainTextRenderer;
import jrm.aui.status.StatusRenderer;
import jrm.aui.status.StatusRendererFactory;
import jrm.batch.Compressor;
import jrm.batch.CompressorFormat;
import jrm.batch.DirUpdater;
import jrm.batch.TorrentChecker;
import jrm.cli.CLIMessages;
import jrm.cli.CMD;
import jrm.cli.CMD_DIRUPD8R;
import jrm.cli.CMD_TRNTCHK;
import jrm.cli.Progress;
import jrm.io.torrent.options.TrntChkMode;
import jrm.misc.BreakException;
import jrm.misc.EnumWithDefault;
import jrm.misc.Log;
import jrm.misc.ProfileSettings;
import jrm.misc.ProfileSettingsEnum;
import jrm.misc.SettingsEnum;
import jrm.profile.Profile;
import jrm.profile.fix.Fix;
import jrm.profile.manager.ProfileNFO;
import jrm.profile.scan.Scan;
import jrm.profile.scan.ScanException;
import jrm.security.PathAbstractor;
import jrm.security.Session;
import jrm.security.Sessions;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class JRomManagerCLI {
    private static final String CLI_ERR_UNKNOWN_COMMAND = "CLI_ERR_UnknownCommand";
    private static final String CLI_ERR_WRONG_ARGS = "CLI_ERR_WrongArgs";
    Session session;
    Path cwdir = null;
    Path rootdir = null;
    Progress handler = null;
    private final Pattern splitLinePattern = Pattern.compile("\"([^\"]*)\"|(\\S+)");
    private final Pattern envPattern = Pattern.compile("\\$(?:([\\w\\.]+)|\\{([\\w\\.]+)\\})");

    public JRomManagerCLI(Args cmd) throws IOException {
        this.session = Sessions.getSession((boolean)true, (boolean)false);
        this.rootdir = this.cwdir = this.session.getUser().getSettings().getWorkPath().resolve("xmlfiles").toAbsolutePath().normalize();
        StatusRendererFactory.Factory.setInstance((StatusRenderer)new PlainTextRenderer());
        Log.init((String)(this.session.getUser().getSettings().getLogPath() + "/JRM.%g.log"), (boolean)false, (int)0x100000, (int)5);
        this.handler = new Progress();
        if (cmd.interactive) {
            this.interactive();
        } else {
            this.stream(cmd);
        }
    }

    private void stream(Args cmd) throws FileNotFoundException {
        InputStreamReader reader = cmd.file != null ? new FileReader(cmd.file) : new InputStreamReader(System.in);
        try (BufferedReader in = new BufferedReader(reader);){
            String line;
            while (null != (line = in.readLine())) {
                if (line.startsWith("#")) continue;
                this.analyze(this.splitLine(line));
            }
        }
        catch (IOException e) {
            Log.err((Object)e.getMessage());
        }
    }

    private void interactive() throws IOException {
        try (BufferedReader console = new BufferedReader(new InputStreamReader(System.in));){
            while (true) {
                if (this.session.getCurrProfile() != null) {
                    System.out.format("jrm [%s]> ", this.session.getCurrProfile().getNfo().getFile().getName());
                } else {
                    System.out.print("jrm> ");
                }
                String line = console.readLine();
                if (line == null) {
                    break;
                }
                this.analyze(this.splitLine(line));
            }
        }
    }

    private Optional<String> getEnv(String name) {
        Optional<String> ret = Optional.ofNullable(System.getProperty(name));
        if (!ret.isPresent()) {
            ret = Optional.ofNullable(System.getenv(name));
        }
        return ret;
    }

    private String[] splitLine(String line) {
        ArrayList<String> list = new ArrayList<String>();
        Matcher m = this.splitLinePattern.matcher(line);
        while (m.find()) {
            Matcher im = this.envPattern.matcher(m.group(m.group(1) != null ? 1 : 2));
            StringBuilder sb = new StringBuilder();
            while (im.find()) {
                im.appendReplacement(sb, this.getEnv(im.group(im.group(1) != null ? 1 : 2)).map(Matcher::quoteReplacement).orElse(""));
            }
            im.appendTail(sb);
            list.add(sb.toString());
        }
        return (String[])list.stream().toArray(String[]::new);
    }

    protected int analyze(String ... args) {
        if (args.length == 0) {
            return 0;
        }
        try {
            switch (CMD.of(args[0])) {
                case LS: {
                    return this.list();
                }
                case PWD: {
                    return this.pwd();
                }
                case QUIET: {
                    this.handler.quiet(true);
                    return 0;
                }
                case VERBOSE: {
                    this.handler.quiet(false);
                    return 0;
                }
                case SET: {
                    return this.set(args);
                }
                case CD: {
                    return this.cd(args);
                }
                case RM: {
                    return this.rm(args);
                }
                case MD: {
                    return this.md(args);
                }
                case PREFS: {
                    return this.prefs(args);
                }
                case LOAD: {
                    return this.load(args);
                }
                case SETTINGS: {
                    return this.settings(args);
                }
                case SCAN: {
                    return this.scan();
                }
                case SCANRESULT: {
                    return this.scanResult();
                }
                case FIX: {
                    return this.fix();
                }
                case DIRUPD8R: {
                    if (args.length == 1) {
                        return this.error(CLIMessages.getString("CLI_ERR_DIRUPD8R_SubCmdMissing"));
                    }
                    return this.dirupd8r(args[1], Arrays.copyOfRange(args, 2, args.length));
                }
                case TRNTCHK: {
                    if (args.length == 1) {
                        return this.error(CLIMessages.getString("CLI_ERR_TRNTCHK_SubCmdMissing"));
                    }
                    return this.trntchk(args[1], Arrays.copyOfRange(args, 2, args.length));
                }
                case COMPRESSOR: {
                    if (args.length < 3) {
                        return this.error(CLIMessages.getString(CLI_ERR_WRONG_ARGS));
                    }
                    return this.compressor(Arrays.copyOfRange(args, 1, args.length));
                }
                case HELP: {
                    return this.help();
                }
                case EXIT: {
                    return this.exit(0);
                }
                case EMPTY: {
                    return 0;
                }
                case UNKNOWN: {
                    return this.error(() -> CLIMessages.getString(CLI_ERR_UNKNOWN_COMMAND) + Stream.of(args).map(s -> s.contains(" ") ? "\"" + s + "\"" : s).collect(Collectors.joining(" ")));
                }
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
        catch (ParameterException | ScanException e) {
            System.out.println(e.getMessage());
            Log.err((String)e.getMessage(), (Throwable)e);
        }
        return -1;
    }

    private int help() {
        for (CMD cmd : CMD.values()) {
            if (cmd == CMD.EMPTY || cmd == CMD.UNKNOWN) continue;
            System.out.append(cmd.allStrings().collect(Collectors.joining(", ")));
            System.out.append(": ").append(CLIMessages.getString("CLI_HELP_" + cmd.name()));
            System.out.append("\n");
        }
        return 0;
    }

    private int cd(String ... args) {
        if (args.length == 1) {
            return this.pwd();
        }
        if (args.length == 2) {
            return this.cd(args[1]);
        }
        return this.error(CLIMessages.getString(CLI_ERR_WRONG_ARGS));
    }

    private int prefs(String ... args) {
        if (args.length == 1) {
            return this.prefs();
        }
        if (args.length == 2) {
            return this.prefs((Enum<?>)SettingsEnum.from((String)args[1]));
        }
        if (args.length == 3) {
            return this.prefs((Enum<?>)SettingsEnum.from((String)args[1]), args[2]);
        }
        return this.error(CLIMessages.getString(CLI_ERR_WRONG_ARGS));
    }

    private int load(String ... args) {
        if (args.length == 2) {
            return this.load(args[1]);
        }
        return this.error(CLIMessages.getString(CLI_ERR_WRONG_ARGS));
    }

    private int settings(String ... args) {
        if (this.session.getCurrProfile() == null) {
            return this.error(CLIMessages.getString("CLI_ERR_NoProfileLoaded"));
        }
        if (args.length == 1) {
            return this.settings();
        }
        if (args.length == 2) {
            return this.settings((Enum<?>)SettingsEnum.from((String)args[1]));
        }
        if (args.length == 3) {
            return this.settings((Enum<?>)SettingsEnum.from((String)args[1]), args[2]);
        }
        return this.error(CLIMessages.getString(CLI_ERR_WRONG_ARGS));
    }

    private int rm(String ... args) throws ParameterException, IOException {
        RmArgs jArgs = new RmArgs();
        JCommander.newBuilder().addObject((Object)jArgs).build().parse(Arrays.copyOfRange(args, 1, args.length));
        for (String arg : jArgs.files) {
            this.recursiveDelete(Paths.get(arg, new String[0]), jArgs.recurisve);
        }
        return 0;
    }

    private int fix() {
        if (this.session.getCurrScan() == null) {
            return this.error(CLIMessages.getString("CLI_ERR_ShouldScanFirst"));
        }
        if (this.session.getCurrProfile().hasPropsChanged()) {
            return this.error(CLIMessages.getString("CLI_ERR_PropsChanged"));
        }
        if (this.session.getCurrScan().actions.stream().mapToInt(Collection::size).sum() == 0) {
            return this.error(CLIMessages.getString("CLI_ERR_NothingToFix"));
        }
        Fix fix = new Fix(this.session.getCurrProfile(), this.session.getCurrScan(), (ProgressHandler)this.handler);
        System.out.format(CLIMessages.getString("CLI_MSG_ActionRemaining"), fix.getActionsRemain());
        return fix.getActionsRemain();
    }

    private int scanResult() {
        if (this.session.getCurrScan() == null) {
            return this.error(CLIMessages.getString("CLI_ERR_ShouldScanFirst"));
        }
        if (this.session.getCurrProfile().hasPropsChanged()) {
            return this.error(CLIMessages.getString("CLI_ERR_PropsChanged"));
        }
        if (this.session.getReport() == null) {
            return this.error(CLIMessages.getString("CLI_ERR_NoReport"));
        }
        System.out.println(this.session.getReport().getStats().getStatus());
        return 0;
    }

    private int scan() throws BreakException, ScanException {
        if (this.session.getCurrProfile() == null) {
            return this.error(CLIMessages.getString("CLI_ERR_NoProfileLoaded"));
        }
        this.session.setCurrScan(new Scan(this.session.getCurrProfile(), (ProgressHandler)this.handler));
        return this.session.getCurrScan().actions.stream().mapToInt(Collection::size).sum();
    }

    private int md(String ... args) throws ParameterException, IOException {
        MdArgs jArgs = new MdArgs();
        JCommander.newBuilder().addObject((Object)jArgs).build().parse(Arrays.copyOfRange(args, 1, args.length));
        for (String arg : jArgs.files) {
            Path path = Paths.get(arg, new String[0]);
            if (Files.exists(path, new LinkOption[0])) continue;
            if (jArgs.parents) {
                Files.createDirectories(path, new FileAttribute[0]);
                continue;
            }
            Files.createDirectory(path, new FileAttribute[0]);
        }
        return 0;
    }

    private int set(String ... args) {
        if (args.length == 1) {
            System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> System.out.println(String.valueOf(k) + "=" + String.valueOf(v))));
            System.getenv().forEach((k, v) -> System.out.println(k + "=" + v));
            return 0;
        }
        if (args.length == 2) {
            this.getEnv(args[1]).ifPresent(System.out::println);
            return 0;
        }
        if (args.length == 3) {
            if (args[2].isEmpty()) {
                System.clearProperty(args[1]);
            } else {
                System.setProperty(args[1], args[2]);
            }
            return 0;
        }
        return this.error(CLIMessages.getString(CLI_ERR_WRONG_ARGS));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void recursiveDelete(Path path, boolean recurse) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) return;
        if (Files.isDirectory(path, new LinkOption[0])) {
            try {
                Files.delete(path);
                return;
            }
            catch (DirectoryNotEmptyException e) {
                if (!recurse) return;
                try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
                    stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                    return;
                }
            }
        } else {
            Files.delete(path);
        }
    }

    private int dirupd8r(String cmd, String ... args) throws ParameterException {
        switch (CMD_DIRUPD8R.of(cmd)) {
            case LSSRC: {
                System.out.append("srcdirs = [\n").append(Stream.of(StringUtils.split((String)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_srcdirs), (char)'|')).map(s -> "\t" + Json.value((String)s).toString()).collect(Collectors.joining(",\n"))).append("\n];\n");
                return 0;
            }
            case LSSDR: {
                System.out.append("sdr = [\n").append(SrcDstResult.fromJSON((String)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_sdr)).stream().map(sdr -> "\t" + sdr.toJSONObject().toString()).collect(Collectors.joining(",\n"))).append("\n];\n");
                return 0;
            }
            case CLEARSRC: {
                this.prefs((Enum<?>)SettingsEnum.dat2dir_srcdirs, "");
                break;
            }
            case CLEARSDR: {
                this.prefs((Enum<?>)SettingsEnum.dat2dir_sdr, "[]");
                break;
            }
            case PRESETS: {
                return this.dirupd8rPresets(args);
            }
            case SETTINGS: {
                return this.dirupd8rSettings(args);
            }
            case ADDSRC: {
                ArrayList list = Stream.of(StringUtils.split((String)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_srcdirs), (char)'|')).collect(Collectors.toCollection(ArrayList::new));
                list.add(args[0]);
                this.prefs((Enum<?>)SettingsEnum.dat2dir_srcdirs, list.stream().collect(Collectors.joining("|")));
                break;
            }
            case ADDSDR: {
                SDRList list = SrcDstResult.fromJSON((String)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_sdr));
                list.add((Object)new SrcDstResult(args[0], args[1]));
                this.prefs((Enum<?>)SettingsEnum.dat2dir_sdr, AbstractSrcDstResult.toJSON((List)list));
                break;
            }
            case START: {
                return this.dirupd8rStart(args);
            }
            case HELP: {
                return this.dirupd8rHelp();
            }
            case EMPTY: {
                break;
            }
            case UNKNOWN: {
                return this.error(() -> CLIMessages.getString(CLI_ERR_UNKNOWN_COMMAND) + cmd + " " + Stream.of(args).map(s -> s.contains(" ") ? "\"" + s + "\"" : s).collect(Collectors.joining(" ")));
            }
        }
        return 0;
    }

    private int dirupd8rHelp() {
        for (CMD_DIRUPD8R ducmd : CMD_DIRUPD8R.values()) {
            if (ducmd == CMD_DIRUPD8R.EMPTY || ducmd == CMD_DIRUPD8R.UNKNOWN) continue;
            System.out.append(ducmd.allStrings().collect(Collectors.joining(", ")));
            System.out.append(": ").append(CLIMessages.getString("CLI_HELP_DIRUPD8R_" + ducmd.name()));
            System.out.append("\n");
        }
        return 0;
    }

    private int dirupd8rStart(String ... args) throws ParameterException {
        SDRList sdrl = SrcDstResult.fromJSON((String)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_sdr));
        List srcdirs = Stream.of(StringUtils.split((String)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_srcdirs), (char)'|')).map(File::new).collect(Collectors.toCollection(ArrayList::new));
        final String[] results = new String[sdrl.size()];
        ResultColUpdater resulthandler = new ResultColUpdater(){

            public void updateResult(int row, String result) {
                results[row] = result;
            }

            public void clearResults() {
                for (int i = 0; i < results.length; ++i) {
                    results[i] = "";
                }
            }
        };
        DirUpdaterArgs jArgs = new DirUpdaterArgs();
        JCommander.newBuilder().addObject((Object)jArgs).build().parse(args);
        new DirUpdater(this.session, (List)sdrl, (ProgressHandler)this.handler, srcdirs, resulthandler, jArgs.dryrun);
        for (int i = 0; i < results.length; ++i) {
            System.out.println(i + " = " + results[i]);
        }
        return 0;
    }

    private int dirupd8rSettings(String ... args) throws NumberFormatException, SecurityException {
        if (args.length > 0) {
            SDRList list = SrcDstResult.fromJSON((String)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_sdr));
            int index = Integer.parseInt(args[0]);
            if (index < list.size()) {
                ProfileSettings settings = this.session.getUser().getSettings().loadProfileSettings(PathAbstractor.getAbsolutePath((Session)this.session, (String)((SrcDstResult)list.get(index)).getSrc()).toFile(), null);
                if (args.length == 3) {
                    settings.setProperty((Enum)SettingsEnum.from((String)args[1]), args[2]);
                    this.session.getUser().getSettings().saveProfileSettings(PathAbstractor.getAbsolutePath((Session)this.session, (String)((SrcDstResult)list.get(index)).getSrc()).toFile(), settings);
                } else if (args.length == 2) {
                    System.out.format("%s%n", settings.getProperty((EnumWithDefault)SettingsEnum.from((String)args[1])));
                } else {
                    for (Map.Entry<Object, Object> entry : settings.getProperties().entrySet()) {
                        System.out.format("%s=%s%n", entry.getKey(), entry.getValue());
                    }
                }
            }
            return 0;
        }
        return this.error(CLIMessages.getString(CLI_ERR_WRONG_ARGS));
    }

    private int dirupd8rPresets(String ... args) throws NumberFormatException, SecurityException {
        if (args.length == 0) {
            System.out.println("TZIP");
            System.out.println("DIR");
            return 0;
        }
        if (args.length == 2) {
            SDRList list = SrcDstResult.fromJSON((String)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_sdr));
            int index = Integer.parseInt(args[0]);
            if (index < list.size()) {
                switch (args[1]) {
                    case "TZIP": {
                        ProfileSettings.TZIP((Session)this.session, (File)PathAbstractor.getAbsolutePath((Session)this.session, (String)((SrcDstResult)list.get(index)).getSrc()).toFile());
                        break;
                    }
                    case "DIR": {
                        ProfileSettings.DIR((Session)this.session, (File)PathAbstractor.getAbsolutePath((Session)this.session, (String)((SrcDstResult)list.get(index)).getSrc()).toFile());
                        break;
                    }
                }
            }
            return 0;
        }
        return this.error(CLIMessages.getString(CLI_ERR_WRONG_ARGS));
    }

    private int trntchk(String cmd, String ... args) throws IOException, ParameterException {
        switch (CMD_TRNTCHK.of(cmd)) {
            case LSSDR: {
                System.out.append("sdr = [\n").append(SrcDstResult.fromJSON((String)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_sdr)).stream().map(sdr -> "\t" + sdr.toJSONObject().toString()).collect(Collectors.joining(",\n"))).append("\n];\n");
                break;
            }
            case CLEARSDR: {
                this.prefs((Enum<?>)SettingsEnum.trntchk_sdr);
                break;
            }
            case ADDSDR: {
                if (args.length == 2) {
                    SDRList list = SrcDstResult.fromJSON((String)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_sdr));
                    list.add((Object)new SrcDstResult(args[0], args[1]));
                    this.prefs((Enum<?>)SettingsEnum.trntchk_sdr, AbstractSrcDstResult.toJSON((List)list));
                    break;
                }
                return this.error(CLIMessages.getString(CLI_ERR_WRONG_ARGS));
            }
            case START: {
                return this.trntchkStart(args);
            }
            case HELP: {
                return this.trntchkHelp();
            }
            case EMPTY: {
                break;
            }
            case UNKNOWN: {
                return this.error(() -> CLIMessages.getString(CLI_ERR_UNKNOWN_COMMAND) + cmd + " " + Stream.of(args).map(s -> s.contains(" ") ? "\"" + s + "\"" : s).collect(Collectors.joining(" ")));
            }
        }
        return 0;
    }

    private int trntchkHelp() {
        for (CMD_TRNTCHK ducmd : CMD_TRNTCHK.values()) {
            if (ducmd == CMD_TRNTCHK.EMPTY || ducmd == CMD_TRNTCHK.UNKNOWN) continue;
            System.out.append(ducmd.allStrings().collect(Collectors.joining(", ")));
            System.out.append(": ").append(CLIMessages.getString("CLI_HELP_TRNTCHK_" + ducmd.name()));
            System.out.append("\n");
        }
        return 0;
    }

    private int trntchkStart(String ... args) throws ParameterException {
        SDRList sdrl = SrcDstResult.fromJSON((String)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_sdr));
        final String[] results = new String[sdrl.size()];
        ResultColUpdater resulthandler = new ResultColUpdater(){

            public void updateResult(int row, String result) {
                results[row] = result;
            }

            public void clearResults() {
                for (int i = 0; i < results.length; ++i) {
                    results[i] = "";
                }
            }
        };
        TrntchkArgs jArgs = new TrntchkArgs();
        JCommander.newBuilder().addObject((Object)jArgs).build().parse(args);
        TrntChkMode mode = jArgs.checkmode != null ? TrntChkMode.valueOf((String)jArgs.checkmode) : TrntChkMode.FILESIZE;
        EnumSet<TorrentChecker.Options> opts = EnumSet.noneOf(TorrentChecker.Options.class);
        if (jArgs.removeunknown) {
            opts.add(TorrentChecker.Options.REMOVEUNKNOWNFILES);
        }
        if (jArgs.removewrongsized) {
            opts.add(TorrentChecker.Options.REMOVEWRONGSIZEDFILES);
        }
        if (jArgs.detectarchives) {
            opts.add(TorrentChecker.Options.DETECTARCHIVEDFOLDERS);
        }
        new TorrentChecker(this.session, (ProgressHandler)this.handler, (List)sdrl, mode, resulthandler, opts);
        return 0;
    }

    private int compressor(String ... args) throws IOException, ParameterException {
        CompressorArgs jArgs = new CompressorArgs();
        JCommander cmd = JCommander.newBuilder().addObject((Object)jArgs).build();
        try {
            cmd.parse(args);
            CompressorFormat format = jArgs.compressor != null ? CompressorFormat.valueOf((String)jArgs.compressor) : CompressorFormat.TZIP;
            for (String arg : jArgs.files) {
                List<Compressor.FileResult> frl;
                Path path = Paths.get(arg, new String[0]);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
                        frl = stream.filter(p -> Files.isRegularFile(p, new LinkOption[0]) && FilenameUtils.isExtension((String)p.getFileName().toString(), (String[])Compressor.getExtensions())).map(Compressor.FileResult::new).toList();
                    }
                } else {
                    frl = Arrays.asList(new Compressor.FileResult(path));
                }
                AtomicInteger cnt = new AtomicInteger();
                Compressor compressor = new Compressor(this.session, cnt, frl.size(), (ProgressHandler)this.handler);
                frl.parallelStream().forEach(fr -> {
                    Path file = fr.getFile();
                    cnt.incrementAndGet();
                    Compressor.UpdResultCallBack cb = arg_0 -> ((Compressor.FileResult)fr).setResult(arg_0);
                    Compressor.UpdSrcCallBack scb = src -> fr.setFile(src.toPath());
                    compressor.compress(format, file.toFile(), jArgs.force, cb, scb);
                });
            }
        }
        catch (ParameterException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            cmd.usage();
            throw e;
        }
        return 0;
    }

    private int prefs() {
        for (SettingsEnum e : SettingsEnum.values()) {
            System.out.format("%s=%s%n", e.toString(), this.session.getUser().getSettings().getProperty((EnumWithDefault)e));
        }
        return 0;
    }

    private int prefs(Enum<?> name) {
        if (!this.session.getUser().getSettings().hasProperty(name)) {
            System.out.format(CLIMessages.getString("CLI_MSG_PropIsNotSet"), name);
        } else if (name instanceof EnumWithDefault) {
            EnumWithDefault n = (EnumWithDefault)name;
            System.out.format("%s=%s%n", name, this.session.getUser().getSettings().getProperty(n));
        }
        return 0;
    }

    private int prefs(Enum<?> name, String value) {
        this.session.getUser().getSettings().setProperty(name, value);
        this.session.getUser().getSettings().saveSettings();
        return 0;
    }

    private int settings() {
        for (ProfileSettingsEnum e : ProfileSettingsEnum.values()) {
            System.out.format("%s=%s%n", e.toString(), this.session.getCurrProfile().getSettings().getProperty((EnumWithDefault)e));
        }
        return 0;
    }

    private int settings(Enum<?> name) {
        if (!this.session.getCurrProfile().getSettings().hasProperty(name)) {
            System.out.format(CLIMessages.getString("CLI_MSG_PropIsNotSet"), name);
        } else if (name instanceof EnumWithDefault) {
            EnumWithDefault n = (EnumWithDefault)name;
            System.out.format("%s=%s%n", name, this.session.getCurrProfile().getSettings().getProperty(n));
        }
        return 0;
    }

    private int settings(Enum<?> name, String value) {
        this.session.getCurrProfile().getSettings().setProperty(name, value);
        this.session.getCurrProfile().saveSettings();
        return 0;
    }

    private int exit(int status) {
        System.exit(status);
        return status;
    }

    private int error(String msg) {
        System.out.println(msg);
        return -1;
    }

    private int error(Supplier<String> supplier) {
        System.out.println(supplier.get());
        return -1;
    }

    private int load(String profile) {
        Path candidate = this.cwdir.resolve(profile);
        if (Files.isRegularFile(candidate, new LinkOption[0])) {
            this.session.setCurrProfile(Profile.load((Session)this.session, (File)candidate.toFile(), (ProgressHandler)this.handler));
        } else {
            System.out.format(CLIMessages.getString("CLI_ERR_ProfileNotExist"), profile);
        }
        return 0;
    }

    private int cd(String dir) {
        if (dir.equals(File.separator)) {
            this.cwdir = this.rootdir;
        } else {
            Path candidate;
            if (dir.startsWith("~")) {
                dir = dir.replace("~", this.rootdir.toString());
            }
            if (this.rootdir.startsWith(candidate = this.cwdir.resolve(dir).normalize()) && !this.rootdir.equals(candidate)) {
                this.cwdir = this.rootdir;
                System.out.format(CLIMessages.getString("CLI_ERR_CantGoUpDir"), dir);
            } else if (Files.isDirectory(candidate, new LinkOption[0])) {
                if (candidate.startsWith(this.rootdir)) {
                    this.cwdir = candidate;
                } else {
                    System.out.format(CLIMessages.getString("CLI_ERR_CantChangeDir"), dir);
                }
            } else {
                System.out.format(CLIMessages.getString("CLI_ERR_UnknownDir"), dir);
            }
        }
        return 0;
    }

    private int pwd() {
        System.out.println("~/" + String.valueOf(this.rootdir.relativize(this.cwdir)));
        return 0;
    }

    private int list() throws IOException {
        try (Stream<Path> stream = Files.walk(this.cwdir, 1, new FileVisitOption[0]);){
            stream.filter(p -> Files.isDirectory(p, new LinkOption[0]) && !p.equals(this.cwdir)).sorted(Path::compareTo).map(this.cwdir::relativize).forEachOrdered(p -> System.out.format("<DIR>\t%s%n", p));
        }
        for (ProfileNFO row : ProfileNFO.list((Session)this.session, (File)this.cwdir.toFile())) {
            System.out.format("<DAT>\t%s\n", row.getName());
        }
        return 0;
    }

    public static void main(String[] args) {
        Args jArgs = new Args();
        JCommander cmd = JCommander.newBuilder().addObject((Object)jArgs).build();
        try {
            cmd.parse(args);
            if (jArgs.help) {
                cmd.usage();
            } else {
                new JRomManagerCLI(jArgs);
            }
        }
        catch (ParameterException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            cmd.usage();
            System.exit(1);
        }
        catch (IOException e) {
            Log.err((Object)e.getMessage());
        }
    }

    @Parameters(separators=" =")
    private static class Args {
        @Parameter(names={"--help", "-h"}, help=true)
        private boolean help = false;
        @Parameter(names={"--interactive", "-i"}, description="Interactive shell")
        private boolean interactive = false;
        @Parameter(names={"--file", "-f"}, description="Input file", arity=1)
        private String file = null;

        private Args() {
        }
    }

    @Parameters(separators=" =")
    private static class RmArgs {
        @Parameter(names={"--recursive", "-r"}, description="Recursive delete")
        private boolean recurisve;
        @Parameter(description="Files")
        private List<String> files = new ArrayList<String>();

        private RmArgs() {
        }
    }

    @Parameters(separators=" =")
    private static class MdArgs {
        @Parameter(names={"--parents", "-p"}, description="Create parents up to this directory")
        private boolean parents;
        @Parameter(description="Files")
        private List<String> files = new ArrayList<String>();

        private MdArgs() {
        }
    }

    @Parameters(separators=" =")
    private static class DirUpdaterArgs {
        @Parameter(names={"--dryrun", "-d"}, description="Dry run")
        private boolean dryrun;

        private DirUpdaterArgs() {
        }
    }

    @Parameters(separators=" =")
    private static class TrntchkArgs {
        @Parameter(names={"--checkmode", "-m"}, arity=1, description="Check mode")
        private String checkmode = null;
        @Parameter(names={"--removeunknown", "-u"}, description="Remove unknown files")
        private boolean removeunknown = false;
        @Parameter(names={"--removewrongsized", "-w"}, description="Remove wrong sized files")
        private boolean removewrongsized = false;
        @Parameter(names={"--detectarchives", "-a"}, description="Detect archived folders")
        private boolean detectarchives = false;

        private TrntchkArgs() {
        }
    }

    @Parameters(separators=" =")
    private static class CompressorArgs {
        @Parameter(names={"--compressor", "-c"}, arity=1, required=true, description="Compression format")
        private String compressor;
        @Parameter(names={"--force", "-f"}, description="Force compression")
        private boolean force;
        @Parameter(description="Files")
        private List<String> files = new ArrayList<String>();

        private CompressorArgs() {
        }
    }
}

