/*
 * Decompiled with CFR 0.152.
 */
package jtrrntzip;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.codec.binary.Hex;

public class ZippedFile {
    private int index;
    private String name;
    private BigInteger size;
    private int crc;

    public final byte[] getLECRC() {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(this.getCrc());
        return bb.array();
    }

    public final void setCRC(byte[] value) {
        this.crc = ByteBuffer.wrap(value).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public final String toString() {
        return Hex.encodeHexString((byte[])this.getLECRC());
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSize(BigInteger size) {
        this.size = size;
    }

    public String getName() {
        return this.name;
    }

    public int getCrc() {
        return this.crc;
    }

    public BigInteger getSize() {
        return this.size;
    }

    public int getIndex() {
        return this.index;
    }
}

