/*
 * Decompiled with CFR 0.152.
 */
package jtrrntzip;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import jtrrntzip.LogCallback;
import jtrrntzip.Messages;
import jtrrntzip.TorrentZipCheck;
import jtrrntzip.TorrentZipOptions;
import jtrrntzip.TorrentZipRebuild;
import jtrrntzip.TrrntZipStatus;
import jtrrntzip.ZipReturn;
import jtrrntzip.ZipStatus;
import jtrrntzip.ZippedFile;
import jtrrntzip.supportedfiles.ICompress;
import jtrrntzip.supportedfiles.zipfile.ZipFile;

public final class TorrentZip {
    private final LogCallback statusLogCallBack;
    private final TorrentZipOptions options;
    private final byte[] buffer;

    public TorrentZip(LogCallback statusLogCallBack, TorrentZipOptions options) {
        this.statusLogCallBack = statusLogCallBack;
        this.options = options;
        this.buffer = new byte[8192];
    }

    public final Set<TrrntZipStatus> process(File f) throws IOException {
        if (this.statusLogCallBack.isVerboseLogging()) {
            this.statusLogCallBack.statusLogCallBack("");
        }
        this.statusLogCallBack.statusLogCallBack(f.getName() + " - ");
        AtomicReference<ICompress> zipFile = new AtomicReference<ICompress>();
        EnumSet<TrrntZipStatus> tzs = this.openZip(f, zipFile);
        if (tzs.contains(TrrntZipStatus.CORRUPTZIP)) {
            this.statusLogCallBack.statusLogCallBack(Messages.getString("TorrentZip.ZipFileCorrupt"));
            return tzs;
        }
        List<ZippedFile> zippedFiles = this.readZipContent(zipFile.get());
        tzs.addAll(TorrentZipCheck.checkZipFiles(zippedFiles, this.statusLogCallBack));
        if (tzs.contains(TrrntZipStatus.VALIDTRRNTZIP) && !this.options.isForceRezip()) {
            this.statusLogCallBack.statusLogCallBack(Messages.getString("TorrentZip.SkippingFile"));
            zipFile.get().zipFileClose();
            return tzs;
        }
        if (this.options.isCheckOnly()) {
            this.statusLogCallBack.statusLogCallBack(tzs.toString());
            zipFile.get().zipFileClose();
            return tzs;
        }
        this.statusLogCallBack.statusLogCallBack(Messages.getString("TorrentZip.TorrentZipping"));
        return TorrentZipRebuild.reZipFiles(zippedFiles, zipFile.get(), this.buffer, this.statusLogCallBack);
    }

    private final EnumSet<TrrntZipStatus> openZip(File f, AtomicReference<ICompress> zipFile) throws IOException {
        zipFile.set(new ZipFile());
        ZipReturn zr = zipFile.get().zipFileOpen(f, f.lastModified(), true);
        if (zr != ZipReturn.ZIPGOOD) {
            return EnumSet.of(TrrntZipStatus.CORRUPTZIP);
        }
        EnumSet<TrrntZipStatus> tzStatus = EnumSet.noneOf(TrrntZipStatus.class);
        if (zipFile.get().zipStatus().contains((Object)ZipStatus.TRRNTZIP)) {
            tzStatus.add(TrrntZipStatus.VALIDTRRNTZIP);
        }
        return tzStatus;
    }

    private final List<ZippedFile> readZipContent(ICompress zipFile) {
        ArrayList<ZippedFile> zippedFiles = new ArrayList<ZippedFile>();
        int i = 0;
        while (i < zipFile.localFilesCount()) {
            int ii = i++;
            ZippedFile zf = new ZippedFile();
            zf.setIndex(ii);
            zf.setName(zipFile.filename(ii));
            zf.setCRC(zipFile.crc32(ii));
            zf.setSize(zipFile.uncompressedSize(ii));
            zippedFiles.add(zf);
        }
        return zippedFiles;
    }
}

