/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.StandardOpenOption;
import java.util.logging.Level;
import jrm.aui.status.NeutralRenderer;
import jrm.aui.status.StatusRenderer;
import jrm.aui.status.StatusRendererFactory;
import jrm.fx.ui.MainFrame;
import jrm.misc.EnumWithDefault;
import jrm.misc.Log;
import jrm.misc.SettingsEnum;
import jrm.security.Session;
import jrm.security.Sessions;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;

public class JRomManager {
    private static MainFrame mainFrame;

    public static void main(String[] args) {
        System.setProperty("file.encoding", "UTF-8");
        Sessions.setSingleMode((boolean)true);
        StatusRendererFactory.Factory.setInstance((StatusRenderer)new NeutralRenderer());
        Args jArgs = new Args();
        JCommander cmd = JCommander.newBuilder().addObject((Object)jArgs).build();
        try {
            cmd.parse(args);
        }
        catch (ParameterException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            cmd.usage();
            System.exit(1);
        }
        Session session = Sessions.getSession((boolean)jArgs.multiuser, (boolean)jArgs.noupdate);
        Log.init((String)(session.getUser().getSettings().getLogPath() + "/JRM.%g.log"), (boolean)jArgs.debug, (int)0x100000, (int)5);
        if (!jArgs.debug) {
            Log.setLevel((Level)Level.parse(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.debug_level)));
        }
        if (JRomManager.lockInstance(session, FilenameUtils.removeExtension((String)JRomManager.class.getSimpleName()) + ".lock")) {
            MainFrame.launch();
        }
    }

    private static boolean lockInstance(Session session, String lockFile) {
        try {
            FileChannel fc = JRomManager.getLock(session, lockFile);
            FileLock fl = fc.tryLock();
            if (fl != null) {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        fl.release();
                        fc.close();
                    }
                    catch (Exception e) {
                        Log.err((String)("Unable to remove lock file: " + lockFile), (Throwable)e);
                    }
                }));
                return true;
            }
            fc.close();
        }
        catch (Exception e) {
            Log.err((String)("Unable to create and/or lock file: " + lockFile), (Throwable)e);
        }
        return false;
    }

    private static FileChannel getLock(Session session, String lockFile) throws IOException {
        return FileChannel.open(session.getUser().getSettings().getWorkPath().resolve(lockFile), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DELETE_ON_CLOSE);
    }

    @Generated
    public static MainFrame getMainFrame() {
        return mainFrame;
    }

    @Parameters(separators=" =")
    private static class Args {
        @Parameter(names={"--multiuser", "-m"}, description="Multi-user mode")
        private boolean multiuser = false;
        @Parameter(names={"--noupdate", "-n"}, description="Don't search for update")
        private boolean noupdate = false;
        @Parameter(names={"--debug", "-d"}, description="Activate debug mode")
        private boolean debug = false;

        private Args() {
        }
    }
}

