/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui.controls;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javafx.scene.control.Control;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.text.Font;
import jrm.fx.ui.misc.DragNDrop;
import jrm.fx.ui.misc.SrcDstResult;

public class DropCell
extends TableCell<SrcDstResult, String> {
    public DropCell(TableView<SrcDstResult> view, DropCellCallback cb, Predicate<File> filter) {
        DragNDrop.SetFilesCallBack drop = files -> DropCell.process(view, this.getIndex(), files, cb);
        this.setFont(new Font(10.0));
        new DragNDrop((Control)this).addFiltered(filter, drop);
    }

    public static void process(TableView<SrcDstResult> view, int startIndex, List<File> files, DropCellCallback cb) {
        int count = view.getItems().size();
        if (startIndex > count || startIndex < 0) {
            startIndex = count;
        }
        ArrayList<SrcDstResult> sdrlist = new ArrayList<SrcDstResult>();
        for (int i = 0; i < files.size(); ++i) {
            if (startIndex + i >= count) {
                view.getItems().add((Object)new SrcDstResult());
            }
            sdrlist.add((SrcDstResult)((Object)view.getItems().get(startIndex + i)));
        }
        cb.call(sdrlist, files);
    }

    protected void updateItem(String item, boolean empty) {
        this.setFont(new Font(10.0));
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText("");
        } else {
            this.setTextOverrun(OverrunStyle.LEADING_ELLIPSIS);
            this.setText(item);
            this.setTooltip(new Tooltip(item));
        }
        this.setGraphic(null);
    }

    public static interface DropCellCallback {
        public void call(List<SrcDstResult> var1, List<File> var2);
    }
}

