/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Optional;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import jrm.fx.ui.Loading;
import jrm.fx.ui.MainFrameController;
import jrm.fx.ui.misc.Settings;
import jrm.fx.ui.profile.ProfileViewer;
import jrm.fx.ui.profile.report.ReportFrame;
import jrm.locale.Messages;
import jrm.misc.Log;
import jrm.security.Session;
import jrm.security.Sessions;
import lombok.Generated;

public class MainFrame
extends Application {
    private static MainFrameController controller;
    private static ReportFrame reportFrame;
    private static ProfileViewer profileViewer;
    private static Session session;
    private static Application application;
    private static HashMap<String, Image> iconsCache;
    private static Optional<Module> iconsModule;

    public static void launch() {
        Application.launch((String[])new String[0]);
    }

    public void start(Stage primaryStage) {
        System.out.println("Starting...");
        MainFrame.setApplication(this);
        Loading loading = new Loading();
        Platform.runLater(() -> {
            try {
                primaryStage.setOnCloseRequest(e -> {
                    session.getUser().getSettings().setProperty("MainFrame.Bounds", Settings.toJson(primaryStage));
                    MainFrame.controller.getSettingsPanelController().scheduler.shutdown();
                });
                primaryStage.getIcons().add((Object)MainFrame.getIcon("/jrm/resicons/rom.png"));
                primaryStage.setTitle(Messages.getString((String)"MainFrame.Title") + " " + this.getVersion());
                primaryStage.setScene(new Scene((Parent)MainFrame.loadMain()));
                MainFrame.setReportFrame(new ReportFrame(primaryStage));
                Settings.fromJson(session.getUser().getSettings().getProperty("MainFrame.Bounds", null), primaryStage);
                primaryStage.show();
            }
            catch (IOException | URISyntaxException e2) {
                e2.printStackTrace();
            }
            loading.hide();
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (Sessions.getSingleSession().getCurrProfile() != null) {
                Sessions.getSingleSession().getCurrProfile().saveSettings();
            }
            Sessions.getSingleSession().getUser().getSettings().saveSettings();
            System.out.println("Shutdown");
        }));
    }

    private static synchronized TabPane loadMain() throws URISyntaxException, IOException {
        FXMLLoader loader = new FXMLLoader(MainFrame.class.getResource("MainFrame.fxml").toURI().toURL(), Messages.getBundle());
        TabPane root = (TabPane)loader.load();
        controller = (MainFrameController)loader.getController();
        root.getStylesheets().add((Object)MainFrame.class.getResource("MainFrame.css").toExternalForm());
        return root;
    }

    public static Image getIcon(String res) {
        if (!iconsCache.containsKey(res)) {
            iconsModule.ifPresentOrElse(module -> {
                try (InputStream in = module.getResourceAsStream(res);){
                    if (in != null) {
                        iconsCache.put(res, new Image(in));
                    }
                }
                catch (Exception e) {
                    Log.err((String)e.getMessage(), (Throwable)e);
                }
            }, () -> {
                try (InputStream in = MainFrame.class.getResourceAsStream(res);){
                    if (in != null) {
                        iconsCache.put(res, new Image(in));
                    }
                }
                catch (Exception e) {
                    Log.err((String)e.getMessage(), (Throwable)e);
                }
            });
        }
        return iconsCache.get(res);
    }

    private String getVersion() {
        Object version = "";
        Package pkg = ((Object)((Object)this)).getClass().getPackage();
        if (pkg.getSpecificationVersion() != null) {
            version = (String)version + pkg.getSpecificationVersion();
            if (pkg.getImplementationVersion() != null) {
                version = (String)version + "." + pkg.getImplementationVersion();
            }
        }
        return version;
    }

    private static synchronized void setApplication(Application application) {
        MainFrame.application = application;
    }

    @Generated
    public static MainFrameController getController() {
        return controller;
    }

    @Generated
    public static ReportFrame getReportFrame() {
        return reportFrame;
    }

    @Generated
    public static void setReportFrame(ReportFrame reportFrame) {
        MainFrame.reportFrame = reportFrame;
    }

    @Generated
    public static ProfileViewer getProfileViewer() {
        return profileViewer;
    }

    @Generated
    public static void setProfileViewer(ProfileViewer profileViewer) {
        MainFrame.profileViewer = profileViewer;
    }

    @Generated
    public static Session getSession() {
        return session;
    }

    @Generated
    public static Application getApplication() {
        return application;
    }

    static {
        session = Sessions.getSingleSession();
        iconsCache = new HashMap();
        iconsModule = ModuleLayer.boot().findModule("res.icons");
    }
}

