/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.StringConverter;
import jrm.aui.progress.ProgressHandler;
import jrm.fx.ui.BaseController;
import jrm.fx.ui.MainFrame;
import jrm.fx.ui.ProfileLoader;
import jrm.fx.ui.ScannerPanelSettingsController;
import jrm.fx.ui.controls.DescriptorCellFactory;
import jrm.fx.ui.controls.Dialogs;
import jrm.fx.ui.misc.DragNDrop;
import jrm.fx.ui.profile.ProfileViewer;
import jrm.fx.ui.progress.ProgressTask;
import jrm.fx.ui.status.NeutralToNodeFormatter;
import jrm.locale.Messages;
import jrm.misc.BreakException;
import jrm.misc.EnumWithDefault;
import jrm.misc.Log;
import jrm.misc.ProfileSettingsEnum;
import jrm.profile.Profile;
import jrm.profile.data.Driver;
import jrm.profile.data.Machine;
import jrm.profile.data.PropertyStub;
import jrm.profile.data.Software;
import jrm.profile.data.Source;
import jrm.profile.data.Systm;
import jrm.profile.filter.CatVer;
import jrm.profile.filter.NPlayer;
import jrm.profile.filter.NPlayers;
import jrm.profile.fix.Fix;
import jrm.profile.manager.ProfileNFO;
import jrm.profile.scan.Scan;
import jrm.profile.scan.options.Descriptor;
import jrm.profile.scan.options.ScanAutomation;
import jrm.security.PathAbstractor;
import jrm.security.Session;
import org.apache.commons.lang3.StringUtils;

public class ScannerPanelController
extends BaseController
implements ProfileLoader {
    private static final String DISK_ICON = "/jrm/resicons/icons/disk.png";
    @FXML
    private Tab dirTab;
    @FXML
    private Button infosBtn;
    @FXML
    private Button scanBtn;
    @FXML
    private Button reportBtn;
    @FXML
    private Button fixBtn;
    @FXML
    private Button importBtn;
    @FXML
    private Button exportBtn;
    @FXML
    private Button romsDestBtn;
    @FXML
    private TextField romsDest;
    @FXML
    private CheckBox disksDestCB;
    @FXML
    private Button disksDestBtn;
    @FXML
    private TextField disksDest;
    @FXML
    private CheckBox swDestCB;
    @FXML
    private Button swDestBtn;
    @FXML
    private TextField swDest;
    @FXML
    private CheckBox swDisksDestCB;
    @FXML
    private Button swDisksDestBtn;
    @FXML
    private TextField swDisksDest;
    @FXML
    private CheckBox samplesDestCB;
    @FXML
    private Button samplesDestBtn;
    @FXML
    private TextField samplesDest;
    @FXML
    private CheckBox backupDestCB;
    @FXML
    private Button backupDestBtn;
    @FXML
    private TextField backupDest;
    @FXML
    private ListView<File> srcList;
    @FXML
    private ContextMenu srcListMenu;
    @FXML
    private MenuItem srcListAddMenuItem;
    @FXML
    private MenuItem srcListDelMenuItem;
    @FXML
    private Tab settingsTab;
    @FXML
    private ScannerPanelSettingsController scannerPanelSettingsController;
    @FXML
    private Tab filterTab;
    @FXML
    private Tab advFilterTab;
    @FXML
    private Tab automationTab;
    @FXML
    private HBox profileinfoLbl;
    @FXML
    private ListView<Systm> systemsFilter;
    @FXML
    private ContextMenu systemsFilterMenu;
    @FXML
    private MenuItem systemsFilterSelectAllMenuItem;
    @FXML
    private MenuItem systemsFilterSelectAllBiosMenuItem;
    @FXML
    private MenuItem systemsFilterSelectAllSoftwaresMenuItem;
    @FXML
    private MenuItem systemsFilterUnselectAllMenuItem;
    @FXML
    private MenuItem systemsFilterUnselectAllBiosMenuItem;
    @FXML
    private MenuItem systemsFilterUnselectAllSoftwaresMenuItem;
    @FXML
    private MenuItem systemsFilterInvertSelectionMenuItem;
    @FXML
    private ListView<Source> sourcesFilter;
    @FXML
    private ContextMenu sourcesFilterMenu;
    @FXML
    private MenuItem sourcesFilterSelectAllMenuItem;
    @FXML
    private MenuItem sourcesFilterUnselectAllMenuItem;
    @FXML
    private MenuItem sourcesFilterInvertSelectionMenuItem;
    @FXML
    private CheckBox chckbxIncludeClones;
    @FXML
    private CheckBox chckbxIncludeDisks;
    @FXML
    private CheckBox chckbxIncludeSamples;
    @FXML
    private ComboBox<Driver.StatusType> cbbxDriverStatus;
    @FXML
    private ComboBox<Machine.CabinetType> cbbxFilterCabinetType;
    @FXML
    private ComboBox<Machine.DisplayOrientation> cbbxFilterDisplayOrientation;
    @FXML
    private ComboBox<Software.Supported> cbbxSWMinSupportedLvl;
    @FXML
    private ComboBox<String> cbbxYearMin;
    @FXML
    private ComboBox<String> cbbxYearMax;
    @FXML
    private TextField tfNPlayers;
    @FXML
    private ListView<NPlayer> listNPlayers;
    @FXML
    private TextField tfCatVer;
    @FXML
    private TreeView<PropertyStub> treeCatVer;
    @FXML
    private ComboBox<Descriptor> cbAutomation;
    @FXML
    private ContextMenu nPlayersMenu;
    @FXML
    private MenuItem nPlayersMenuItemAll;
    @FXML
    private MenuItem nPlayersMenuItemNone;
    @FXML
    private MenuItem nPlayersMenuItemInvert;
    @FXML
    private MenuItem nPlayersMenuItemClear;
    @FXML
    private ContextMenu catVerMenu;
    @FXML
    private MenuItem catVerMenuItemSelectAll;
    @FXML
    private MenuItem catVerMenuItemSelectMature;
    @FXML
    private MenuItem catVerMenuItemUnselectAll;
    @FXML
    private MenuItem catVerMenuItemUnselectMature;
    @FXML
    private MenuItem catVerMenuItemClear;
    private static final String MATURE = "* Mature *";

    public void initialize(URL location, ResourceBundle resources) {
        this.dirTab.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/folder.png")));
        this.settingsTab.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/cog.png")));
        this.filterTab.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/arrow_join.png")));
        this.advFilterTab.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/arrow_in.png")));
        this.automationTab.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/link.png")));
        this.romsDestBtn.setGraphic((Node)new ImageView(MainFrame.getIcon(DISK_ICON)));
        this.disksDestBtn.setGraphic((Node)new ImageView(MainFrame.getIcon(DISK_ICON)));
        this.disksDestCB.selectedProperty().addListener((observable, oldValue, newValue) -> {
            this.disksDest.setDisable(newValue == false);
            this.disksDestBtn.setDisable(newValue == false);
            this.session.getCurrProfile().setProperty(ProfileSettingsEnum.disks_dest_dir_enabled, newValue.booleanValue());
        });
        this.swDestBtn.setGraphic((Node)new ImageView(MainFrame.getIcon(DISK_ICON)));
        this.swDestCB.selectedProperty().addListener((observable, oldValue, newValue) -> {
            this.swDest.setDisable(newValue == false);
            this.swDestBtn.setDisable(newValue == false);
            this.session.getCurrProfile().setProperty(ProfileSettingsEnum.swroms_dest_dir_enabled, newValue.booleanValue());
        });
        this.swDisksDestBtn.setGraphic((Node)new ImageView(MainFrame.getIcon(DISK_ICON)));
        this.swDisksDestCB.selectedProperty().addListener((observable, oldValue, newValue) -> {
            this.swDisksDest.setDisable(newValue == false);
            this.swDisksDestBtn.setDisable(newValue == false);
            this.session.getCurrProfile().setProperty(ProfileSettingsEnum.swdisks_dest_dir_enabled, newValue.booleanValue());
        });
        this.samplesDestBtn.setGraphic((Node)new ImageView(MainFrame.getIcon(DISK_ICON)));
        this.samplesDestCB.selectedProperty().addListener((observable, oldValue, newValue) -> {
            this.samplesDest.setDisable(newValue == false);
            this.samplesDestBtn.setDisable(newValue == false);
            this.session.getCurrProfile().setProperty(ProfileSettingsEnum.samples_dest_dir_enabled, newValue.booleanValue());
        });
        this.backupDestBtn.setGraphic((Node)new ImageView(MainFrame.getIcon(DISK_ICON)));
        this.backupDestCB.selectedProperty().addListener((observable, oldValue, newValue) -> {
            this.backupDest.setDisable(newValue == false);
            this.backupDestBtn.setDisable(newValue == false);
            this.session.getCurrProfile().setProperty(ProfileSettingsEnum.backup_dest_dir_enabled, newValue.booleanValue());
        });
        this.infosBtn.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/information.png")));
        this.scanBtn.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/magnifier.png")));
        this.reportBtn.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/report.png")));
        this.fixBtn.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/tick.png")));
        this.importBtn.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/table_refresh.png")));
        this.exportBtn.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/table_save.png")));
        this.srcList.setCellFactory(param -> new ListCell<File>(){

            protected void updateItem(File item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty) {
                    this.setText(null);
                    this.setOnMouseClicked(null);
                } else {
                    this.setText(item.toString());
                    this.setOnMouseClicked(ev -> {
                        if (ev.getClickCount() == 2) {
                            ScannerPanelController.this.chooseSrc(item, ProfileSettingsEnum.src_dir, "MainFrame.ChooseRomsSource");
                        }
                    });
                }
            }
        });
        this.srcListMenu.setOnShowing(e -> this.srcListDelMenuItem.setDisable(this.srcList.getSelectionModel().getSelectedIndex() < 0));
        this.srcListDelMenuItem.setOnAction(e -> {
            this.srcList.getItems().removeAll((Collection)this.srcList.getSelectionModel().getSelectedItems());
            this.saveSrcList();
        });
        this.srcListAddMenuItem.setOnAction(e -> this.chooseSrc(null, ProfileSettingsEnum.src_dir, "MainFrame.ChooseRomsSource"));
        new DragNDrop((Control)this.romsDest).addDir(txt -> this.session.getCurrProfile().setProperty(ProfileSettingsEnum.roms_dest_dir, txt));
        new DragNDrop((Control)this.disksDest).addDir(txt -> this.session.getCurrProfile().setProperty(ProfileSettingsEnum.disks_dest_dir, txt));
        new DragNDrop((Control)this.swDest).addDir(txt -> this.session.getCurrProfile().setProperty(ProfileSettingsEnum.swroms_dest_dir, txt));
        new DragNDrop((Control)this.swDisksDest).addDir(txt -> this.session.getCurrProfile().setProperty(ProfileSettingsEnum.swdisks_dest_dir, txt));
        new DragNDrop((Control)this.samplesDest).addDir(txt -> this.session.getCurrProfile().setProperty(ProfileSettingsEnum.samples_dest_dir, txt));
        new DragNDrop((Control)this.backupDest).addDir(txt -> this.session.getCurrProfile().setProperty(ProfileSettingsEnum.backup_dest_dir, txt));
        new DragNDrop((Control)this.srcList).addDirs(files -> this.session.getCurrProfile().setProperty(ProfileSettingsEnum.src_dir, String.join((CharSequence)"|", files.stream().map(File::getAbsolutePath).toList())));
        this.systemsFilter.setCellFactory(CheckBoxListCell.forListView(item -> {
            SimpleBooleanProperty observable = new SimpleBooleanProperty(item.isSelected(this.session.getCurrProfile()));
            observable.addListener((obs, wasSelected, isNowSelected) -> {
                item.setSelected(this.session.getCurrProfile(), isNowSelected.booleanValue());
                ProfileViewer.getResetCounter().incrementAndGet();
            });
            return observable;
        }));
        this.sourcesFilter.setCellFactory(CheckBoxListCell.forListView(item -> {
            SimpleBooleanProperty observable = new SimpleBooleanProperty(item.isSelected(this.session.getCurrProfile()));
            observable.addListener((obs, wasSelected, isNowSelected) -> {
                item.setSelected(this.session.getCurrProfile(), isNowSelected.booleanValue());
                ProfileViewer.getResetCounter().incrementAndGet();
            });
            return observable;
        }));
        this.cbbxDriverStatus.setItems(FXCollections.observableArrayList((Object[])Driver.StatusType.values()));
        this.cbbxFilterCabinetType.setItems(FXCollections.observableArrayList((Object[])Machine.CabinetType.values()));
        this.cbbxFilterDisplayOrientation.setItems(FXCollections.observableArrayList((Object[])Machine.DisplayOrientation.values()));
        this.cbbxSWMinSupportedLvl.setItems(FXCollections.observableArrayList((Object[])Software.Supported.values()));
        this.chckbxIncludeClones.setOnAction(e -> {
            this.session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_InclClones, this.chckbxIncludeClones.isSelected());
            ProfileViewer.getResetCounter().incrementAndGet();
        });
        this.chckbxIncludeDisks.setOnAction(e -> {
            this.session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_InclDisks, this.chckbxIncludeDisks.isSelected());
            ProfileViewer.getResetCounter().incrementAndGet();
        });
        this.chckbxIncludeSamples.setOnAction(e -> {
            this.session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_InclSamples, this.chckbxIncludeSamples.isSelected());
            ProfileViewer.getResetCounter().incrementAndGet();
        });
        this.cbbxFilterCabinetType.setOnAction(e -> {
            this.session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_CabinetType, ((Machine.CabinetType)this.cbbxFilterCabinetType.getValue()).toString());
            ProfileViewer.getResetCounter().incrementAndGet();
        });
        this.cbbxFilterDisplayOrientation.setOnAction(e -> {
            this.session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_DisplayOrientation, ((Machine.DisplayOrientation)this.cbbxFilterDisplayOrientation.getValue()).toString());
            ProfileViewer.getResetCounter().incrementAndGet();
        });
        this.cbbxDriverStatus.setOnAction(e -> {
            this.session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_DriverStatus, ((Driver.StatusType)this.cbbxDriverStatus.getValue()).toString());
            ProfileViewer.getResetCounter().incrementAndGet();
        });
        this.cbbxSWMinSupportedLvl.setOnAction(e -> {
            this.session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_MinSoftwareSupportedLevel, ((Software.Supported)this.cbbxSWMinSupportedLvl.getValue()).toString());
            ProfileViewer.getResetCounter().incrementAndGet();
        });
        this.cbbxYearMin.setOnAction(e -> {
            this.session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_YearMin, (String)this.cbbxYearMin.getValue());
            ProfileViewer.getResetCounter().incrementAndGet();
        });
        this.cbbxYearMax.setOnAction(e -> {
            this.session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_YearMax, (String)this.cbbxYearMax.getValue());
            ProfileViewer.getResetCounter().incrementAndGet();
        });
        new DragNDrop((Control)this.tfNPlayers).addFile(this::selectNPlayersFile);
        this.listNPlayers.setCellFactory(CheckBoxListCell.forListView(item -> {
            SimpleBooleanProperty observable = new SimpleBooleanProperty(item.isSelected(this.session.getCurrProfile()));
            observable.addListener((obs, wasSelected, isNowSelected) -> {
                item.setSelected(this.session.getCurrProfile(), isNowSelected.booleanValue());
                ProfileViewer.getResetCounter().incrementAndGet();
            });
            return observable;
        }));
        new DragNDrop((Control)this.tfCatVer).addFile(this::selectCatVerFile);
        this.treeCatVer.setCellFactory(CheckBoxTreeCell.forTreeView(item -> {
            if (item instanceof CheckBoxTreeItem) {
                CheckBoxTreeItem i = (CheckBoxTreeItem)item;
                return i.selectedProperty();
            }
            return null;
        }, (StringConverter)new StringConverter<TreeItem<PropertyStub>>(this){

            public String toString(TreeItem<PropertyStub> object) {
                return ((PropertyStub)object.getValue()).toString();
            }

            public TreeItem<PropertyStub> fromString(String string) {
                return null;
            }
        }));
        this.cbAutomation.setItems(FXCollections.observableArrayList((Object[])ScanAutomation.values()));
        this.cbAutomation.setCellFactory(param -> new DescriptorCellFactory());
        this.cbAutomation.setButtonCell((ListCell)this.cbAutomation.getCellFactory().call(null));
        this.cbAutomation.setOnAction(e -> this.session.getCurrProfile().setProperty(ProfileSettingsEnum.automation_scan, ((Descriptor)this.cbAutomation.getValue()).toString()));
        this.importBtn.setOnAction(e -> {
            List<FileChooser.ExtensionFilter> filters = Arrays.asList(new FileChooser.ExtensionFilter("Properties", new String[]{"*.properties"}));
            Path presets = this.session.getUser().getSettings().getWorkPath().resolve("presets");
            this.chooseOpenFile((Control)this.importBtn, null, presets.toFile(), filters, file -> {
                this.session.getCurrProfile().loadSettings(PathAbstractor.getAbsolutePath((Session)this.session, (String)file.toString()).toFile());
                this.session.getCurrProfile().loadCatVer(null);
                this.session.getCurrProfile().loadNPlayers(null);
                this.initProfileSettings(this.session);
            });
        });
        this.exportBtn.setOnAction(e -> {
            List<FileChooser.ExtensionFilter> filters = Arrays.asList(new FileChooser.ExtensionFilter("Properties", new String[]{"*.properties"}));
            Path presets = this.session.getUser().getSettings().getWorkPath().resolve("presets");
            try {
                Files.createDirectories(presets, new FileAttribute[0]);
                this.chooseSaveFile((Control)this.exportBtn, null, presets.toFile(), filters, file -> this.session.getCurrProfile().saveSettings(PathAbstractor.getAbsolutePath((Session)this.session, (String)file.toString()).toFile()));
            }
            catch (IOException e1) {
                Log.err((String)e1.getMessage(), (Throwable)e1);
            }
        });
    }

    @Override
    public void loadProfile(final Session session, final ProfileNFO profile) {
        if (session.getCurrProfile() != null) {
            session.getCurrProfile().saveSettings();
        }
        if (MainFrame.getProfileViewer() != null) {
            MainFrame.getProfileViewer().clear();
        }
        try {
            Thread thread = new Thread((Runnable)((Object)new ProgressTask<Profile>((Stage)this.romsDest.getScene().getWindow()){

                protected Profile call() throws Exception {
                    return Profile.load((Session)session, (ProfileNFO)profile, (ProgressHandler)this);
                }

                protected void succeeded() {
                    try {
                        Profile profile2 = (Profile)this.get();
                        session.getReport().setProfile(session.getCurrProfile());
                        MainFrame.getReportFrame().setNeedUpdate(true);
                        ProfileViewer.getResetCounter().incrementAndGet();
                        MainFrame.getController().getScannerPanelTab().setDisable(profile2 == null);
                        ScannerPanelController.this.scanBtn.setDisable(profile2 == null);
                        ScannerPanelController.this.fixBtn.setDisable(true);
                        if (profile2 != null && session.getCurrProfile() != null) {
                            ScannerPanelController.this.profileinfoLbl.getChildren().setAll(NeutralToNodeFormatter.toNodes(session.getCurrProfile().getName()));
                            ScannerPanelController.this.systemsFilter.setItems(FXCollections.observableList((List)session.getCurrProfile().getSystems().getSystems()));
                            ScannerPanelController.this.sourcesFilter.setItems(FXCollections.observableList((List)session.getCurrProfile().getSources().getSrces()));
                            ScannerPanelController.this.initProfileSettings(session);
                            MainFrame.getController().getTabPane().getSelectionModel().select(1);
                            MainFrame.getController().getProfilePanelController().refreshList();
                        }
                        this.close();
                    }
                    catch (InterruptedException e) {
                        this.close();
                        Log.err((String)e.getMessage(), (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        this.close();
                        Optional.ofNullable(e.getCause()).ifPresentOrElse(cause -> {
                            Log.err((String)cause.getMessage(), (Throwable)cause);
                            Dialogs.showError(cause);
                        }, () -> {
                            Log.err((String)e.getMessage(), (Throwable)e);
                            Dialogs.showError(e);
                        });
                    }
                }

                protected void failed() {
                    if (this.getException() instanceof BreakException) {
                        Dialogs.showAlert("Cancelled");
                    } else {
                        this.close();
                        Optional.ofNullable(this.getException().getCause()).ifPresentOrElse(cause -> {
                            Log.err((String)cause.getMessage(), (Throwable)cause);
                            Dialogs.showError(cause);
                        }, () -> {
                            Log.err((String)this.getException().getMessage(), (Throwable)this.getException());
                            Dialogs.showError(this.getException());
                        });
                    }
                }
            }));
            thread.setDaemon(true);
            thread.start();
        }
        catch (IOException | URISyntaxException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            Dialogs.showError(e);
        }
    }

    @FXML
    private void scan(ActionEvent e) {
        this.scan(this.session, true);
    }

    private void scan(final Session session, final boolean automate) {
        String txtdstdir = this.romsDest.getText();
        if (txtdstdir.isEmpty()) {
            this.romsDestBtn.fire();
            txtdstdir = this.romsDest.getText();
        }
        if (txtdstdir.isEmpty()) {
            return;
        }
        try {
            Thread thread = new Thread((Runnable)((Object)new ProgressTask<Scan>((Stage)this.romsDest.getScene().getWindow()){

                protected Scan call() throws Exception {
                    return new Scan(session.getCurrProfile(), (ProgressHandler)this);
                }

                protected void succeeded() {
                    try {
                        session.setCurrScan((Scan)this.get());
                        ScannerPanelController.this.fixBtn.setDisable(session.getCurrScan() == null || session.getCurrScan().actions.stream().mapToInt(Collection::size).sum() == 0);
                        this.close();
                        if (MainFrame.getProfileViewer() != null) {
                            MainFrame.getProfileViewer().reload();
                        }
                        ScanAutomation automation = ScanAutomation.valueOf((String)session.getCurrProfile().getSettings().getProperty((EnumWithDefault)ProfileSettingsEnum.automation_scan));
                        if (MainFrame.getReportFrame() != null) {
                            if (automation.hasReport()) {
                                MainFrame.getReportFrame().setVisible();
                            }
                            MainFrame.getReportFrame().setNeedUpdate(true);
                        }
                        if (automate && !ScannerPanelController.this.fixBtn.isDisabled() && automation.hasFix()) {
                            ScannerPanelController.this.fix(session);
                        }
                    }
                    catch (InterruptedException e) {
                        this.close();
                        Log.err((String)e.getMessage(), (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        this.close();
                        Optional.ofNullable(e.getCause()).ifPresentOrElse(cause -> {
                            Log.err((String)cause.getMessage(), (Throwable)cause);
                            Dialogs.showError(cause);
                        }, () -> {
                            Log.err((String)e.getMessage(), (Throwable)e);
                            Dialogs.showError(e);
                        });
                    }
                }

                protected void failed() {
                    this.close();
                    if (this.getException() instanceof BreakException) {
                        Dialogs.showAlert("Cancelled");
                    } else {
                        Optional.ofNullable(this.getException().getCause()).ifPresentOrElse(cause -> {
                            Log.err((String)cause.getMessage(), (Throwable)cause);
                            Dialogs.showError(cause);
                        }, () -> {
                            Log.err((String)this.getException().getMessage(), (Throwable)this.getException());
                            Dialogs.showError(this.getException());
                        });
                    }
                }
            }));
            thread.setDaemon(true);
            thread.start();
        }
        catch (IOException | URISyntaxException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            Dialogs.showError(e);
        }
    }

    @FXML
    private void report(ActionEvent evt) {
        MainFrame.getReportFrame().setVisible();
    }

    @FXML
    private void fix(ActionEvent e) {
        this.fix(this.session);
    }

    private void fix(final Session session) {
        try {
            Thread thread = new Thread((Runnable)((Object)new ProgressTask<Fix>((Stage)this.romsDest.getScene().getWindow()){
                private boolean toFix;
                {
                    super(owner);
                    this.toFix = false;
                }

                protected Fix call() throws Exception {
                    Fix fix;
                    Optional<ButtonType> answer;
                    if (session.getCurrProfile().hasPropsChanged() && (answer = Dialogs.showConfirmation(Messages.getString((String)"MainFrame.WarnSettingsChanged"), Messages.getString((String)"MainFrame.RescanBeforeFix"), ButtonType.YES, ButtonType.NO, ButtonType.CANCEL)).isPresent()) {
                        if (answer.get() == ButtonType.YES) {
                            session.setCurrScan(new Scan(session.getCurrProfile(), (ProgressHandler)this));
                            boolean bl = this.toFix = session.getCurrScan().actions.stream().mapToInt(Collection::size).sum() > 0;
                            if (!this.toFix) {
                                return null;
                            }
                        } else if (answer.get() != ButtonType.NO) {
                            return null;
                        }
                    }
                    this.toFix = (fix = new Fix(session.getCurrProfile(), session.getCurrScan(), (ProgressHandler)this)).getActionsRemain() > 0;
                    return fix;
                }

                protected void succeeded() {
                    try {
                        ScanAutomation automation;
                        this.get();
                        ScannerPanelController.this.fixBtn.setDisable(!this.toFix);
                        this.close();
                        if (MainFrame.getProfileViewer() != null) {
                            MainFrame.getProfileViewer().reload();
                        }
                        if ((automation = ScanAutomation.valueOf((String)session.getCurrProfile().getSettings().getProperty((EnumWithDefault)ProfileSettingsEnum.automation_scan))).hasScanAgain()) {
                            ScannerPanelController.this.scan(session, false);
                        }
                    }
                    catch (InterruptedException e) {
                        this.close();
                        Log.err((String)e.getMessage(), (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        this.close();
                        Optional.ofNullable(e.getCause()).ifPresentOrElse(cause -> {
                            Log.err((String)cause.getMessage(), (Throwable)cause);
                            Dialogs.showError(cause);
                        }, () -> {
                            Log.err((String)e.getMessage(), (Throwable)e);
                            Dialogs.showError(e);
                        });
                    }
                }

                protected void failed() {
                    if (this.getException() instanceof BreakException) {
                        Dialogs.showAlert("Cancelled");
                    } else {
                        this.close();
                        Optional.ofNullable(this.getException().getCause()).ifPresentOrElse(cause -> {
                            Log.err((String)cause.getMessage(), (Throwable)cause);
                            Dialogs.showError(cause);
                        }, () -> {
                            Log.err((String)this.getException().getMessage(), (Throwable)this.getException());
                            Dialogs.showError(this.getException());
                        });
                    }
                }
            }));
            thread.setDaemon(true);
            thread.start();
        }
        catch (IOException | URISyntaxException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            Dialogs.showError(e);
        }
    }

    private void initProfileSettings(Session session) {
        this.romsDest.setText(session.getCurrProfile().getProperty(ProfileSettingsEnum.roms_dest_dir));
        this.disksDestCB.setSelected(((Boolean)session.getCurrProfile().getProperty(ProfileSettingsEnum.disks_dest_dir_enabled, Boolean.class)).booleanValue());
        this.disksDest.setText(session.getCurrProfile().getProperty(ProfileSettingsEnum.disks_dest_dir));
        this.swDestCB.setSelected(((Boolean)session.getCurrProfile().getProperty(ProfileSettingsEnum.swroms_dest_dir_enabled, Boolean.class)).booleanValue());
        this.swDest.setText(session.getCurrProfile().getProperty(ProfileSettingsEnum.swroms_dest_dir));
        this.swDisksDestCB.setSelected(((Boolean)session.getCurrProfile().getProperty(ProfileSettingsEnum.swdisks_dest_dir_enabled, Boolean.class)).booleanValue());
        this.swDisksDest.setText(session.getCurrProfile().getProperty(ProfileSettingsEnum.swdisks_dest_dir));
        this.samplesDestCB.setSelected(((Boolean)session.getCurrProfile().getProperty(ProfileSettingsEnum.samples_dest_dir_enabled, Boolean.class)).booleanValue());
        this.samplesDest.setText(session.getCurrProfile().getProperty(ProfileSettingsEnum.samples_dest_dir));
        this.backupDestCB.setSelected(((Boolean)session.getCurrProfile().getProperty(ProfileSettingsEnum.backup_dest_dir_enabled, Boolean.class)).booleanValue());
        this.backupDest.setText(session.getCurrProfile().getProperty(ProfileSettingsEnum.backup_dest_dir));
        this.srcList.setItems(FXCollections.observableList(Stream.of(StringUtils.split((String)session.getCurrProfile().getProperty(ProfileSettingsEnum.src_dir), (char)'|')).filter(s -> !s.isEmpty()).map(File::new).collect(Collectors.toList())));
        this.scannerPanelSettingsController.initProfileSettings(session.getCurrProfile().getSettings());
        this.chckbxIncludeClones.setSelected(((Boolean)session.getCurrProfile().getProperty(ProfileSettingsEnum.filter_InclClones, Boolean.class)).booleanValue());
        this.chckbxIncludeDisks.setSelected(((Boolean)session.getCurrProfile().getProperty(ProfileSettingsEnum.filter_InclDisks, Boolean.class)).booleanValue());
        this.chckbxIncludeSamples.setSelected(((Boolean)session.getCurrProfile().getProperty(ProfileSettingsEnum.filter_InclSamples, Boolean.class)).booleanValue());
        this.cbbxDriverStatus.getSelectionModel().select((Object)Driver.StatusType.valueOf((String)session.getCurrProfile().getProperty(ProfileSettingsEnum.filter_DriverStatus)));
        this.cbbxFilterCabinetType.getSelectionModel().select((Object)Machine.CabinetType.valueOf((String)session.getCurrProfile().getProperty(ProfileSettingsEnum.filter_CabinetType)));
        this.cbbxFilterDisplayOrientation.getSelectionModel().select((Object)Machine.DisplayOrientation.valueOf((String)session.getCurrProfile().getProperty(ProfileSettingsEnum.filter_DisplayOrientation)));
        this.cbbxSWMinSupportedLvl.getSelectionModel().select((Object)Software.Supported.valueOf((String)session.getCurrProfile().getProperty(ProfileSettingsEnum.filter_MinSoftwareSupportedLevel)));
        this.cbbxYearMin.setItems((ObservableList)FXCollections.observableArrayList((Collection)session.getCurrProfile().getYears()).sorted());
        this.cbbxYearMin.getSelectionModel().select((Object)session.getCurrProfile().getProperty(ProfileSettingsEnum.filter_YearMin));
        this.cbbxYearMax.setItems((ObservableList)FXCollections.observableArrayList((Collection)session.getCurrProfile().getYears()).sorted());
        this.cbbxYearMax.getSelectionModel().select((Object)session.getCurrProfile().getProperty(ProfileSettingsEnum.filter_YearMax));
        this.showNPlayers();
        this.showCatVer();
        this.cbAutomation.getSelectionModel().select((Object)ScanAutomation.valueOf((String)session.getCurrProfile().getProperty(ProfileSettingsEnum.automation_scan)));
    }

    private void selectNPlayersFile(String file) {
        if (Files.isRegularFile(Path.of(file, new String[0]), new LinkOption[0])) {
            this.session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_nplayers_ini, file);
            this.session.getCurrProfile().loadNPlayers(null);
            this.showNPlayers();
        }
    }

    private void showNPlayers() {
        this.tfNPlayers.setText(this.session.getCurrProfile().getNplayers() != null ? this.session.getCurrProfile().getNplayers().file.getAbsolutePath() : null);
        this.listNPlayers.setItems((ObservableList)Optional.ofNullable(this.session.getCurrProfile().getNplayers()).map(NPlayers::getListNPlayers).map(FXCollections::observableArrayList).orElse(null));
    }

    private void selectCatVerFile(String file) {
        if (Files.isRegularFile(Path.of(file, new String[0]), new LinkOption[0])) {
            this.session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_catver_ini, file);
            this.session.getCurrProfile().loadCatVer(null);
            this.showCatVer();
        }
    }

    private void showCatVer() {
        this.tfCatVer.setText(this.session.getCurrProfile().getCatver() != null ? this.session.getCurrProfile().getCatver().file.getAbsolutePath() : null);
        CatVer root = this.session.getCurrProfile().getCatver();
        if (root != null) {
            CheckBoxTreeItem rootitem = new CheckBoxTreeItem((Object)root);
            rootitem.setExpanded(true);
            this.session.getCurrProfile().getCatver().forEach(cat -> {
                CheckBoxTreeItem catitem = new CheckBoxTreeItem(cat);
                rootitem.getChildren().add((Object)catitem);
                cat.forEach(subcat -> catitem.getChildren().add((Object)new CheckBoxTreeItem(subcat)));
            });
            this.treeCatVer.setRoot((TreeItem)rootitem);
            rootitem.selectedProperty().addListener((observable, oldvalue, newvalue) -> root.setSelected(newvalue.booleanValue()));
            rootitem.getChildren().forEach(catitem -> {
                ((CheckBoxTreeItem)catitem).selectedProperty().addListener((observable, oldvalue, newvalue) -> ((CatVer.Category)catitem.getValue()).setSelected(newvalue.booleanValue()));
                catitem.getChildren().forEach(subcatitem -> {
                    ((CheckBoxTreeItem)subcatitem).selectedProperty().addListener((observable, oldvalue, newvalue) -> {
                        ((CatVer.Category.SubCategory)subcatitem.getValue()).setSelected(newvalue.booleanValue());
                        this.treeCatVer.refresh();
                        ProfileViewer.getResetCounter().incrementAndGet();
                    });
                    ((CheckBoxTreeItem)subcatitem).setSelected(((CatVer.Category.SubCategory)subcatitem.getValue()).isSelected());
                });
            });
        } else {
            this.treeCatVer.setRoot(null);
        }
    }

    @FXML
    private void chooseRomsDest(ActionEvent e) {
        this.chooseAnyDest(this.romsDest, ProfileSettingsEnum.roms_dest_dir, "MainFrame.ChooseRomsDestination");
    }

    @FXML
    private void chooseDisksDest(ActionEvent e) {
        this.chooseAnyDest(this.disksDest, ProfileSettingsEnum.disks_dest_dir, "MainFrame.ChooseDisksDestination");
    }

    @FXML
    private void chooseSWRomsDest(ActionEvent e) {
        this.chooseAnyDest(this.swDest, ProfileSettingsEnum.swroms_dest_dir, "MainFrame.ChooseSWRomsDestination");
    }

    @FXML
    private void chooseSWDisksDest(ActionEvent e) {
        this.chooseAnyDest(this.swDisksDest, ProfileSettingsEnum.swdisks_dest_dir, "MainFrame.ChooseSWDisksDestination");
    }

    @FXML
    private void chooseSamplesDest(ActionEvent e) {
        this.chooseAnyDest(this.samplesDest, ProfileSettingsEnum.samples_dest_dir, "MainFrame.ChooseSamplesDestination");
    }

    @FXML
    private void chooseBackupDest(ActionEvent e) {
        this.chooseAnyDest(this.backupDest, ProfileSettingsEnum.backup_dest_dir, "MainFrame.ChooseBackupDestination");
    }

    private void chooseAnyDest(TextField tf, ProfileSettingsEnum ppt, String defPptName) {
        File workdir = this.session.getUser().getSettings().getWorkPath().toFile();
        File defdir = PathAbstractor.getAbsolutePath((Session)this.session, (String)this.session.getUser().getSettings().getProperty(defPptName, workdir.getAbsolutePath())).toFile();
        this.chooseDir((Control)tf, tf.getText(), defdir, dir -> {
            tf.setText(dir.toString());
            this.session.getUser().getSettings().setProperty(defPptName, tf.getText());
            this.session.getCurrProfile().setProperty(ppt, tf.getText());
        });
    }

    private void chooseSrc(File oldDir, ProfileSettingsEnum ppt, String defPptName) {
        File workdir = this.session.getUser().getSettings().getWorkPath().toFile();
        File defdir = PathAbstractor.getAbsolutePath((Session)this.session, (String)this.session.getUser().getSettings().getProperty(defPptName, workdir.getAbsolutePath())).toFile();
        this.chooseDir((Control)this.srcList, oldDir != null ? oldDir.toString() : null, defdir, dir -> {
            boolean modified = false;
            if (oldDir != null) {
                if (!oldDir.equals(dir.toFile())) {
                    int i = this.srcList.getItems().indexOf((Object)oldDir);
                    this.srcList.getItems().set(i, (Object)dir.toFile());
                    modified = true;
                }
            } else if (-1 == this.srcList.getItems().indexOf((Object)dir.toFile())) {
                this.srcList.getItems().add((Object)dir.toFile());
                modified = true;
            }
            if (modified) {
                this.saveSrcList();
                this.session.getUser().getSettings().setProperty(defPptName, dir.toString());
            }
        });
    }

    private void saveSrcList() {
        this.session.getCurrProfile().setProperty(ProfileSettingsEnum.src_dir, String.join((CharSequence)"|", this.srcList.getItems().stream().map(File::getAbsolutePath).toList()));
    }

    @FXML
    private void infos(ActionEvent evt) {
        if (MainFrame.getProfileViewer() == null) {
            try {
                MainFrame.setProfileViewer(new ProfileViewer((Stage)this.infosBtn.getScene().getWindow()));
            }
            catch (IOException | URISyntaxException e) {
                Log.err((String)e.getMessage(), (Throwable)e);
            }
        }
        if (MainFrame.getProfileViewer() != null) {
            MainFrame.getProfileViewer().show();
            MainFrame.getProfileViewer().reload();
        }
    }

    @FXML
    private void systemsFilterSelectAll() {
        for (Systm systm : this.session.getCurrProfile().getSystems()) {
            systm.setSelected(this.session.getCurrProfile(), true);
        }
        this.systemsFilter.refresh();
        ProfileViewer.getResetCounter().incrementAndGet();
    }

    @FXML
    private void systemsFilterSelectAllBios() {
        for (Systm systm : this.session.getCurrProfile().getSystems()) {
            if (systm.getType() != Systm.Type.BIOS) continue;
            systm.setSelected(this.session.getCurrProfile(), true);
        }
        this.systemsFilter.refresh();
        ProfileViewer.getResetCounter().incrementAndGet();
    }

    @FXML
    private void systemsFilterSelectAllSoftwares() {
        for (Systm systm : this.session.getCurrProfile().getSystems()) {
            if (systm.getType() != Systm.Type.SOFTWARELIST) continue;
            systm.setSelected(this.session.getCurrProfile(), true);
        }
        this.systemsFilter.refresh();
        ProfileViewer.getResetCounter().incrementAndGet();
    }

    @FXML
    private void systemsFilterUnselectAll() {
        for (Systm systm : this.session.getCurrProfile().getSystems()) {
            systm.setSelected(this.session.getCurrProfile(), false);
        }
        this.systemsFilter.refresh();
        ProfileViewer.getResetCounter().incrementAndGet();
    }

    @FXML
    private void systemsFilterUnselectAllBios() {
        for (Systm systm : this.session.getCurrProfile().getSystems()) {
            if (systm.getType() != Systm.Type.BIOS) continue;
            systm.setSelected(this.session.getCurrProfile(), false);
        }
        this.systemsFilter.refresh();
        ProfileViewer.getResetCounter().incrementAndGet();
    }

    @FXML
    private void systemsFilterUnselectAllSoftwares() {
        for (Systm systm : this.session.getCurrProfile().getSystems()) {
            if (systm.getType() != Systm.Type.SOFTWARELIST) continue;
            systm.setSelected(this.session.getCurrProfile(), false);
        }
        this.systemsFilter.refresh();
        ProfileViewer.getResetCounter().incrementAndGet();
    }

    @FXML
    private void systemsFilterInvertSelection() {
        for (Systm systm : this.session.getCurrProfile().getSystems()) {
            systm.setSelected(this.session.getCurrProfile(), !systm.isSelected(this.session.getCurrProfile()));
        }
        this.systemsFilter.refresh();
        ProfileViewer.getResetCounter().incrementAndGet();
    }

    @FXML
    private void sourcesFilterSelectAll() {
        for (Source source : this.session.getCurrProfile().getSources()) {
            source.setSelected(this.session.getCurrProfile(), true);
        }
        this.sourcesFilter.refresh();
        ProfileViewer.getResetCounter().incrementAndGet();
    }

    @FXML
    private void sourcesFilterUnselectAll() {
        for (Source source : this.session.getCurrProfile().getSources()) {
            source.setSelected(this.session.getCurrProfile(), false);
        }
        this.sourcesFilter.refresh();
        ProfileViewer.getResetCounter().incrementAndGet();
    }

    @FXML
    private void sourcesFilterInvertSelection() {
        for (Source source : this.session.getCurrProfile().getSources()) {
            source.setSelected(this.session.getCurrProfile(), !source.isSelected(this.session.getCurrProfile()));
        }
        this.sourcesFilter.refresh();
        ProfileViewer.getResetCounter().incrementAndGet();
    }

    @FXML
    void nPlayersListSelectAll() {
        for (NPlayer nplayer : this.session.getCurrProfile().getNplayers()) {
            nplayer.setSelected(this.session.getCurrProfile(), true);
        }
        this.listNPlayers.refresh();
        ProfileViewer.getResetCounter().incrementAndGet();
    }

    @FXML
    void nPlayersListSelectNone() {
        for (NPlayer nplayer : this.session.getCurrProfile().getNplayers()) {
            nplayer.setSelected(this.session.getCurrProfile(), false);
        }
        this.listNPlayers.refresh();
        ProfileViewer.getResetCounter().incrementAndGet();
    }

    @FXML
    void nPlayersListSelectInvert() {
        for (NPlayer nplayer : this.session.getCurrProfile().getNplayers()) {
            nplayer.setSelected(this.session.getCurrProfile(), !nplayer.isSelected(this.session.getCurrProfile()));
        }
        this.listNPlayers.refresh();
        ProfileViewer.getResetCounter().incrementAndGet();
    }

    @FXML
    void nPlayersListClear() {
        this.session.getCurrProfile().saveSettings();
        this.session.getCurrProfile().setNplayers(null);
        this.session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_nplayers_ini, null);
        this.session.getCurrProfile().saveSettings();
        this.tfNPlayers.setText(null);
        this.listNPlayers.setItems(null);
    }

    private Stream<CheckBoxTreeItem<PropertyStub>> streamSubCatItems() {
        return ((CheckBoxTreeItem)this.treeCatVer.getRoot()).getChildren().stream().flatMap(t -> t.getChildren().stream()).map(t -> (CheckBoxTreeItem)t);
    }

    @FXML
    void catVerListSelectAll() {
        this.streamSubCatItems().forEachOrdered(subcat -> subcat.setSelected(true));
        this.treeCatVer.refresh();
        ProfileViewer.getResetCounter().incrementAndGet();
    }

    @FXML
    void catVerListUnselectAll() {
        this.streamSubCatItems().forEachOrdered(subcat -> subcat.setSelected(false));
        this.treeCatVer.refresh();
        ProfileViewer.getResetCounter().incrementAndGet();
    }

    private Stream<CheckBoxTreeItem<PropertyStub>> streamMatureItems() {
        return this.streamSubCatItems().filter(t -> {
            Object patt0$temp = t.getValue();
            if (!(patt0$temp instanceof CatVer.Category.SubCategory)) return false;
            CatVer.Category.SubCategory subcat = (CatVer.Category.SubCategory)patt0$temp;
            if (subcat.name.endsWith(MATURE)) return true;
            if (!subcat.getParent().name.endsWith(MATURE)) return false;
            return true;
        });
    }

    @FXML
    void catVerListSelectMature() {
        this.streamMatureItems().forEachOrdered(subcat -> subcat.setSelected(true));
        this.treeCatVer.refresh();
        ProfileViewer.getResetCounter().incrementAndGet();
    }

    @FXML
    void catVerListUnselectMature() {
        this.streamMatureItems().forEachOrdered(subcat -> subcat.setSelected(false));
        this.treeCatVer.refresh();
        ProfileViewer.getResetCounter().incrementAndGet();
    }

    @FXML
    void catVerListClear() {
        this.session.getCurrProfile().saveSettings();
        this.session.getCurrProfile().setCatver(null);
        this.session.getCurrProfile().setProperty(ProfileSettingsEnum.filter_catver_ini, null);
        this.session.getCurrProfile().saveSettings();
        this.tfCatVer.setText(null);
        this.treeCatVer.setRoot(null);
    }
}

