/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui;

import java.net.URL;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.cell.TextFieldListCell;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.util.Callback;
import jrm.fx.ui.MainFrame;
import jrm.fx.ui.controls.DescriptorCellFactory;
import jrm.locale.Messages;
import jrm.misc.EnumWithDefault;
import jrm.misc.ProfileSettings;
import jrm.misc.ProfileSettingsEnum;
import jrm.profile.scan.options.Descriptor;
import jrm.profile.scan.options.FormatOptions;
import jrm.profile.scan.options.HashCollisionOptions;
import jrm.profile.scan.options.MergeOptions;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ScannerPanelSettingsController
implements Initializable {
    @FXML
    private CheckBox needSHA1Chkbx;
    @FXML
    private CheckBox useParallelismChkbx;
    @FXML
    private CheckBox createMissingSetsChkbx;
    @FXML
    private CheckBox createOnlyCompleteChkbx;
    @FXML
    private CheckBox ignoreUnneededContainersChkbx;
    @FXML
    private CheckBox ignoreUnneededEntriesChkbx;
    @FXML
    private CheckBox ignoreUnknownContainersChkbx;
    @FXML
    private CheckBox useImplicitMergeChkbx;
    @FXML
    private CheckBox ignoreMergeNameRomsChkbx;
    @FXML
    private CheckBox ignoreMergeNameDisksChkbx;
    @FXML
    private CheckBox excludeGamesChkbx;
    @FXML
    private CheckBox excludeMachinesChkbx;
    @FXML
    private CheckBox backupChkbx;
    @FXML
    private CheckBox zeroEntryMattersChkbx;
    @FXML
    private ComboBox<Descriptor> compressionCbx;
    @FXML
    private ComboBox<Descriptor> mergeModeCbx;
    @FXML
    private ComboBox<Descriptor> collisionModeCbx;
    @FXML
    private ListView<String> dstExcludeGlob;
    @FXML
    private Pane settingsPane;
    @FXML
    private ContextMenu catVerMenu;
    private ProfileSettings settings;
    @FXML
    ContextMenu dstExcludeGlobMenu;
    @FXML
    MenuItem addDstExcludeGlobMenu;
    @FXML
    MenuItem deleteDstExcludeGlobMenu;

    public void initialize(URL location, ResourceBundle resources) {
        Callback cellFactory = param -> new DescriptorCellFactory();
        this.needSHA1Chkbx.selectedProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty((Enum)ProfileSettingsEnum.need_sha1_or_md5, newValue.booleanValue()));
        this.useParallelismChkbx.selectedProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty((Enum)ProfileSettingsEnum.use_parallelism, newValue.booleanValue()));
        this.createMissingSetsChkbx.selectedProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty((Enum)ProfileSettingsEnum.create_mode, newValue.booleanValue()));
        this.createOnlyCompleteChkbx.selectedProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty((Enum)ProfileSettingsEnum.createfull_mode, newValue.booleanValue()));
        this.ignoreUnneededContainersChkbx.selectedProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty((Enum)ProfileSettingsEnum.ignore_unneeded_containers, newValue.booleanValue()));
        this.ignoreUnneededEntriesChkbx.selectedProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty((Enum)ProfileSettingsEnum.ignore_unneeded_entries, newValue.booleanValue()));
        this.ignoreUnknownContainersChkbx.selectedProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty((Enum)ProfileSettingsEnum.ignore_unknown_containers, newValue.booleanValue()));
        this.useImplicitMergeChkbx.selectedProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty((Enum)ProfileSettingsEnum.implicit_merge, newValue.booleanValue()));
        this.ignoreMergeNameRomsChkbx.selectedProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty((Enum)ProfileSettingsEnum.ignore_merge_name_roms, newValue.booleanValue()));
        this.ignoreMergeNameDisksChkbx.selectedProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty((Enum)ProfileSettingsEnum.ignore_merge_name_disks, newValue.booleanValue()));
        this.excludeGamesChkbx.selectedProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty((Enum)ProfileSettingsEnum.exclude_games, newValue.booleanValue()));
        this.excludeMachinesChkbx.selectedProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty((Enum)ProfileSettingsEnum.exclude_machines, newValue.booleanValue()));
        this.backupChkbx.selectedProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty((Enum)ProfileSettingsEnum.backup, newValue.booleanValue()));
        this.zeroEntryMattersChkbx.selectedProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty((Enum)ProfileSettingsEnum.zero_entry_matters, newValue.booleanValue()));
        this.compressionCbx.setItems(FXCollections.observableArrayList((Object[])FormatOptions.values()));
        this.compressionCbx.setCellFactory(cellFactory);
        this.compressionCbx.setButtonCell((ListCell)cellFactory.call(null));
        this.compressionCbx.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty((Enum)ProfileSettingsEnum.format, newValue.toString()));
        this.mergeModeCbx.setItems(FXCollections.observableArrayList((Object[])MergeOptions.values()));
        this.mergeModeCbx.setCellFactory(cellFactory);
        this.mergeModeCbx.setButtonCell((ListCell)cellFactory.call(null));
        this.mergeModeCbx.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty((Enum)ProfileSettingsEnum.merge_mode, newValue.toString()));
        this.collisionModeCbx.setItems(FXCollections.observableArrayList((Object[])HashCollisionOptions.values()));
        this.collisionModeCbx.setCellFactory(cellFactory);
        this.collisionModeCbx.setButtonCell((ListCell)cellFactory.call(null));
        this.collisionModeCbx.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.settings.setProperty((Enum)ProfileSettingsEnum.hash_collision_mode, newValue.toString()));
        MenuItem pdMameMenuItemMerged = new MenuItem(Messages.getString((String)"MainFrame.mntmPleasuredome.text"));
        pdMameMenuItemMerged.setOnAction(e -> this.pdMameMergedPreset());
        MenuItem pdMameMenuItemNonMerged = new MenuItem(Messages.getString((String)"MainFrame.mntmPdMameNon.text"));
        pdMameMenuItemNonMerged.setOnAction(e -> this.pdMameNonMergedPreset());
        MenuItem pdMameMenuItemSplit = new MenuItem(Messages.getString((String)"MainFrame.mntmPdMameSplit.text"));
        pdMameMenuItemSplit.setOnAction(e -> this.pdMameSplitPreset());
        this.catVerMenu = new ContextMenu(new MenuItem[]{new Menu(Messages.getString((String)"MainFrame.mnPresets.text"), null, new MenuItem[]{pdMameMenuItemMerged, pdMameMenuItemNonMerged, pdMameMenuItemSplit})});
        this.settingsPane.setOnContextMenuRequested(event -> {
            this.catVerMenu.show((Node)this.settingsPane, event.getScreenX(), event.getScreenY());
            event.consume();
        });
        this.settingsPane.setOnMousePressed(e -> this.catVerMenu.hide());
        this.addDstExcludeGlobMenu.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/add.png")));
        this.deleteDstExcludeGlobMenu.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/delete.png")));
    }

    void initProfileSettings(ProfileSettings settings) {
        this.settings = settings;
        this.needSHA1Chkbx.setSelected(((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.need_sha1_or_md5, Boolean.class)).booleanValue());
        this.useParallelismChkbx.setSelected(((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.use_parallelism, Boolean.class)).booleanValue());
        this.createMissingSetsChkbx.setSelected(((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.create_mode, Boolean.class)).booleanValue());
        this.createOnlyCompleteChkbx.setSelected(((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.createfull_mode, Boolean.class)).booleanValue());
        this.ignoreUnneededContainersChkbx.setSelected(((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.ignore_unneeded_containers, Boolean.class)).booleanValue());
        this.ignoreUnneededEntriesChkbx.setSelected(((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.ignore_unneeded_entries, Boolean.class)).booleanValue());
        this.ignoreUnknownContainersChkbx.setSelected(((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.ignore_unknown_containers, Boolean.class)).booleanValue());
        this.useImplicitMergeChkbx.setSelected(((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.implicit_merge, Boolean.class)).booleanValue());
        this.ignoreMergeNameRomsChkbx.setSelected(((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.ignore_merge_name_roms, Boolean.class)).booleanValue());
        this.ignoreMergeNameDisksChkbx.setSelected(((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.ignore_merge_name_disks, Boolean.class)).booleanValue());
        this.excludeGamesChkbx.setSelected(((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.exclude_games, Boolean.class)).booleanValue());
        this.excludeMachinesChkbx.setSelected(((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.exclude_machines, Boolean.class)).booleanValue());
        this.backupChkbx.setSelected(((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.backup, Boolean.class)).booleanValue());
        this.zeroEntryMattersChkbx.setSelected(((Boolean)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.zero_entry_matters, Boolean.class)).booleanValue());
        this.compressionCbx.getSelectionModel().select((Object)FormatOptions.valueOf((String)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.format)));
        this.mergeModeCbx.getSelectionModel().select((Object)MergeOptions.valueOf((String)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.merge_mode)));
        this.collisionModeCbx.getSelectionModel().select((Object)HashCollisionOptions.valueOf((String)settings.getProperty((EnumWithDefault)ProfileSettingsEnum.hash_collision_mode)));
        this.dstExcludeGlob.setCellFactory(TextFieldListCell.forListView());
        this.loadGlob();
    }

    @FXML
    private void pdMameMergedPreset() {
        this.createMissingSetsChkbx.setSelected(true);
        this.createOnlyCompleteChkbx.setSelected(false);
        this.ignoreUnneededContainersChkbx.setSelected(false);
        this.ignoreUnneededEntriesChkbx.setSelected(false);
        this.ignoreUnknownContainersChkbx.setSelected(true);
        this.useImplicitMergeChkbx.setSelected(true);
        this.ignoreMergeNameDisksChkbx.setSelected(true);
        this.ignoreMergeNameRomsChkbx.setSelected(false);
        this.zeroEntryMattersChkbx.setSelected(false);
        this.compressionCbx.getSelectionModel().select((Object)FormatOptions.TZIP);
        this.mergeModeCbx.getSelectionModel().select((Object)MergeOptions.MERGE);
        this.collisionModeCbx.getSelectionModel().select((Object)HashCollisionOptions.HALFDUMB);
    }

    @FXML
    private void pdMameNonMergedPreset() {
        this.createMissingSetsChkbx.setSelected(true);
        this.createOnlyCompleteChkbx.setSelected(false);
        this.ignoreUnneededContainersChkbx.setSelected(false);
        this.ignoreUnneededEntriesChkbx.setSelected(false);
        this.ignoreUnknownContainersChkbx.setSelected(true);
        this.useImplicitMergeChkbx.setSelected(true);
        this.ignoreMergeNameDisksChkbx.setSelected(true);
        this.ignoreMergeNameRomsChkbx.setSelected(false);
        this.zeroEntryMattersChkbx.setSelected(false);
        this.compressionCbx.getSelectionModel().select((Object)FormatOptions.TZIP);
        this.mergeModeCbx.getSelectionModel().select((Object)MergeOptions.SUPERFULLNOMERGE);
    }

    @FXML
    private void pdMameSplitPreset() {
        this.createMissingSetsChkbx.setSelected(true);
        this.createOnlyCompleteChkbx.setSelected(false);
        this.ignoreUnneededContainersChkbx.setSelected(false);
        this.ignoreUnneededEntriesChkbx.setSelected(false);
        this.ignoreUnknownContainersChkbx.setSelected(true);
        this.useImplicitMergeChkbx.setSelected(true);
        this.ignoreMergeNameDisksChkbx.setSelected(true);
        this.ignoreMergeNameRomsChkbx.setSelected(false);
        this.compressionCbx.getSelectionModel().select((Object)FormatOptions.TZIP);
        this.mergeModeCbx.getSelectionModel().select((Object)MergeOptions.SPLIT);
        this.zeroEntryMattersChkbx.setSelected(false);
    }

    @FXML
    private void addGlob() {
        this.dstExcludeGlob.getItems().add((Object)"");
        this.dstExcludeGlob.edit(this.dstExcludeGlob.getItems().size() - 1);
    }

    @FXML
    private void delGlob() {
        if (!this.dstExcludeGlob.getSelectionModel().isEmpty()) {
            this.dstExcludeGlob.getItems().remove(this.dstExcludeGlob.getSelectionModel().getSelectedIndex());
            this.saveGlob();
        }
    }

    @FXML
    private void commitGlob(ListView.EditEvent<String> e) {
        if (((String)e.getNewValue()).isBlank()) {
            this.dstExcludeGlob.getItems().remove(e.getIndex());
        } else {
            this.dstExcludeGlob.getItems().set(e.getIndex(), (Object)((String)e.getNewValue()));
        }
        this.saveGlob();
    }

    private void saveGlob() {
        this.settings.setProperty((Enum)ProfileSettingsEnum.exclusion_glob_list, this.dstExcludeGlob.getItems().stream().collect(Collectors.joining("|")));
    }

    private void loadGlob() {
        this.dstExcludeGlob.getItems().setAll(Stream.of(StringUtils.split((String)this.settings.getProperty(ProfileSettingsEnum.exclusion_glob_list.toString(), "|"), (String)"|")).filter(s -> !s.isEmpty()).toList());
    }

    @Generated
    public ProfileSettings getSettings() {
        return this.settings;
    }
}

