/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui.controls;

import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.text.Font;

public final class ButtonCellFactory<S, T>
extends TableCell<S, T> {
    private final Button btn;

    public ButtonCellFactory(String name, Action<S, T> action) {
        this.btn = new Button(name);
        this.btn.setFont(new Font(10.0));
        this.btn.setMinHeight(15.0);
        this.btn.setPadding(new Insets(0.0));
        this.btn.setMaxWidth(Double.MAX_VALUE);
        this.btn.setOnAction(e -> action.doAction(this));
        this.setMinHeight(15.0);
    }

    protected void updateItem(T item, boolean empty) {
        this.setFont(new Font(10.0));
        super.updateItem(item, empty);
        this.setGraphic((Node)(empty ? null : this.btn));
    }

    public static interface Action<S, T> {
        public void doAction(TableCell<S, T> var1);
    }
}

