/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui.controls;

import java.text.SimpleDateFormat;
import java.util.Date;
import javafx.scene.control.TableCell;
import javafx.scene.control.Tooltip;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import jrm.profile.manager.ProfileNFO;

public final class DateCellFactory
extends TableCell<ProfileNFO, Date> {
    private final SimpleDateFormat DATEFMT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    protected void updateItem(Date item, boolean empty) {
        this.setFont(new Font(10.0));
        if (empty) {
            this.setText("");
        } else if (item == null) {
            this.setTextFill((Paint)(this.getTableRow().isSelected() ? Color.LIGHTGRAY : Color.GRAY));
            this.setText("????-??-?? ??:??:??");
        } else {
            String date = this.DATEFMT.format(item);
            this.setText(date);
            this.setTooltip(new Tooltip(date));
        }
        this.setGraphic(null);
        this.setStyle("");
    }
}

