/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui.controls;

import javafx.beans.binding.Bindings;
import javafx.beans.binding.When;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Tooltip;
import javafx.scene.text.Font;
import javafx.util.StringConverter;
import jrm.fx.ui.controls.NameCellFactory;
import jrm.locale.Messages;
import jrm.profile.manager.ProfileNFO;
import jrm.profile.manager.ProfileNFOMame;

public class ProfileCellFactory
extends NameCellFactory<ProfileNFO> {
    public ProfileCellFactory() {
        super(new StringConverter<ProfileNFO>(){
            ProfileNFO nfo;

            public String toString(ProfileNFO nfo) {
                this.nfo = nfo;
                if (nfo != null) {
                    return nfo.getName();
                }
                return null;
            }

            public ProfileNFO fromString(String string) {
                if (this.nfo != null) {
                    this.nfo.setNewName(string);
                }
                return this.nfo;
            }
        });
    }

    @Override
    public void updateItem(ProfileNFO item, boolean empty) {
        this.setFont(new Font(10.0));
        super.updateItem(item, empty);
        if (!empty) {
            StringProperty stringProperty = this.styleProperty();
            When when = Bindings.when((ObservableBooleanValue)this.getTableRow().selectedProperty());
            When.StringConditionBuilder stringConditionBuilder = when.then((ObservableStringValue)new SimpleStringProperty(switch (item.getMame().getStatus()) {
                case ProfileNFOMame.MameStatus.UPTODATE -> "-fx-text-fill: #aaffaa;";
                case ProfileNFOMame.MameStatus.NEEDUPDATE -> "-fx-text-fill: #ffaa88;";
                case ProfileNFOMame.MameStatus.NOTFOUND -> "-fx-text-fill: #ffaaaa;";
                default -> "-fx-text-fill: #ffffff;";
            }));
            stringProperty.bind((ObservableValue)stringConditionBuilder.otherwise((ObservableStringValue)new SimpleStringProperty(switch (item.getMame().getStatus()) {
                case ProfileNFOMame.MameStatus.UPTODATE -> "-fx-text-fill: #00aa00;";
                case ProfileNFOMame.MameStatus.NEEDUPDATE -> "-fx-text-fill: #cc8800;";
                case ProfileNFOMame.MameStatus.NOTFOUND -> "-fx-text-fill: #cc0000;";
                default -> "-fx-text-fill: #000000;";
            })));
            this.setTooltip(new Tooltip(switch (item.getMame().getStatus()) {
                case ProfileNFOMame.MameStatus.UPTODATE -> String.format(Messages.getString((String)"FileTableCellRenderer.IsUpToDate"), item.getName());
                case ProfileNFOMame.MameStatus.NEEDUPDATE -> String.format(Messages.getString((String)"FileTableCellRenderer.NeedUpdateFromMame"), item.getName());
                case ProfileNFOMame.MameStatus.NOTFOUND -> String.format(Messages.getString((String)"FileTableCellRenderer.StatusUnknownMameNotFound"), item.getName());
                default -> this.getText();
            }));
        }
    }
}

