/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui.controls;

import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.effect.BlendMode;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.util.Callback;

public class WebviewCellFactory<S, T>
implements Callback<TableColumn<S, T>, TableCell<S, T>> {
    public TableCell<S, T> call(TableColumn<S, T> column) {
        return new TableCell<S, T>(this){

            protected void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (item == null || empty) {
                    this.setText(null);
                    this.setGraphic(null);
                    this.setStyle("");
                } else {
                    WebView webview = new WebView();
                    WebEngine engine = webview.getEngine();
                    webview.setPrefHeight(-1.0);
                    webview.setBlendMode(BlendMode.DARKEN);
                    webview.setFontScale(0.75);
                    this.setGraphic((Node)webview);
                    engine.loadContent("<body topmargin=0 leftmargin=0 style=\"background-color: transparent;white-space:nowrap;overflow:hidden;text-overflow:ellipsis\">" + String.valueOf(item) + "</body>");
                }
            }
        };
    }
}

