/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui.profile;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import jrm.fx.ui.MainFrame;
import jrm.fx.ui.misc.Settings;
import jrm.fx.ui.profile.ProfileViewerController;
import jrm.locale.Messages;
import jrm.profile.Profile;
import jrm.security.Session;
import jrm.security.Sessions;
import lombok.Generated;

public class ProfileViewer
extends Stage {
    private ProfileViewerController controller;
    private Session session = Sessions.getSingleSession();
    private Profile profile;
    private static final AtomicInteger resetCounter = new AtomicInteger();
    private Timer resetTimer = null;

    public ProfileViewer(Stage parent) throws IOException, URISyntaxException {
        this.initOwner((Window)parent);
        this.initModality(Modality.NONE);
        this.getIcons().add((Object)((Image)parent.getIcons().get(0)));
        this.setOnShowing(e -> Settings.fromJson(this.session.getUser().getSettings().getProperty("ProfileViewer.Bounds", null), this));
        this.setOnCloseRequest(e -> {
            this.session.getUser().getSettings().setProperty("ProfileViewer.Bounds", Settings.toJson(this));
            this.hide();
        });
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("ProfileViewer.fxml").toURI().toURL(), Messages.getBundle());
        Scene root = (Scene)loader.load();
        this.controller = (ProfileViewerController)loader.getController();
        this.setScene(root);
        resetCounter.incrementAndGet();
        this.resetTimer = new Timer(true);
        this.resetTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (resetCounter.get() > 0) {
                    Platform.runLater(() -> {
                        if (MainFrame.getProfileViewer() != null) {
                            resetCounter.set(0);
                            MainFrame.getProfileViewer().reset(ProfileViewer.this.session.getCurrProfile());
                        }
                    });
                }
            }
        }, 0L, 1000L);
    }

    public void clear() {
        this.controller.clear();
    }

    public void reload() {
        this.controller.reload();
    }

    public void reset(Profile profile) {
        this.profile = profile;
        this.controller.reset(profile);
    }

    @Generated
    public Profile getProfile() {
        return this.profile;
    }

    @Generated
    public static AtomicInteger getResetCounter() {
        return resetCounter;
    }
}

