/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui.profile.manager;

import java.io.File;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.image.ImageView;
import jrm.fx.ui.MainFrame;
import jrm.profile.manager.Dir;

public class DirItem
extends TreeItem<Dir> {
    public DirItem(File file) {
        super((Object)new Dir(file, "/"));
        this.setExpanded(true);
        this.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/folder_open.png")));
        this.buildDirTree((Dir)this.getValue(), this);
    }

    private DirItem(Dir dir) {
        super((Object)dir);
        this.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/folder_open.png")));
    }

    private void buildDirTree(Dir dir, DirItem node) {
        File[] listFiles;
        if (dir == null) {
            return;
        }
        File dirfile = dir.getFile();
        if (dirfile != null && dirfile.isDirectory() && (listFiles = dirfile.listFiles()) != null) {
            for (File file : listFiles) {
                if (file == null || !file.isDirectory()) continue;
                DirItem newdir = new DirItem(new Dir(file));
                node.getChildren().add((Object)newdir);
                this.buildDirTree(new Dir(file), newdir);
            }
        }
    }

    public void reload() {
        this.getChildren().clear();
        this.buildDirTree((Dir)this.getValue(), this);
        if (!this.isLeaf()) {
            this.setExpanded(true);
        }
    }
}

