/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui.profile.report;

import java.io.IOException;
import java.net.URISyntaxException;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import jrm.aui.progress.StatusHandler;
import jrm.fx.ui.misc.Settings;
import jrm.fx.ui.profile.report.ReportFrameController;
import jrm.fx.ui.status.NeutralToNodeFormatter;
import jrm.locale.Messages;
import jrm.security.Session;
import jrm.security.Sessions;

public class ReportFrame
extends Stage
implements StatusHandler {
    private ReportFrameController controller;
    private Session session = Sessions.getSingleSession();
    private String status = "";
    private boolean needUpdate = false;

    public ReportFrame(Stage parent) throws IOException, URISyntaxException {
        this.initOwner((Window)parent);
        this.initModality(Modality.NONE);
        this.getIcons().add((Object)((Image)parent.getIcons().get(0)));
        this.setOnShowing(e -> Settings.fromJson(this.session.getUser().getSettings().getProperty("ReportFrame.Bounds", null), this));
        this.setOnCloseRequest(e -> {
            this.session.getUser().getSettings().setProperty("ReportFrame.Bounds", Settings.toJson(this));
            this.hide();
        });
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("ReportFrame.fxml").toURI().toURL(), Messages.getBundle());
        BorderPane root = (BorderPane)loader.load();
        this.controller = (ReportFrameController)loader.getController();
        this.setScene(new Scene((Parent)root));
        this.session.getReport().setStatusHandler((StatusHandler)this);
    }

    public void setStatus(String text) {
        this.status = text;
    }

    public void setNeedUpdate(boolean needUpdate) {
        this.needUpdate = needUpdate;
        if (this.isShowing()) {
            this.update();
        }
    }

    private void update() {
        if (this.needUpdate) {
            this.controller.viewController.setReport(Sessions.getSingleSession().getReport());
            this.controller.status.getChildren().setAll(NeutralToNodeFormatter.toNodes(this.status));
            this.needUpdate = false;
        }
    }

    public void setVisible() {
        this.update();
        super.show();
    }
}

