/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui.profile.report;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import jrm.fx.ui.MainFrame;
import jrm.fx.ui.controls.Dialogs;
import jrm.locale.Messages;
import jrm.misc.Log;
import jrm.profile.data.Entity;
import jrm.profile.data.EntityBase;
import jrm.profile.report.ContainerTZip;
import jrm.profile.report.ContainerUnknown;
import jrm.profile.report.ContainerUnneeded;
import jrm.profile.report.EntryAdd;
import jrm.profile.report.EntryMissing;
import jrm.profile.report.EntryMissingDuplicate;
import jrm.profile.report.EntryOK;
import jrm.profile.report.EntryUnneeded;
import jrm.profile.report.EntryWrongHash;
import jrm.profile.report.EntryWrongName;
import jrm.profile.report.FilterOptions;
import jrm.profile.report.Note;
import jrm.profile.report.Report;
import jrm.profile.report.RomSuspiciousCRC;
import jrm.profile.report.SubjectSet;

public class ReportViewController
implements Initializable {
    @FXML
    protected TreeView<Object> treeview;
    @FXML
    private ContextMenu menu;
    @FXML
    private MenuItem openAllNodes;
    @FXML
    private MenuItem closeAllNodes;
    @FXML
    private CheckMenuItem showok;
    @FXML
    private CheckMenuItem hidemissing;
    @FXML
    private MenuItem detail;
    @FXML
    private MenuItem copyCrc;
    @FXML
    private MenuItem copySha1;
    @FXML
    private MenuItem copyName;
    @FXML
    private MenuItem searchWeb;
    private static final Set<FilterOptions> filterOptions = new HashSet<FilterOptions>();
    private Report report;

    public void initialize(URL location, ResourceBundle resources) {
        this.openAllNodes.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/folder_open.png")));
        this.closeAllNodes.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/folder_closed.png")));
        this.showok.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/folder_closed_green.png")));
        this.hidemissing.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/folder_closed_red.png")));
        this.menu.setOnShowing(e -> {
            TreeItem item = (TreeItem)this.treeview.getSelectionModel().getSelectedItem();
            boolean disabled = item == null || !(item.getValue() instanceof Note);
            this.detail.setDisable(disabled);
            this.copyCrc.setDisable(disabled);
            this.copySha1.setDisable(disabled);
            this.copyName.setDisable(disabled);
            this.searchWeb.setDisable(disabled);
        });
    }

    public void setReport(Report report) {
        this.report = report;
        this.build();
    }

    private void build() {
        TreeItem root = new TreeItem((Object)this.report);
        this.report.stream(filterOptions).forEachOrdered(s -> {
            TreeItem sitem = new TreeItem(s);
            s.stream(filterOptions).forEach(n -> sitem.getChildren().add((Object)new TreeItem(n)));
            root.getChildren().add((Object)sitem);
        });
        this.treeview.setShowRoot(false);
        this.treeview.setFixedCellSize(20.0);
        this.treeview.setCellFactory(p -> new ReportTreeCell());
        this.treeview.setRoot(root);
    }

    @FXML
    private void detail(ActionEvent e) {
        Object object;
        if (this.treeview.getSelectionModel().getSelectedItem() != null && (object = ((TreeItem)this.treeview.getSelectionModel().getSelectedItem()).getValue()) instanceof Note) {
            Note note = (Note)object;
            ReportViewController.detail(note);
        }
    }

    private static void detail(Note note) {
        TextArea node = new TextArea(note.getDetail());
        node.setEditable(false);
        Dialogs.showConfirmation("Detail", (Node)node, ButtonType.OK);
    }

    @FXML
    private void copyCrc(ActionEvent e) {
        Object object;
        if (this.treeview.getSelectionModel().getSelectedItem() != null && (object = ((TreeItem)this.treeview.getSelectionModel().getSelectedItem()).getValue()) instanceof Note) {
            Note note = (Note)object;
            ClipboardContent content = new ClipboardContent();
            content.putString(note.getCrc());
            Clipboard.getSystemClipboard().setContent((Map)content);
        }
    }

    @FXML
    private void copySha1(ActionEvent e) {
        Object object;
        if (this.treeview.getSelectionModel().getSelectedItem() != null && (object = ((TreeItem)this.treeview.getSelectionModel().getSelectedItem()).getValue()) instanceof Note) {
            Note note = (Note)object;
            ClipboardContent content = new ClipboardContent();
            content.putString(note.getSha1());
            Clipboard.getSystemClipboard().setContent((Map)content);
        }
    }

    @FXML
    private void copyName(ActionEvent e) {
        Object object;
        if (this.treeview.getSelectionModel().getSelectedItem() != null && (object = ((TreeItem)this.treeview.getSelectionModel().getSelectedItem()).getValue()) instanceof Note) {
            Note note = (Note)object;
            ClipboardContent content = new ClipboardContent();
            content.putString(note.getName());
            Clipboard.getSystemClipboard().setContent((Map)content);
        }
    }

    @FXML
    private void searchWeb(ActionEvent e) {
        Object object;
        if (this.treeview.getSelectionModel().getSelectedItem() != null && (object = ((TreeItem)this.treeview.getSelectionModel().getSelectedItem()).getValue()) instanceof Note) {
            Note note = (Note)object;
            try {
                String name = note.getName();
                String crc = note.getCrc();
                String sha1 = note.getSha1();
                String hash = Optional.ofNullable(Optional.ofNullable(crc).orElse(sha1)).map(h -> "+" + h).orElse("");
                MainFrame.getApplication().getHostServices().showDocument(new URI("https://www.google.com/search?q=" + URLEncoder.encode("\"" + name + "\"", "UTF-8") + hash).toString());
            }
            catch (IOException | URISyntaxException e1) {
                Log.err((String)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    @FXML
    private void showok(ActionEvent e) {
        if (this.showok.isSelected()) {
            filterOptions.add(FilterOptions.SHOWOK);
        } else {
            filterOptions.remove(FilterOptions.SHOWOK);
        }
        this.build();
    }

    @FXML
    private void hidemissing(ActionEvent e) {
        if (this.hidemissing.isSelected()) {
            filterOptions.add(FilterOptions.HIDEMISSING);
        } else {
            filterOptions.remove(FilterOptions.HIDEMISSING);
        }
        this.build();
    }

    @FXML
    private void openAllNodes(ActionEvent e) {
        TreeItem root = this.treeview.getRoot();
        this.treeview.setRoot(null);
        for (TreeItem child : root.getChildren()) {
            if (child.isLeaf()) continue;
            child.setExpanded(true);
        }
        this.treeview.setRoot(root);
    }

    @FXML
    private void closeAllNodes(ActionEvent e) {
        TreeItem root = this.treeview.getRoot();
        this.treeview.setRoot(null);
        for (TreeItem child : root.getChildren()) {
            if (child.isLeaf()) continue;
            child.setExpanded(false);
        }
        this.treeview.setRoot(root);
    }

    private static final class ReportTreeCell
    extends TreeCell<Object> {
        private static final Pattern regex = Pattern.compile("%s");
        private static final String[] missing = regex.split(Messages.getString((String)"SubjectSet.Missing"));
        private static final String[] unneeded = regex.split(Messages.getString((String)"SubjectSet.Unneeded"));
        private static final String[] foundneedfixes = regex.split(Messages.getString((String)"SubjectSet.FoundNeedFixes"));
        private static final String[] foundincomplete = regex.split(Messages.getString((String)"SubjectSet.FoundIncomplete"));
        private static final String[] found = regex.split(Messages.getString((String)"SubjectSet.Found"));
        private static final String[] missingtotallycreated = regex.split(Messages.getString((String)"SubjectSet.MissingTotallyCreated"));
        private static final String[] missingpartiallycreated = regex.split(Messages.getString((String)"SubjectSet.MissingPartiallyCreated"));
        private static final String[] unknown = regex.split(Messages.getString((String)"SubjectSet.Unknown"));
        private static final String[] eadd = regex.split(Messages.getString((String)"EntryAddAdd"));
        private static final String[] emissing = regex.split(Messages.getString((String)"EntryMissing.Missing"));
        private static final String[] emissingdup = regex.split(Messages.getString((String)"EntryMissingDuplicate.MissingDuplicate"));
        private static final String[] eok = regex.split(Messages.getString((String)"EntryOK.OK"));
        private static final String[] eunneeded = regex.split(Messages.getString((String)"EntryUnneeded.Unneeded"));
        private static final String[] ewronghash = regex.split(Messages.getString((String)"EntryWrongHash.Wrong"));
        private static final String[] ewrongname = regex.split(Messages.getString((String)"EntryWrongName.Wrong"));

        public ReportTreeCell() {
            this.setOnMouseClicked(e -> {
                TreeItem ti = this.getTreeItem();
                if (ti == null || e.getClickCount() < 2) {
                    return;
                }
                Object patt0$temp = ti.getValue();
                if (patt0$temp instanceof Note) {
                    Note note = (Note)patt0$temp;
                    ReportViewController.detail(note);
                }
            });
        }

        protected void updateItem(Object item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setGraphic(null);
                this.setText(null);
            } else if (item instanceof SubjectSet) {
                SubjectSet s = (SubjectSet)item;
                this.updateSubjectSet(s);
            } else if (item instanceof RomSuspiciousCRC) {
                RomSuspiciousCRC s = (RomSuspiciousCRC)item;
                this.updateRomSuspiciousCRC(s);
            } else if (item instanceof ContainerTZip) {
                ContainerTZip s = (ContainerTZip)item;
                this.updateContainerTZip(s);
            } else if (item instanceof ContainerUnknown) {
                ContainerUnknown s = (ContainerUnknown)item;
                this.updateContainerUnknown(s);
            } else if (item instanceof ContainerUnneeded) {
                ContainerUnneeded s = (ContainerUnneeded)item;
                this.updateContainerUnneeded(s);
            } else if (item instanceof EntryAdd) {
                EntryAdd s = (EntryAdd)item;
                this.updateEntryAdd(s);
            } else if (item instanceof EntryMissing) {
                EntryMissing s = (EntryMissing)item;
                this.updateEntryMissing(s);
            } else if (item instanceof EntryMissingDuplicate) {
                EntryMissingDuplicate s = (EntryMissingDuplicate)item;
                this.updateEntryMissingDuplicate(s);
            } else if (item instanceof EntryOK) {
                EntryOK s = (EntryOK)item;
                this.updateEntryOK(s);
            } else if (item instanceof EntryUnneeded) {
                EntryUnneeded s = (EntryUnneeded)item;
                this.updateEntryUnneeded(s);
            } else if (item instanceof EntryWrongHash) {
                EntryWrongHash s = (EntryWrongHash)item;
                this.updateEntryWrongHash(s);
            } else if (item instanceof EntryWrongName) {
                EntryWrongName s = (EntryWrongName)item;
                this.updateEntryWrongName(s);
            } else {
                this.setGraphic(null);
                this.setText(item.toString());
            }
        }

        private void updateContainerUnneeded(ContainerUnneeded s) {
            ImageView i = new ImageView(MainFrame.getIcon("/jrm/resicons/icons/exclamation.png"));
            this.setGraphic((Node)new HBox(new Node[]{i, new Text(s.toString())}));
            this.setText(null);
        }

        private void updateContainerUnknown(ContainerUnknown s) {
            ImageView i = new ImageView(MainFrame.getIcon("/jrm/resicons/icons/error.png"));
            this.setGraphic((Node)new HBox(new Node[]{i, new Text(s.toString())}));
            this.setText(null);
        }

        private void updateContainerTZip(ContainerTZip s) {
            ImageView i = new ImageView(MainFrame.getIcon("/jrm/resicons/icons/compress.png"));
            this.setGraphic((Node)new HBox(new Node[]{i, new Text(s.toString())}));
            this.setText(null);
        }

        private void updateRomSuspiciousCRC(RomSuspiciousCRC s) {
            ImageView i = new ImageView(MainFrame.getIcon("/jrm/resicons/icons/information.png"));
            this.setGraphic((Node)new HBox(new Node[]{i, new Text(s.toString())}));
            this.setText(null);
        }

        private void updateEntryWrongName(EntryWrongName s) {
            ImageView i = new ImageView(MainFrame.getIcon("/jrm/resicons/icons/bullet_pink.png"));
            Text n = new Text(s.getParent().getWare().getFullName());
            n.setFill((Paint)Color.BLUE);
            Text en = new Text(s.getEntry().getName());
            en.setFont(Font.font((String)en.getFont().getFamily(), (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)en.getFont().getSize()));
            Text enn = new Text(s.getEntity().getNormalizedName());
            enn.setFont(Font.font((String)enn.getFont().getFamily(), (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)enn.getFont().getSize()));
            this.setGraphic((Node)new HBox(new Node[]{i, new Text(ewrongname[0]), n, new Text(ewrongname[1]), en, new Text(ewrongname[2]), enn, new Text(ewrongname[3])}));
            this.setText(null);
        }

        private void updateEntryWrongHash(EntryWrongHash s) {
            String hash;
            String ehash;
            String hashname;
            ImageView i = new ImageView(MainFrame.getIcon("/jrm/resicons/icons/bullet_orange.png"));
            Text n = new Text(s.getParent().getWare().getFullName());
            n.setFill((Paint)Color.BLUE);
            Text ef = new Text(s.getEntry().getRelFile());
            ef.setFont(Font.font((String)ef.getFont().getFamily(), (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)ef.getFont().getSize()));
            if (s.getEntry().getMd5() == null && s.getEntry().getSha1() == null) {
                hashname = "CRC";
                ehash = s.getEntry().getCrc();
                hash = s.getCrc();
            } else if (s.getEntry().getSha1() == null) {
                hashname = "MD5";
                ehash = s.getEntry().getMd5();
                hash = s.getMd5();
            } else {
                hashname = "SHA-1";
                ehash = s.getEntry().getSha1();
                hash = s.getSha1();
            }
            this.setGraphic((Node)new HBox(new Node[]{i, new Text(ewronghash[0]), n, new Text(ewronghash[1]), ef, new Text(ewronghash[2]), new Text(hashname), new Text(ewronghash[3]), new Text(ehash), new Text(ewronghash[4]), new Text(hash), new Text(ewronghash[5])}));
            this.setText(null);
        }

        private void updateEntryUnneeded(EntryUnneeded s) {
            ImageView i = new ImageView(MainFrame.getIcon("/jrm/resicons/icons/bullet_black.png"));
            Text n = new Text(s.getParent().getWare().getFullName());
            n.setFill((Paint)Color.BLUE);
            Text ef = new Text(s.getEntry().getRelFile());
            ef.setFont(Font.font((String)ef.getFont().getFamily(), (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)ef.getFont().getSize()));
            String hash = s.getEntry().getSha1() != null ? s.getEntry().getSha1() : (s.getEntry().getMd5() != null ? s.getEntry().getMd5() : s.getEntry().getCrc());
            this.setGraphic((Node)new HBox(new Node[]{i, new Text(eunneeded[0]), n, new Text(eunneeded[1]), ef, new Text(eunneeded[2]), new Text(hash), new Text(eunneeded[3])}));
            this.setText(null);
        }

        private void updateEntryOK(EntryOK s) {
            ImageView i = new ImageView(MainFrame.getIcon("/jrm/resicons/icons/bullet_green.png"));
            Text n = new Text(s.getParent().getWare().getFullName());
            n.setFill((Paint)Color.BLUE);
            Text en = new Text(s.getEntity().getNormalizedName());
            en.setFont(Font.font((String)en.getFont().getFamily(), (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)en.getFont().getSize()));
            this.setGraphic((Node)new HBox(new Node[]{i, new Text(eok[0]), n, new Text(eok[1]), en, new Text(eok[2])}));
            this.setText(null);
        }

        private void updateEntryMissingDuplicate(EntryMissingDuplicate s) {
            ImageView i = new ImageView(MainFrame.getIcon("/jrm/resicons/icons/bullet_purple.png"));
            Text n = new Text(s.getParent().getWare().getFullName());
            n.setFill((Paint)Color.BLUE);
            Text ef = new Text(s.getEntry().getRelFile());
            ef.setFont(Font.font((String)ef.getFont().getFamily(), (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)ef.getFont().getSize()));
            Text en = new Text(s.getEntity().getName());
            en.setFont(Font.font((String)en.getFont().getFamily(), (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)en.getFont().getSize()));
            this.setGraphic((Node)new HBox(new Node[]{i, new Text(emissingdup[0]), n, new Text(emissingdup[1]), ef, new Text(emissingdup[2]), en}));
            this.setText(null);
        }

        private void updateEntryMissing(EntryMissing s) {
            ImageView i = new ImageView(MainFrame.getIcon("/jrm/resicons/icons/bullet_red.png"));
            Text n = new Text(s.getParent().getWare().getFullName());
            n.setFill((Paint)Color.BLUE);
            Text en = new Text(s.getEntity().getName());
            en.setFont(Font.font((String)en.getFont().getFamily(), (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)en.getFont().getSize()));
            EntityBase entityBase = s.getEntity();
            if (entityBase instanceof Entity) {
                Entity e = (Entity)entityBase;
                String hash = e.getSha1() != null ? e.getSha1() : (e.getMd5() != null ? e.getMd5() : e.getCrc());
                this.setGraphic((Node)new HBox(new Node[]{i, new Text(emissing[0]), n, new Text(emissing[1]), en, new Text(emissing[2] + " (" + hash + ")")}));
            } else {
                this.setGraphic((Node)new HBox(new Node[]{i, new Text(emissing[0]), n, new Text(emissing[1]), en, new Text(emissing[2])}));
            }
            this.setText(null);
        }

        private void updateEntryAdd(EntryAdd s) {
            ImageView i = new ImageView(MainFrame.getIcon("/jrm/resicons/icons/bullet_blue.png"));
            Text n = new Text(s.getParent().getWare().getFullName());
            n.setFill((Paint)Color.BLUE);
            Text en = new Text(s.getEntity().getNormalizedName());
            en.setFont(Font.font((String)en.getFont().getFamily(), (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)en.getFont().getSize()));
            Text ep = new Text(s.getEntry().getParent().getRelFile().toString());
            ep.setFont(Font.font((String)ep.getFont().getFamily(), (FontPosture)FontPosture.ITALIC, (double)ep.getFont().getSize()));
            Text ef = new Text(s.getEntry().getRelFile());
            ef.setFont(Font.font((String)ef.getFont().getFamily(), (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)ef.getFont().getSize()));
            this.setGraphic((Node)new HBox(new Node[]{i, new Text(eadd[0]), n, new Text(eadd[1]), en, new Text(eadd[2]), ep, new Text(eadd[3]), ef}));
            this.setText(null);
        }

        private void updateSubjectSet(SubjectSet s) {
            String[] t = switch (s.getStatus()) {
                case SubjectSet.Status.MISSING -> missing;
                case SubjectSet.Status.UNNEEDED -> unneeded;
                case SubjectSet.Status.FOUND -> {
                    if (s.hasNotes()) {
                        if (s.isFixable()) {
                            yield foundneedfixes;
                        }
                        yield foundincomplete;
                    }
                    yield found;
                }
                case SubjectSet.Status.CREATE, SubjectSet.Status.CREATEFULL -> {
                    if (s.isFixable()) {
                        yield missingtotallycreated;
                    }
                    yield missingpartiallycreated;
                }
                default -> unknown;
            };
            ImageView i = s.getNotes().isEmpty() && SubjectSet.Status.FOUND.equals((Object)s.getStatus()) ? new ImageView(MainFrame.getIcon("/jrm/resicons/icons/bullet_green.png")) : new ImageView(MainFrame.getIcon(this.getFolderIcon(s, false)));
            Text n = new Text(s.getWare().getFullName());
            n.setFill((Paint)Color.BLUE);
            Text d = new Text(s.getWare().getDescription().toString());
            d.setFill((Paint)Color.PURPLE);
            this.setGraphic((Node)new HBox(new Node[]{i, new Text(t[0]), n, new Text(t[1]), d, new Text(t[2])}));
            this.setText(null);
        }

        private String getFolderIcon(Object value, boolean expanded) {
            Object icon = "/jrm/resicons/folder";
            icon = (String)icon + (expanded ? "_open" : "_closed");
            if (value instanceof SubjectSet) {
                SubjectSet s = (SubjectSet)value;
                icon = (String)icon + (switch (s.getStatus()) {
                    case SubjectSet.Status.FOUND -> {
                        if (s.hasNotes()) {
                            if (s.isFixable()) {
                                yield "_purple";
                            }
                            yield "_orange";
                        }
                        yield "_green";
                    }
                    case SubjectSet.Status.CREATE, SubjectSet.Status.CREATEFULL -> {
                        if (s.isFixable()) {
                            yield "_blue";
                        }
                        yield "_orange";
                    }
                    case SubjectSet.Status.MISSING -> "_red";
                    case SubjectSet.Status.UNNEEDED -> "_gray";
                    default -> "";
                });
            }
            icon = (String)icon + ".png";
            return icon;
        }
    }
}

