/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui.progress;

import java.net.URL;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import jrm.fx.ui.MainFrame;
import jrm.fx.ui.progress.ProgressTask;
import jrm.fx.ui.status.NeutralToNodeFormatter;
import jrm.locale.Messages;
import lombok.Generated;

public class ProgressController
implements Initializable {
    @FXML
    private VBox panel;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private Label progressBarLbl;
    @FXML
    private Label lblTimeleft;
    @FXML
    private ProgressBar progressBar2;
    @FXML
    private Label progressBarLbl2;
    @FXML
    private Label lblTimeleft2;
    @FXML
    private ProgressBar progressBar3;
    @FXML
    private Label progressBarLbl3;
    @FXML
    private Label lblTimeleft3;
    @FXML
    private Button cancelBtn;
    private ProgressTask<?> task;
    private static final String HH_MM_SS_OF_HH_MM_SS_NONE = "--:--:-- / --:--:--";
    private Pane[] lblInfo = new Pane[0];
    private Pane[] lblSubInfo = new Pane[0];
    private static final Color colorNormal = new Color(0.7, 0.7, 0.7, 1.0);
    private static final Color colorLight = new Color(0.8, 0.8, 0.8, 1.0);
    private static final Color colorLighter = new Color(0.9, 0.9, 0.9, 1.0);
    private Deque<HBox> viewCache = new ArrayDeque<HBox>();

    public void initialize(URL location, ResourceBundle resources) {
        this.cancelBtn.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/stop.png")));
        this.setInfos(1, false);
        this.progressBar2.setVisible(false);
        this.progressBarLbl2.setVisible(false);
        this.lblTimeleft2.setVisible(false);
        ((RowConstraints)((GridPane)this.lblTimeleft2.getParent()).getRowConstraints().get(2)).setPrefHeight(0.0);
        this.progressBar3.setVisible(false);
        this.progressBarLbl3.setVisible(false);
        this.lblTimeleft3.setVisible(false);
        ((RowConstraints)((GridPane)this.lblTimeleft3.getParent()).getRowConstraints().get(3)).setPrefHeight(0.0);
    }

    void setInfos(int threadCnt, Boolean multipleSubInfos) {
        Integer lblSubInfoCnt = Optional.ofNullable(multipleSubInfos).map(multSubNfo -> multSubNfo != false ? threadCnt : 1).orElse(0);
        if (this.lblInfo != null && this.lblInfo.length == threadCnt && this.lblSubInfo != null && this.lblSubInfo.length == lblSubInfoCnt) {
            return;
        }
        this.panel.getChildren().forEach(n -> {
            if (n instanceof HBox) {
                HBox w = (HBox)n;
                w.getChildren().clear();
                this.viewCache.add(w);
            }
        });
        this.panel.getChildren().clear();
        this.lblInfo = new Pane[threadCnt];
        this.lblSubInfo = new Pane[lblSubInfoCnt.intValue()];
        for (int i = 0; i < threadCnt; ++i) {
            this.lblInfo[i] = this.buildView(this.isOdd(i) ? colorNormal : colorLight);
            this.panel.getChildren().add((Object)this.lblInfo[i]);
            if (!Boolean.TRUE.equals(multipleSubInfos)) continue;
            this.lblSubInfo[i] = this.buildView(this.isOdd(i) ? colorNormal : colorLight);
            this.panel.getChildren().add((Object)this.lblSubInfo[i]);
        }
        if (Boolean.FALSE.equals(multipleSubInfos)) {
            this.lblSubInfo[0] = this.buildView(colorLighter);
            this.panel.getChildren().add((Object)this.lblSubInfo[0]);
        }
    }

    void extendInfos(int threadCnt, Boolean multipleSubInfos) {
        if (this.lblInfo == null || this.lblInfo.length == threadCnt) {
            return;
        }
        if (Boolean.TRUE.equals(multipleSubInfos) && this.lblSubInfo == null) {
            return;
        }
        int oldThreadCnt = this.lblInfo.length;
        this.lblInfo = Arrays.copyOf(this.lblInfo, threadCnt);
        if (Boolean.TRUE.equals(multipleSubInfos)) {
            this.lblSubInfo = Arrays.copyOf(this.lblSubInfo, threadCnt);
        }
        for (int i = oldThreadCnt; i < threadCnt; ++i) {
            this.lblInfo[i] = this.buildView(this.isOdd(i) ? colorNormal : colorLight);
            this.panel.getChildren().add((Object)this.lblInfo[i]);
            if (!Boolean.TRUE.equals(multipleSubInfos)) continue;
            this.lblSubInfo[i] = this.buildView(this.isOdd(i) ? colorNormal : colorLight);
            this.panel.getChildren().add((Object)this.lblSubInfo[i]);
        }
    }

    private boolean isOdd(int i) {
        return i % 2 != 0;
    }

    private HBox buildView(Color color) {
        HBox view;
        if (!this.viewCache.isEmpty()) {
            view = this.viewCache.poll();
        } else {
            view = new HBox();
            view.setPrefHeight(20.0);
            view.setMaxWidth(2.147483647E9);
            view.setAlignment(Pos.CENTER_LEFT);
        }
        view.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)color, null, null)}));
        view.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)color.darker(), (Paint)color.brighter(), (Paint)color.brighter(), (Paint)color.darker(), BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, BorderStrokeStyle.SOLID, null, null, null)}));
        return view;
    }

    void clearInfos() {
        for (Pane label : this.lblInfo) {
            label.getChildren().clear();
        }
        for (Pane label : this.lblSubInfo) {
            label.getChildren().clear();
        }
    }

    public void setFullProgress(ProgressTask.PData pd) {
        int i;
        for (i = 0; i < this.lblInfo.length; ++i) {
            this.lblInfo[i].getChildren().setAll(NeutralToNodeFormatter.toNodes(i < pd.getInfos().length ? pd.getInfos()[i] : ""));
        }
        for (i = 0; i < this.lblSubInfo.length; ++i) {
            this.lblSubInfo[i].getChildren().setAll(NeutralToNodeFormatter.toNodes(i < pd.getSubinfos().length ? pd.getSubinfos()[i] : ""));
        }
        if (this.progressBar.isVisible() != pd.getPb1().isVisibility()) {
            this.progressBar.setVisible(pd.getPb1().isVisibility());
            this.progressBarLbl.setVisible(pd.getPb1().isVisibility());
            this.lblTimeleft.setVisible(pd.getPb1().isVisibility());
            ((RowConstraints)((GridPane)this.lblTimeleft.getParent()).getRowConstraints().get(1)).setPrefHeight(pd.getPb1().isVisibility() ? -1.0 : 0.0);
        }
        if (pd.getPb1().isVisibility()) {
            if (pd.getPb1().isIndeterminate()) {
                this.progressBar.setProgress(-1.0);
                this.progressBarLbl.setVisible(false);
            } else if (pd.getPb1().getVal() > 0) {
                if ((int)(this.progressBar.getProgress() * 100.0) != (int)pd.getPb1().getPerc()) {
                    this.progressBar.setProgress(pd.getPb1().getPerc() / 100.0);
                }
                if (pd.getPb1().isStringPainted()) {
                    this.progressBarLbl.setVisible(true);
                    this.progressBarLbl.setText(Optional.ofNullable(pd.getPb1().getMsg()).orElse(""));
                } else {
                    this.progressBarLbl.setVisible(false);
                }
                this.lblTimeleft.setText(pd.getPb1().getTimeleft());
            } else {
                this.lblTimeleft.setText(HH_MM_SS_OF_HH_MM_SS_NONE);
            }
        }
        if (this.progressBar2.isVisible() != pd.getPb2().isVisibility()) {
            this.progressBar2.setVisible(pd.getPb2().isVisibility());
            this.progressBarLbl2.setVisible(pd.getPb2().isVisibility());
            this.lblTimeleft2.setVisible(pd.getPb2().isVisibility());
            ((RowConstraints)((GridPane)this.lblTimeleft2.getParent()).getRowConstraints().get(2)).setPrefHeight(pd.getPb2().isVisibility() ? -1.0 : 0.0);
        }
        if (pd.getPb2().isVisibility()) {
            if (pd.getPb2().isIndeterminate()) {
                this.progressBar2.setProgress(-1.0);
                this.progressBarLbl2.setVisible(false);
            } else if (pd.getPb2().getPerc() >= 0.0) {
                if ((int)(this.progressBar2.getProgress() * 100.0) != (int)pd.getPb2().getPerc()) {
                    this.progressBar2.setProgress(pd.getPb2().getPerc() / 100.0);
                }
                if (pd.getPb2().isStringPainted()) {
                    this.progressBarLbl2.setVisible(true);
                    this.progressBarLbl2.setText(Optional.ofNullable(pd.getPb2().getMsg()).orElse(""));
                } else {
                    this.progressBarLbl2.setVisible(false);
                }
                this.lblTimeleft2.setText(pd.getPb2().getTimeleft());
            } else {
                this.lblTimeleft2.setText(HH_MM_SS_OF_HH_MM_SS_NONE);
            }
        }
        if (this.progressBar3.isVisible() != pd.getPb3().isVisibility()) {
            this.progressBar3.setVisible(pd.getPb3().isVisibility());
            this.progressBarLbl3.setVisible(pd.getPb3().isVisibility());
            this.lblTimeleft3.setVisible(pd.getPb3().isVisibility());
            ((RowConstraints)((GridPane)this.lblTimeleft3.getParent()).getRowConstraints().get(3)).setPrefHeight(pd.getPb3().isVisibility() ? -1.0 : 0.0);
        }
        if (pd.getPb3().isVisibility()) {
            if (pd.getPb3().isIndeterminate()) {
                this.progressBar3.setProgress(-1.0);
                this.progressBarLbl3.setVisible(false);
            } else if (pd.getPb3().getPerc() >= 0.0) {
                if ((int)(this.progressBar3.getProgress() * 100.0) != (int)pd.getPb3().getPerc()) {
                    this.progressBar3.setProgress(pd.getPb3().getPerc() / 100.0);
                }
                if (pd.getPb3().isStringPainted()) {
                    this.progressBarLbl3.setVisible(true);
                    this.progressBarLbl3.setText(Optional.ofNullable(pd.getPb3().getMsg()).orElse(""));
                } else {
                    this.progressBarLbl3.setVisible(false);
                }
                this.lblTimeleft3.setText(pd.getPb3().getTimeleft());
            } else {
                this.lblTimeleft3.setText(HH_MM_SS_OF_HH_MM_SS_NONE);
            }
        }
    }

    void close() {
        this.panel.getScene().getWindow().hide();
    }

    void canCancel(boolean canCancel) {
        this.cancelBtn.setDisable(!canCancel);
    }

    @FXML
    void doCancel() {
        this.task.doCancel();
        this.cancelBtn.setDisable(true);
        this.cancelBtn.setText(Messages.getString((String)"Progress.Canceling"));
    }

    @Generated
    public void setTask(ProgressTask<?> task) {
        this.task = task;
    }
}

