/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui.progress;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.stage.Stage;
import jrm.aui.progress.ProgressHandler;
import jrm.aui.progress.ProgressInputStream;
import jrm.fx.ui.progress.Progress;
import jrm.misc.OffsetProvider;
import lombok.Generated;
import org.apache.commons.lang3.time.DurationFormatUtils;

public abstract class ProgressTask<V>
extends Task<V>
implements ProgressHandler {
    private static final String HH_MM_SS = "HH:mm:ss";
    private static final String S_OF_S = "%s / %s";
    private static final String HH_MM_SS_OF_HH_MM_SS_NONE = "--:--:-- / --:--:--";
    private final Progress progress;
    private final List<String> errors = new ArrayList<String>();
    private boolean cancel = false;
    private boolean canCancel = true;
    private final PData data = new PData();
    private long lastEvent = 0L;
    private PData lastPData = null;
    private Set<ProgressHandler.Option> options = EnumSet.noneOf(ProgressHandler.Option.class);
    private OffsetProvider offsetProvider = null;

    protected ProgressTask(Stage owner) throws IOException, URISyntaxException {
        this.progress = new Progress(owner, this);
    }

    public synchronized void setInfos(int threadCnt, Boolean multipleSubInfos) {
        this.data.threadCnt = threadCnt <= 0 ? Runtime.getRuntime().availableProcessors() : threadCnt;
        this.data.multipleSubInfos = multipleSubInfos;
        this.data.infos = new String[this.data.threadCnt];
        this.data.subinfos = multipleSubInfos == null ? new String[0] : new String[multipleSubInfos != false ? this.data.threadCnt : 1];
        Platform.runLater(() -> this.progress.getController().setInfos(this.data.threadCnt, this.data.multipleSubInfos));
    }

    private synchronized void extendInfos(int threadCnt) {
        this.data.threadCnt = threadCnt;
        this.data.infos = Arrays.copyOf(this.data.infos, this.data.threadCnt);
        if (Boolean.TRUE.equals(this.data.multipleSubInfos)) {
            this.data.subinfos = Arrays.copyOf(this.data.subinfos, this.data.threadCnt);
        }
        Platform.runLater(() -> this.progress.getController().extendInfos(this.data.threadCnt, this.data.multipleSubInfos));
    }

    public void clearInfos() {
        int i;
        for (i = 0; i < this.data.infos.length; ++i) {
            this.data.infos[i] = null;
        }
        for (i = 0; i < this.data.subinfos.length; ++i) {
            this.data.subinfos[i] = null;
        }
        this.data.pb2.msg = null;
        Platform.runLater(() -> this.progress.getController().clearInfos());
    }

    private synchronized void cleanup() {
        if (this.offsetProvider != null) {
            for (int offset : this.offsetProvider.freeOffsets()) {
                if (offset >= this.data.infos.length) continue;
                this.data.infos[offset] = "";
                if (this.data.infos.length != this.data.subinfos.length) continue;
                this.data.subinfos[offset] = "";
            }
        }
    }

    private synchronized int getOffset() {
        if (this.offsetProvider != null) {
            int offset = this.offsetProvider.getOffset();
            if (offset < 0) {
                return 0;
            }
            if (offset >= this.data.threadCnt) {
                this.extendInfos(offset + 1);
            }
            return offset;
        }
        return 0;
    }

    public void setProgress(String msg, Integer val, Integer max, String submsg) {
        int offset = this.getOffset();
        if (msg != null) {
            this.data.infos[offset] = msg;
        }
        boolean force = false;
        if (val != null) {
            if (val < 0 && this.data.pb1.visibility) {
                this.data.pb1.visibility = false;
            } else if (val >= 0 && !this.data.pb1.visibility) {
                this.data.pb1.visibility = true;
            }
            this.data.pb1.stringPainted = val != 0;
            this.data.pb1.indeterminate = val == 0;
            force = this.computeProgress(this.data.pb1, val, max, force);
            this.showDuration(this.data.pb1, val);
        }
        if (submsg != null || val != null && val == -1) {
            if (this.data.subinfos.length == 1) {
                this.data.subinfos[0] = submsg;
            } else if (this.data.subinfos.length > 1) {
                this.data.subinfos[offset] = submsg;
            }
        }
        this.sendSetProgress(1, force);
    }

    private synchronized void sendSetProgress(int pb, boolean force) {
        boolean doit = false;
        if (pb == 1) {
            this.cleanup();
        }
        if (force) {
            doit = true;
        } else if (pb == 1 && this.data.pb1.visibility && !this.data.pb1.indeterminate && this.data.pb1.val > 0 && this.data.pb1.max == this.data.pb1.val) {
            doit = true;
        } else if (pb == 2 && this.data.pb2.visibility && !this.data.pb2.indeterminate && this.data.pb2.val > 0 && this.data.pb2.max == this.data.pb2.val) {
            doit = true;
        } else if (pb == 3 && this.data.pb3.visibility && !this.data.pb3.indeterminate && this.data.pb3.val > 0 && this.data.pb3.max == this.data.pb3.val) {
            doit = true;
        } else if (this.lastPData == null || this.lastPData.infos.length == 1 && this.lastPData.infos[0] != null && !this.lastPData.infos[0].equals(this.data.infos[0])) {
            doit = true;
        } else if (System.currentTimeMillis() - this.lastEvent > 100L) {
            doit = true;
        } else if (!(this.data.pb1.visibility || this.data.pb2.visibility || this.data.pb3.visibility || this.options.contains(ProgressHandler.Option.LAZY))) {
            doit = true;
        }
        if (doit) {
            this.lastPData = new PData(this.data);
            Platform.runLater(() -> this.progress.getController().setFullProgress(this.lastPData));
            this.lastEvent = System.currentTimeMillis();
        }
        this.data.pb1.msg = null;
    }

    private boolean computeProgress(PData.PB pb, Integer val, Integer max, boolean force) {
        if (max != null) {
            pb.max = max;
        }
        if (val >= 0) {
            pb.val = val;
        }
        if (val == 0) {
            pb.startTime = System.currentTimeMillis();
        }
        if (pb.val >= 0 && pb.max > 0) {
            float perc = (float)pb.val * 100.0f / (float)pb.max;
            force = (int)pb.perc != (int)perc;
            pb.perc = perc;
        }
        return force;
    }

    private void showDuration(PData.PB pb, int val) {
        if (val > 0) {
            if (pb.msg == null) {
                pb.msg = String.format("%.02f%%", pb.perc);
            }
            String left = DurationFormatUtils.formatDuration((long)((System.currentTimeMillis() - pb.startTime) * (long)(pb.max - val) / (long)val), (String)HH_MM_SS);
            String total = DurationFormatUtils.formatDuration((long)((System.currentTimeMillis() - pb.startTime) * (long)pb.max / (long)val), (String)HH_MM_SS);
            pb.timeleft = String.format(S_OF_S, left, total);
        } else {
            pb.timeleft = HH_MM_SS_OF_HH_MM_SS_NONE;
        }
    }

    public void setProgress2(String msg, Integer val, Integer max) {
        boolean force = false;
        if (msg != null && val != null) {
            if (!this.data.pb2.visibility) {
                this.data.pb2.visibility = true;
            }
            this.data.pb2.stringPainted = true;
            this.data.pb2.msg = msg;
            this.data.pb2.indeterminate = val == 0 && msg == null;
            force = this.computeProgress(this.data.pb2, val, max, force);
            this.showDuration(this.data.pb2, val);
        } else if (this.data.pb2.visibility) {
            this.data.pb2.visibility = false;
        }
        this.sendSetProgress(2, force);
    }

    public void setProgress3(String msg, Integer val, Integer max) {
        boolean force = false;
        if (msg != null && val != null) {
            if (!this.data.pb3.visibility) {
                this.data.pb3.visibility = true;
            }
            this.data.pb3.stringPainted = true;
            this.data.pb3.msg = msg;
            this.data.pb3.indeterminate = val == 0 && msg == null;
            force = this.computeProgress(this.data.pb3, val, max, force);
            this.showDuration(this.data.pb3, val);
        } else if (this.data.pb3.visibility) {
            this.data.pb3.visibility = false;
        }
        this.sendSetProgress(3, force);
    }

    public int getCurrent() {
        return this.data.pb1.val;
    }

    public int getCurrent2() {
        return this.data.pb2.val;
    }

    public int getCurrent3() {
        return this.data.pb3.val;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void doCancel() {
        this.cancel = true;
    }

    public boolean canCancel() {
        return this.canCancel;
    }

    public void canCancel(boolean canCancel) {
        this.canCancel = canCancel;
        Platform.runLater(() -> this.progress.getController().canCancel(canCancel));
    }

    public InputStream getInputStream(InputStream in, Integer len) {
        return new ProgressInputStream(in, len, (ProgressHandler)this);
    }

    public void close() {
        this.progress.close();
    }

    public void addError(String error) {
        this.errors.add(error);
    }

    public void setOptions(ProgressHandler.Option first, ProgressHandler.Option ... rest) {
        this.options = EnumSet.of(first, rest);
    }

    public void setOffsetProvider(OffsetProvider offsetProvider) {
        this.offsetProvider = offsetProvider;
    }

    static final class PData {
        int threadCnt = 1;
        Boolean multipleSubInfos = false;
        String[] infos = new String[]{null};
        String[] subinfos = new String[]{null};
        final PB pb1;
        final PB pb2;
        final PB pb3;

        PData() {
            this.pb1 = new PB();
            this.pb2 = new PB();
            this.pb3 = new PB();
        }

        PData(PData data) {
            this.threadCnt = data.threadCnt;
            this.multipleSubInfos = data.multipleSubInfos;
            this.infos = Arrays.copyOf(data.infos, data.infos.length);
            this.subinfos = Arrays.copyOf(data.subinfos, data.subinfos.length);
            this.pb1 = new PB(data.pb1);
            this.pb2 = new PB(data.pb2);
            this.pb3 = new PB(data.pb3);
        }

        @Generated
        public int getThreadCnt() {
            return this.threadCnt;
        }

        @Generated
        public Boolean getMultipleSubInfos() {
            return this.multipleSubInfos;
        }

        @Generated
        public String[] getInfos() {
            return this.infos;
        }

        @Generated
        public String[] getSubinfos() {
            return this.subinfos;
        }

        @Generated
        public PB getPb1() {
            return this.pb1;
        }

        @Generated
        public PB getPb2() {
            return this.pb2;
        }

        @Generated
        public PB getPb3() {
            return this.pb3;
        }

        @Generated
        public void setThreadCnt(int threadCnt) {
            this.threadCnt = threadCnt;
        }

        @Generated
        public void setMultipleSubInfos(Boolean multipleSubInfos) {
            this.multipleSubInfos = multipleSubInfos;
        }

        @Generated
        public void setInfos(String[] infos) {
            this.infos = infos;
        }

        @Generated
        public void setSubinfos(String[] subinfos) {
            this.subinfos = subinfos;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PData)) {
                return false;
            }
            PData other = (PData)o;
            if (this.getThreadCnt() != other.getThreadCnt()) {
                return false;
            }
            Boolean this$multipleSubInfos = this.getMultipleSubInfos();
            Boolean other$multipleSubInfos = other.getMultipleSubInfos();
            if (this$multipleSubInfos == null ? other$multipleSubInfos != null : !((Object)this$multipleSubInfos).equals(other$multipleSubInfos)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getInfos(), other.getInfos())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getSubinfos(), other.getSubinfos())) {
                return false;
            }
            PB this$pb1 = this.getPb1();
            PB other$pb1 = other.getPb1();
            if (this$pb1 == null ? other$pb1 != null : !((Object)this$pb1).equals(other$pb1)) {
                return false;
            }
            PB this$pb2 = this.getPb2();
            PB other$pb2 = other.getPb2();
            if (this$pb2 == null ? other$pb2 != null : !((Object)this$pb2).equals(other$pb2)) {
                return false;
            }
            PB this$pb3 = this.getPb3();
            PB other$pb3 = other.getPb3();
            return !(this$pb3 == null ? other$pb3 != null : !((Object)this$pb3).equals(other$pb3));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getThreadCnt();
            Boolean $multipleSubInfos = this.getMultipleSubInfos();
            result = result * 59 + ($multipleSubInfos == null ? 43 : ((Object)$multipleSubInfos).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getInfos());
            result = result * 59 + Arrays.deepHashCode(this.getSubinfos());
            PB $pb1 = this.getPb1();
            result = result * 59 + ($pb1 == null ? 43 : ((Object)$pb1).hashCode());
            PB $pb2 = this.getPb2();
            result = result * 59 + ($pb2 == null ? 43 : ((Object)$pb2).hashCode());
            PB $pb3 = this.getPb3();
            result = result * 59 + ($pb3 == null ? 43 : ((Object)$pb3).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ProgressTask.PData(threadCnt=" + this.getThreadCnt() + ", multipleSubInfos=" + this.getMultipleSubInfos() + ", infos=" + Arrays.deepToString(this.getInfos()) + ", subinfos=" + Arrays.deepToString(this.getSubinfos()) + ", pb1=" + String.valueOf(this.getPb1()) + ", pb2=" + String.valueOf(this.getPb2()) + ", pb3=" + String.valueOf(this.getPb3()) + ")";
        }

        static final class PB {
            boolean visibility = false;
            boolean stringPainted = false;
            boolean indeterminate = false;
            int max = 100;
            int val = 0;
            double perc = 0.0;
            String msg = null;
            String timeleft;
            transient long startTime = System.currentTimeMillis();

            PB() {
            }

            PB(PB pb) {
                this.visibility = pb.visibility;
                this.stringPainted = pb.stringPainted;
                this.indeterminate = pb.indeterminate;
                this.max = pb.max;
                this.val = pb.val;
                this.perc = pb.perc;
                this.msg = pb.msg;
                this.timeleft = pb.timeleft;
            }

            @Generated
            public boolean isVisibility() {
                return this.visibility;
            }

            @Generated
            public boolean isStringPainted() {
                return this.stringPainted;
            }

            @Generated
            public boolean isIndeterminate() {
                return this.indeterminate;
            }

            @Generated
            public int getMax() {
                return this.max;
            }

            @Generated
            public int getVal() {
                return this.val;
            }

            @Generated
            public double getPerc() {
                return this.perc;
            }

            @Generated
            public String getMsg() {
                return this.msg;
            }

            @Generated
            public String getTimeleft() {
                return this.timeleft;
            }

            @Generated
            public long getStartTime() {
                return this.startTime;
            }

            @Generated
            public void setVisibility(boolean visibility) {
                this.visibility = visibility;
            }

            @Generated
            public void setStringPainted(boolean stringPainted) {
                this.stringPainted = stringPainted;
            }

            @Generated
            public void setIndeterminate(boolean indeterminate) {
                this.indeterminate = indeterminate;
            }

            @Generated
            public void setMax(int max) {
                this.max = max;
            }

            @Generated
            public void setVal(int val) {
                this.val = val;
            }

            @Generated
            public void setPerc(double perc) {
                this.perc = perc;
            }

            @Generated
            public void setMsg(String msg) {
                this.msg = msg;
            }

            @Generated
            public void setTimeleft(String timeleft) {
                this.timeleft = timeleft;
            }

            @Generated
            public void setStartTime(long startTime) {
                this.startTime = startTime;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PB)) {
                    return false;
                }
                PB other = (PB)o;
                if (this.isVisibility() != other.isVisibility()) {
                    return false;
                }
                if (this.isStringPainted() != other.isStringPainted()) {
                    return false;
                }
                if (this.isIndeterminate() != other.isIndeterminate()) {
                    return false;
                }
                if (this.getMax() != other.getMax()) {
                    return false;
                }
                if (this.getVal() != other.getVal()) {
                    return false;
                }
                if (Double.compare(this.getPerc(), other.getPerc()) != 0) {
                    return false;
                }
                String this$msg = this.getMsg();
                String other$msg = other.getMsg();
                if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
                    return false;
                }
                String this$timeleft = this.getTimeleft();
                String other$timeleft = other.getTimeleft();
                return !(this$timeleft == null ? other$timeleft != null : !this$timeleft.equals(other$timeleft));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isVisibility() ? 79 : 97);
                result = result * 59 + (this.isStringPainted() ? 79 : 97);
                result = result * 59 + (this.isIndeterminate() ? 79 : 97);
                result = result * 59 + this.getMax();
                result = result * 59 + this.getVal();
                long $perc = Double.doubleToLongBits(this.getPerc());
                result = result * 59 + (int)($perc >>> 32 ^ $perc);
                String $msg = this.getMsg();
                result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
                String $timeleft = this.getTimeleft();
                result = result * 59 + ($timeleft == null ? 43 : $timeleft.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "ProgressTask.PData.PB(visibility=" + this.isVisibility() + ", stringPainted=" + this.isStringPainted() + ", indeterminate=" + this.isIndeterminate() + ", max=" + this.getMax() + ", val=" + this.getVal() + ", perc=" + this.getPerc() + ", msg=" + this.getMsg() + ", timeleft=" + this.getTimeleft() + ", startTime=" + this.getStartTime() + ")";
            }
        }
    }
}

