/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui.status;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import lombok.Generated;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class NeutralToNodeFormatter {
    public static List<Node> toNodes(String xml) {
        if (xml == null) {
            return List.of();
        }
        if (xml.startsWith("<document>")) {
            List<Node> list;
            ByteArrayInputStream in = new ByteArrayInputStream(("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + xml).getBytes(StandardCharsets.UTF_8));
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                SAXParser parser = factory.newSAXParser();
                parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                Handler handler = new Handler();
                parser.parse((InputStream)in, (DefaultHandler)handler);
                list = handler.nodes;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    e.printStackTrace();
                }
            }
            in.close();
            return list;
        }
        return List.of(new Label(xml));
    }

    @Generated
    private NeutralToNodeFormatter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class Handler
    extends DefaultHandler {
        private List<Node> nodes = new ArrayList<Node>();
        private Label current = null;
        private StringBuilder buffer = new StringBuilder();

        private Handler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (qName) {
                case "document": {
                    break;
                }
                case "label": {
                    this.flush();
                    this.current = new Label();
                    boolean bold = false;
                    boolean italic = false;
                    block30: for (int i = 0; i < attributes.getLength(); ++i) {
                        switch (attributes.getQName(i)) {
                            case "color": {
                                this.current.setTextFill((Paint)Color.web((String)attributes.getValue(i)));
                                continue block30;
                            }
                            case "bold": {
                                bold = Boolean.parseBoolean(attributes.getValue(i));
                                continue block30;
                            }
                            case "italic": {
                                italic = Boolean.parseBoolean(attributes.getValue(i));
                                continue block30;
                            }
                        }
                    }
                    if (!bold && !italic) break;
                    this.current.setFont(Font.font((String)this.current.getFont().getFamily(), (FontWeight)(bold ? FontWeight.BOLD : FontWeight.NORMAL), (FontPosture)(italic ? FontPosture.ITALIC : FontPosture.REGULAR), (double)this.current.getFont().getSize()));
                    break;
                }
                case "progress": {
                    this.flush();
                    int width = 100;
                    int value = 0;
                    int max = 100;
                    block31: for (int i = 0; i < attributes.getLength(); ++i) {
                        switch (attributes.getQName(i)) {
                            case "width": {
                                width = Integer.parseInt(attributes.getValue(i));
                                continue block31;
                            }
                            case "value": {
                                value = Integer.parseInt(attributes.getValue(i));
                                continue block31;
                            }
                            case "max": {
                                max = Integer.parseInt(attributes.getValue(i));
                            }
                        }
                    }
                    ProgressBar progress = new ProgressBar();
                    progress.setPrefWidth((double)width);
                    progress.setPrefHeight(10.0);
                    progress.setProgress((double)value / (double)max);
                    this.nodes.add((Node)progress);
                    break;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            switch (qName) {
                case "document": 
                case "label": {
                    this.flush();
                    break;
                }
            }
        }

        private void flush() {
            if (this.buffer.length() > 0) {
                if (this.current == null) {
                    this.current = new Label();
                }
                this.current.setText(this.buffer.toString());
                this.buffer.setLength(0);
                this.nodes.add((Node)this.current);
                this.current = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buffer.append(ch, start, length);
        }
    }
}

