/*
 * Decompiled with CFR 0.152.
 */
package jrm.fullserver.db;

import java.io.IOException;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import jrm.misc.Log;
import jrm.misc.SystemSettings;
import lombok.Generated;

public abstract class DB {
    protected SystemSettings settings;

    protected DB(SystemSettings settings) {
        this.settings = settings;
    }

    public static DB getInstance(SystemSettings settings) {
        try {
            return DB.getInstance(settings.getDBClass(), settings);
        }
        catch (ClassNotFoundException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static DB getInstance(String cls, SystemSettings settings) throws ClassNotFoundException {
        return DB.getInstance(Class.forName(cls).asSubclass(DB.class), settings);
    }

    public static <T extends DB> T getInstance(Class<T> cls, SystemSettings settings) {
        try {
            return (T)((DB)cls.getConstructor(SystemSettings.class).newInstance(settings));
        }
        catch (Exception e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public abstract Connection connectToDB(String var1, boolean var2, boolean var3, boolean var4) throws IOException, SQLException;

    public Connection connectToDB(String name, boolean drop, boolean safe) throws IOException, SQLException {
        return this.connectToDB(name, drop, safe, false);
    }

    public abstract boolean shouldDropDB(Path var1, Path var2) throws IOException;

    public abstract void dropDB(String var1) throws IOException;

    @Generated
    public SystemSettings getSettings() {
        return this.settings;
    }
}

