/*
 * Decompiled with CFR 0.152.
 */
package jrm.fullserver.db;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import jrm.fullserver.db.DB;
import jrm.misc.Log;
import jrm.misc.SystemSettings;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;

class H2
extends DB {
    public H2(SystemSettings settings) {
        super(settings);
    }

    @Override
    public Connection connectToDB(String name, boolean drop, boolean safe, boolean ifexists) throws IOException, SQLException {
        if (drop) {
            this.dropDB(name);
        }
        StringBuilder url = new StringBuilder("jdbc:h2:");
        url.append(this.getDBPath(name));
        if (ifexists) {
            url.append(";IFEXISTS=TRUE");
        }
        if (!safe) {
            url.append(";LOG=0;LOCK_MODE=0;UNDO_LOG=0");
        }
        url.append(";MODE=MYSQL");
        Log.debug((Object)("Opening " + String.valueOf(url)));
        return DriverManager.getConnection(url.toString(), "sa", System.getProperty("DB_PW", ""));
    }

    @Override
    public void dropDB(String name) throws IOException {
        for (File file : this.getDBPath(name).getParent().toFile().listFiles(f -> f.getName().toLowerCase().startsWith(name.toLowerCase() + ".") && Files.isRegularFile(f.toPath(), new LinkOption[0]))) {
            file.delete();
        }
    }

    @Override
    public boolean shouldDropDB(@NonNull Path cpsPath, Path capturePath) throws IOException {
        long created;
        if (cpsPath == null) {
            throw new NullPointerException("cpsPath is marked non-null but is null");
        }
        String name = cpsPath.getFileName().toString();
        Path dbpath = this.getDBPath(name, true);
        if (!Files.exists(dbpath, new LinkOption[0])) {
            return true;
        }
        if (!Files.exists(cpsPath, new LinkOption[0])) {
            return false;
        }
        long l = created = Files.exists(dbpath, new LinkOption[0]) ? Files.getFileAttributeView(dbpath, BasicFileAttributeView.class, new LinkOption[0]).readAttributes().creationTime().toMillis() : 0L;
        if (cpsPath.toFile().lastModified() > created) {
            return true;
        }
        return capturePath != null && capturePath.toFile().lastModified() > created;
    }

    private Path getDBPath(String name, boolean full) {
        if (name.contains("%w")) {
            name = name.replace("%w", this.getSettings().getWorkPath().toString());
        }
        if (!Paths.get(name, new String[0]).isAbsolute()) {
            Path basepath = this.settings.getWorkPath();
            String ext = FilenameUtils.getExtension((String)name).toLowerCase();
            if (ext.equalsIgnoreCase("db") && ((ext = FilenameUtils.getExtension((String)FilenameUtils.getBaseName((String)name)).toLowerCase()).equalsIgnoreCase("mv") || ext.equalsIgnoreCase("h2"))) {
                ext = FilenameUtils.getExtension((String)FilenameUtils.getBaseName((String)FilenameUtils.getBaseName((String)name))).toLowerCase();
            }
            if ("sys".equals(ext)) {
                basepath = this.settings.getBasePath();
            }
            return basepath.resolve(this.resolveName(name, full));
        }
        return this.resolveName(name, full);
    }

    private Path resolveName(String name, boolean full) {
        if (full && !name.endsWith(".db")) {
            return Paths.get(name + ".mv.db", new String[0]);
        }
        if (!full && name.endsWith(".db")) {
            return Paths.get(name.substring(0, name.length() - 6), new String[0]);
        }
        return Paths.get(name, new String[0]);
    }

    private Path getDBPath(String name) {
        return this.getDBPath(name, false);
    }
}

