/*
 * Decompiled with CFR 0.152.
 */
package jrm.fullserver.db;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Closeable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jrm.fullserver.db.SQLUtils;
import jrm.misc.Log;
import jrm.misc.SystemSettings;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import org.apache.commons.dbutils.handlers.MapHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public abstract class SQL
implements SQLUtils,
Closeable {
    protected Connection db;
    private final boolean shouldClose;
    private final SystemSettings settings;
    protected QueryRunner qryRunner = new QueryRunner();

    protected SQL(boolean shouldClose, SystemSettings settings) {
        this.db = null;
        this.shouldClose = shouldClose;
        this.settings = settings;
    }

    protected SQL(@NonNull Connection db, boolean shouldClose, SystemSettings settings) {
        if (db == null) {
            throw new NullPointerException("db is marked non-null but is null");
        }
        this.db = db;
        this.shouldClose = shouldClose;
        this.settings = settings;
    }

    public <T> T getScalarValue(String select, Class<T> cls) throws SQLException {
        return (T)this.qryRunner.query(this.db, select, (ResultSetHandler)new ScalarHandler(1));
    }

    protected Integer getIntValue(String select, int col) throws SQLException {
        return (Integer)this.qryRunner.query(this.db, select, (ResultSetHandler)new ScalarHandler(col));
    }

    protected Long getLongValue(String select, int col) throws SQLException {
        return (Long)this.qryRunner.query(this.db, select, (ResultSetHandler)new ScalarHandler(col));
    }

    @Override
    public Long getLongValue(String select, Object ... args) throws SQLException {
        if (!this.supportsArrayParams() && this.findArrayParam(args) != -1) {
            AtomicReference<String> selectRef = new AtomicReference<String>(select);
            AtomicReference<Object[]> argsRef = new AtomicReference<Object[]>(args);
            this.convertArrayParams(selectRef, argsRef);
            select = selectRef.get();
            args = argsRef.get();
        }
        return (Long)this.qryRunner.query(this.db, select, (ResultSetHandler)new ScalarHandler(1), args);
    }

    @Override
    public Long count(String select, Object ... args) throws SQLException {
        if (!this.supportsArrayParams() && this.findArrayParam(args) != -1) {
            AtomicReference<String> selectRef = new AtomicReference<String>(select);
            AtomicReference<Object[]> argsRef = new AtomicReference<Object[]>(args);
            this.convertArrayParams(selectRef, argsRef);
            select = selectRef.get();
            args = argsRef.get();
        }
        return this.getLongValue("SELECT COUNT(*) FROM (" + select + ") AS T", args);
    }

    @Override
    public Long countTbl(String table, String context) throws SQLException {
        return this.getLongValue("SELECT COUNT(*) FROM " + this.getSQLTable(table, context));
    }

    protected Integer getIntValue(String select) throws SQLException {
        return this.getIntValue(select, 1);
    }

    protected Long getLongValue(String select) throws SQLException {
        return this.getLongValue(select, 1);
    }

    @Override
    public <T> List<T> getColumnList(String select, int col) throws SQLException {
        return (List)this.qryRunner.query(this.db, select, (ResultSetHandler)new ColumnListHandler(col));
    }

    public synchronized String createSchema(String name, boolean drop) throws SQLException {
        if (name != null && this.db.getMetaData().supportsSchemasInDataManipulation()) {
            if (drop) {
                this.dropSchema(name);
            }
            this.qryRunner.execute(this.db, "CREATE SCHEMA IF NOT EXISTS " + this.backquote(name), new Object[0]);
        }
        return name;
    }

    public String dropSchema(String name) throws SQLException {
        if (this.db.getMetaData().supportsSchemasInDataManipulation()) {
            this.qryRunner.execute(this.db, "DROP SCHEMA IF EXISTS " + this.backquote(name) + " CASCADE", new Object[0]);
        }
        return name;
    }

    protected LinkedHashMap<String, Object> convertBeanToMap(Object bean) {
        return this.convertBeanToMap(bean, null);
    }

    protected LinkedHashMap<String, Object> convertBeanToMap(Object bean, Set<String> columns) {
        LinkedHashMap<String, Object> set = new LinkedHashMap<String, Object>();
        try {
            if (columns != null) {
                columns = columns.stream().map(Introspector::decapitalize).collect(Collectors.toSet());
            }
            for (PropertyDescriptor prop : Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors()) {
                if (columns != null) {
                    if (!columns.contains(prop.getName())) continue;
                    set.put(prop.getName(), prop.getReadMethod().invoke(bean, new Object[0]));
                    continue;
                }
                if (prop.getWriteMethod() == null) continue;
                set.put(prop.getName(), prop.getReadMethod().invoke(bean, new Object[0]));
            }
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Log.warn((Object)e.getMessage());
        }
        return set;
    }

    protected void updateBeanFromMap(Object bean, Map<String, Object> set) {
        try {
            Map<String, PropertyDescriptor> descriptors = Stream.of(Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors()).collect(Collectors.toMap(e -> Introspector.decapitalize(e.getName()), e -> e));
            set.forEach((n, v) -> {
                try {
                    ((PropertyDescriptor)descriptors.get(Introspector.decapitalize(n))).getWriteMethod().invoke(bean, v);
                }
                catch (Exception e1) {
                    Log.err((String)e1.getMessage(), (Throwable)e1);
                }
            });
        }
        catch (IntrospectionException e1) {
            Log.err((String)e1.getMessage(), (Throwable)e1);
        }
    }

    public void linkSchema(Connection otherdb, String schema) throws SQLException {
        this.qryRunner.execute(this.db, "CALL LINK_SCHEMA(?,?,?,?,?,?)", new Object[]{schema, "", otherdb.getMetaData().getURL(), otherdb.getMetaData().getUserName(), "", schema});
    }

    protected boolean hasResult(String select, Object ... args) throws SQLException {
        return this.qryRunner.query(this.db, select, (ResultSetHandler)new ScalarHandler(1), args) != null;
    }

    @Override
    public List<Map<String, Object>> query(String select, Object ... args) throws SQLException {
        if (!this.supportsArrayParams() && this.findArrayParam(args) != -1) {
            AtomicReference<String> selectRef = new AtomicReference<String>(select);
            AtomicReference<Object[]> argsRef = new AtomicReference<Object[]>(args);
            this.convertArrayParams(selectRef, argsRef);
            select = selectRef.get();
            args = argsRef.get();
        }
        return (List)this.qryRunner.query(this.db, select, (ResultSetHandler)new MapListHandler(), args);
    }

    public <T> T queryHandler(String select, ResultSetHandler<T> beanListHandler, Object ... args) throws SQLException {
        if (!this.supportsArrayParams() && this.findArrayParam(args) != -1) {
            AtomicReference<String> selectRef = new AtomicReference<String>(select);
            AtomicReference<Object[]> argsRef = new AtomicReference<Object[]>(args);
            this.convertArrayParams(selectRef, argsRef);
            select = selectRef.get();
            args = argsRef.get();
        }
        return (T)this.qryRunner.query(this.db, select, beanListHandler, args);
    }

    @Override
    public Map<String, Object> queryFirst(String select, Object ... args) throws SQLException {
        if (!((String)select).contains(" LIMIT ")) {
            select = (String)select + " LIMIT 1";
        }
        if (!this.supportsArrayParams() && this.findArrayParam(args) != -1) {
            AtomicReference<Object> selectRef = new AtomicReference<Object>(select);
            AtomicReference<Object[]> argsRef = new AtomicReference<Object[]>(args);
            this.convertArrayParams(selectRef, argsRef);
            select = (String)selectRef.get();
            args = argsRef.get();
        }
        return (Map)this.qryRunner.query(this.db, (String)select, (ResultSetHandler)new MapHandler(), args);
    }

    @Override
    public int update(String update, Object ... args) throws SQLException {
        if (!this.supportsArrayParams() && this.findArrayParam(args) != -1) {
            AtomicReference<String> updateRef = new AtomicReference<String>(update);
            AtomicReference<Object[]> argsRef = new AtomicReference<Object[]>(args);
            this.convertArrayParams(updateRef, argsRef);
            update = updateRef.get();
            args = argsRef.get();
        }
        return this.qryRunner.update(this.db, update, args);
    }

    public void insert(String table, String context, Map<String, Object> toset) throws SQLException {
        this.qryRunner.update(this.db, "INSERT INTO " + this.getSQLTable(table, context) + " (" + String.valueOf(this.makeCols((Collection<String>)toset.keySet())) + ") VALUES(" + String.valueOf(this.appendParam(toset.size())) + ")", toset.values().toArray());
    }

    private int findArrayParam(Object[] args) {
        int pos = -1;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null || !args[i].getClass().isArray()) continue;
                pos = i;
            }
        }
        return pos;
    }

    private void convertArrayParams(AtomicReference<String> queryRef, AtomicReference<Object[]> argsRef) {
        Object[] args = argsRef.get();
        String query = queryRef.get();
        if (args != null) {
            int pos;
            while (-1 != (pos = this.findArrayParam(args))) {
                int i;
                int arrlen = Array.getLength(args[pos]);
                Object[] newargs = new Object[args.length - 1 + arrlen];
                System.arraycopy(args, 0, newargs, 0, pos);
                for (i = 0; i < arrlen; ++i) {
                    newargs[i + pos] = Array.get(args[pos], i);
                }
                for (i = pos + 1; i < args.length; ++i) {
                    newargs[i - 1 + arrlen] = args[i];
                }
                query = query.replaceFirst("=\\s*?ANY\\(\\?\\)", " IN(" + String.valueOf(this.appendParam(arrlen)) + ")");
                args = newargs;
            }
        }
        argsRef.set(args);
        queryRef.set(query);
    }

    @Override
    public void dropTable(String table) throws SQLException {
        this.qryRunner.update(this.db, "DROP TABLE IF EXISTS " + table);
    }

    @Override
    public void close() {
        if (this.shouldClose) {
            try {
                if (!this.db.isClosed()) {
                    Log.info((Object)("will close " + this.db.getMetaData().getURL()));
                    this.db.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public boolean supportsNullsFirst() throws SQLException {
        return this.db.getMetaData().getDatabaseProductName().equals("H2");
    }

    public int getMaxIndexLength() throws SQLException {
        return this.db.getMetaData().getMaxIndexLength();
    }

    public boolean supportsMultipleTablesUpdate() throws SQLException {
        return !this.db.getMetaData().getDatabaseProductName().equals("H2");
    }

    public boolean supportsReplace() throws SQLException {
        return !this.db.getMetaData().getDatabaseProductName().equals("H2");
    }

    public boolean supportsDump() throws SQLException {
        return this.db.getMetaData().getDatabaseProductName().equals("H2");
    }

    public boolean supportsArrayParams() throws SQLException {
        return this.db.getMetaData().getDatabaseProductName().equals("H2");
    }

    public boolean supportsInsertIgnore() throws SQLException {
        return !this.db.getMetaData().getDatabaseProductName().equals("H2");
    }

    @Override
    @Generated
    public Connection getDb() {
        return this.db;
    }

    @Generated
    public boolean isShouldClose() {
        return this.shouldClose;
    }

    @Generated
    public SystemSettings getSettings() {
        return this.settings;
    }
}

