/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import jrm.misc.IOUtils;

public class TempFileInputStream
extends FileInputStream {
    private final File file;
    private final long length;

    public TempFileInputStream(File file) throws FileNotFoundException {
        super(file);
        this.file = file;
        this.length = file.length();
    }

    @Override
    public void close() throws IOException {
        super.close();
        Files.deleteIfExists(this.file.toPath());
    }

    public static InputStream newInstance() throws IOException {
        return new TempFileInputStream(IOUtils.createTempFile((String)"JRMSRV", null).toFile());
    }

    public static InputStream newInstance(InputStream in) throws IOException {
        return TempFileInputStream.newInstance(in, -1L, false);
    }

    public static InputStream newInstance(InputStream in, long len) throws IOException {
        return TempFileInputStream.newInstance(in, len, false);
    }

    public static InputStream newInstance(InputStream in, long len, boolean close) throws IOException {
        Path tmpfile = IOUtils.createTempFile((String)"JRMSRV", null);
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(tmpfile, new OpenOption[0]));){
            if (len < 0L) {
                int b = in.read();
                while (b != -1) {
                    out.write(b);
                    b = in.read();
                }
            } else {
                for (long i = 0L; i < len; ++i) {
                    out.write(in.read());
                }
            }
            if (close) {
                in.close();
            }
        }
        return new TempFileInputStream(tmpfile.toFile());
    }

    public long getLength() {
        return this.length;
    }
}

