/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.actions;

import com.eclipsesource.json.JsonObject;
import java.io.IOException;
import java.util.Date;
import jrm.misc.Log;
import jrm.server.shared.SessionStub;
import jrm.server.shared.WebSession;
import jrm.server.shared.actions.CatVerActions;
import jrm.server.shared.actions.CompressorActions;
import jrm.server.shared.actions.Dat2DirActions;
import jrm.server.shared.actions.Dir2DatActions;
import jrm.server.shared.actions.GlobalActions;
import jrm.server.shared.actions.NPlayersActions;
import jrm.server.shared.actions.ProfileActions;
import jrm.server.shared.actions.ReportActions;
import jrm.server.shared.actions.TrntChkActions;
import lombok.Generated;

public interface ActionsMgr
extends SessionStub {
    public void send(String var1) throws IOException;

    public void sendOptional(String var1) throws IOException;

    public boolean isOpen();

    public WebSession getSession();

    default public void processActions(ActionsMgr mgr, JsonObject jso) {
        block47: {
            try {
                if (jso == null) break block47;
                mgr.getSession().setLastAction(new Date());
                switch (jso.getString("cmd", "unknown")) {
                    case "Global.setProperty": {
                        new GlobalActions(this).setProperty(jso);
                        break;
                    }
                    case "Global.getMemory": {
                        new GlobalActions(this).setMemory(jso);
                        break;
                    }
                    case "Global.GC": {
                        new GlobalActions(this).gc(jso);
                        break;
                    }
                    case "Profile.import": {
                        new ProfileActions(this).imprt(jso);
                        break;
                    }
                    case "Profile.load": {
                        new ProfileActions(this).load(jso);
                        break;
                    }
                    case "Profile.scan": {
                        new ProfileActions(this).scan(jso, true);
                        break;
                    }
                    case "Profile.fix": {
                        new ProfileActions(this).fix(jso);
                        break;
                    }
                    case "Profile.importSettings": {
                        new ProfileActions(this).importSettings(jso);
                        break;
                    }
                    case "Profile.exportSettings": {
                        new ProfileActions(this).exportSettings(jso);
                        break;
                    }
                    case "Profile.setProperty": {
                        new ProfileActions(this).setProperty(jso);
                        break;
                    }
                    case "ReportLite.setFilter": {
                        new ReportActions(this).setFilter(jso, true);
                        break;
                    }
                    case "Report.setFilter": {
                        new ReportActions(this).setFilter(jso, false);
                        break;
                    }
                    case "CatVer.load": {
                        new CatVerActions(this).load(jso);
                        break;
                    }
                    case "NPlayers.load": {
                        new NPlayersActions(this).load(jso);
                        break;
                    }
                    case "Progress.cancel": {
                        if (mgr.getSession().getWorker() != null && mgr.getSession().getWorker().isAlive() && mgr.getSession().getWorker().progress != null) {
                            mgr.getSession().getWorker().getProgress().doCancel();
                        }
                        break;
                    }
                    case "Dat2Dir.start": {
                        new Dat2DirActions(this).start(jso);
                        break;
                    }
                    case "Dir2Dat.start": {
                        new Dir2DatActions(this).start(jso);
                        break;
                    }
                    case "TrntChk.start": {
                        new TrntChkActions(this).start(jso);
                        break;
                    }
                    case "Compressor.start": {
                        new CompressorActions(this).start(jso);
                        break;
                    }
                    case "Dat2Dir.settings": {
                        new Dat2DirActions(this).settings(jso);
                        break;
                    }
                    default: {
                        Log.err(() -> "Unknown command : " + jso.getString("cmd", "unknown"));
                    }
                }
            }
            catch (Exception e) {
                Log.err((String)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class SingleCmd {
        final String cmd;

        @Generated
        public SingleCmd(String cmd) {
            this.cmd = cmd;
        }
    }

    public static class UpdateResult {
        final String cmd;
        final Params params;

        @Generated
        public UpdateResult(String cmd, Params params) {
            this.cmd = cmd;
            this.params = params;
        }

        static class Params {
            final int row;
            final String result;

            @Generated
            public Params(int row, String result) {
                this.row = row;
                this.result = result;
            }
        }
    }
}

