/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.actions;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import jrm.aui.progress.ProgressHandler;
import jrm.batch.Compressor;
import jrm.batch.CompressorFormat;
import jrm.misc.BreakException;
import jrm.misc.EnumWithDefault;
import jrm.misc.Log;
import jrm.misc.MultiThreadingVirtual;
import jrm.misc.SettingsEnum;
import jrm.security.PathAbstractor;
import jrm.security.Session;
import jrm.server.shared.WebSession;
import jrm.server.shared.Worker;
import jrm.server.shared.actions.ActionsMgr;
import jrm.server.shared.actions.ProgressActions;
import org.apache.commons.io.FilenameUtils;

public class CompressorActions {
    private final ActionsMgr ws;

    public CompressorActions(ActionsMgr ws) {
        this.ws = ws;
    }

    public void start(JsonObject jso) {
        this.ws.getSession().setWorker(new Worker(() -> {
            WebSession session = this.ws.getSession();
            CompressorFormat format = CompressorFormat.valueOf((String)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.compressor_format));
            Boolean force = (Boolean)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.compressor_force, Boolean.class);
            Boolean use_parallelism = (Boolean)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.use_parallelism, Boolean.class);
            int nThreads = Boolean.TRUE.equals(use_parallelism) ? (Integer)session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.thread_count, Integer.class) : 1;
            session.getWorker().progress = new ProgressActions(this.ws);
            session.getWorker().progress.setInfos(Math.min(Runtime.getRuntime().availableProcessors(), this.ws.getSession().getCachedCompressorList().size()), true);
            try {
                this.clearResults();
                AtomicInteger cnt = new AtomicInteger();
                Compressor compressor = new Compressor((Session)session, cnt, this.ws.getSession().getCachedCompressorList().size(), (ProgressHandler)session.getWorker().progress);
                ArrayList<Compressor.FileResult> values = new ArrayList<Compressor.FileResult>(this.ws.getSession().getCachedCompressorList().values());
                try (MultiThreadingVirtual mt = new MultiThreadingVirtual("compressor", (ProgressHandler)session.getWorker().progress, nThreads, fr -> this.doCompress(session, format, force, cnt, compressor, (List<Compressor.FileResult>)values, (Compressor.FileResult)fr));){
                    mt.start(this.ws.getSession().getCachedCompressorList().values().stream());
                }
            }
            catch (BreakException e) {
                session.getWorker().progress.doCancel();
            }
            finally {
                session.getWorker().progress.close();
                this.end();
            }
        })).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doCompress(WebSession session, CompressorFormat format, boolean force, AtomicInteger cnt, Compressor compressor, List<Compressor.FileResult> values, Compressor.FileResult fr) {
        if (session.getWorker().progress.isCancel()) {
            return;
        }
        try {
            int i = values.indexOf(fr);
            File file = PathAbstractor.getAbsolutePath((Session)session, (String)fr.getFile().toString()).toFile();
            Compressor.UpdResultCallBack cb = txt -> {
                fr.setResult(txt);
                this.updateResult(i, fr.getResult());
            };
            Compressor.UpdSrcCallBack scb = src -> {
                fr.setFile(PathAbstractor.getRelativePath((Session)session, (Path)src.toPath()));
                this.updateFile(i, fr.getFile());
            };
            switch (format) {
                case SEVENZIP: {
                    this.doCompress2SevenZip(force, compressor, file, cb, scb);
                    return;
                }
                case ZIP: {
                    this.doCompress2Zip(force, compressor, file, cb, scb);
                    return;
                }
                case TZIP: {
                    this.doCompress2TZip(force, compressor, file, cb, scb);
                    return;
                }
            }
            return;
        }
        catch (BreakException e) {
            session.getWorker().progress.doCancel();
            return;
        }
        catch (Exception e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            cnt.incrementAndGet();
        }
    }

    private void doCompress2TZip(boolean force, Compressor compressor, File file, Compressor.UpdResultCallBack cb, Compressor.UpdSrcCallBack scb) throws IllegalArgumentException {
        if ("zip".equals(FilenameUtils.getExtension((String)file.getName()))) {
            compressor.zip2TZip(file, force, cb);
        } else if ((file = compressor.sevenZip2Zip(file, true, cb, scb)) != null && file.exists()) {
            compressor.zip2TZip(file, force, cb);
        }
    }

    private void doCompress2Zip(boolean force, Compressor compressor, File file, Compressor.UpdResultCallBack cb, Compressor.UpdSrcCallBack scb) throws IllegalArgumentException {
        if ("zip".equals(FilenameUtils.getExtension((String)file.getName()))) {
            if (force) {
                compressor.zip2Zip(file, cb, scb);
            } else {
                cb.apply("Skipped");
            }
        } else {
            compressor.sevenZip2Zip(file, false, cb, scb);
        }
    }

    private void doCompress2SevenZip(boolean force, Compressor compressor, File file, Compressor.UpdResultCallBack cb, Compressor.UpdSrcCallBack scb) throws IllegalArgumentException {
        switch (FilenameUtils.getExtension((String)file.getName())) {
            case "zip": {
                compressor.zip2SevenZip(file, cb, scb);
                break;
            }
            case "7z": {
                if (force) {
                    compressor.sevenZip2SevenZip(file, cb, scb);
                    break;
                }
                cb.apply("Skipped");
                break;
            }
            default: {
                compressor.sevenZip2SevenZip(file, cb, scb);
            }
        }
    }

    void updateFile(int row, Path file) {
        try {
            if (this.ws.isOpen()) {
                JsonObject msg = new JsonObject();
                msg.add("cmd", "Compressor.updateFile");
                JsonObject params = new JsonObject();
                params.add("row", row);
                params.add("file", file.toString());
                msg.add("params", (JsonValue)params);
                this.ws.send(msg.toString());
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    void updateResult(int row, String result) {
        try {
            if (this.ws.isOpen()) {
                JsonObject msg = new JsonObject();
                msg.add("cmd", "Compressor.updateResult");
                JsonObject params = new JsonObject();
                params.add("row", row);
                params.add("result", result);
                msg.add("params", (JsonValue)params);
                this.ws.send(msg.toString());
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    void clearResults() {
        try {
            if (this.ws.isOpen()) {
                JsonObject msg = new JsonObject();
                msg.add("cmd", "Compressor.clearResults");
                this.ws.send(msg.toString());
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    void end() {
        try {
            if (this.ws.isOpen()) {
                JsonObject msg = new JsonObject();
                msg.add("cmd", "Compressor.end");
                this.ws.send(msg.toString());
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }
}

