/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.actions;

import com.eclipsesource.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import jrm.aui.progress.ProgressHandler;
import jrm.misc.BreakException;
import jrm.misc.EnumWithDefault;
import jrm.misc.Log;
import jrm.misc.SettingsEnum;
import jrm.profile.manager.Export;
import jrm.profile.scan.Dir2Dat;
import jrm.profile.scan.DirScan;
import jrm.security.Session;
import jrm.server.shared.WebSession;
import jrm.server.shared.Worker;
import jrm.server.shared.actions.ActionsMgr;
import jrm.server.shared.actions.ProgressActions;

public class Dir2DatActions {
    private final ActionsMgr ws;

    public Dir2DatActions(ActionsMgr ws) {
        this.ws = ws;
    }

    public void start(JsonObject jso) {
        this.ws.getSession().setWorker(new Worker(() -> {
            WebSession session = this.ws.getSession();
            session.getWorker().progress = new ProgressActions(this.ws);
            try {
                String srcdir = session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_src_dir);
                String dstdat = session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_dst_file);
                String format = session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_format);
                JsonObject opts = jso.get("params").asObject().get("options").asObject();
                EnumSet<DirScan.Options> options = this.getOptions(opts);
                HashMap headers = new HashMap();
                JsonObject hdrs = jso.get("params").asObject().get("headers").asObject();
                hdrs.forEach(m -> {
                    if (!m.getValue().isNull()) {
                        headers.put(m.getName(), m.getValue().asString());
                    }
                });
                if (srcdir != null && dstdat != null) {
                    new Dir2Dat((Session)this.ws.getSession(), new File(srcdir), new File(dstdat), (ProgressHandler)session.getWorker().progress, options, Export.ExportType.valueOf((String)format), headers);
                }
            }
            catch (BreakException breakException) {
            }
            finally {
                this.end();
                session.setCurrProfile(null);
                session.setCurrScan(null);
                session.getWorker().progress.close();
                session.getWorker().progress = null;
                session.setLastAction(new Date());
            }
        })).start();
    }

    private EnumSet<DirScan.Options> getOptions(JsonObject opts) {
        EnumSet<DirScan.Options> options = EnumSet.of(DirScan.Options.USE_PARALLELISM, DirScan.Options.MD5_DISKS, DirScan.Options.SHA1_DISKS);
        if (opts.getBoolean("dir2dat.scan_subfolders", true)) {
            options.add(DirScan.Options.RECURSE);
        }
        if (!opts.getBoolean("dir2dat.deep_scan", false)) {
            options.add(DirScan.Options.IS_DEST);
        }
        if (opts.getBoolean("dir2dat.add_md5", false)) {
            options.add(DirScan.Options.NEED_MD5);
        }
        if (opts.getBoolean("dir2dat.add_sha1", false)) {
            options.add(DirScan.Options.NEED_SHA1);
        }
        if (opts.getBoolean("dir2dat.junk_folders", false)) {
            options.add(DirScan.Options.JUNK_SUBFOLDERS);
        }
        if (opts.getBoolean("dir2dat.do_not_scan_archives", false)) {
            options.add(DirScan.Options.ARCHIVES_AND_CHD_AS_ROMS);
        }
        if (opts.getBoolean("dir2dat.match_profile", false)) {
            options.add(DirScan.Options.MATCH_PROFILE);
        }
        if (opts.getBoolean("dir2dat.include_empty_dirs", false)) {
            options.add(DirScan.Options.EMPTY_DIRS);
        }
        return options;
    }

    void end() {
        try {
            if (this.ws.isOpen()) {
                JsonObject msg = new JsonObject();
                msg.add("cmd", "Dir2Dat.end");
                this.ws.send(msg.toString());
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }
}

