/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.actions;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.nio.file.Path;
import jrm.misc.Log;
import jrm.misc.ProfileSettingsEnum;
import jrm.profile.Profile;
import jrm.security.PathAbstractor;
import jrm.security.Session;
import jrm.server.shared.actions.ActionsMgr;

public class NPlayersActions {
    private final ActionsMgr ws;

    public NPlayersActions(ActionsMgr ws) {
        this.ws = ws;
    }

    public void load(JsonObject jso) {
        JsonValue jsv = jso.get("params").asObject().get("path");
        this.ws.getSession().getCurrProfile().setProperty(ProfileSettingsEnum.filter_nplayers_ini, jsv != null && !jsv.isNull() ? jsv.asString() : null);
        this.ws.getSession().getCurrProfile().loadNPlayers(null);
        this.ws.getSession().getCurrProfile().saveSettings();
        this.loaded(this.ws.getSession().getCurrProfile());
    }

    public void loaded(Profile profile) {
        try {
            if (this.ws.isOpen()) {
                JsonObject msg = new JsonObject();
                msg.add("cmd", "NPlayers.loaded");
                JsonObject params = new JsonObject();
                params.add("path", profile.getNplayers() != null ? PathAbstractor.getRelativePath((Session)this.ws.getSession(), (Path)profile.getNplayers().file.toPath()).toString() : null);
                msg.add("params", (JsonValue)params);
                this.ws.send(msg.toString());
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }
}

