/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.actions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jrm.aui.progress.ProgressHandler;
import jrm.aui.progress.ProgressInputStream;
import jrm.misc.Log;
import jrm.misc.OffsetProvider;
import jrm.server.shared.actions.ActionsMgr;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class ProgressActions
implements ProgressHandler {
    private static final String HH_MM_SS = "HH:mm:ss";
    private static final String S_OF_S = "%s / %s";
    private static final String HH_MM_SS_OF_HH_MM_SS_NONE = "--:--:-- / --:--:--";
    private ActionsMgr ws;
    private final List<String> errors = new ArrayList<String>();
    private boolean cancel = false;
    private boolean canCancel = true;
    private Gson gson;
    private final SetFullProgress.Data data = new SetFullProgress.Data();
    private OffsetProvider offsetProvider = null;

    public ProgressActions(ActionsMgr ws) {
        this.ws = ws;
        this.gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).create();
        this.sendOpen();
    }

    private void sendOpen() {
        try {
            if (this.ws.isOpen()) {
                this.ws.send(this.gson.toJson((Object)new Open()));
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    public void reload(ActionsMgr ws) {
        this.ws = ws;
        this.sendOpen();
        this.sendSetInfos();
        this.sendSetProgress(0, true);
    }

    private synchronized void cleanup() {
        if (this.offsetProvider != null) {
            for (int offset : this.offsetProvider.freeOffsets()) {
                if (offset >= this.data.infos.length) continue;
                this.data.infos[offset] = "";
                if (this.data.infos.length != this.data.subinfos.length) continue;
                this.data.subinfos[offset] = "";
            }
        }
    }

    private void sendSetProgress(int pb, boolean force) {
        try {
            if (pb == 1) {
                this.cleanup();
            }
            if (force) {
                this.ws.send(this.gson.toJson((Object)new SetFullProgress(this.data)));
            } else if (!(this.data.pb1.visibility || this.data.pb2.visibility || this.data.pb3.visibility)) {
                this.ws.send(this.gson.toJson((Object)new SetFullProgress(this.data)));
            } else if (pb == 1 && this.data.pb1.visibility && !this.data.pb1.indeterminate && this.data.pb1.val > 0 && this.data.pb1.max == this.data.pb1.val) {
                this.ws.send(this.gson.toJson((Object)new SetFullProgress(this.data)));
            } else if (pb == 2 && this.data.pb2.visibility && !this.data.pb2.indeterminate && this.data.pb2.val > 0 && this.data.pb2.max == this.data.pb2.val) {
                this.ws.send(this.gson.toJson((Object)new SetFullProgress(this.data)));
            } else if (pb == 3 && this.data.pb3.visibility && !this.data.pb3.indeterminate && this.data.pb3.val > 0 && this.data.pb3.max == this.data.pb3.val) {
                this.ws.send(this.gson.toJson((Object)new SetFullProgress(this.data)));
            } else {
                this.ws.sendOptional(this.gson.toJson((Object)new SetFullProgress(this.data)));
            }
            this.data.pb1.msg = null;
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void setInfos(int threadCnt, Boolean multipleSubInfos) {
        this.data.threadCnt = threadCnt <= 0 ? Runtime.getRuntime().availableProcessors() : threadCnt;
        this.data.multipleSubInfos = multipleSubInfos;
        this.data.infos = new String[this.data.threadCnt];
        this.data.subinfos = multipleSubInfos == null ? new String[0] : new String[multipleSubInfos != false ? this.data.threadCnt : 1];
        this.sendSetInfos();
    }

    private void sendSetInfos() {
        try {
            if (this.ws.isOpen()) {
                this.ws.send(this.gson.toJson((Object)new SetInfos(new SetInfos.Data(this.data.threadCnt, this.data.multipleSubInfos))));
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    private synchronized void extendInfos(int threadCnt) {
        this.data.threadCnt = threadCnt;
        this.data.infos = Arrays.copyOf(this.data.infos, threadCnt);
        if (Boolean.TRUE.equals(this.data.multipleSubInfos)) {
            this.data.subinfos = Arrays.copyOf(this.data.subinfos, threadCnt);
        }
        this.sendExtendInfos();
    }

    private void sendExtendInfos() {
        try {
            if (this.ws.isOpen()) {
                this.ws.send(this.gson.toJson((Object)new ExtendInfos(new ExtendInfos.Data(this.data.threadCnt, this.data.multipleSubInfos))));
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    public void clearInfos() {
        int i;
        for (i = 0; i < this.data.infos.length; ++i) {
            this.data.infos[i] = null;
        }
        for (i = 0; i < this.data.subinfos.length; ++i) {
            this.data.subinfos[i] = null;
        }
        this.data.pb2.msg = null;
        this.sendClearInfos();
    }

    private void sendClearInfos() {
        try {
            if (this.ws.isOpen()) {
                this.ws.send(this.gson.toJson((Object)new ClearInfos()));
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    public void setProgress(String msg, Integer val, Integer max, String submsg) {
        int offset = this.getOffset();
        if (msg != null) {
            this.data.infos[offset] = msg;
        }
        boolean force = false;
        if (val != null) {
            if (val < 0 && this.data.pb1.visibility) {
                this.data.pb1.visibility = false;
            } else if (val >= 0 && !this.data.pb1.visibility) {
                this.data.pb1.visibility = true;
            }
            this.data.pb1.stringPainted = val != 0;
            this.data.pb1.indeterminate = val == 0;
            force = this.computeProgress(this.data.pb1, val, max, force);
            this.showDuration(this.data.pb1, val);
        }
        if (submsg != null || val != null && val == -1) {
            if (this.data.subinfos.length == 1) {
                this.data.subinfos[0] = submsg;
            } else if (this.data.subinfos.length > 1) {
                this.data.subinfos[offset] = submsg;
            }
        }
        this.sendSetProgress(1, force);
    }

    public void setProgress2(String msg, Integer val, Integer max) {
        boolean force = false;
        if (msg != null && val != null) {
            if (!this.data.pb2.visibility) {
                this.data.pb2.visibility = true;
            }
            this.data.pb2.stringPainted = true;
            this.data.pb2.msg = msg;
            this.data.pb2.indeterminate = val == 0 && msg == null;
            force = this.computeProgress(this.data.pb2, val, max, force);
            this.showDuration(this.data.pb2, val);
        } else if (this.data.pb2.visibility) {
            this.data.pb2.visibility = false;
        }
        this.sendSetProgress(2, force);
    }

    public void setProgress3(String msg, Integer val, Integer max) {
        boolean force = false;
        if (msg != null && val != null) {
            if (!this.data.pb3.visibility) {
                this.data.pb3.visibility = true;
            }
            this.data.pb3.stringPainted = true;
            this.data.pb3.msg = msg;
            this.data.pb3.indeterminate = val == 0 && msg == null;
            force = this.computeProgress(this.data.pb3, val, max, force);
            this.showDuration(this.data.pb3, val);
        } else if (this.data.pb3.visibility) {
            this.data.pb3.visibility = false;
        }
        this.sendSetProgress(3, force);
    }

    private boolean computeProgress(SetFullProgress.Data.PB pb, Integer val, Integer max, boolean force) {
        if (max != null) {
            pb.max = max;
        }
        if (val >= 0) {
            pb.val = val;
        }
        if (val == 0) {
            pb.startTime = System.currentTimeMillis();
        }
        if (pb.val >= 0 && pb.max > 0) {
            float perc = (float)pb.val * 100.0f / (float)pb.max;
            force = (int)pb.perc != (int)perc;
            pb.perc = perc;
        }
        return force;
    }

    private synchronized int getOffset() {
        if (this.offsetProvider != null) {
            int offset = this.offsetProvider.getOffset();
            if (offset < 0) {
                return 0;
            }
            if (offset >= this.data.threadCnt) {
                this.extendInfos(offset + 1);
            }
            return offset;
        }
        return 0;
    }

    private void showDuration(SetFullProgress.Data.PB pb, int val) {
        if (val > 0) {
            if (pb.msg == null) {
                pb.msg = String.format("%.02f%%", pb.perc);
            }
            String left = DurationFormatUtils.formatDuration((long)((System.currentTimeMillis() - pb.startTime) * (long)(pb.max - val) / (long)val), (String)HH_MM_SS);
            String total = DurationFormatUtils.formatDuration((long)((System.currentTimeMillis() - pb.startTime) * (long)pb.max / (long)val), (String)HH_MM_SS);
            pb.timeleft = String.format(S_OF_S, left, total);
        } else {
            pb.timeleft = HH_MM_SS_OF_HH_MM_SS_NONE;
        }
    }

    public int getCurrent() {
        return this.data.pb1.val;
    }

    public int getCurrent2() {
        return this.data.pb2.val;
    }

    public int getCurrent3() {
        return this.data.pb3.val;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void doCancel() {
        this.cancel = true;
    }

    public InputStream getInputStream(InputStream in, Integer len) {
        return new ProgressInputStream(in, len, (ProgressHandler)this);
    }

    public void close() {
        try {
            if (this.ws.isOpen()) {
                this.ws.send(this.gson.toJson((Object)new Close(this.errors)));
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    public boolean canCancel() {
        return this.canCancel;
    }

    public void canCancel(boolean canCancel) {
        this.canCancel = canCancel;
        this.sendCanCancel();
    }

    private void sendCanCancel() {
        try {
            if (this.ws.isOpen()) {
                this.ws.send(this.gson.toJson((Object)new CanCancel(this.canCancel)));
            }
        }
        catch (IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    public void addError(String error) {
        this.errors.add(error);
    }

    public void setOptions(ProgressHandler.Option first, ProgressHandler.Option ... rest) {
    }

    public void setOffsetProvider(OffsetProvider offsetProvider) {
        this.offsetProvider = offsetProvider;
    }

    static final class SetFullProgress {
        static final String cmd = "Progress.setFullProgress";
        final Data params;

        SetFullProgress(Data data) {
            this.params = data;
        }

        static final class Data {
            int threadCnt = 1;
            Boolean multipleSubInfos = false;
            String[] infos = new String[]{null};
            String[] subinfos = new String[]{null};
            final PB pb1 = new PB();
            final PB pb2 = new PB();
            final PB pb3 = new PB();

            Data() {
            }

            static final class PB {
                boolean visibility = false;
                boolean stringPainted = false;
                boolean indeterminate = false;
                int max = 100;
                int val = 0;
                double perc = 0.0;
                String msg = null;
                String timeleft;
                transient long startTime = 0L;

                PB() {
                }
            }
        }
    }

    static final class Open {
        static final String cmd = "Progress";

        private Open() {
        }
    }

    static final class SetInfos {
        static final String cmd = "Progress.setInfos";
        final Data params;

        SetInfos(Data data) {
            this.params = data;
        }

        static final class Data {
            int threadCnt = 1;
            Boolean multipleSubInfos = false;

            Data(int threadCnt, Boolean multipleSubInfos) {
                this.threadCnt = threadCnt;
                this.multipleSubInfos = multipleSubInfos;
            }
        }
    }

    static final class ExtendInfos {
        static final String cmd = "Progress.extendInfos";
        final Data params;

        ExtendInfos(Data data) {
            this.params = data;
        }

        static final class Data {
            int threadCnt = 1;
            Boolean multipleSubInfos = false;

            Data(int threadCnt, Boolean multipleSubInfos) {
                this.threadCnt = threadCnt;
                this.multipleSubInfos = multipleSubInfos;
            }
        }
    }

    static final class ClearInfos {
        static final String cmd = "Progress.clearInfos";

        private ClearInfos() {
        }
    }

    static final class Close {
        static final String cmd = "Progress.close";
        final Data params;

        public Close(List<String> errors) {
            this.params = new Data(errors);
        }

        static final class Data {
            String[] errors = null;

            public Data(List<String> errors) {
                this.errors = (String[])errors.toArray(String[]::new);
            }
        }
    }

    static final class CanCancel {
        static final String cmd = "Progress.canCancel";
        final Data params;

        CanCancel(boolean canCancel) {
            this.params = new Data(canCancel);
        }

        static final class Data {
            final boolean canCancel;

            Data(boolean canCancel) {
                this.canCancel = canCancel;
            }
        }
    }
}

