/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.datasources;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import jrm.batch.Compressor;
import jrm.server.shared.datasources.XMLRequest;
import jrm.server.shared.datasources.XMLResponse;
import jrm.xml.EnhancedXMLStreamWriter;
import jrm.xml.SimpleAttribute;

public class BatchCompressorFRXMLResponse
extends XMLResponse {
    private static final String RESULT = "result";
    private static final String RECORD = "record";
    private static final String STATUS = "status";
    private static final String RESPONSE = "response";

    public BatchCompressorFRXMLResponse(XMLRequest request) throws IOException, XMLStreamException {
        super(request);
    }

    @Override
    protected void fetch(XMLRequest.Operation operation) throws XMLStreamException {
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        this.writer.writeElement("startRow", (CharSequence)"0", new SimpleAttribute[0]);
        this.writer.writeElement("endRow", (CharSequence)Integer.toString(this.request.getSession().getCachedCompressorList().size() - 1), new SimpleAttribute[0]);
        this.writer.writeElement("totalRows", (CharSequence)Integer.toString(this.request.getSession().getCachedCompressorList().size()), new SimpleAttribute[0]);
        this.writer.writeStartElement("data");
        for (Map.Entry<String, Compressor.FileResult> sr : this.request.getSession().getCachedCompressorList().entrySet()) {
            this.writeRecord(this.writer, sr.getKey(), sr.getValue().getFile(), sr.getValue().getResult());
        }
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    @Override
    protected void add(XMLRequest.Operation operation) throws XMLStreamException {
        if (operation.hasData("file")) {
            String id = UUID.randomUUID().toString();
            Compressor.FileResult fr = new Compressor.FileResult(Paths.get(operation.getData("file"), new String[0]));
            this.request.getSession().getCachedCompressorList().put(id, fr);
            this.writer.writeStartElement(RESPONSE);
            this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
            this.writer.writeStartElement("data");
            this.writeRecord(this.writer, id, fr.getFile(), fr.getResult());
            this.writer.writeEndElement();
            this.writer.writeEndElement();
        } else {
            this.failure("file is missing in request");
        }
    }

    @Override
    protected void update(XMLRequest.Operation operation) throws XMLStreamException {
        if (!operation.hasData("id")) {
            this.failure("id is missing in request");
            return;
        }
        String id = operation.getData("id");
        Compressor.FileResult fr = this.request.getSession().getCachedCompressorList().get(id);
        if (fr == null) {
            this.failure(id + " not in list");
            return;
        }
        if (!operation.hasData("file") && !operation.hasData(RESULT)) {
            this.failure("field to update is missing in request");
            return;
        }
        if (operation.hasData("file")) {
            fr.setFile(Paths.get(operation.getData("file"), new String[0]));
        }
        if (operation.hasData(RESULT)) {
            fr.setResult(operation.getData(RESULT));
        }
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        this.writer.writeStartElement("data");
        this.writeRecord(this.writer, id, fr.getFile(), fr.getResult());
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    private void writeRecord(EnhancedXMLStreamWriter writer, String id, Path file, String result) throws XMLStreamException {
        writer.writeElement(RECORD, new SimpleAttribute[]{new SimpleAttribute("id", (Object)id), new SimpleAttribute("file", (Object)file), new SimpleAttribute(RESULT, (Object)result)});
    }

    @Override
    protected void remove(XMLRequest.Operation operation) throws XMLStreamException {
        if (operation.hasData("id")) {
            String id = operation.getData("id");
            if (this.request.getSession().getCachedCompressorList().remove(id) != null) {
                this.writer.writeStartElement(RESPONSE);
                this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
                this.writer.writeStartElement("data");
                this.writer.writeElement(RECORD, new SimpleAttribute[]{new SimpleAttribute("id", (Object)id)});
                this.writer.writeEndElement();
                this.writer.writeEndElement();
            } else {
                this.failure(id + " is not in the list");
            }
        } else {
            this.failure("Src is missing in request");
        }
    }

    @Override
    protected void custom(XMLRequest.Operation operation) throws XMLStreamException {
        if ("clear".equals(operation.getOperationId().toString())) {
            this.request.getSession().getCachedCompressorList().clear();
            this.success();
        }
    }
}

