/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.datasources;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import jrm.batch.TrntChkReport;
import jrm.profile.report.ReportIntf;
import jrm.security.Session;
import jrm.server.shared.datasources.XMLRequest;
import jrm.server.shared.datasources.XMLResponse;
import jrm.xml.SimpleAttribute;

public class BatchTrntChkReportTreeXMLResponse
extends XMLResponse {
    private static final String PARENT_ID = "ParentID";
    private static final String STATUS = "status";

    public BatchTrntChkReportTreeXMLResponse(XMLRequest request) throws IOException, XMLStreamException {
        super(request);
    }

    @Override
    protected void fetch(XMLRequest.Operation operation) throws XMLStreamException {
        TrntChkReport report = null;
        if (operation.hasData("src")) {
            File srcfile = this.pathAbstractor.getAbsolutePath(operation.getData("src")).toFile();
            File reportfile = ReportIntf.getReportFile((Session)this.request.getSession(), (File)srcfile);
            if (this.request.session.getTmpTCReport() == null || !this.request.session.getTmpTCReport().getReportFile((Session)this.request.getSession()).equals(reportfile) || this.request.getSession().getTmpTCReport().getFileModified() != reportfile.lastModified()) {
                this.request.session.setTmpTCReport(TrntChkReport.load((Session)this.request.getSession(), (File)srcfile));
            }
            report = this.request.session.getTmpTCReport();
        }
        if (report != null) {
            this.writer.writeStartElement("response");
            this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
            Boolean showok = Optional.ofNullable(operation.getData("showOK")).map(Boolean::valueOf).orElse(true);
            this.writer.writeElement("showOK", (CharSequence)showok.toString(), new SimpleAttribute[0]);
            Long parentID = Long.valueOf(operation.getData(PARENT_ID));
            if (parentID == 0L) {
                this.fetchRoot(operation, report, showok);
            } else {
                this.fetchNode(report, parentID);
            }
            this.writer.writeEndElement();
        } else {
            this.success();
        }
    }

    private void fetchNode(TrntChkReport report, Long parentID) throws XMLStreamException {
        TrntChkReport.Child parent = (TrntChkReport.Child)report.getAll().get(parentID);
        if (parent != null) {
            int nodecount = parent.getChildren() != null ? parent.getChildren().size() : 0;
            this.writer.writeElement("startRow", (CharSequence)"0", new SimpleAttribute[0]);
            this.writer.writeElement("endRow", (CharSequence)Integer.toString(nodecount - 1), new SimpleAttribute[0]);
            this.writer.writeElement("totalRows", (CharSequence)Integer.toString(nodecount), new SimpleAttribute[0]);
            this.writer.writeStartElement("data");
            if (parent.getChildren() != null) {
                for (TrntChkReport.Child n : parent.getChildren()) {
                    this.writer.writeStartElement("record");
                    this.writer.writeAttribute("ID", Long.toString(n.getUid()));
                    this.writer.writeAttribute(PARENT_ID, parentID.toString());
                    this.writer.writeAttribute("title", n.getData().getTitle());
                    if (n.getData().getLength() != null) {
                        this.writer.writeAttribute("length", n.getData().getLength().toString());
                    }
                    this.writer.writeAttribute(STATUS, n.getData().getStatus().toString());
                    this.writer.writeAttribute("isFolder", Boolean.toString(n.getChildren() != null && !n.getChildren().isEmpty()));
                    this.writer.writeEndElement();
                }
            }
            this.writer.writeEndElement();
        }
    }

    private void fetchRoot(XMLRequest.Operation operation, TrntChkReport report, Boolean showok) throws XMLStreamException {
        List<TrntChkReport.Child> nodes = report.getNodes().stream().filter(n -> showok != false || n.getData().getStatus() != TrntChkReport.Status.OK).toList();
        int nodecount = nodes.size();
        int start = Math.min(nodecount - 1, operation.getStartRow());
        this.writer.writeElement("startRow", (CharSequence)Integer.toString(start), new SimpleAttribute[0]);
        int end = Math.min(nodecount - 1, operation.getEndRow());
        this.writer.writeElement("endRow", (CharSequence)Integer.toString(end), new SimpleAttribute[0]);
        this.writer.writeElement("totalRows", (CharSequence)Integer.toString(nodecount), new SimpleAttribute[0]);
        if (nodecount > 0) {
            this.writer.writeStartElement("data");
            for (int i = start; i <= end; ++i) {
                TrntChkReport.Child n2 = nodes.get(i);
                this.writer.writeStartElement("record");
                this.writer.writeAttribute("ID", Long.toString(n2.getUid()));
                this.writer.writeAttribute(PARENT_ID, "0");
                this.writer.writeAttribute("title", n2.getData().getTitle());
                if (n2.getData().getLength() != null) {
                    this.writer.writeAttribute("length", n2.getData().getLength().toString());
                }
                this.writer.writeAttribute(STATUS, n2.getData().getStatus().toString());
                this.writer.writeAttribute("isFolder", Boolean.toString(n2.getChildren() != null && !n2.getChildren().isEmpty()));
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
        }
    }
}

