/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.datasources;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jrm.profile.filter.CatVer;
import jrm.server.shared.datasources.XMLRequest;
import jrm.server.shared.datasources.XMLResponse;
import jrm.xml.SimpleAttribute;

public class CatVerXMLResponse
extends XMLResponse {
    private static final String IS_SELECTED = "isSelected";
    private static final String IS_FOLDER = "isFolder";
    private static final String PARENT_ID = "ParentID";
    private static final String RECORD = "record";

    public CatVerXMLResponse(XMLRequest request) throws IOException, XMLStreamException {
        super(request);
    }

    private int countNode(CatVer catver) {
        int count = 0;
        if (catver != null) {
            ++count;
            for (int i = 0; i < catver.getListCategories().size(); ++i) {
                ++count;
                CatVer.Category cat = (CatVer.Category)catver.getListCategories().get(i);
                for (int j = 0; j < cat.getListSubCategories().size(); ++j) {
                    ++count;
                }
            }
        }
        return count;
    }

    private void outputNode(XMLStreamWriter writer, CatVer catver) throws XMLStreamException {
        if (catver != null) {
            this.writeRootNode(writer, catver);
            for (CatVer.Category cat : catver) {
                this.writeCatNode(writer, catver, cat);
                for (CatVer.Category.SubCategory subcat : cat) {
                    this.writeSubCatNode(writer, cat, subcat);
                }
            }
        }
    }

    private void writeSubCatNode(XMLStreamWriter writer, CatVer.Category cat, CatVer.Category.SubCategory subcat) throws XMLStreamException {
        writer.writeStartElement(RECORD);
        writer.writeAttribute("ID", subcat.getPropertyName());
        writer.writeAttribute("Name", subcat.name);
        writer.writeAttribute(PARENT_ID, cat.getPropertyName());
        writer.writeAttribute("Cnt", Integer.toString(subcat.size()));
        writer.writeAttribute(IS_FOLDER, Boolean.toString(false));
        writer.writeAttribute(IS_SELECTED, Boolean.toString(subcat.isSelected()));
        writer.writeEndElement();
    }

    private void writeCatNode(XMLStreamWriter writer, CatVer catver, CatVer.Category cat) throws XMLStreamException {
        writer.writeStartElement(RECORD);
        writer.writeAttribute("ID", cat.getPropertyName());
        writer.writeAttribute("Name", cat.name);
        writer.writeAttribute(PARENT_ID, catver.getPropertyName());
        writer.writeAttribute(IS_FOLDER, Boolean.toString(!cat.getListSubCategories().isEmpty()));
        writer.writeAttribute(IS_SELECTED, Boolean.toString(cat.isSelected()));
        int isOpen = 0;
        for (CatVer.Category.SubCategory subcat : cat) {
            isOpen = (byte)(isOpen | (subcat.isSelected() ? 1 : 0));
            isOpen = (byte)(isOpen | (!subcat.isSelected() ? 2 : 0));
        }
        writer.writeAttribute("isOpen", Boolean.toString(isOpen == 3));
        writer.writeEndElement();
    }

    private void writeRootNode(XMLStreamWriter writer, CatVer catver) throws XMLStreamException {
        writer.writeStartElement(RECORD);
        writer.writeAttribute("ID", catver.getPropertyName());
        writer.writeAttribute("Name", this.request.session.getMsgs().getString("CatVer.AllCategories"));
        writer.writeAttribute(PARENT_ID, "1");
        writer.writeAttribute(IS_FOLDER, Boolean.toString(!catver.getListCategories().isEmpty()));
        writer.writeAttribute(IS_SELECTED, Boolean.toString(catver.isSelected()));
        writer.writeAttribute("isOpen", Boolean.TRUE.toString());
        writer.writeEndElement();
    }

    @Override
    protected void fetch(XMLRequest.Operation operation) throws XMLStreamException {
        int nodecount = this.countNode(this.request.session.getCurrProfile().getCatver());
        this.writer.writeStartElement("response");
        this.writer.writeElement("status", (CharSequence)"0", new SimpleAttribute[0]);
        this.writer.writeElement("startRow", (CharSequence)"0", new SimpleAttribute[0]);
        this.writer.writeElement("endRow", (CharSequence)Integer.toString(nodecount - 1), new SimpleAttribute[0]);
        this.writer.writeElement("totalRows", (CharSequence)Integer.toString(nodecount), new SimpleAttribute[0]);
        this.writer.writeStartElement("data");
        this.outputNode((XMLStreamWriter)this.writer, this.request.session.getCurrProfile().getCatver());
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }
}

