/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.datasources;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import jrm.profile.manager.ProfileNFO;
import jrm.security.Session;
import jrm.server.shared.datasources.XMLRequest;
import jrm.server.shared.datasources.XMLResponse;
import jrm.xml.SimpleAttribute;
import org.apache.commons.lang3.StringUtils;

public class ProfilesListXMLResponse
extends XMLResponse {
    private static final String STATUS = "status";
    private static final String RESPONSE = "response";
    private static final String PARENT = "Parent";
    private static final String XMLFILES = "xmlfiles";

    public ProfilesListXMLResponse(XMLRequest request) throws IOException, XMLStreamException {
        super(request);
    }

    @Override
    protected void fetch(XMLRequest.Operation operation) throws XMLStreamException {
        Path dir = this.request.getSession().getUser().getSettings().getWorkPath().resolve(XMLFILES).toAbsolutePath().normalize();
        if (operation.hasData(PARENT)) {
            dir = this.pathAbstractor.getAbsolutePath(operation.getData(PARENT));
        }
        List rows = ProfileNFO.list((Session)this.request.getSession(), (File)dir.toFile());
        this.writer.writeStartElement(RESPONSE);
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        this.writer.writeElement("startRow", (CharSequence)"0", new SimpleAttribute[0]);
        this.writer.writeElement("parent", (CharSequence)this.pathAbstractor.getRelativePath(dir).toString(), new SimpleAttribute[0]);
        this.writer.writeElement("endRow", (CharSequence)Integer.toString(rows.size() - 1), new SimpleAttribute[0]);
        this.writer.writeElement("totalRows", (CharSequence)Integer.toString(rows.size()), new SimpleAttribute[0]);
        this.writer.writeStartElement("data");
        for (int i = 0; i < rows.size(); ++i) {
            this.writeRecord((ProfileNFO)rows.get(i));
        }
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    private void writeRecord(ProfileNFO nfo) throws XMLStreamException {
        this.writer.writeEmptyElement("record");
        this.writer.writeAttribute("Name", nfo.getName());
        this.writer.writeAttribute(PARENT, this.pathAbstractor.getRelativePath(nfo.getFile().getParentFile().toPath()).toString());
        this.writer.writeAttribute("File", nfo.getFile().getName());
        this.writer.writeAttribute("version", nfo.getHTMLVersion());
        this.writer.writeAttribute("haveSets", nfo.getHTMLHaveSets());
        this.writer.writeAttribute("haveRoms", nfo.getHTMLHaveRoms());
        this.writer.writeAttribute("haveDisks", nfo.getHTMLHaveDisks());
        this.writer.writeAttribute("created", nfo.getHTMLCreated());
        this.writer.writeAttribute("scanned", nfo.getHTMLScanned());
        this.writer.writeAttribute("fixed", nfo.getHTMLFixed());
    }

    @Override
    protected void add(XMLRequest.Operation operation) throws XMLStreamException {
        if (operation.hasData("Src")) {
            Path src;
            Path dir = this.request.getSession().getUser().getSettings().getWorkPath().resolve(XMLFILES).toAbsolutePath().normalize();
            if (operation.hasData(PARENT) && !StringUtils.isEmpty((CharSequence)operation.getData(PARENT))) {
                dir = this.pathAbstractor.getAbsolutePath(operation.getData(PARENT));
            }
            if (Files.exists(src = this.pathAbstractor.getAbsolutePath(operation.getData("Src")), new LinkOption[0]) && Files.isRegularFile(src, new LinkOption[0])) {
                try {
                    Path dst = dir.resolve(operation.getData("File"));
                    if (!src.equals(dst)) {
                        Files.copy(src, dst, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                    }
                    ProfileNFO nfo = ProfileNFO.load((Session)this.request.getSession(), (File)dst.toFile());
                    this.writer.writeStartElement(RESPONSE);
                    this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
                    this.writer.writeStartElement("data");
                    this.writeRecord(nfo);
                    this.writer.writeEndElement();
                    this.writer.writeEndElement();
                }
                catch (IOException ex) {
                    this.failure(ex.getMessage());
                }
            } else {
                this.failure("Source file does not exist");
            }
        } else {
            this.failure("Src is needed");
        }
    }

    @Override
    protected void remove(XMLRequest.Operation operation) throws XMLStreamException {
        Path dir = this.request.getSession().getUser().getSettings().getWorkPath().resolve(XMLFILES).toAbsolutePath().normalize();
        if (operation.hasData(PARENT) && !StringUtils.isEmpty((CharSequence)operation.getData(PARENT))) {
            dir = this.pathAbstractor.getAbsolutePath(operation.getData(PARENT));
        }
        Path dst = dir.resolve(operation.getData("File"));
        ProfileNFO nfo = ProfileNFO.load((Session)this.request.getSession(), (File)dst.toFile());
        if (this.request.session.getCurrProfile() == null || !this.request.getSession().getCurrProfile().getNfo().equals(nfo)) {
            if (nfo.delete()) {
                this.writer.writeStartElement(RESPONSE);
                this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
                this.writer.writeStartElement("data");
                this.writer.writeEmptyElement("record");
                this.writer.writeAttribute(PARENT, this.pathAbstractor.getRelativePath(nfo.getFile().getParentFile().toPath()).toString());
                this.writer.writeAttribute("File", nfo.getFile().getName());
                this.writer.writeEndElement();
                this.writer.writeEndElement();
            } else {
                this.failure("Failed to delete profile");
            }
        } else {
            this.failure("Can't delete current loaded profile");
        }
    }

    @Override
    protected void custom(XMLRequest.Operation operation) throws XMLStreamException, IOException {
        if ("DropCache".equals(operation.getOperationId().toString())) {
            Path dst;
            Path dir = this.request.getSession().getUser().getSettings().getWorkPath().resolve(XMLFILES).toAbsolutePath().normalize();
            if (operation.hasData(PARENT) && !StringUtils.isEmpty((CharSequence)operation.getData(PARENT))) {
                dir = this.pathAbstractor.getAbsolutePath(operation.getData(PARENT));
            }
            if (Files.isRegularFile(dst = dir.resolve(operation.getData("File")), new LinkOption[0])) {
                Path cache = dir.resolve(operation.getData("File") + ".cache");
                if (Files.exists(cache, new LinkOption[0]) && !cache.toFile().delete()) {
                    this.failure("Can't delete " + String.valueOf(cache));
                } else {
                    this.success();
                }
            } else {
                this.failure("Can't find " + String.valueOf(dst));
            }
        } else {
            super.custom(operation);
        }
    }
}

