/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.datasources;

import java.io.File;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import jrm.profile.report.Note;
import jrm.profile.report.Report;
import jrm.profile.report.ReportIntf;
import jrm.profile.report.Subject;
import jrm.profile.report.SubjectSet;
import jrm.security.Session;
import jrm.server.shared.datasources.XMLRequest;
import jrm.server.shared.datasources.XMLResponse;
import jrm.xml.SimpleAttribute;

public class ReportTreeXMLResponse
extends XMLResponse {
    private static final String RECORD = "record";
    private static final String PARENT_ID = "ParentID";
    private static final String STATUS = "status";

    public ReportTreeXMLResponse(XMLRequest request) throws IOException, XMLStreamException {
        super(request);
    }

    @Override
    protected void fetch(XMLRequest.Operation operation) throws XMLStreamException, IOException {
        int parentID;
        this.writer.writeStartElement("response");
        this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
        Report report = this.request.session.getReport();
        if (operation.hasData("src")) {
            File srcfile = this.pathAbstractor.getAbsolutePath(operation.getData("src")).toFile();
            File reportfile = ReportIntf.getReportFile((Session)this.request.session, (File)srcfile);
            if (this.request.session.getTmpReport() == null || !this.request.session.getTmpReport().getReportFile((Session)this.request.session).equals(reportfile) || this.request.session.getTmpReport().getFileModified() != reportfile.lastModified()) {
                this.request.session.setTmpReport(Report.load((Session)this.request.session, (File)srcfile));
            }
            report = this.request.session.getTmpReport();
        }
        if ((parentID = Integer.parseInt(operation.getData(PARENT_ID))) == 0) {
            this.fetchRoot(operation, report);
        } else {
            this.fetchNode(report, parentID);
        }
        this.writer.writeEndElement();
    }

    private void fetchNode(Report report, int parentID) throws XMLStreamException {
        Subject subject = ((Report)report.getHandler().getFilteredReport()).findSubject(Integer.valueOf(parentID));
        if (subject != null) {
            int nodecount = subject.size();
            this.writer.writeElement("startRow", (CharSequence)"0", new SimpleAttribute[0]);
            this.writer.writeElement("endRow", (CharSequence)Integer.toString(nodecount - 1), new SimpleAttribute[0]);
            this.writer.writeElement("totalRows", (CharSequence)Integer.toString(nodecount), new SimpleAttribute[0]);
            this.writer.writeStartElement("data");
            for (Note n : subject) {
                this.writer.writeStartElement(RECORD);
                this.writer.writeAttribute("ID", Integer.toString(n.getId()));
                this.writer.writeAttribute(PARENT_ID, Integer.toString(parentID));
                this.writer.writeAttribute("title", n.getDocument());
                this.writer.writeAttribute("class", n.getClass().getSimpleName());
                this.writer.writeAttribute("isFolder", Boolean.toString(false));
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
        }
    }

    private void fetchRoot(XMLRequest.Operation operation, Report report) throws XMLStreamException {
        int nodecount = ((Report)report.getHandler().getFilteredReport()).size();
        int start = Math.min(nodecount - 1, operation.getStartRow());
        this.writer.writeElement("startRow", (CharSequence)Integer.toString(start), new SimpleAttribute[0]);
        int end = Math.min(nodecount - 1, operation.getEndRow());
        this.writer.writeElement("endRow", (CharSequence)Integer.toString(end), new SimpleAttribute[0]);
        this.writer.writeElement("totalRows", (CharSequence)Integer.toString(nodecount), new SimpleAttribute[0]);
        this.writer.writeElement("infos", (CharSequence)report.getStats().getStatus(), new SimpleAttribute[0]);
        if (nodecount > 0) {
            this.writer.writeStartElement("data");
            for (int i = start; i <= end; ++i) {
                Subject s = ((Report)report.getHandler().getFilteredReport()).get(i);
                this.writer.writeStartElement(RECORD);
                this.writer.writeAttribute("ID", Integer.toString(s.getId()));
                this.writer.writeAttribute(PARENT_ID, Integer.toString(0));
                this.writer.writeAttribute("title", s.getDocument());
                this.writer.writeAttribute("class", s.getClass().getSimpleName());
                if (s instanceof SubjectSet) {
                    SubjectSet ss = (SubjectSet)s;
                    this.writer.writeAttribute(STATUS, ss.getStatus().toString());
                    this.writer.writeAttribute("hasNotes", Boolean.toString(ss.hasNotes()));
                    this.writer.writeAttribute("isFixable", Boolean.toString(ss.isFixable()));
                }
                this.writer.writeAttribute("isFolder", Boolean.toString(!s.getNotes().isEmpty()));
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
        }
    }

    @Override
    protected void custom(XMLRequest.Operation operation) throws XMLStreamException, IOException {
        if ("detail".equals(operation.getOperationId().toString())) {
            Report report = this.request.session.getReport();
            if (operation.hasData("src")) {
                File srcfile = this.pathAbstractor.getAbsolutePath(operation.getData("src")).toFile();
                File reportfile = ReportIntf.getReportFile((Session)this.request.session, (File)srcfile);
                if (this.request.session.getTmpReport() == null || !this.request.session.getTmpReport().getReportFile((Session)this.request.session).equals(reportfile) || this.request.session.getTmpReport().getFileModified() != reportfile.lastModified()) {
                    this.request.session.setTmpReport(Report.load((Session)this.request.session, (File)srcfile));
                }
                report = this.request.session.getTmpReport();
            }
            int parentID = Integer.parseInt(operation.getData(PARENT_ID));
            Subject subject = ((Report)report.getHandler().getFilteredReport()).findSubject(Integer.valueOf(parentID));
            this.writer.writeStartElement("response");
            this.writer.writeElement(STATUS, (CharSequence)"0", new SimpleAttribute[0]);
            this.writer.writeStartElement("data");
            for (Note n : subject) {
                if (n.getId() != Integer.valueOf(operation.getData("ID")).intValue()) continue;
                this.writer.writeStartElement(RECORD);
                this.writer.writeAttribute("ID", Integer.toString(n.getId()));
                this.writer.writeAttribute(PARENT_ID, Integer.toString(parentID));
                this.writer.writeAttribute("Name", n.getName());
                this.writer.writeAttribute("CRC", n.getCrc());
                this.writer.writeAttribute("SHA1", n.getSha1());
                this.writer.writeStartElement("Detail");
                this.writer.writeCData(n.getDetail());
                this.writer.writeEndElement();
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeEndElement();
        } else {
            super.custom(operation);
        }
    }
}

