/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.handlers;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import jrm.server.shared.WebSession;
import jrm.server.shared.actions.CatVerActions;
import jrm.server.shared.actions.NPlayersActions;
import jrm.server.shared.actions.ProfileActions;
import jrm.server.shared.lpr.LongPollingReqMgr;

public class ActionServlet
extends HttpServlet {
    private static final String APPLICATION_JSON = "application/json";

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        try {
            if ("/actions/cmd".equals(req.getRequestURI())) {
                if (req.getContentLengthLong() < 0L) {
                    resp.setStatus(411);
                } else if (req.getContentLength() < 0) {
                    resp.setStatus(413);
                } else if (req.getContentLength() > 0) {
                    if (req.getContentType().equalsIgnoreCase(APPLICATION_JSON)) {
                        byte[] buf = new byte[req.getContentLength()];
                        req.getInputStream().read(buf, 0, req.getContentLength());
                        new LongPollingReqMgr((WebSession)req.getSession().getAttribute("session")).process(new String(buf, StandardCharsets.UTF_8));
                        resp.setContentLength(0);
                        resp.setContentType(APPLICATION_JSON);
                        resp.setStatus(200);
                    } else {
                        resp.setStatus(400);
                    }
                } else {
                    resp.setStatus(400);
                }
            } else {
                resp.setStatus(501);
            }
        }
        catch (Exception e) {
            resp.setStatus(500);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        try {
            WebSession sess = (WebSession)req.getSession().getAttribute("session");
            switch (req.getRequestURI()) {
                case "/actions/init": {
                    this.doInit(sess);
                    this.doLPR(resp, sess);
                    break;
                }
                case "/actions/lpr": {
                    this.doLPR(resp, sess);
                    break;
                }
                default: {
                    resp.setStatus(501);
                    break;
                }
            }
        }
        catch (Exception e) {
            resp.setStatus(500);
        }
    }

    private void doInit(WebSession sess) {
        LongPollingReqMgr cmd = new LongPollingReqMgr(sess);
        if (sess.getCurrProfile() != null) {
            new ProfileActions(cmd).loaded(sess.getCurrProfile());
            new CatVerActions(cmd).loaded(sess.getCurrProfile());
            new NPlayersActions(cmd).loaded(sess.getCurrProfile());
        }
        if (sess.getWorker() != null && sess.getWorker().isAlive() && sess.getWorker().progress != null) {
            sess.getWorker().progress.reload(cmd);
        }
    }

    private void doLPR(HttpServletResponse resp, WebSession sess) {
        if (WebSession.isTerminate()) {
            resp.setStatus(410);
            return;
        }
        try {
            String msg = sess.getLprMsg().poll(20L, TimeUnit.SECONDS);
            if (msg == null && WebSession.isTerminate()) {
                resp.setStatus(410);
            } else {
                ArrayList<String> msgs = new ArrayList<String>();
                msgs.add(msg);
                while (msgs.size() <= 100 && null != (msg = sess.getLprMsg().poll())) {
                    msgs.add(msg);
                }
                msg = this.encapsulate(msgs);
                this.sendResp(resp, msg);
            }
        }
        catch (InterruptedException e) {
            resp.setStatus(500);
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            resp.setStatus(500);
        }
    }

    private void sendResp(HttpServletResponse resp, String msg) throws IOException {
        resp.setContentType(APPLICATION_JSON);
        resp.setStatus(200);
        if (msg != null) {
            resp.setContentLength(msg.getBytes(StandardCharsets.UTF_8).length);
            resp.getWriter().write(msg);
        } else {
            resp.setContentLength(0);
        }
    }

    private String encapsulate(ArrayList<String> msgs) {
        Object msg = msgs.size() > 1 ? "{\"cmd\":\"Global.multiCMD\",\"params\":[" + msgs.stream().collect(Collectors.joining(",")) + "]}" : msgs.get(0);
        return msg;
    }
}

