/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.handlers;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jrm.misc.Log;
import jrm.security.PathAbstractor;
import jrm.security.Session;
import jrm.server.shared.WebSession;

public class DownloadServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        try {
            if ("/download/".equals(req.getRequestURI())) {
                this.download(req, resp);
            } else {
                super.doPost(req, resp);
            }
        }
        catch (ServletException | IOException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
        }
    }

    private void download(HttpServletRequest req, HttpServletResponse resp) {
        try {
            WebSession ws = (WebSession)req.getSession().getAttribute("session");
            PathAbstractor pathAbstractor = new PathAbstractor((Session)ws);
            String path = req.getParameter("path");
            if (path != null) {
                final Path file = pathAbstractor.getAbsolutePath(path);
                if (Files.isRegularFile(file, new LinkOption[0])) {
                    String dlfilename = file.getFileName().toString();
                    resp.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + URLEncoder.encode(dlfilename, "UTF-8") + "; filename=\"" + dlfilename + "\"");
                    resp.setHeader("Content-Transfer-Encoding", "binary");
                    resp.setStatus(200);
                    resp.setContentLengthLong(Files.size(file));
                    resp.setContentType(Files.probeContentType(file));
                    resp.setDateHeader("Last-Modified", Files.getLastModifiedTime(file, new LinkOption[0]).toMillis());
                    resp.setHeader("Cache-Control", "max-age=86400");
                    Files.copy(file, (OutputStream)resp.getOutputStream());
                } else {
                    String dlfilename = file.getFileName().toString() + ".zip";
                    resp.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + URLEncoder.encode(dlfilename, "UTF-8") + "; filename=\"" + dlfilename + "\"");
                    resp.setHeader("Content-Transfer-Encoding", "binary");
                    resp.setContentType("application/zip");
                    resp.setStatus(200);
                    final ZipOutputStream zos = new ZipOutputStream((OutputStream)resp.getOutputStream(), StandardCharsets.UTF_8);
                    Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                        @Override
                        public FileVisitResult visitFile(Path f, BasicFileAttributes attrs) throws IOException {
                            zos.putNextEntry(new ZipEntry(file.relativize(f).toString()));
                            Files.copy(f, zos);
                            zos.closeEntry();
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    zos.finish();
                }
            } else {
                resp.setStatus(400);
            }
        }
        catch (IOException e) {
            try {
                resp.sendError(500, e.getMessage());
            }
            catch (IOException e1) {
                Log.err((String)e1.getMessage(), (Throwable)e1);
            }
        }
    }
}

