/*
 * Decompiled with CFR 0.152.
 */
package jrm.server.shared.handlers;

import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import jrm.misc.Log;
import jrm.misc.URIUtils;
import org.apache.commons.io.IOUtils;

public class ImageServlet
extends HttpServlet {
    private static URI uri = null;
    private static Boolean isModule = null;

    private static URI getURI() throws URISyntaxException {
        if (isModule == null && !(isModule = Boolean.valueOf(URIUtils.URIExists((URI)(uri = URI.create("jrt:/jrm.merged.module/jrm/resicons/"))))).booleanValue()) {
            uri = ImageServlet.class.getResource("/jrm/resicons/").toURI();
        }
        return uri;
    }

    private boolean ifModifiedSince(HttpServletRequest req, URLConnection urlconn) {
        String ifModifiedSince = req.getHeader("if-modified-since");
        try {
            if (ifModifiedSince != null && ImageServlet.dateParse(ifModifiedSince).getTime() / 1000L == urlconn.getLastModified() / 1000L) {
                return false;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return true;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            URI uri = URI.create(String.valueOf(ImageServlet.getURI()) + req.getRequestURI().substring(8));
            URL url = uri.toURL();
            URLConnection urlconn = url.openConnection();
            urlconn.setDoInput(true);
            if (urlconn.getContentLength() == 0) {
                resp.sendError(404, "Empty result");
                return;
            }
            if (!this.ifModifiedSince(req, urlconn)) {
                resp.sendError(304);
                return;
            }
            resp.setStatus(200);
            resp.setContentLengthLong(urlconn.getContentLengthLong());
            resp.setContentType(urlconn.getContentType());
            resp.setDateHeader("Last-Modified", urlconn.getLastModified());
            resp.setHeader("Cache-Control", "max-age=86400");
            IOUtils.copy((InputStream)urlconn.getInputStream(), (OutputStream)resp.getOutputStream());
        }
        catch (IOException | URISyntaxException e) {
            try {
                resp.sendError(404, e.getMessage());
            }
            catch (IOException e1) {
                Log.err((String)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    private static Date dateParse(String str) throws ParseException {
        SimpleDateFormat gmtFrmt = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss z", Locale.US);
        gmtFrmt.setTimeZone(TimeZone.getTimeZone(ZoneId.of("GMT")));
        return gmtFrmt.parse(str);
    }
}

