/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValueBase;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import jrm.batch.DirUpdaterResults;
import jrm.fx.ui.BaseController;
import jrm.fx.ui.controls.ButtonCellFactory;
import jrm.fx.ui.profile.report.ReportLite;
import jrm.profile.report.Report;
import jrm.security.Session;
import lombok.Generated;

public class BatchDirUpd8rResultsController
extends BaseController {
    @FXML
    private TableView<DirUpdaterResults.DirUpdaterResult> resultList;
    @FXML
    private TableColumn<DirUpdaterResults.DirUpdaterResult, String> datCol;
    @FXML
    private TableColumn<DirUpdaterResults.DirUpdaterResult, Integer> haveCol;
    @FXML
    private TableColumn<DirUpdaterResults.DirUpdaterResult, Integer> createCol;
    @FXML
    private TableColumn<DirUpdaterResults.DirUpdaterResult, Integer> fixCol;
    @FXML
    private TableColumn<DirUpdaterResults.DirUpdaterResult, Integer> missCol;
    @FXML
    private TableColumn<DirUpdaterResults.DirUpdaterResult, Integer> totalCol;
    @FXML
    private TableColumn<DirUpdaterResults.DirUpdaterResult, DirUpdaterResults.DirUpdaterResult> reportCol;
    @FXML
    private Button ok;
    private Font font = new Font(10.0);

    public void initialize(URL location, ResourceBundle resources) {
        this.ok.setOnAction(e -> this.ok.getScene().getWindow().hide());
        this.resultList.setFixedCellSize(18.0);
        this.resultList.setSelectionModel(null);
        this.datCol.setCellFactory(param -> new TableCell<DirUpdaterResults.DirUpdaterResult, String>(){

            protected void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty) {
                    this.setText("");
                } else {
                    this.setTextOverrun(OverrunStyle.LEADING_ELLIPSIS);
                    this.setText(item);
                    this.setTooltip(new Tooltip(item));
                }
                this.setMinHeight(15.0);
                this.setFont(BatchDirUpd8rResultsController.this.font);
                this.setGraphic(null);
            }
        });
        this.datCol.setCellValueFactory(param -> new ObservableValueBase<String>(this){

            public String getValue() {
                return ((DirUpdaterResults.DirUpdaterResult)param.getValue()).getDat().toString();
            }
        });
        this.haveCol.setCellFactory(param -> new TableCell<DirUpdaterResults.DirUpdaterResult, Integer>(){

            protected void updateItem(Integer item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty) {
                    this.setText("");
                } else {
                    this.setTextFill((Paint)Color.GREEN);
                    this.setAlignment(Pos.CENTER_RIGHT);
                    this.setText(item.toString());
                    this.setTooltip(new Tooltip(item.toString()));
                }
                this.setMinHeight(15.0);
                this.setFont(BatchDirUpd8rResultsController.this.font);
                this.setGraphic(null);
            }
        });
        this.haveCol.setCellValueFactory(param -> new ObservableValueBase<Integer>(this){

            public Integer getValue() {
                return ((DirUpdaterResults.DirUpdaterResult)param.getValue()).getStats().getSetFoundOk();
            }
        });
        this.createCol.setCellFactory(param -> new TableCell<DirUpdaterResults.DirUpdaterResult, Integer>(){

            protected void updateItem(Integer item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty) {
                    this.setText("");
                } else {
                    this.setTextFill((Paint)Color.BLUE);
                    this.setAlignment(Pos.CENTER_RIGHT);
                    this.setText(item.toString());
                    this.setTooltip(new Tooltip(item.toString()));
                }
                this.setMinHeight(15.0);
                this.setFont(BatchDirUpd8rResultsController.this.font);
                this.setGraphic(null);
            }
        });
        this.createCol.setCellValueFactory(param -> new ObservableValueBase<Integer>(this){

            public Integer getValue() {
                return ((DirUpdaterResults.DirUpdaterResult)param.getValue()).getStats().getSetCreateComplete();
            }
        });
        this.fixCol.setCellFactory(param -> new TableCell<DirUpdaterResults.DirUpdaterResult, Integer>(){

            protected void updateItem(Integer item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty) {
                    this.setText("");
                } else {
                    this.setTextFill((Paint)Color.DARKVIOLET);
                    this.setAlignment(Pos.CENTER_RIGHT);
                    this.setText(item.toString());
                    this.setTooltip(new Tooltip(item.toString()));
                }
                this.setMinHeight(15.0);
                this.setFont(BatchDirUpd8rResultsController.this.font);
                this.setGraphic(null);
            }
        });
        this.fixCol.setCellValueFactory(param -> new ObservableValueBase<Integer>(this){

            public Integer getValue() {
                return ((DirUpdaterResults.DirUpdaterResult)param.getValue()).getStats().getSetFoundFixComplete();
            }
        });
        this.missCol.setCellFactory(param -> new TableCell<DirUpdaterResults.DirUpdaterResult, Integer>(){

            protected void updateItem(Integer item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty) {
                    this.setText("");
                } else {
                    this.setTextFill((Paint)Color.RED);
                    this.setAlignment(Pos.CENTER_RIGHT);
                    this.setText(item.toString());
                    this.setTooltip(new Tooltip(item.toString()));
                }
                this.setMinHeight(15.0);
                this.setFont(BatchDirUpd8rResultsController.this.font);
                this.setGraphic(null);
            }
        });
        this.missCol.setCellValueFactory(param -> new ObservableValueBase<Integer>(this){

            public Integer getValue() {
                return ((DirUpdaterResults.DirUpdaterResult)param.getValue()).getStats().getSetCreate() + ((DirUpdaterResults.DirUpdaterResult)param.getValue()).getStats().getSetFound() + ((DirUpdaterResults.DirUpdaterResult)param.getValue()).getStats().getSetMissing() - (((DirUpdaterResults.DirUpdaterResult)param.getValue()).getStats().getSetCreateComplete() + ((DirUpdaterResults.DirUpdaterResult)param.getValue()).getStats().getSetFoundFixComplete() + ((DirUpdaterResults.DirUpdaterResult)param.getValue()).getStats().getSetFoundOk());
            }
        });
        this.totalCol.setCellFactory(param -> new TableCell<DirUpdaterResults.DirUpdaterResult, Integer>(){

            protected void updateItem(Integer item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty) {
                    this.setText("");
                } else {
                    this.setAlignment(Pos.CENTER_RIGHT);
                    this.setText(item.toString());
                    this.setTooltip(new Tooltip(item.toString()));
                }
                this.setMinHeight(15.0);
                this.setFont(BatchDirUpd8rResultsController.this.font);
                this.setGraphic(null);
            }
        });
        this.totalCol.setCellValueFactory(param -> new ObservableValueBase<Integer>(this){

            public Integer getValue() {
                return ((DirUpdaterResults.DirUpdaterResult)param.getValue()).getStats().getSetCreate() + ((DirUpdaterResults.DirUpdaterResult)param.getValue()).getStats().getSetFound() + ((DirUpdaterResults.DirUpdaterResult)param.getValue()).getStats().getSetMissing();
            }
        });
        this.reportCol.setCellFactory(param -> new ButtonCellFactory("Report", cell -> {
            DirUpdaterResults.DirUpdaterResult result = (DirUpdaterResults.DirUpdaterResult)this.resultList.getItems().get(cell.getIndex());
            try {
                new ReportLite((Stage)this.resultList.getScene().getWindow(), Report.load((Session)this.session, (File)result.getDat()));
            }
            catch (IOException | URISyntaxException e1) {
                e1.printStackTrace();
            }
        }));
    }

    @Generated
    public TableView<DirUpdaterResults.DirUpdaterResult> getResultList() {
        return this.resultList;
    }
}

