/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValueBase;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Font;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import jrm.aui.basic.AbstractSrcDstResult;
import jrm.aui.basic.ResultColUpdater;
import jrm.aui.progress.ProgressHandler;
import jrm.batch.Compressor;
import jrm.batch.CompressorFormat;
import jrm.batch.DirUpdater;
import jrm.batch.DirUpdaterResults;
import jrm.batch.TorrentChecker;
import jrm.batch.TrntChkReport;
import jrm.fx.ui.BaseController;
import jrm.fx.ui.BatchDirUpd8rResults;
import jrm.fx.ui.BatchTorrentResults;
import jrm.fx.ui.MainFrame;
import jrm.fx.ui.ScannerPanelSettingsController;
import jrm.fx.ui.controls.ButtonCellFactory;
import jrm.fx.ui.controls.Dialogs;
import jrm.fx.ui.controls.DropCell;
import jrm.fx.ui.controls.NodeCellFactory;
import jrm.fx.ui.misc.DragNDrop;
import jrm.fx.ui.misc.FileResult;
import jrm.fx.ui.misc.SrcDstResult;
import jrm.fx.ui.progress.ProgressTask;
import jrm.io.torrent.options.TrntChkMode;
import jrm.locale.Messages;
import jrm.misc.BreakException;
import jrm.misc.EnumWithDefault;
import jrm.misc.Log;
import jrm.misc.MultiThreadingVirtual;
import jrm.misc.ProfileSettings;
import jrm.misc.SettingsEnum;
import jrm.security.PathAbstractor;
import jrm.security.Session;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class BatchToolsPanelController
extends BaseController {
    private static final String ICON_BULLET_GO = "/jrm/resicons/icons/bullet_go.png";
    @FXML
    private Tab panelBatchToolsDat2Dir;
    @FXML
    private Tab panelBatchToolsDir2Torrent;
    @FXML
    private Tab panelBatchToolsCompressor;
    @FXML
    private Button btnBatchToolsDir2DatStart;
    @FXML
    private Button btnBatchToolsTrntChkStart;
    @FXML
    private Button btnBatchToolsCompressorStart;
    @FXML
    private Button btnBatchToolsCompressorClear;
    @FXML
    private ChoiceBox<TrntChkMode> cbbxBatchToolsTrntChk;
    @FXML
    private ChoiceBox<CompressorFormat> cbbxBatchToolsCompressorFormat;
    @FXML
    private CheckBox cbBatchToolsDat2DirDryRun;
    @FXML
    private CheckBox cbBatchToolsTrntChkDetectArchivedFolder;
    @FXML
    private CheckBox cbBatchToolsTrntChkRemoveUnknownFiles;
    @FXML
    private CheckBox cbBatchToolsTrntChkRemoveWrongSizedFiles;
    @FXML
    private CheckBox cbBatchToolsCompressorForce;
    @FXML
    private TableView<File> tvBatchToolsDat2DirSrc;
    @FXML
    private TableColumn<File, File> tvBatchToolsDat2DirSrcCol;
    @FXML
    private ContextMenu popupMenuSrc;
    @FXML
    private MenuItem mnDat2DirAddSrcDir;
    @FXML
    private MenuItem mnDat2DirDelSrcDir;
    @FXML
    private TableView<SrcDstResult> tvBatchToolsDat2DirDst;
    @FXML
    private TableColumn<SrcDstResult, String> tvBatchToolsDat2DirDstDatsCol;
    @FXML
    private TableColumn<SrcDstResult, String> tvBatchToolsDat2DirDstDirsCol;
    @FXML
    private TableColumn<SrcDstResult, String> tvBatchToolsDat2DirDstResultCol;
    @FXML
    private TableColumn<SrcDstResult, SrcDstResult> tvBatchToolsDat2DirDstDetailsCol;
    @FXML
    private TableColumn<SrcDstResult, Boolean> tvBatchToolsDat2DirDstSelCol;
    @FXML
    private ContextMenu popupMenuDst;
    @FXML
    private MenuItem mnDat2DirDelDstDat;
    @FXML
    private Menu mntmDat2DirDstPresets;
    @FXML
    private TableView<SrcDstResult> tvBatchToolsTorrent;
    @FXML
    private TableColumn<SrcDstResult, String> tvBatchToolsTorrentFilesCol;
    @FXML
    private TableColumn<SrcDstResult, String> tvBatchToolsTorrentDstDirsCol;
    @FXML
    private TableColumn<SrcDstResult, String> tvBatchToolsTorrentResultCol;
    @FXML
    private TableColumn<SrcDstResult, SrcDstResult> tvBatchToolsTorrentDetailsCol;
    @FXML
    private TableColumn<SrcDstResult, Boolean> tvBatchToolsTorrentSelCol;
    @FXML
    private ContextMenu popupMenuTorrent;
    @FXML
    private MenuItem mnDelTorrent;
    @FXML
    private TableView<FileResult> tvBatchToolsCompressor;
    @FXML
    private TableColumn<FileResult, Path> tvBatchToolsCompressorFileCol;
    @FXML
    private TableColumn<FileResult, String> tvBatchToolsCompressorStatusCol;
    private Font font = new Font(10.0);

    public void initialize(URL location, ResourceBundle resources) {
        this.initDat2Dir();
        this.initTorrent();
        this.initCompressor();
    }

    private void initCompressor() {
        this.panelBatchToolsCompressor.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/compress.png")));
        this.tvBatchToolsCompressor.setFixedCellSize(18.0);
        new DragNDrop((Control)this.tvBatchToolsCompressor).addAny(this::addFilesToCompressorList);
        this.tvBatchToolsCompressorFileCol.setCellFactory(param -> new TableCell<FileResult, Path>(){

            protected void updateItem(Path item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.setFont(BatchToolsPanelController.this.font);
                if (empty) {
                    this.setText("");
                } else {
                    this.setText(item.toString());
                    this.setTooltip(new Tooltip(this.getText()));
                }
            }
        });
        this.tvBatchToolsCompressorFileCol.setCellValueFactory(param -> ((FileResult)param.getValue()).fileProperty());
        this.tvBatchToolsCompressorStatusCol.setCellFactory(param -> new TableCell<FileResult, String>(){

            protected void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.setFont(BatchToolsPanelController.this.font);
                if (empty) {
                    this.setText("");
                } else {
                    this.setText(item);
                    this.setTooltip(new Tooltip(item));
                }
            }
        });
        this.tvBatchToolsCompressorStatusCol.setCellValueFactory(param -> ((FileResult)param.getValue()).resultProperty());
        this.cbbxBatchToolsCompressorFormat.setItems(FXCollections.observableArrayList((Object[])CompressorFormat.values()));
        this.cbbxBatchToolsCompressorFormat.getSelectionModel().select((Object)CompressorFormat.valueOf((String)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.compressor_format)));
        this.cbbxBatchToolsCompressorFormat.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.compressor_format, newValue.toString()));
        this.cbBatchToolsCompressorForce.setSelected(((Boolean)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.compressor_force, Boolean.class)).booleanValue());
        this.cbBatchToolsCompressorForce.selectedProperty().addListener((observable, oldValue, newValue) -> this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.compressor_force, newValue.booleanValue()));
        this.btnBatchToolsCompressorClear.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/bin.png")));
        this.btnBatchToolsCompressorStart.setGraphic((Node)new ImageView(MainFrame.getIcon(ICON_BULLET_GO)));
        this.btnBatchToolsCompressorStart.setOnAction(e -> {
            try {
                Thread thread = new Thread((Runnable)((Object)this.startCompression()));
                thread.setDaemon(true);
                thread.start();
            }
            catch (IOException | URISyntaxException e1) {
                e1.printStackTrace();
            }
        });
    }

    private ProgressTask<Void> startCompression() throws IOException, URISyntaxException {
        return new ProgressTask<Void>((Stage)this.btnBatchToolsCompressorStart.getScene().getWindow()){

            protected Void call() throws Exception {
                AtomicInteger cnt = new AtomicInteger();
                Compressor compressor = new Compressor(BatchToolsPanelController.this.session, cnt, BatchToolsPanelController.this.tvBatchToolsCompressor.getItems().size(), (ProgressHandler)this);
                Boolean use_parallelism = (Boolean)BatchToolsPanelController.this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.compressor_parallelism, Boolean.class);
                int nThreads = Boolean.TRUE.equals(use_parallelism) ? (Integer)BatchToolsPanelController.this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.thread_count, Integer.class) : 1;
                this.setInfos(nThreads <= 0 ? Runtime.getRuntime().availableProcessors() : nThreads, true);
                BatchToolsPanelController.this.tvBatchToolsCompressor.getItems().forEach(fr -> fr.setResult(""));
                try (MultiThreadingVirtual mt = new MultiThreadingVirtual("compressor", (ProgressHandler)this, nThreads, fr -> {
                    if (this.isCancel()) {
                        return;
                    }
                    BatchToolsPanelController.this.compress(cnt, compressor, (FileResult)fr);
                });){
                    mt.start(BatchToolsPanelController.this.tvBatchToolsCompressor.getItems().stream());
                }
                return null;
            }

            public void succeeded() {
                this.close();
            }

            protected void failed() {
                this.close();
                if (this.getException() instanceof BreakException || this.isCancelled()) {
                    Dialogs.showAlert("Cancelled");
                } else {
                    Optional.ofNullable(this.getException().getCause()).ifPresentOrElse(cause -> {
                        Log.err((String)cause.getMessage(), (Throwable)cause);
                        Dialogs.showError(cause);
                    }, () -> {
                        Log.err((String)this.getException().getMessage(), (Throwable)this.getException());
                        Dialogs.showError(this.getException());
                    });
                }
            }
        };
    }

    private void compress(AtomicInteger cnt, Compressor compressor, FileResult fr) throws IllegalArgumentException {
        File file = fr.getFile().toFile();
        cnt.incrementAndGet();
        Compressor.UpdResultCallBack cb = fr::setResult;
        Compressor.UpdSrcCallBack scb = src -> fr.setFile(src.toPath());
        switch ((CompressorFormat)this.cbbxBatchToolsCompressorFormat.getSelectionModel().getSelectedItem()) {
            case SEVENZIP: {
                this.toSevenZip(compressor, file, cb, scb);
                break;
            }
            case ZIP: {
                this.toZip(compressor, file, cb, scb);
                break;
            }
            case TZIP: {
                this.toTZip(compressor, file, cb, scb);
            }
        }
    }

    private void toSevenZip(Compressor compressor, File file, Compressor.UpdResultCallBack cb, Compressor.UpdSrcCallBack scb) throws IllegalArgumentException {
        switch (FilenameUtils.getExtension((String)file.getName())) {
            case "zip": {
                compressor.zip2SevenZip(file, cb, scb);
                break;
            }
            case "7z": {
                if (this.cbBatchToolsCompressorForce.isSelected()) {
                    compressor.sevenZip2SevenZip(file, cb, scb);
                    break;
                }
                cb.apply("Skipped");
                break;
            }
            default: {
                compressor.sevenZip2SevenZip(file, cb, scb);
            }
        }
    }

    private void toZip(Compressor compressor, File file, Compressor.UpdResultCallBack cb, Compressor.UpdSrcCallBack scb) throws IllegalArgumentException {
        if ("zip".equals(FilenameUtils.getExtension((String)file.getName()))) {
            if (this.cbBatchToolsCompressorForce.isSelected()) {
                compressor.zip2Zip(file, cb, scb);
            } else {
                cb.apply("Skipped");
            }
        } else {
            compressor.sevenZip2Zip(file, false, cb, scb);
        }
    }

    private void toTZip(Compressor compressor, File file, Compressor.UpdResultCallBack cb, Compressor.UpdSrcCallBack scb) throws IllegalArgumentException {
        if ("zip".equals(FilenameUtils.getExtension((String)file.getName()))) {
            compressor.zip2TZip(file, this.cbBatchToolsCompressorForce.isSelected(), cb);
        } else if ((file = compressor.sevenZip2Zip(file, true, cb, scb)) != null && file.exists()) {
            compressor.zip2TZip(file, this.cbBatchToolsCompressorForce.isSelected(), cb);
        }
    }

    private void addFilesToCompressorList(List<File> files) {
        String[] extensions = new String[]{"zip", "7z", "rar", "arj", "tar", "lzh", "lha", "tgz", "tbz", "tbz2", "rpm", "iso", "deb", "cab"};
        LinkedHashSet<FileResult> set = new LinkedHashSet<FileResult>((Collection<FileResult>)this.tvBatchToolsCompressor.getItems());
        List<FileResult> ffiles = files.stream().flatMap(f -> {
            try {
                return f.isDirectory() ? Files.find(f.toPath(), Integer.MAX_VALUE, (p, attr) -> attr.isRegularFile() && FilenameUtils.isExtension((String)p.getFileName().toString(), (String[])extensions), new FileVisitOption[0]) : Stream.of(f.toPath());
            }
            catch (IOException e) {
                return null;
            }
        }).map(FileResult::new).toList();
        set.addAll(ffiles);
        this.tvBatchToolsCompressor.setItems(FXCollections.observableArrayList(set));
    }

    private void initTorrent() {
        this.panelBatchToolsDir2Torrent.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/drive_web.png")));
        this.initTorrentList();
        this.cbbxBatchToolsTrntChk.setItems(FXCollections.observableArrayList((Object[])TrntChkMode.values()));
        this.cbbxBatchToolsTrntChk.getSelectionModel().select((Object)TrntChkMode.valueOf((String)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_mode)));
        this.cbbxBatchToolsTrntChk.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.trntchk_mode, newValue.toString());
            this.cbBatchToolsTrntChkRemoveWrongSizedFiles.setDisable(newValue == TrntChkMode.FILENAME);
        });
        this.cbBatchToolsTrntChkDetectArchivedFolder.setSelected(((Boolean)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_detect_archived_folders, Boolean.class)).booleanValue());
        this.cbBatchToolsTrntChkDetectArchivedFolder.selectedProperty().addListener((observable, oldValue, newValue) -> this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.trntchk_detect_archived_folders, newValue.booleanValue()));
        this.cbBatchToolsTrntChkRemoveWrongSizedFiles.setSelected(((Boolean)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_remove_wrong_sized_files, Boolean.class)).booleanValue());
        this.cbBatchToolsTrntChkRemoveWrongSizedFiles.selectedProperty().addListener((observable, oldValue, newValue) -> this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.trntchk_remove_wrong_sized_files, newValue.booleanValue()));
        this.cbBatchToolsTrntChkRemoveUnknownFiles.setSelected(((Boolean)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_remove_unknown_files, Boolean.class)).booleanValue());
        this.cbBatchToolsTrntChkRemoveUnknownFiles.selectedProperty().addListener((observable, oldValue, newValue) -> this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.trntchk_remove_unknown_files, newValue.booleanValue()));
        this.btnBatchToolsTrntChkStart.setOnAction(e -> this.startTorrent());
        this.btnBatchToolsTrntChkStart.setGraphic((Node)new ImageView(MainFrame.getIcon(ICON_BULLET_GO)));
    }

    private void initTorrentList() {
        this.tvBatchToolsTorrent.setFixedCellSize(18.0);
        this.tvBatchToolsTorrent.getItems().setAll(SrcDstResult.fromJSON(this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_sdr)));
        this.tvBatchToolsTorrentFilesCol.setCellFactory(param -> new DropCell(this.tvBatchToolsTorrent, (sdrlist, files) -> {
            for (int i = 0; i < files.size(); ++i) {
                ((SrcDstResult)((Object)((Object)((Object)sdrlist.get(i))))).setSrc(PathAbstractor.getRelativePath((Session)this.session, (Path)((File)files.get(i)).toPath()).toString());
            }
            this.saveTorrentDst();
        }, file -> {
            if (Files.isRegularFile(file.toPath(), new LinkOption[0])) {
                return file.getName().endsWith(".torrent");
            }
            return false;
        }));
        this.tvBatchToolsTorrentFilesCol.setCellValueFactory(param -> ((SrcDstResult)((Object)((Object)param.getValue()))).srcProperty());
        this.tvBatchToolsTorrentDstDirsCol.setCellFactory(param -> new DropCell(this.tvBatchToolsTorrent, (sdrlist, files) -> {
            for (int i = 0; i < files.size(); ++i) {
                ((SrcDstResult)((Object)((Object)((Object)sdrlist.get(i))))).setDst(PathAbstractor.getRelativePath((Session)this.session, (Path)((File)files.get(i)).toPath()).toString());
            }
            this.saveTorrentDst();
        }, File::isDirectory));
        this.tvBatchToolsTorrentDstDirsCol.setCellValueFactory(param -> ((SrcDstResult)((Object)((Object)param.getValue()))).dstProperty());
        this.tvBatchToolsTorrentResultCol.setCellFactory(param -> new NodeCellFactory());
        this.tvBatchToolsTorrentResultCol.setCellValueFactory(param -> ((SrcDstResult)((Object)((Object)param.getValue()))).resultProperty());
        this.tvBatchToolsTorrentSelCol.setCellFactory(CheckBoxTableCell.forTableColumn(param -> {
            SrcDstResult sdr = (SrcDstResult)((Object)((Object)this.tvBatchToolsTorrent.getItems().get(param.intValue())));
            SimpleBooleanProperty observable = new SimpleBooleanProperty(sdr.isSelected());
            observable.addListener((obs, wasSelected, isNowSelected) -> {
                sdr.setSelected((boolean)isNowSelected);
                this.saveTorrentDst();
            });
            return observable;
        }));
        this.tvBatchToolsTorrentDetailsCol.setCellFactory(param -> new ButtonCellFactory("Detail", cell -> {
            AbstractSrcDstResult sdr = (AbstractSrcDstResult)this.tvBatchToolsTorrent.getItems().get(cell.getIndex());
            TrntChkReport results = TrntChkReport.load((Session)this.session, (File)PathAbstractor.getAbsolutePath((Session)this.session, (String)sdr.getSrc()).toFile());
            try {
                new BatchTorrentResults((Stage)this.tvBatchToolsTorrent.getScene().getWindow(), results);
            }
            catch (IOException | URISyntaxException e1) {
                e1.printStackTrace();
            }
        }));
        this.popupMenuTorrent.setOnShowing(e -> this.mnDelTorrent.setDisable(this.tvBatchToolsTorrent.getSelectionModel().isEmpty()));
    }

    private void initDat2Dir() {
        this.panelBatchToolsDat2Dir.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/application_cascade.png")));
        this.initDat2DirSrc();
        this.initDat2DirDst();
        this.cbBatchToolsDat2DirDryRun.setSelected(((Boolean)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_dry_run, Boolean.class)).booleanValue());
        this.cbBatchToolsDat2DirDryRun.selectedProperty().addListener((observable, oldValue, newValue) -> this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dat2dir_dry_run, newValue.booleanValue()));
        this.btnBatchToolsDir2DatStart.setGraphic((Node)new ImageView(MainFrame.getIcon(ICON_BULLET_GO)));
        this.btnBatchToolsDir2DatStart.setOnAction(e -> this.startDir2Dat());
    }

    private void initDat2DirDst() {
        this.tvBatchToolsDat2DirDst.setFixedCellSize(18.0);
        this.tvBatchToolsDat2DirDst.getItems().setAll(SrcDstResult.fromJSON(this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_sdr)));
        this.tvBatchToolsDat2DirDstDatsCol.setCellFactory(param -> new DropCell(this.tvBatchToolsDat2DirDst, (sdrlist, files) -> {
            for (int i = 0; i < files.size(); ++i) {
                ((SrcDstResult)((Object)((Object)((Object)sdrlist.get(i))))).setSrc(PathAbstractor.getRelativePath((Session)this.session, (Path)((File)files.get(i)).toPath()).toString());
            }
            this.saveDat2DirDst();
        }, file -> {
            if (Files.isRegularFile(file.toPath(), new LinkOption[0])) {
                return file.getName().endsWith(".xml") || file.getName().endsWith(".dat");
            }
            if (file.isDirectory()) {
                try {
                    return Files.list(file.toPath()).map(Path::toFile).anyMatch(f -> f.getName().endsWith(".xml") || f.getName().endsWith(".dat"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }));
        this.tvBatchToolsDat2DirDstDatsCol.setCellValueFactory(param -> ((SrcDstResult)((Object)((Object)param.getValue()))).srcProperty());
        this.tvBatchToolsDat2DirDstDirsCol.setCellFactory(param -> new DropCell(this.tvBatchToolsDat2DirDst, (sdrlist, files) -> {
            for (int i = 0; i < files.size(); ++i) {
                ((SrcDstResult)((Object)((Object)((Object)sdrlist.get(i))))).setDst(PathAbstractor.getRelativePath((Session)this.session, (Path)((File)files.get(i)).toPath()).toString());
            }
            this.saveDat2DirDst();
        }, File::isDirectory));
        this.tvBatchToolsDat2DirDstDirsCol.setCellValueFactory(param -> ((SrcDstResult)((Object)((Object)param.getValue()))).dstProperty());
        this.tvBatchToolsDat2DirDstResultCol.setCellFactory(param -> new TableCell<SrcDstResult, String>(){

            protected void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.setFont(BatchToolsPanelController.this.font);
                if (empty) {
                    this.setText("");
                } else {
                    this.setText(item);
                    this.setTooltip(new Tooltip(item));
                }
            }
        });
        this.tvBatchToolsDat2DirDstResultCol.setCellValueFactory(param -> ((SrcDstResult)((Object)((Object)param.getValue()))).resultProperty());
        this.tvBatchToolsDat2DirDstDetailsCol.setCellFactory(param -> this.getDat2DirDetailButtonCellFactory());
        this.tvBatchToolsDat2DirDstSelCol.setCellFactory(CheckBoxTableCell.forTableColumn(param -> {
            SrcDstResult sdr = (SrcDstResult)((Object)((Object)this.tvBatchToolsDat2DirDst.getItems().get(param.intValue())));
            SimpleBooleanProperty observable = new SimpleBooleanProperty(sdr.isSelected());
            observable.addListener((obs, wasSelected, isNowSelected) -> {
                sdr.setSelected((boolean)isNowSelected);
                this.saveDat2DirDst();
            });
            return observable;
        }));
        this.popupMenuDst.setOnShowing(e -> {
            this.mntmDat2DirDstPresets.setDisable(this.tvBatchToolsDat2DirDst.getSelectionModel().isEmpty());
            this.mnDat2DirDelDstDat.setDisable(this.tvBatchToolsDat2DirDst.getSelectionModel().isEmpty());
        });
    }

    private ButtonCellFactory<SrcDstResult, SrcDstResult> getDat2DirDetailButtonCellFactory() {
        return new ButtonCellFactory<SrcDstResult, SrcDstResult>("Detail", cell -> {
            AbstractSrcDstResult sdr = (AbstractSrcDstResult)this.tvBatchToolsDat2DirDst.getItems().get(cell.getIndex());
            DirUpdaterResults results = DirUpdaterResults.load((Session)this.session, (File)new File(sdr.getSrc()));
            try {
                new BatchDirUpd8rResults((Stage)this.tvBatchToolsDat2DirDst.getScene().getWindow(), results);
            }
            catch (IOException | URISyntaxException e1) {
                e1.printStackTrace();
            }
        });
    }

    private void initDat2DirSrc() {
        new DragNDrop((Control)this.tvBatchToolsDat2DirSrc).addDirs(dirs -> {
            this.tvBatchToolsDat2DirSrc.getItems().addAll((Collection)dirs);
            this.saveDat2DirSrc();
        });
        this.tvBatchToolsDat2DirSrc.setFixedCellSize(18.0);
        this.tvBatchToolsDat2DirSrc.getItems().setAll(Stream.of(StringUtils.split((String)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_srcdirs), (char)'|')).filter(s -> !s.isBlank()).map(File::new).toList());
        this.tvBatchToolsDat2DirSrcCol.setCellFactory(param -> new TableCell<File, File>(){

            protected void updateItem(File item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.setFont(BatchToolsPanelController.this.font);
                this.setText(empty ? "" : item.toString());
            }
        });
        this.tvBatchToolsDat2DirSrcCol.setCellValueFactory(param -> new ObservableValueBase<File>(this){

            public File getValue() {
                return (File)param.getValue();
            }
        });
        this.popupMenuSrc.setOnShowing(e -> this.mnDat2DirDelSrcDir.setDisable(this.tvBatchToolsDat2DirSrc.getSelectionModel().isEmpty()));
        this.mnDat2DirDelSrcDir.setOnAction(e -> {
            this.tvBatchToolsDat2DirSrc.getItems().removeAll((Collection)this.tvBatchToolsDat2DirSrc.getSelectionModel().getSelectedItems());
            this.saveDat2DirSrc();
        });
        File lastsrcdir = Optional.ofNullable(this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_lastsrcdir)).map(File::new).filter(File::exists).orElse(null);
        this.mnDat2DirAddSrcDir.setOnAction(e -> this.chooseDir((Control)this.tvBatchToolsDat2DirSrc, null, lastsrcdir, dir -> {
            this.tvBatchToolsDat2DirSrc.getItems().add((Object)dir.toFile());
            this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dat2dir_lastsrcdir, dir.toFile().getParent());
            this.saveDat2DirSrc();
        }));
    }

    private void startDir2Dat() {
        if (!this.tvBatchToolsDat2DirSrc.getItems().isEmpty()) {
            ObservableList sdrl = this.tvBatchToolsDat2DirDst.getItems();
            if (sdrl.stream().filter(sdr -> !this.session.getUser().getSettings().getProfileSettingsFile(PathAbstractor.getAbsolutePath((Session)this.session, (String)sdr.getSrc()).toFile()).exists()).count() > 0L) {
                Dialogs.showAlert(Messages.getString((String)"MainFrame.AllDatsPresetsAssigned"));
            } else {
                try {
                    ResultColUpdater updater = new ResultColUpdater(){

                        public void updateResult(int row, String result) {
                            ((SrcDstResult)((Object)BatchToolsPanelController.this.tvBatchToolsDat2DirDst.getItems().get(row))).setResult(result);
                        }

                        public void clearResults() {
                            for (AbstractSrcDstResult item : BatchToolsPanelController.this.tvBatchToolsDat2DirDst.getItems()) {
                                item.setResult("");
                            }
                        }
                    };
                    Thread thread = new Thread((Runnable)((Object)this.buildDir2DatTask((List<SrcDstResult>)sdrl, updater)));
                    thread.setDaemon(true);
                    thread.start();
                }
                catch (IOException | URISyntaxException ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            Dialogs.showAlert(Messages.getString((String)"MainFrame.AtLeastOneSrcDir"));
        }
    }

    private void startTorrent() {
        if (!this.tvBatchToolsTorrent.getItems().isEmpty()) {
            ObservableList sdrl = this.tvBatchToolsTorrent.getItems();
            TrntChkMode mode = (TrntChkMode)this.cbbxBatchToolsTrntChk.getSelectionModel().getSelectedItem();
            ResultColUpdater updater = new ResultColUpdater(){

                public void updateResult(int row, String result) {
                    ((SrcDstResult)((Object)BatchToolsPanelController.this.tvBatchToolsTorrent.getItems().get(row))).setResult(result);
                }

                public void clearResults() {
                    for (AbstractSrcDstResult item : BatchToolsPanelController.this.tvBatchToolsTorrent.getItems()) {
                        item.setResult("");
                    }
                }
            };
            EnumSet<TorrentChecker.Options> opts = EnumSet.noneOf(TorrentChecker.Options.class);
            if (this.cbBatchToolsTrntChkRemoveUnknownFiles.isSelected()) {
                opts.add(TorrentChecker.Options.REMOVEUNKNOWNFILES);
            }
            if (this.cbBatchToolsTrntChkRemoveWrongSizedFiles.isSelected()) {
                opts.add(TorrentChecker.Options.REMOVEWRONGSIZEDFILES);
            }
            if (this.cbBatchToolsTrntChkDetectArchivedFolder.isSelected()) {
                opts.add(TorrentChecker.Options.DETECTARCHIVEDFOLDERS);
            }
            try {
                Thread thread = new Thread((Runnable)((Object)this.buildTorrentTask((List<SrcDstResult>)sdrl, mode, updater, opts)));
                thread.setDaemon(true);
                thread.start();
            }
            catch (IOException | URISyntaxException ex) {
                Log.err((String)ex.getMessage(), (Throwable)ex);
                Dialogs.showError(ex);
            }
        } else {
            Dialogs.showAlert(Messages.getString((String)"MainFrame.AtLeastOneSrcDir"));
        }
    }

    private ProgressTask<DirUpdater> buildDir2DatTask(final List<SrcDstResult> sdrl, final ResultColUpdater updater) throws IOException, URISyntaxException {
        return new ProgressTask<DirUpdater>((Stage)this.tvBatchToolsDat2DirDst.getScene().getWindow()){

            protected DirUpdater call() throws Exception {
                List<File> srclist = BatchToolsPanelController.this.tvBatchToolsDat2DirSrc.getItems().stream().map(f -> PathAbstractor.getAbsolutePath((Session)BatchToolsPanelController.this.session, (String)f.toString()).toFile()).toList();
                return new DirUpdater(BatchToolsPanelController.this.session, sdrl, (ProgressHandler)this, srclist, updater, BatchToolsPanelController.this.cbBatchToolsDat2DirDryRun.isSelected());
            }

            public void succeeded() {
                this.close();
                BatchToolsPanelController.this.saveDat2DirDst();
                BatchToolsPanelController.this.session.setCurrProfile(null);
                BatchToolsPanelController.this.session.setCurrScan(null);
                BatchToolsPanelController.this.session.getReport().setProfile(BatchToolsPanelController.this.session.getCurrProfile());
                if (MainFrame.getProfileViewer() != null) {
                    MainFrame.getProfileViewer().hide();
                    MainFrame.setProfileViewer(null);
                }
                if (MainFrame.getReportFrame() != null) {
                    MainFrame.getReportFrame().hide();
                }
                ((Tab)MainFrame.getController().getTabPane().getTabs().get(1)).setDisable(true);
            }

            protected void failed() {
                this.close();
                if (this.getException() instanceof BreakException || this.isCancelled()) {
                    Dialogs.showAlert("Cancelled");
                } else {
                    Optional.ofNullable(this.getException().getCause()).ifPresentOrElse(cause -> {
                        Log.err((String)cause.getMessage(), (Throwable)cause);
                        Dialogs.showError(cause);
                    }, () -> {
                        Log.err((String)this.getException().getMessage(), (Throwable)this.getException());
                        Dialogs.showError(this.getException());
                    });
                }
            }
        };
    }

    private ProgressTask<TorrentChecker<SrcDstResult>> buildTorrentTask(final List<SrcDstResult> sdrl, final TrntChkMode mode, final ResultColUpdater updater, final EnumSet<TorrentChecker.Options> opts) throws IOException, URISyntaxException {
        return new ProgressTask<TorrentChecker<SrcDstResult>>((Stage)this.tvBatchToolsDat2DirDst.getScene().getWindow()){

            protected TorrentChecker<SrcDstResult> call() throws Exception {
                return new TorrentChecker(BatchToolsPanelController.this.session, (ProgressHandler)this, sdrl, mode, updater, (Set)opts);
            }

            public void succeeded() {
                this.close();
            }

            protected void failed() {
                this.close();
                if (this.getException() instanceof BreakException || this.isCancelled()) {
                    Dialogs.showAlert("Cancelled");
                } else {
                    Optional.ofNullable(this.getException().getCause()).ifPresentOrElse(cause -> {
                        Log.err((String)cause.getMessage(), (Throwable)cause);
                        Dialogs.showError(cause);
                    }, () -> {
                        Log.err((String)this.getException().getMessage(), (Throwable)this.getException());
                        Dialogs.showError(this.getException());
                    });
                }
            }
        };
    }

    private void saveDat2DirDst() {
        this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dat2dir_sdr, AbstractSrcDstResult.toJSON((List)this.tvBatchToolsDat2DirDst.getItems()));
    }

    private void saveTorrentDst() {
        this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.trntchk_sdr, AbstractSrcDstResult.toJSON((List)this.tvBatchToolsTorrent.getItems()));
    }

    private void saveDat2DirSrc() {
        this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dat2dir_srcdirs, String.join((CharSequence)"|", this.tvBatchToolsDat2DirSrc.getItems().stream().map(File::getAbsolutePath).toList()));
    }

    @FXML
    void onCustomPresets(ActionEvent e) {
        try {
            if (!this.tvBatchToolsDat2DirDst.getSelectionModel().isEmpty()) {
                new CustomPresets((Stage)this.tvBatchToolsDat2DirDst.getScene().getWindow());
            }
        }
        catch (IOException | URISyntaxException e1) {
            e1.printStackTrace();
        }
    }

    @FXML
    void onDelDat2DirDst(ActionEvent e) {
        this.tvBatchToolsDat2DirDst.getItems().removeAll((Collection)this.tvBatchToolsDat2DirDst.getSelectionModel().getSelectedItems());
        this.saveDat2DirDst();
    }

    @FXML
    void onAddDat2DirDstDat(ActionEvent e) {
        File lastdstdatdir = Optional.ofNullable(this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_lastdstdatdir)).map(File::new).filter(File::exists).filter(File::isDirectory).orElse(null);
        this.chooseOpenFileMulti((Control)this.tvBatchToolsDat2DirDst, null, lastdstdatdir, (Collection<FileChooser.ExtensionFilter>)Arrays.asList(new FileChooser.ExtensionFilter("DAT files", new String[]{"*.dat", "*.xml"})), paths -> DropCell.process(this.tvBatchToolsDat2DirDst, this.tvBatchToolsDat2DirDst.getSelectionModel().getSelectedIndex(), paths.stream().map(Path::toFile).toList(), (sdrlist, files) -> {
            for (int i = 0; i < files.size(); ++i) {
                ((SrcDstResult)((Object)((Object)((Object)sdrlist.get(i))))).setSrc(PathAbstractor.getRelativePath((Session)this.session, (Path)((File)files.get(i)).toPath()).toString());
            }
            this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dat2dir_lastdstdatdir, (String)files.stream().map(File::getParent).findFirst().orElse(null));
            this.saveDat2DirDst();
        }));
    }

    @FXML
    void onAddDat2DirDstDatDir(ActionEvent e) {
        File lastdstdatdir = Optional.ofNullable(this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_lastdstdatdir)).map(File::new).filter(File::exists).filter(File::isDirectory).orElse(null);
        this.chooseDir((Control)this.tvBatchToolsDat2DirDst, null, lastdstdatdir, path -> DropCell.process(this.tvBatchToolsDat2DirDst, this.tvBatchToolsDat2DirDst.getSelectionModel().getSelectedIndex(), Arrays.asList(path.toFile()), (sdrlist, files) -> {
            for (int i = 0; i < files.size(); ++i) {
                ((SrcDstResult)((Object)((Object)((Object)sdrlist.get(i))))).setSrc(PathAbstractor.getRelativePath((Session)this.session, (Path)((File)files.get(i)).toPath()).toString());
            }
            this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dat2dir_lastdstdatdir, (String)files.stream().map(File::getParent).findFirst().orElse(null));
            this.saveDat2DirDst();
        }));
    }

    @FXML
    void onAddDat2DirDstDir(ActionEvent e) {
        File lastdstdir = Optional.ofNullable(this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dat2dir_lastdstdir)).map(File::new).filter(File::exists).filter(File::isDirectory).orElse(null);
        this.chooseDir((Control)this.tvBatchToolsDat2DirDst, null, lastdstdir, path -> DropCell.process(this.tvBatchToolsDat2DirDst, this.tvBatchToolsDat2DirDst.getSelectionModel().getSelectedIndex(), Arrays.asList(path.toFile()), (sdrlist, files) -> {
            for (int i = 0; i < files.size(); ++i) {
                ((SrcDstResult)((Object)((Object)((Object)sdrlist.get(i))))).setDst(PathAbstractor.getRelativePath((Session)this.session, (Path)((File)files.get(i)).toPath()).toString());
            }
            this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dat2dir_lastdstdir, (String)files.stream().map(File::getParent).findFirst().orElse(null));
            this.saveDat2DirDst();
        }));
    }

    @FXML
    void onTZIPPresets(ActionEvent e) {
        for (AbstractSrcDstResult sdr : this.tvBatchToolsDat2DirDst.getSelectionModel().getSelectedItems()) {
            ProfileSettings.TZIP((Session)this.session, (File)PathAbstractor.getAbsolutePath((Session)this.session, (String)sdr.getSrc()).toFile());
        }
    }

    @FXML
    void onDIRPresets(ActionEvent e) {
        for (AbstractSrcDstResult sdr : this.tvBatchToolsDat2DirDst.getSelectionModel().getSelectedItems()) {
            ProfileSettings.DIR((Session)this.session, (File)PathAbstractor.getAbsolutePath((Session)this.session, (String)sdr.getSrc()).toFile());
        }
    }

    @FXML
    void onAddTorrent(ActionEvent e) {
        File lasttrntdir = Optional.ofNullable(this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_lasttrntdir)).map(File::new).filter(File::exists).filter(File::isDirectory).orElse(null);
        this.chooseOpenFileMulti((Control)this.tvBatchToolsTorrent, null, lasttrntdir, (Collection<FileChooser.ExtensionFilter>)Arrays.asList(new FileChooser.ExtensionFilter("Torrent files", new String[]{"*.torrent"})), paths -> DropCell.process(this.tvBatchToolsTorrent, this.tvBatchToolsTorrent.getSelectionModel().getSelectedIndex(), paths.stream().map(Path::toFile).toList(), (sdrlist, files) -> {
            for (int i = 0; i < files.size(); ++i) {
                ((SrcDstResult)((Object)((Object)((Object)sdrlist.get(i))))).setSrc(PathAbstractor.getRelativePath((Session)this.session, (Path)((File)files.get(i)).toPath()).toString());
            }
            this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.trntchk_lasttrntdir, (String)files.stream().map(File::getParent).findFirst().orElse(null));
            this.saveTorrentDst();
        }));
    }

    @FXML
    void onAddTorrentDstDir(ActionEvent e) {
        File lastdstdir = Optional.ofNullable(this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.trntchk_lastdstdir)).map(File::new).filter(File::exists).filter(File::isDirectory).orElse(null);
        this.chooseDir((Control)this.tvBatchToolsTorrent, null, lastdstdir, path -> DropCell.process(this.tvBatchToolsTorrent, this.tvBatchToolsTorrent.getSelectionModel().getSelectedIndex(), Arrays.asList(path.toFile()), (sdrlist, files) -> {
            for (int i = 0; i < files.size(); ++i) {
                ((SrcDstResult)((Object)((Object)((Object)sdrlist.get(i))))).setDst(PathAbstractor.getRelativePath((Session)this.session, (Path)((File)files.get(i)).toPath()).toString());
            }
            this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.trntchk_lastdstdir, (String)files.stream().map(File::getParent).findFirst().orElse(null));
            this.saveTorrentDst();
        }));
    }

    @FXML
    void onDelTorrent(ActionEvent e) {
        this.tvBatchToolsTorrent.getItems().removeAll((Collection)this.tvBatchToolsTorrent.getSelectionModel().getSelectedItems());
        this.saveTorrentDst();
    }

    @FXML
    void onAddArchive(ActionEvent e) {
        File lastdir = Optional.ofNullable(this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.compressor_lastdir)).map(File::new).filter(File::exists).filter(File::isDirectory).orElse(null);
        this.chooseOpenFileMulti((Control)this.tvBatchToolsCompressor, null, lastdir, (Collection<FileChooser.ExtensionFilter>)Arrays.asList(new FileChooser.ExtensionFilter("Archive files", new String[]{"*.zip", "*.7z", "*.rar", "*.arj", "*.tar", "*.lzh", "*.lha", "*.tgz", "*.tbz", "*.tbz2", "*.rpm", "*.iso", "*.deb", "*.cab"})), paths -> {
            paths.stream().map(FileResult::new).forEachOrdered(arg_0 -> this.tvBatchToolsCompressor.getItems().add(arg_0));
            this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.compressor_lastdir, (String)paths.stream().map(Path::toFile).map(File::getParent).findFirst().orElse(null));
        });
    }

    @FXML
    void onDelArchive(ActionEvent e) {
        this.tvBatchToolsCompressor.getItems().removeAll((Collection)this.tvBatchToolsCompressor.getSelectionModel().getSelectedItems());
    }

    public class CustomPresets
    extends Stage {
        ScannerPanelSettingsController controller;

        public CustomPresets(Stage parent) throws IOException, URISyntaxException {
            this.initOwner((Window)parent);
            this.initModality(Modality.WINDOW_MODAL);
            this.getIcons().add((Object)((Image)parent.getIcons().get(0)));
            this.setOnShowing(e -> {});
            this.setOnCloseRequest(e -> this.hide());
            FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("ScannerPanelSettings.fxml").toURI().toURL(), Messages.getBundle());
            ScrollPane settings = (ScrollPane)loader.load();
            this.controller = (ScannerPanelSettingsController)loader.getController();
            BorderPane root = new BorderPane((Node)settings);
            Button cancel = new Button("Cancel");
            cancel.setOnAction(e -> this.close());
            Button ok = new Button("OK");
            ok.setOnAction(e -> this.save());
            HBox bar = new HBox(new Node[]{cancel, ok});
            bar.setPadding(new Insets(5.0));
            bar.setSpacing(5.0);
            bar.setAlignment(Pos.CENTER_RIGHT);
            root.setBottom((Node)bar);
            this.setScene(new Scene((Parent)root, 600.0, 400.0));
            this.sizeToScene();
            AbstractSrcDstResult entry = (AbstractSrcDstResult)BatchToolsPanelController.this.tvBatchToolsDat2DirDst.getSelectionModel().getSelectedItems().get(0);
            this.controller.initProfileSettings(BatchToolsPanelController.this.session.getUser().getSettings().loadProfileSettings(PathAbstractor.getAbsolutePath((Session)BatchToolsPanelController.this.session, (String)entry.getSrc()).toFile(), null));
            this.show();
        }

        private void save() {
            for (AbstractSrcDstResult sdr : BatchToolsPanelController.this.tvBatchToolsDat2DirDst.getSelectionModel().getSelectedItems()) {
                BatchToolsPanelController.this.session.getUser().getSettings().saveProfileSettings(PathAbstractor.getAbsolutePath((Session)BatchToolsPanelController.this.session, (String)sdr.getSrc()).toFile(), this.controller.getSettings());
            }
            this.close();
        }
    }
}

