/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui;

import java.net.URL;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.text.Font;
import jrm.batch.TrntChkReport;
import jrm.fx.ui.MainFrame;
import jrm.profile.report.FilterOptions;
import lombok.Generated;

public class BatchTorrentResultsController
implements Initializable {
    @FXML
    private TreeView<TrntChkReport.Child> treeview;
    @FXML
    private ContextMenu menu;
    @FXML
    private MenuItem openAllNodes;
    @FXML
    private MenuItem closeAllNodes;
    @FXML
    private CheckMenuItem showok;
    @FXML
    private CheckMenuItem hidemissing;
    private Font font = new Font(10.0);
    private static final EnumSet<FilterOptions> filterOptions = EnumSet.noneOf(FilterOptions.class);
    private TrntChkReport report;

    public void initialize(URL location, ResourceBundle resources) {
        this.treeview.setCellFactory(param -> new TreeCell<TrntChkReport.Child>(){

            protected void updateItem(TrntChkReport.Child item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.setFont(BatchTorrentResultsController.this.font);
                if (empty) {
                    this.setText("");
                } else {
                    StringBuilder str = new StringBuilder(item.getData().getTitle());
                    Optional.ofNullable(item.getData().getLength()).ifPresent(l -> str.append(" (" + l + ")"));
                    Optional.ofNullable(item.getData().getStatus()).ifPresent(s -> str.append(" [" + String.valueOf(s) + "]"));
                    this.setText(str.toString());
                    Image icon = !this.getTreeItem().isLeaf() ? MainFrame.getIcon("/jrm/resicons/folder" + (this.getTreeItem().isExpanded() ? "_open" : "_closed") + BatchTorrentResultsController.this.statusColor(item.getData().getStatus()) + ".png") : MainFrame.getIcon("/jrm/resicons/icons/bullet" + BatchTorrentResultsController.this.statusColor(item.getData().getStatus()) + ".png");
                    this.setGraphic((Node)new ImageView(icon));
                }
            }
        });
    }

    protected String statusColor(TrntChkReport.Status status) {
        switch (status) {
            case OK: {
                return "_green";
            }
            case MISSING: {
                return "_red";
            }
            case SHA1: {
                return "_purple";
            }
            case SIZE: {
                return "_blue";
            }
            case SKIPPED: {
                return "_orange";
            }
            case UNKNOWN: {
                return "_gray";
            }
        }
        return "";
    }

    @FXML
    private void onOK(ActionEvent e) {
        this.treeview.getScene().getWindow().hide();
    }

    public void setResult(TrntChkReport report) {
        this.report = report;
        this.build();
    }

    private void build() {
        this.treeview.setRoot(this.buildTree(null, this.report.filter(filterOptions)));
    }

    private TreeItem<TrntChkReport.Child> buildTree(TreeItem<TrntChkReport.Child> parent, List<TrntChkReport.Child> children) {
        TreeItem p;
        TreeItem treeItem = p = parent == null ? new TreeItem() : parent;
        if (children != null) {
            for (TrntChkReport.Child c : children) {
                p.getChildren().add(this.buildTree((TreeItem<TrntChkReport.Child>)new TreeItem((Object)c), c.getChildren()));
            }
        }
        return p;
    }

    @FXML
    private void showok(ActionEvent e) {
        if (this.showok.isSelected()) {
            filterOptions.add(FilterOptions.SHOWOK);
        } else {
            filterOptions.remove(FilterOptions.SHOWOK);
        }
        this.build();
    }

    @FXML
    private void hidemissing(ActionEvent e) {
        if (this.hidemissing.isSelected()) {
            filterOptions.add(FilterOptions.HIDEMISSING);
        } else {
            filterOptions.remove(FilterOptions.HIDEMISSING);
        }
        this.build();
    }

    @FXML
    private void openAllNodes(ActionEvent e) {
        TreeItem root = this.treeview.getRoot();
        this.treeview.setRoot(null);
        for (TreeItem child : root.getChildren()) {
            if (child.isLeaf()) continue;
            child.setExpanded(true);
        }
        this.treeview.setRoot(root);
    }

    @FXML
    private void closeAllNodes(ActionEvent e) {
        TreeItem root = this.treeview.getRoot();
        this.treeview.setRoot(null);
        for (TreeItem child : root.getChildren()) {
            if (child.isLeaf()) continue;
            child.setExpanded(false);
        }
        this.treeview.setRoot(root);
    }

    @Generated
    public TreeView<TrntChkReport.Child> getTreeview() {
        return this.treeview;
    }
}

