/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.ImageView;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import jrm.aui.progress.ProgressHandler;
import jrm.fx.ui.BaseController;
import jrm.fx.ui.MainFrame;
import jrm.fx.ui.controls.Dialogs;
import jrm.fx.ui.misc.DragNDrop;
import jrm.fx.ui.progress.ProgressTask;
import jrm.misc.BreakException;
import jrm.misc.EnumWithDefault;
import jrm.misc.Log;
import jrm.misc.SettingsEnum;
import jrm.profile.manager.Export;
import jrm.profile.scan.Dir2Dat;
import jrm.profile.scan.DirScan;
import jrm.security.Session;

public class Dir2DatController
extends BaseController {
    @FXML
    CheckBox includeEmptyDirs;
    @FXML
    CheckBox matchCurrentProfile;
    @FXML
    CheckBox doNotScan;
    @FXML
    CheckBox junkSubfolders;
    @FXML
    CheckBox addShamd;
    @FXML
    CheckBox addMd;
    @FXML
    CheckBox deepScanFor;
    @FXML
    CheckBox scanSubfolders;
    @FXML
    TextField name;
    @FXML
    TextField description;
    @FXML
    TextField version;
    @FXML
    TextField author;
    @FXML
    TextField comment;
    @FXML
    TextField category;
    @FXML
    TextField date;
    @FXML
    TextField email;
    @FXML
    TextField homepage;
    @FXML
    TextField url;
    @FXML
    TextField srcDir;
    @FXML
    TextField dstDat;
    @FXML
    Button srcDirBtn;
    @FXML
    Button dstDatBtn;
    @FXML
    Button generate;
    @FXML
    ToggleGroup format;
    @FXML
    RadioButton formatMame;
    @FXML
    RadioButton formatLogiqxDat;
    @FXML
    RadioButton formatSWList;

    public void initialize(URL location, ResourceBundle resources) {
        this.scanSubfolders.setSelected(((Boolean)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_scan_subfolders, Boolean.class)).booleanValue());
        this.scanSubfolders.selectedProperty().addListener((observable, oldValue, newValue) -> this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_scan_subfolders, newValue.booleanValue()));
        this.deepScanFor.setSelected(((Boolean)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_deep_scan, Boolean.class)).booleanValue());
        this.deepScanFor.selectedProperty().addListener((observable, oldValue, newValue) -> this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_deep_scan, newValue.booleanValue()));
        this.addMd.setSelected(((Boolean)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_add_md5, Boolean.class)).booleanValue());
        this.addMd.selectedProperty().addListener((observable, oldValue, newValue) -> this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_add_md5, newValue.booleanValue()));
        this.addShamd.setSelected(((Boolean)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_add_sha1, Boolean.class)).booleanValue());
        this.addShamd.selectedProperty().addListener((observable, oldValue, newValue) -> this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_add_sha1, newValue.booleanValue()));
        this.junkSubfolders.setSelected(((Boolean)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_junk_folders, Boolean.class)).booleanValue());
        this.junkSubfolders.selectedProperty().addListener((observable, oldValue, newValue) -> this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_junk_folders, newValue.booleanValue()));
        this.doNotScan.setSelected(((Boolean)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_do_not_scan_archives, Boolean.class)).booleanValue());
        this.doNotScan.selectedProperty().addListener((observable, oldValue, newValue) -> this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_do_not_scan_archives, newValue.booleanValue()));
        this.matchCurrentProfile.setSelected(((Boolean)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_match_profile, Boolean.class)).booleanValue());
        this.matchCurrentProfile.selectedProperty().addListener((observable, oldValue, newValue) -> this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_match_profile, newValue.booleanValue()));
        this.includeEmptyDirs.setSelected(((Boolean)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_include_empty_dirs, Boolean.class)).booleanValue());
        this.includeEmptyDirs.selectedProperty().addListener((observable, oldValue, newValue) -> this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_include_empty_dirs, newValue.booleanValue()));
        new DragNDrop((Control)this.srcDir).addDir(txt -> this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_src_dir, txt));
        this.srcDir.setText(this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_src_dir));
        this.srcDirBtn.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/disk.png")));
        this.srcDirBtn.setOnAction(e -> {
            Path workdir = this.session.getUser().getSettings().getWorkPath();
            File lastsrcdir = Optional.ofNullable(this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_lastsrcdir)).map(File::new).filter(File::exists).orElse(workdir.toFile());
            this.chooseDir((Control)this.srcDirBtn, this.srcDir.getText(), lastsrcdir, path -> {
                this.session.getUser().getSettings().setProperty("MainFrame.ChooseDatSrc", path.toString());
                this.srcDir.setText(path.toString());
                this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_src_dir, this.srcDir.getText());
                this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_lastsrcdir, (String)Optional.ofNullable(path).map(Path::toFile).map(File::getParent).orElse(null));
            });
        });
        new DragNDrop((Control)this.dstDat).addNewFile(txt -> this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_dst_file, txt));
        this.dstDat.setText(this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_dst_file));
        this.dstDatBtn.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/disk.png")));
        this.dstDatBtn.setOnAction(e -> {
            Path workdir = this.session.getUser().getSettings().getWorkPath();
            File lastdstdir = Optional.ofNullable(this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_lastdstdir)).map(File::new).filter(File::exists).orElse(workdir.toFile());
            this.chooseSaveFile((Control)this.dstDatBtn, this.dstDat.getText(), lastdstdir, Collections.singletonList(new FileChooser.ExtensionFilter("Dat file", new String[]{"*.xml", "*.dat"})), path -> {
                this.session.getUser().getSettings().setProperty("MainFrame.ChooseDatDst", path.toString());
                this.dstDat.setText(path.toString());
                this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_dst_file, this.dstDat.getText());
                this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_lastdstdir, (String)Optional.ofNullable(path).map(Path::toFile).map(File::getParent).orElse(null));
            });
        });
        this.format.selectToggle((Toggle)(switch (Export.ExportType.valueOf((String)this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_format))) {
            case Export.ExportType.MAME -> this.formatMame;
            case Export.ExportType.DATAFILE -> this.formatLogiqxDat;
            case Export.ExportType.SOFTWARELIST -> this.formatSWList;
            default -> this.formatMame;
        }));
        this.format.selectedToggleProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == this.formatMame) {
                this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_format, Export.ExportType.MAME.toString());
            } else if (newValue == this.formatLogiqxDat) {
                this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_format, Export.ExportType.DATAFILE.toString());
            } else if (newValue == this.formatSWList) {
                this.session.getUser().getSettings().setProperty((Enum)SettingsEnum.dir2dat_format, Export.ExportType.SOFTWARELIST.toString());
            }
        });
        this.generate.setOnAction(e -> this.dir2dat());
    }

    private void dir2dat() {
        try {
            Thread thread = new Thread((Runnable)((Object)this.dir2DatTask()));
            thread.setDaemon(true);
            thread.start();
        }
        catch (IOException | URISyntaxException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            Dialogs.showError(e);
        }
    }

    private ProgressTask<Void> dir2DatTask() throws IOException, URISyntaxException {
        return new ProgressTask<Void>((Stage)this.dstDat.getScene().getWindow()){

            protected Void call() throws Exception {
                File dstdat;
                File srcdir;
                String src = Dir2DatController.this.srcDir.getText();
                String dst = Dir2DatController.this.dstDat.getText();
                if (src != null && src.length() > 0 && dst != null && dst.length() > 0 && (srcdir = new File(src)).isDirectory() && (dstdat = new File(dst)).getParentFile().isDirectory() && (dstdat.exists() || dstdat.createNewFile())) {
                    EnumSet<DirScan.Options> options = Dir2DatController.this.initOptions(Dir2DatController.this.session);
                    Export.ExportType type = Export.ExportType.valueOf((String)Dir2DatController.this.session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_format));
                    HashMap<String, String> headers = Dir2DatController.this.initHeaders();
                    new Dir2Dat(Dir2DatController.this.session, srcdir, dstdat, (ProgressHandler)this, options, type, headers);
                }
                return null;
            }

            public void succeeded() {
                this.close();
            }

            protected void failed() {
                if (this.getException() instanceof BreakException) {
                    Dialogs.showAlert("Cancelled");
                } else {
                    this.close();
                    Optional.ofNullable(this.getException().getCause()).ifPresentOrElse(cause -> {
                        Log.err((String)cause.getMessage(), (Throwable)cause);
                        Dialogs.showError(cause);
                    }, () -> {
                        Log.err((String)this.getException().getMessage(), (Throwable)this.getException());
                        Dialogs.showError(this.getException());
                    });
                }
            }
        };
    }

    private EnumSet<DirScan.Options> initOptions(Session session) {
        EnumSet<DirScan.Options> options = EnumSet.of(DirScan.Options.USE_PARALLELISM, DirScan.Options.MD5_DISKS, DirScan.Options.SHA1_DISKS);
        if (Boolean.TRUE.equals(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_scan_subfolders, Boolean.class))) {
            options.add(DirScan.Options.RECURSE);
        }
        if (Boolean.FALSE.equals(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_deep_scan, Boolean.class))) {
            options.add(DirScan.Options.IS_DEST);
        }
        if (Boolean.TRUE.equals(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_add_md5, Boolean.class))) {
            options.add(DirScan.Options.NEED_MD5);
        }
        if (Boolean.TRUE.equals(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_add_sha1, Boolean.class))) {
            options.add(DirScan.Options.NEED_SHA1);
        }
        if (Boolean.TRUE.equals(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_junk_folders, Boolean.class))) {
            options.add(DirScan.Options.JUNK_SUBFOLDERS);
        }
        if (Boolean.TRUE.equals(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_do_not_scan_archives, Boolean.class))) {
            options.add(DirScan.Options.ARCHIVES_AND_CHD_AS_ROMS);
        }
        if (Boolean.TRUE.equals(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_match_profile, Boolean.class))) {
            options.add(DirScan.Options.MATCH_PROFILE);
        }
        if (Boolean.TRUE.equals(session.getUser().getSettings().getProperty((EnumWithDefault)SettingsEnum.dir2dat_include_empty_dirs, Boolean.class))) {
            options.add(DirScan.Options.EMPTY_DIRS);
        }
        return options;
    }

    private HashMap<String, String> initHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("name", this.name.getText());
        headers.put("description", this.description.getText());
        headers.put("version", this.version.getText());
        headers.put("author", this.author.getText());
        headers.put("comment", this.comment.getText());
        headers.put("category", this.category.getText());
        headers.put("date", this.date.getText());
        headers.put("email", this.email.getText());
        headers.put("homepage", this.homepage.getText());
        headers.put("url", this.url.getText());
        return headers;
    }
}

