/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.value.ObservableValueBase;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.TextFieldTreeCell;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.util.StringConverter;
import jrm.aui.progress.ProgressHandler;
import jrm.fx.ui.MainFrame;
import jrm.fx.ui.ProfileLoader;
import jrm.fx.ui.controls.DateCellFactory;
import jrm.fx.ui.controls.Dialogs;
import jrm.fx.ui.controls.ProfileCellFactory;
import jrm.fx.ui.controls.VersionCellFactory;
import jrm.fx.ui.misc.DragNDrop;
import jrm.fx.ui.profile.manager.DirItem;
import jrm.fx.ui.profile.manager.HaveNTotalCellFactory;
import jrm.fx.ui.progress.ProgressTask;
import jrm.locale.Messages;
import jrm.misc.BreakException;
import jrm.misc.Log;
import jrm.profile.manager.Dir;
import jrm.profile.manager.Import;
import jrm.profile.manager.ProfileNFO;
import jrm.profile.manager.ProfileNFOMame;
import jrm.profile.manager.ProfileNFOStats;
import jrm.security.Session;
import jrm.security.Sessions;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;

public class ProfilePanelController
implements Initializable {
    @FXML
    Button btnLoad;
    @FXML
    Button btnImportDat;
    @FXML
    Button btnImportSL;
    @FXML
    TreeView<Dir> profilesTree;
    @FXML
    TableView<ProfileNFO> profilesList;
    @FXML
    TableColumn<ProfileNFO, ProfileNFO> profileCol;
    @FXML
    TableColumn<ProfileNFO, String> profileVersionCol;
    @FXML
    TableColumn<ProfileNFO, ProfileNFOStats.HaveNTotal> profileHaveSetsCol;
    @FXML
    TableColumn<ProfileNFO, ProfileNFOStats.HaveNTotal> profileHaveRomsCol;
    @FXML
    TableColumn<ProfileNFO, ProfileNFOStats.HaveNTotal> profileHaveDisksCol;
    @FXML
    TableColumn<ProfileNFO, Date> profileCreatedCol;
    @FXML
    TableColumn<ProfileNFO, Date> profileLastScanCol;
    @FXML
    TableColumn<ProfileNFO, Date> profileLastFixCol;
    @FXML
    MenuItem createFolderMenu;
    @FXML
    MenuItem deleteFolderMenu;
    @FXML
    MenuItem deleteProfileMenu;
    @FXML
    MenuItem renameProfileMenu;
    @FXML
    MenuItem dropCacheMenu;
    @FXML
    MenuItem updateFromMameMenu;
    @FXML
    ContextMenu folderMenu;
    @FXML
    ContextMenu profileMenu;
    final Session session = Sessions.getSingleSession();
    private ProfileLoader profileLoader;
    private static Comparator<Long> nullSafeLongComparator = Comparator.nullsFirst(Long::compareTo);
    private static Comparator<ProfileNFOStats.HaveNTotal> haveNTotalComparator = Comparator.comparing(ProfileNFOStats.HaveNTotal::getHave, nullSafeLongComparator).thenComparing(ProfileNFOStats.HaveNTotal::getHave, nullSafeLongComparator);

    public void initialize(URL location, ResourceBundle resources) {
        this.btnLoad.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/add.png")));
        this.btnImportDat.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/script_go.png")));
        this.btnImportSL.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/application_go.png")));
        this.createFolderMenu.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/folder_add.png")));
        this.deleteFolderMenu.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/folder_delete.png")));
        this.deleteProfileMenu.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/script_delete.png")));
        this.renameProfileMenu.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/script_edit.png")));
        this.dropCacheMenu.setGraphic((Node)new ImageView(MainFrame.getIcon("/jrm/resicons/icons/bin.png")));
        this.folderMenu.setOnShowing(e -> {
            TreeItem selected = (TreeItem)this.profilesTree.getSelectionModel().getSelectedItem();
            this.deleteFolderMenu.setDisable(selected == null);
            this.createFolderMenu.setDisable(selected == null);
        });
        this.profileMenu.setOnShowing(e -> {
            ProfileNFO selected = (ProfileNFO)this.profilesList.getSelectionModel().getSelectedItem();
            this.deleteProfileMenu.setDisable(selected == null);
            this.renameProfileMenu.setDisable(selected == null);
            this.dropCacheMenu.setDisable(selected == null);
            this.updateFromMameMenu.setDisable(selected == null || !selected.isJRM());
        });
        this.profilesTree.setCellFactory(p -> new TextFieldTreeCell((StringConverter)new StringConverter<Dir>(this){
            private Dir dir;

            public String toString(Dir dir) {
                this.dir = dir;
                return dir.toString();
            }

            public Dir fromString(String string) {
                return this.dir.renameTo(this.dir.getFile().toPath().getParent().resolve(string).toFile());
            }
        }));
        this.profilesTree.setOnEditCommit(this::editCommitProfileDir);
        this.profilesTree.setRoot((TreeItem)new DirItem(this.session.getUser().getSettings().getWorkPath().resolve("xmlfiles").toAbsolutePath().normalize().toFile()));
        this.profilesTree.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.populate((TreeItem<Dir>)newValue));
        this.profilesTree.getSelectionModel().select(0);
        this.profileCol.setEditable(true);
        this.profileCol.setCellFactory(param -> new ProfileCellFactory());
        this.profileCol.setOnEditCommit(this::editCommitProfile);
        this.profileCol.setCellValueFactory(param -> new ObservableValueBase<ProfileNFO>(this){

            public ProfileNFO getValue() {
                return (ProfileNFO)param.getValue();
            }
        });
        this.profileVersionCol.setCellFactory(param -> new VersionCellFactory());
        this.profileVersionCol.setCellValueFactory(param -> new ObservableValueBase<String>(this){

            public String getValue() {
                return ((ProfileNFO)param.getValue()).getStats().getVersion();
            }
        });
        this.profileHaveSetsCol.setCellFactory(param -> new HaveNTotalCellFactory());
        this.profileHaveSetsCol.setCellValueFactory(param -> new ObservableValueBase<ProfileNFOStats.HaveNTotal>(this){

            public ProfileNFOStats.HaveNTotal getValue() {
                return ((ProfileNFO)param.getValue()).getStats().getSets();
            }
        });
        this.profileHaveSetsCol.setComparator(haveNTotalComparator);
        this.profileHaveRomsCol.setCellFactory(param -> new HaveNTotalCellFactory());
        this.profileHaveRomsCol.setCellValueFactory(param -> new ObservableValueBase<ProfileNFOStats.HaveNTotal>(this){

            public ProfileNFOStats.HaveNTotal getValue() {
                return ((ProfileNFO)param.getValue()).getStats().getRoms();
            }
        });
        this.profileHaveRomsCol.setComparator(haveNTotalComparator);
        this.profileHaveDisksCol.setCellFactory(param -> new HaveNTotalCellFactory());
        this.profileHaveDisksCol.setCellValueFactory(param -> new ObservableValueBase<ProfileNFOStats.HaveNTotal>(this){

            public ProfileNFOStats.HaveNTotal getValue() {
                return ((ProfileNFO)param.getValue()).getStats().getDisks();
            }
        });
        this.profileHaveDisksCol.setComparator(haveNTotalComparator);
        this.profileCreatedCol.setCellFactory(param -> new DateCellFactory());
        this.profileCreatedCol.setCellValueFactory(param -> new ObservableValueBase<Date>(this){

            public Date getValue() {
                return ((ProfileNFO)param.getValue()).getStats().getCreated();
            }
        });
        this.profileLastScanCol.setCellFactory(param -> new DateCellFactory());
        this.profileLastScanCol.setCellValueFactory(param -> new ObservableValueBase<Date>(this){

            public Date getValue() {
                return ((ProfileNFO)param.getValue()).getStats().getScanned();
            }
        });
        this.profileLastFixCol.setCellFactory(param -> new DateCellFactory());
        this.profileLastFixCol.setCellValueFactory(param -> new ObservableValueBase<Date>(this){

            public Date getValue() {
                return ((ProfileNFO)param.getValue()).getStats().getFixed();
            }
        });
        this.profilesList.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.btnLoad.setDisable(newValue == null));
        this.profilesList.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    this.profileLoader.loadProfile(this.session, (ProfileNFO)row.getItem());
                }
            });
            return row;
        });
        this.profilesList.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.profilesList.refresh());
        this.profilesList.setEditable(false);
        this.profilesList.setFixedCellSize(18.0);
        new DragNDrop((Control)this.profilesList).addAny(files -> this.importDat(files, true));
    }

    private void editCommitProfileDir(TreeView.EditEvent<Dir> e) {
        Platform.runLater(() -> {
            TreeItem<Dir> patt0$temp = ProfilePanelController.getTreeViewItem(this.profilesTree.getRoot(), (Dir)e.getNewValue());
            if (patt0$temp instanceof DirItem) {
                DirItem newItem = (DirItem)patt0$temp;
                newItem.reload();
            }
        });
    }

    private void editCommitProfile(TableColumn.CellEditEvent<ProfileNFO, ProfileNFO> e) {
        ProfileNFO pnfo = (ProfileNFO)e.getRowValue();
        AtomicInteger err = new AtomicInteger();
        Arrays.asList("", ".properties", ".cache").forEach(ext -> {
            File newfile;
            File oldfile = new File(pnfo.getFile().getParentFile(), pnfo.getName() + ext);
            boolean success = !oldfile.equals(newfile = new File(pnfo.getFile().getParentFile(), ((ProfileNFO)e.getNewValue()).getNewName() + ext)) && oldfile.renameTo(newfile);
            err.set(err.get() << 1 | (success ? 0 : 1));
            if (!success) {
                Log.warn(() -> "Can't rename " + oldfile.getName() + " to " + newfile.getName());
            }
        });
        if (err.get() != 0) {
            Dialogs.showAlert("Can't rename " + ((ProfileNFO)e.getOldValue()).getName() + " to " + ((ProfileNFO)e.getNewValue()).getNewName());
            e.getTableView().refresh();
        } else {
            File newNfoFile = new File(pnfo.getFile().getParentFile(), ((ProfileNFO)e.getNewValue()).getNewName());
            if (this.session.getCurrProfile() != null && this.session.getCurrProfile().getNfo().getFile().equals(pnfo.getFile())) {
                this.session.getCurrProfile().getNfo().relocate(this.session, newNfoFile);
            }
            pnfo.relocate(this.session, newNfoFile);
        }
    }

    private void populate(TreeItem<Dir> newValue) {
        if (newValue == null) {
            return;
        }
        this.profilesList.setItems(FXCollections.observableArrayList((Collection)ProfileNFO.list((Session)this.session, (File)((Dir)newValue.getValue()).getFile())));
    }

    @FXML
    void actionLoad(ActionEvent e) {
        ProfileNFO profile = (ProfileNFO)this.profilesList.getSelectionModel().getSelectedItem();
        if (profile != null) {
            this.profileLoader.loadProfile(this.session, profile);
        }
    }

    @FXML
    void actionImportDat(ActionEvent e) {
        this.importDat(false);
    }

    @FXML
    void actionImportSL(ActionEvent e) {
        this.importDat(true);
    }

    private void importDat(boolean sl) {
        File workdir = this.session.getUser().getSettings().getWorkPath().toFile();
        FileChooser chooser = new FileChooser();
        FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter(Messages.getString((String)"MainFrame.DatFile"), new String[]{"*.dat", "*.xml"});
        FileChooser.ExtensionFilter filter2 = new FileChooser.ExtensionFilter(Messages.getString((String)"MainFrame.MameExecutable"), new String[]{SystemUtils.IS_OS_WINDOWS ? "*mame*.exe" : "*mame*"});
        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{filter, filter2});
        chooser.setSelectedExtensionFilter(filter);
        Optional.ofNullable(this.session.getUser().getSettings().getProperty("MainFrame.ChooseExeOrDatToImport", workdir.getAbsolutePath())).map(File::new).filter(File::isDirectory).ifPresent(arg_0 -> ((FileChooser)chooser).setInitialDirectory(arg_0));
        List files = chooser.showOpenMultipleDialog(this.profilesList.getScene().getWindow());
        this.importDat(files, sl);
        if (files != null) {
            this.session.getUser().getSettings().setProperty("MainFrame.ChooseExeOrDatToImport", (String)files.stream().filter(File::exists).map(File::getParent).findFirst().orElse(null));
        }
    }

    private void importDat(List<File> files, boolean sl) {
        try {
            if (files == null) {
                return;
            }
            Thread thread = new Thread((Runnable)((Object)new ImportDatTask((Stage)this.profilesList.getScene().getWindow(), files, sl)));
            thread.setDaemon(true);
            thread.start();
        }
        catch (IOException | URISyntaxException e) {
            Log.err((String)e.getMessage(), (Throwable)e);
            Dialogs.showError(e);
        }
    }

    public static <T> TreeItem<T> getTreeViewItem(TreeItem<T> item, T value) {
        if (item != null) {
            if (item.getValue().equals(value)) {
                return item;
            }
            for (TreeItem child : item.getChildren()) {
                TreeItem<T> s = ProfilePanelController.getTreeViewItem(child, value);
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    public void refreshList() {
        this.profilesList.refresh();
    }

    @FXML
    private void createFolder(ActionEvent e) {
        TreeItem selectedItem = (TreeItem)this.profilesTree.getSelectionModel().getSelectedItem();
        if (selectedItem instanceof DirItem) {
            DirItem d = (DirItem)selectedItem;
            Dir newDir = new Dir(new File(((Dir)selectedItem.getValue()).getFile(), Messages.getString((String)"MainFrame.NewFolder")));
            d.reload();
            TreeItem<Dir> newItem = ProfilePanelController.getTreeViewItem(d, newDir);
            this.profilesTree.getSelectionModel().clearSelection();
            this.profilesTree.getSelectionModel().select(newItem);
            this.profilesTree.layout();
            this.profilesTree.edit(newItem);
        }
    }

    @FXML
    private void deleteFolder(ActionEvent e) {
        TreeItem selectedItem = (TreeItem)this.profilesTree.getSelectionModel().getSelectedItem();
        if (selectedItem instanceof DirItem) {
            DirItem d = (DirItem)selectedItem;
            try {
                boolean empty = false;
                try (Stream<Path> entries = Files.list(((Dir)d.getValue()).getFile().toPath());){
                    empty = !entries.findFirst().isPresent();
                }
                boolean doit = empty;
                if (!empty) {
                    doit = Dialogs.showConfirmation("Dir not empty", "This directory is not empty, delete?", ButtonType.YES, ButtonType.NO).map(t -> t == ButtonType.YES).orElse(false);
                }
                if (doit) {
                    FileUtils.deleteDirectory((File)((Dir)d.getValue()).getFile());
                    selectedItem.getParent().getChildren().remove((Object)d);
                }
            }
            catch (IOException ex) {
                Log.err((String)ex.getMessage(), (Throwable)ex);
                Dialogs.showAlert(ex.getMessage());
            }
        }
    }

    @FXML
    private void deleteProfile(ActionEvent e) {
        ProfileNFO nfo = (ProfileNFO)this.profilesList.getSelectionModel().getSelectedItem();
        if (nfo != null && (this.session.getCurrProfile() == null || !this.session.getCurrProfile().getNfo().equals(nfo)) && nfo.delete()) {
            this.profilesList.getItems().remove((Object)nfo);
        }
    }

    @FXML
    private void renameProfile(ActionEvent e) {
        this.profilesList.setEditable(true);
        this.profilesList.edit(this.profilesList.getSelectionModel().getSelectedIndex(), this.profileCol);
        this.profilesList.setEditable(false);
    }

    @FXML
    private void dropCache(ActionEvent e) {
        ProfileNFO nfo = (ProfileNFO)this.profilesList.getSelectionModel().getSelectedItem();
        if (nfo != null) {
            try {
                Files.deleteIfExists(Paths.get(nfo.getFile().getAbsolutePath() + ".cache", new String[0]));
            }
            catch (IOException e1) {
                Log.err((String)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    @FXML
    private void updateFromMame(ActionEvent e) {
        ProfileNFO nfo = (ProfileNFO)this.profilesList.getSelectionModel().getSelectedItem();
        if (nfo != null) {
            try {
                FileChooser chooser = new FileChooser();
                chooser.setTitle(Messages.getString((String)"MainFrame.ChooseMameNewLocation"));
                chooser.setInitialDirectory(nfo.getFile().getParentFile());
                chooser.setInitialFileName(nfo.getFile().getName());
                if (nfo.getMame().getStatus() == ProfileNFOMame.MameStatus.NEEDUPDATE || EnumSet.of(ProfileNFOMame.MameStatus.NOTFOUND, ProfileNFOMame.MameStatus.UNKNOWN).contains(nfo.getMame().getStatus()) && this.updateFromMameRelocate(nfo, chooser.showOpenDialog(this.profilesList.getScene().getWindow())) == ProfileNFOMame.MameStatus.NEEDUPDATE) {
                    Thread thread = new Thread((Runnable)((Object)new UpdateFromMameTask((Stage)this.profilesList.getScene().getWindow(), nfo)));
                    thread.setDaemon(true);
                    thread.start();
                }
            }
            catch (IOException | URISyntaxException ex) {
                Log.err((String)ex.getMessage(), (Throwable)ex);
                Dialogs.showError(ex);
            }
        }
    }

    private ProfileNFOMame.MameStatus updateFromMameRelocate(ProfileNFO nfo, File mame) {
        if (mame.exists()) {
            return nfo.getMame().relocate(mame);
        }
        return ProfileNFOMame.MameStatus.NOTFOUND;
    }

    @Generated
    public void setProfileLoader(ProfileLoader profileLoader) {
        this.profileLoader = profileLoader;
    }

    private final class ImportDatTask
    extends ProgressTask<Void> {
        private final List<File> files;
        private final boolean sl;
        final List<ImportWithBaseFile> imprts;

        private ImportDatTask(Stage owner, List<File> files, boolean sl) throws IOException, URISyntaxException {
            super(owner);
            this.imprts = new ArrayList<ImportWithBaseFile>();
            this.files = files;
            this.sl = sl;
        }

        protected Void call() throws Exception {
            for (File basefile : this.files) {
                for (File file : this.searchDats(basefile)) {
                    this.setProgress(Messages.getString((String)"MainFrame.ImportingFromMame"), -1);
                    this.imprts.add(new ImportWithBaseFile(new Import(ProfilePanelController.this.session, file, this.sl, (ProgressHandler)this), basefile));
                }
            }
            return null;
        }

        protected void succeeded() {
            this.close();
            for (ImportWithBaseFile imprt : this.imprts) {
                try {
                    this.importDat(imprt, this.sl);
                }
                catch (IOException e) {
                    Log.err((String)e.getMessage(), (Throwable)e);
                }
            }
            TreeItem theNode = (TreeItem)ProfilePanelController.this.profilesTree.getSelectionModel().getSelectedItem();
            if (theNode instanceof DirItem) {
                DirItem d = (DirItem)theNode;
                d.reload();
                ProfilePanelController.this.populate(d);
            } else {
                Log.err((Object)Messages.getString((String)"MainFrame.NodeNotFound"));
            }
        }

        protected void failed() {
            if (this.getException() instanceof BreakException) {
                Dialogs.showAlert("Cancelled");
            } else {
                this.close();
                Optional.ofNullable(this.getException().getCause()).ifPresentOrElse(cause -> {
                    Log.err((String)cause.getMessage(), (Throwable)cause);
                    Dialogs.showError(cause);
                }, () -> {
                    Log.err((String)this.getException().getMessage(), (Throwable)this.getException());
                    Dialogs.showError(this.getException());
                });
            }
        }

        private void importDat(ImportWithBaseFile imprt, boolean sl) throws IllegalArgumentException, IOException {
            Path selDir = ((Dir)((TreeItem)ProfilePanelController.this.profilesTree.getSelectionModel().getSelectedItem()).getValue()).getFile().toPath();
            File currDir = selDir.resolve(imprt.basefile.toPath().getParent().relativize(imprt.imprt.getOrgFile().toPath().getParent())).toFile();
            Files.createDirectories(currDir.toPath(), new FileAttribute[0]);
            if (!imprt.imprt.isMame()) {
                AtomicReference<File> fileRef = new AtomicReference<File>(new File(currDir, imprt.imprt.getFile().getName()));
                int mode = this.importDatExistsChoose(fileRef);
                if (mode == 3) {
                    return;
                }
                if (!fileRef.get().exists() || mode == 0) {
                    try {
                        FileUtils.copyFile((File)imprt.imprt.getFile(), (File)fileRef.get());
                    }
                    catch (IOException e) {
                        Log.err((String)e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                VBox layout = new VBox();
                layout.setPrefWidth(300.0);
                Label label = new Label("Choose a name to save JRM file for import of " + String.valueOf(imprt.imprt.getOrgFile()));
                label.setWrapText(true);
                layout.getChildren().add((Object)label);
                TextField nameField = new TextField(imprt.imprt.getFile().getName());
                layout.getChildren().add((Object)nameField);
                Optional<ButtonType> result = Dialogs.showConfirmation("Choose a name to save JRM file", (Node)layout, ButtonType.APPLY);
                String fileName = result.filter(t -> t == ButtonType.APPLY).map(t -> nameField.getText()).filter(t -> !t.isBlank()).map(t -> t.endsWith(".jrm") ? t : t + ".jrm").orElse(imprt.imprt.getFile().getName());
                this.importDat(ProfilePanelController.this.session, sl, imprt.imprt, currDir.toPath().resolve(fileName).toFile());
            }
        }

        private int importDatExistsChoose(AtomicReference<File> file) throws IllegalArgumentException {
            ButtonType filechooser;
            ButtonType autorename;
            ButtonType overwrite;
            ButtonType[] options;
            Optional<ButtonType> ret;
            int mode = -1;
            if (file.get().exists() && (mode = (ret = Dialogs.showConfirmation("File already exists", "File already exists, choose what to do", options = new ButtonType[]{overwrite = new ButtonType("Overwrite"), autorename = new ButtonType("Auto Rename"), filechooser = new ButtonType("File Chooser"), ButtonType.CANCEL})).isEmpty() ? 3 : (ret.get() == overwrite ? 0 : (ret.get() == autorename ? 1 : (ret.get() == filechooser ? 2 : 3)))) == 1) {
                file.set(this.autoRenameFile(file.get()));
            }
            return mode;
        }

        private File autoRenameFile(File file) throws IllegalArgumentException {
            int i = 1;
            File testFile;
            while ((testFile = new File(file.getParentFile(), FilenameUtils.getBaseName((String)file.getName()) + "_" + i + "." + FilenameUtils.getExtension((String)file.getName()))).exists()) {
                ++i;
            }
            return testFile;
        }

        private List<File> searchDats(File file) {
            return this.searchDats(file, new ArrayList<File>());
        }

        private List<File> searchDats(File file, List<File> files) {
            if (file.isFile()) {
                if (FilenameUtils.isExtension((String)file.getName(), (String[])new String[]{"xml", "dat"}) || file.getName().toLowerCase().contains("mame") && (FilenameUtils.isExtension((String)file.getName(), (String)"exe") || file.canExecute())) {
                    files.add(file);
                }
            } else if (file.isDirectory()) {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(file.toPath());){
                    stream.forEach(p -> this.searchDats(p.toFile(), files));
                }
                catch (IOException e) {
                    Log.warn((Object)e.getMessage());
                }
            }
            return files;
        }

        private Void importDat(Session session, boolean sl, Import imprt, File file) {
            try {
                File parent = file.getParentFile();
                FileUtils.copyFile((File)imprt.getFile(), (File)file);
                if (imprt.isMame()) {
                    ProfileNFO pnfo = ProfileNFO.load((Session)session, (File)file);
                    pnfo.getMame().set(imprt.getOrgFile(), sl);
                    if (imprt.getRomsFile() != null) {
                        FileUtils.copyFileToDirectory((File)imprt.getRomsFile(), (File)parent);
                        pnfo.getMame().setFileroms(new File(parent, imprt.getRomsFile().getName()));
                        if (imprt.getSlFile() != null) {
                            FileUtils.copyFileToDirectory((File)imprt.getSlFile(), (File)parent);
                            pnfo.getMame().setFilesl(new File(parent, imprt.getSlFile().getName()));
                        }
                    }
                    pnfo.save(session);
                }
            }
            catch (IOException e) {
                Log.err((String)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    private final class UpdateFromMameTask
    extends ProgressTask<Import> {
        private final ProfileNFO nfo;

        private UpdateFromMameTask(Stage owner, ProfileNFO nfo) throws IOException, URISyntaxException {
            super(owner);
            this.nfo = nfo;
        }

        protected Import call() throws Exception {
            return new Import(ProfilePanelController.this.session, this.nfo.getMame().getFile(), this.nfo.getMame().isSL(), (ProgressHandler)this);
        }

        protected void succeeded() {
            try {
                this.close();
                this.updateFromMame(ProfilePanelController.this.session, this.nfo, (Import)this.get());
            }
            catch (InterruptedException e) {
                Log.err((String)e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (IOException | ExecutionException e) {
                Log.err((String)e.getMessage(), (Throwable)e);
                Dialogs.showError(e);
            }
        }

        protected void failed() {
            if (this.getException() instanceof BreakException) {
                Dialogs.showAlert("Cancelled");
            } else {
                this.close();
                Optional.ofNullable(this.getException().getCause()).ifPresentOrElse(cause -> {
                    Log.err((String)cause.getMessage(), (Throwable)cause);
                    Dialogs.showError(cause);
                }, () -> {
                    Log.err((String)this.getException().getMessage(), (Throwable)this.getException());
                    Dialogs.showError(this.getException());
                });
            }
        }

        private void updateFromMame(Session session, ProfileNFO nfo, Import imprt) throws IOException {
            nfo.getMame().delete();
            nfo.getMame().setFileroms(new File(nfo.getFile().getParentFile(), imprt.getRomsFile().getName()));
            Files.copy(imprt.getRomsFile().toPath(), nfo.getMame().getFileroms().toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            if (nfo.getMame().isSL()) {
                nfo.getMame().setFilesl(new File(nfo.getFile().getParentFile(), imprt.getSlFile().getName()));
                Files.copy(imprt.getSlFile().toPath(), nfo.getMame().getFilesl().toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            }
            nfo.getMame().setUpdated();
            nfo.getStats().reset();
            nfo.save(session);
            ProfilePanelController.this.profilesList.refresh();
        }
    }

    private static final class ImportWithBaseFile {
        Import imprt;
        File basefile;

        @Generated
        public ImportWithBaseFile(Import imprt, File basefile) {
            this.imprt = imprt;
            this.basefile = basefile;
        }
    }
}

