/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui.controls;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import jrm.fx.ui.MainFrame;
import lombok.Generated;

public final class Dialogs {
    private static final String ICO = "/jrm/resicons/rom.png";

    public static void showError(Throwable e) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        ((Stage)alert.getDialogPane().getScene().getWindow()).getIcons().add((Object)MainFrame.getIcon(ICO));
        alert.setTitle("Error");
        alert.setHeaderText(e.getMessage());
        VBox dialogPaneContent = new VBox();
        Label label = new Label("Stack Trace:");
        String stackTrace = Dialogs.getStackTrace(e);
        TextArea textArea = new TextArea();
        textArea.setText(stackTrace);
        dialogPaneContent.getChildren().addAll((Object[])new Node[]{label, textArea});
        alert.getDialogPane().setContent((Node)dialogPaneContent);
        alert.showAndWait();
    }

    public static void showAlert(String message) {
        Alert alert = new Alert(Alert.AlertType.WARNING);
        ((Stage)alert.getDialogPane().getScene().getWindow()).getIcons().add((Object)MainFrame.getIcon(ICO));
        alert.setTitle("Warning");
        alert.setHeaderText(null);
        alert.setContentText(message);
        alert.showAndWait();
    }

    public static Optional<ButtonType> showConfirmation(String title, String message, ButtonType ... buttons) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        ((Stage)alert.getDialogPane().getScene().getWindow()).getIcons().add((Object)MainFrame.getIcon(ICO));
        alert.setTitle(title);
        alert.setHeaderText(null);
        alert.setContentText(message);
        if (buttons != null && buttons.length > 0) {
            alert.getButtonTypes().clear();
            alert.getButtonTypes().addAll((Object[])buttons);
        }
        return alert.showAndWait();
    }

    public static Optional<ButtonType> showConfirmation(String title, Node message, ButtonType ... buttons) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        ((Stage)alert.getDialogPane().getScene().getWindow()).getIcons().add((Object)MainFrame.getIcon(ICO));
        alert.setTitle(title);
        alert.setHeaderText(null);
        alert.getDialogPane().setContent(message);
        if (buttons != null && buttons.length > 0) {
            alert.getButtonTypes().clear();
            alert.getButtonTypes().addAll((Object[])buttons);
        }
        return alert.showAndWait();
    }

    private static String getStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    @Generated
    private Dialogs() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

