/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui.controls;

import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import jrm.fx.ui.status.NeutralToNodeFormatter;

public final class NodeCellFactory<T>
extends TableCell<T, String> {
    protected void updateItem(String item, boolean empty) {
        this.setFont(new Font(10.0));
        this.setGraphic(null);
        this.setStyle("");
        if (empty || item == null) {
            this.setText("");
        } else {
            this.setAlignment(Pos.CENTER);
            this.setGraphic(null);
            this.setStyle("");
            TextFlow tf = new TextFlow();
            tf.getChildren().addAll(NeutralToNodeFormatter.toNodes(item));
            tf.setMinWidth(Double.NEGATIVE_INFINITY);
            tf.setPrefWidth(-1.0);
            tf.setTextAlignment(TextAlignment.LEFT);
            tf.setPrefHeight(10.0);
            this.setGraphic((Node)tf);
        }
    }
}

