/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui.misc;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import jrm.security.PathAbstractor;
import jrm.security.Session;
import jrm.security.Sessions;

public class DragNDrop {
    private final String styleAccept;
    private final String styleReject;
    private Control control;

    public DragNDrop(Control control) {
        if (control instanceof Cell) {
            this.styleAccept = "-fx-background-color: #DDFFDD;";
            this.styleReject = "-fx-background-color: #FFDDDD;";
        } else {
            this.styleAccept = "-fx-control-inner-background: #DDFFDD;";
            this.styleReject = "-fx-control-inner-background: #FFDDDD;";
        }
        this.control = control;
    }

    public void addFile(SetCallBack cb) {
        this.addFiltered((File f) -> Files.isRegularFile(f.toPath(), new LinkOption[0]), cb);
    }

    public void addNewFile(SetCallBack cb) {
        this.addFiltered((File f) -> !Files.exists(f.toPath(), new LinkOption[0]) || Files.isRegularFile(f.toPath(), new LinkOption[0]), cb);
    }

    public void addAny(SetFilesCallBack cb) {
        this.addFiltered((File f) -> true, cb);
    }

    public void addDir(SetCallBack cb) {
        this.addFiltered((File f) -> Files.isDirectory(f.toPath(), new LinkOption[0]), cb);
    }

    public void addDirs(SetFilesCallBack cb) {
        this.addFiltered((File f) -> Files.isDirectory(f.toPath(), new LinkOption[0]), cb);
    }

    public void addFiltered(Predicate<File> filter, SetFilesCallBack cb) {
        this.control.setOnDragOver(event -> {
            Dragboard db;
            if (event.getGestureSource() != this.control && (db = event.getDragboard()).hasFiles() && db.getFiles().stream().filter(f -> !filter.test((File)f)).count() == 0L) {
                event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                this.control.setStyle(this.styleAccept);
                return;
            }
            this.control.setStyle(this.styleReject);
            event.consume();
        });
        this.control.setOnDragExited(event -> this.control.setStyle(""));
        this.control.setOnDragDropped(event -> {
            Dragboard db = event.getDragboard();
            boolean success = false;
            if (db.hasFiles() && db.getFiles().stream().filter(f -> !filter.test((File)f)).count() == 0L) {
                if (this.control instanceof ListView) {
                    ListView lv = (ListView)this.control;
                    LinkedHashSet set = new LinkedHashSet(lv.getItems());
                    for (File f2 : db.getFiles()) {
                        if (set.contains(f2)) continue;
                        lv.getItems().add((Object)f2);
                    }
                    cb.call((List<File>)lv.getItems());
                } else {
                    cb.call(db.getFiles());
                }
                success = true;
            }
            event.setDropCompleted(success);
            event.consume();
        });
    }

    public void addFiltered(Predicate<File> filter, SetCallBack cb) {
        Control control = this.control;
        if (control instanceof TextField) {
            TextField tf = (TextField)control;
            tf.textProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue == null || newValue.isBlank() || tf.isDisabled()) {
                    tf.setStyle(null);
                } else if (filter.test(PathAbstractor.getAbsolutePath((Session)Sessions.getSingleSession(), (String)newValue).toFile())) {
                    tf.setStyle("-fx-text-inner-color: green;");
                    cb.call((String)newValue);
                } else {
                    tf.setStyle("-fx-text-inner-color: red;");
                }
            });
        }
        this.control.setOnDragOver(event -> {
            Dragboard db;
            if (event.getGestureSource() != this.control && (db = event.getDragboard()).hasFiles() && db.getFiles().size() == 1 && filter.test((File)db.getFiles().get(0))) {
                event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                this.control.setStyle(this.styleAccept);
                return;
            }
            this.control.setStyle(this.styleReject);
            event.consume();
        });
        this.control.setOnDragExited(event -> this.control.setStyle(""));
        this.control.setOnDragDropped(event -> {
            Dragboard db = event.getDragboard();
            boolean success = false;
            if (db.hasFiles() && db.getFiles().size() == 1 && filter.test((File)db.getFiles().get(0))) {
                Control patt0$temp = this.control;
                if (patt0$temp instanceof TextInputControl) {
                    TextInputControl tic = (TextInputControl)patt0$temp;
                    tic.setText(((File)db.getFiles().get(0)).toString());
                }
                cb.call(((File)db.getFiles().get(0)).toString());
                success = true;
            }
            event.setDropCompleted(success);
            event.consume();
        });
    }

    @FunctionalInterface
    public static interface SetCallBack {
        public void call(String var1);
    }

    public static interface SetFilesCallBack {
        public void call(List<File> var1);
    }
}

