/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui.profile;

import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValueBase;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import jrm.aui.progress.ProgressHandler;
import jrm.fx.ui.MainFrame;
import jrm.fx.ui.controls.Dialogs;
import jrm.fx.ui.profile.ProfileViewer;
import jrm.fx.ui.profile.filter.Keywords;
import jrm.fx.ui.progress.ProgressTask;
import jrm.locale.Messages;
import jrm.misc.BreakException;
import jrm.misc.Log;
import jrm.misc.ProfileSettingsEnum;
import jrm.profile.Profile;
import jrm.profile.data.Anyware;
import jrm.profile.data.AnywareList;
import jrm.profile.data.AnywareStatus;
import jrm.profile.data.Device;
import jrm.profile.data.Disk;
import jrm.profile.data.Entity;
import jrm.profile.data.EntityBase;
import jrm.profile.data.EntityStatus;
import jrm.profile.data.Machine;
import jrm.profile.data.MachineList;
import jrm.profile.data.Rom;
import jrm.profile.data.Sample;
import jrm.profile.data.Samples;
import jrm.profile.data.Software;
import jrm.profile.data.SoftwareList;
import jrm.profile.filter.Keywords;
import jrm.profile.manager.Export;
import jrm.profile.manager.ProfileNFOMame;
import jrm.security.Session;
import jrm.security.Sessions;

public class ProfileViewerController
implements Initializable {
    private static final String D_OF_D_FMT = "%d/%d";
    @FXML
    private TableView<AnywareList<? extends Anyware>> tableWL;
    @FXML
    private TableColumn<AnywareList<? extends Anyware>, AnywareList<? extends Anyware>> tableWLName;
    @FXML
    private TableColumn<AnywareList<? extends Anyware>, String> tableWLDesc;
    @FXML
    private TableColumn<AnywareList<? extends Anyware>, String> tableWLHave;
    @FXML
    private ToggleButton toggleWLUnknown;
    @FXML
    private ToggleButton toggleWLMissing;
    @FXML
    private ToggleButton toggleWLPartial;
    @FXML
    private ToggleButton toggleWLComplete;
    @FXML
    private TableView<Anyware> tableW;
    private final TableColumn<Anyware, Anyware> tableWMStatus = new TableColumn(Messages.getString((String)"MachineListRenderer.Status"));
    private final TableColumn<Anyware, Machine> tableWMName = new TableColumn(Messages.getString((String)"MachineListRenderer.Name"));
    private final TableColumn<Anyware, String> tableWMDescription = new TableColumn(Messages.getString((String)"MachineListRenderer.Description"));
    private final TableColumn<Anyware, String> tableWMHave = new TableColumn(Messages.getString((String)"MachineListRenderer.Have"));
    private final TableColumn<Anyware, Object> tableWMCloneOf = new TableColumn(Messages.getString((String)"MachineListRenderer.CloneOf"));
    private final TableColumn<Anyware, Object> tableWMRomOf = new TableColumn(Messages.getString((String)"MachineListRenderer.RomOf"));
    private final TableColumn<Anyware, Object> tableWMSampleOf = new TableColumn(Messages.getString((String)"MachineListRenderer.SampleOf"));
    private final TableColumn<Anyware, CheckBox> tableWMSelected = new TableColumn(Messages.getString((String)"MachineListRenderer.Selected"));
    private final TableColumn<Anyware, Anyware> tableWSStatus = new TableColumn(Messages.getString((String)"SoftwareListRenderer.Status"));
    private final TableColumn<Anyware, String> tableWSName = new TableColumn(Messages.getString((String)"SoftwareListRenderer.Name"));
    private final TableColumn<Anyware, String> tableWSDescription = new TableColumn(Messages.getString((String)"SoftwareListRenderer.Description"));
    private final TableColumn<Anyware, String> tableWSHave = new TableColumn(Messages.getString((String)"SoftwareListRenderer.Have"));
    private final TableColumn<Anyware, Object> tableWSCloneOf = new TableColumn(Messages.getString((String)"SoftwareListRenderer.CloneOf"));
    private final TableColumn<Anyware, CheckBox> tableWSSelected = new TableColumn(Messages.getString((String)"SoftwareListRenderer.Selected"));
    @FXML
    private ToggleButton toggleWUnknown;
    @FXML
    private ToggleButton toggleWMissing;
    @FXML
    private ToggleButton toggleWPartial;
    @FXML
    private ToggleButton toggleWComplete;
    @FXML
    private TextField search;
    @FXML
    private TableView<EntityBase> tableEntity;
    @FXML
    private TableColumn<EntityBase, EntityBase> tableEntityStatus;
    @FXML
    private TableColumn<EntityBase, EntityBase> tableEntityName;
    @FXML
    private TableColumn<EntityBase, Long> tableEntitySize;
    @FXML
    private TableColumn<EntityBase, String> tableEntityCRC;
    @FXML
    private TableColumn<EntityBase, String> tableEntityMD5;
    @FXML
    private TableColumn<EntityBase, String> tableEntitySHA1;
    @FXML
    private TableColumn<EntityBase, String> tableEntityMergeName;
    @FXML
    private TableColumn<EntityBase, Entity.Status> tableEntityDumpStatus;
    @FXML
    private ToggleButton toggleEntityUnknown;
    @FXML
    private ToggleButton toggleEntityKO;
    @FXML
    private ToggleButton toggleEntityOK;
    @FXML
    private ContextMenu menuWL;
    @FXML
    private MenuItem mntmFilteredAsLogiqxDat;
    @FXML
    private MenuItem mntmFilteredAsMameDat;
    @FXML
    private MenuItem mntmFilteredAsSoftwareLists;
    @FXML
    private MenuItem mntmAllAsLogiqxDat;
    @FXML
    private MenuItem mntmAllAsMameDat;
    @FXML
    private MenuItem mntmAllAsSoftwareLists;
    @FXML
    private MenuItem mntmSelectedFilteredAsSoftwareLists;
    @FXML
    private MenuItem mntmSelectedAsSoftwareLists;
    @FXML
    private ContextMenu menuW;
    @FXML
    private MenuItem mntmSelectByKeywords;
    @FXML
    private MenuItem mntmSelectAll;
    @FXML
    private MenuItem mntmSelectNone;
    @FXML
    private MenuItem mntmSelectInvert;
    @FXML
    private ContextMenu menuEntity;
    @FXML
    private MenuItem mntmCopyCrc;
    @FXML
    private MenuItem mntmCopySha1;
    @FXML
    private MenuItem mntmCopyName;
    @FXML
    private MenuItem mntmSearchWeb;
    private static final Image diskMultipleGreen = MainFrame.getIcon("/jrm/resicons/disk_multiple_green.png");
    private static final Image diskMultipleOrange = MainFrame.getIcon("/jrm/resicons/disk_multiple_orange.png");
    private static final Image diskMultipleRed = MainFrame.getIcon("/jrm/resicons/disk_multiple_red.png");
    private static final Image diskMultipleGray = MainFrame.getIcon("/jrm/resicons/disk_multiple_gray.png");
    private static final Image folderClosedGreen = MainFrame.getIcon("/jrm/resicons/folder_closed_green.png");
    private static final Image folderClosedOrange = MainFrame.getIcon("/jrm/resicons/folder_closed_orange.png");
    private static final Image folderClosedRed = MainFrame.getIcon("/jrm/resicons/folder_closed_red.png");
    private static final Image folderClosedGray = MainFrame.getIcon("/jrm/resicons/folder_closed_gray.png");
    private static final Image bulletGreen = MainFrame.getIcon("/jrm/resicons/icons/bullet_green.png");
    private static final Image bulletRed = MainFrame.getIcon("/jrm/resicons/icons/bullet_red.png");
    private static final Image bulletBlack = MainFrame.getIcon("/jrm/resicons/icons/bullet_black.png");
    private final Map<String, String> haveCache = new HashMap<String, String>();
    private Session session = Sessions.getSingleSession();
    private static final Font monospaced = Font.font((String)"Monospaced", (double)10.0);
    private FilteredList<Anyware> filteredData;

    public void initialize(URL location, ResourceBundle resources) {
        this.initTableWL();
        this.initTableW();
        this.initTableE();
    }

    private void initTableE() {
        this.tableEntityStatus.setCellFactory(p -> new TableCell<EntityBase, EntityBase>(this){

            protected void updateItem(EntityBase item, boolean empty) {
                if (item == null || empty) {
                    this.setText("");
                    this.setGraphic(null);
                } else {
                    this.setGraphic((Node)new ImageView(switch (item.getStatus()) {
                        case EntityStatus.KO -> bulletRed;
                        case EntityStatus.OK -> bulletGreen;
                        case EntityStatus.UNKNOWN -> bulletBlack;
                        default -> bulletBlack;
                    }));
                }
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                this.setFont(new Font(10.0));
            }
        });
        this.tableEntityStatus.setCellValueFactory(p -> new ObservableValueBase<EntityBase>(this){

            public EntityBase getValue() {
                return (EntityBase)p.getValue();
            }
        });
        this.tableEntityName.setCellFactory(p -> new TableCell<EntityBase, EntityBase>(this){
            final Image romSmall = MainFrame.getIcon("/jrm/resicons/rom_small.png");
            final Image drive = MainFrame.getIcon("/jrm/resicons/icons/drive.png");
            final Image sound = MainFrame.getIcon("/jrm/resicons/icons/sound.png");

            protected void updateItem(EntityBase item, boolean empty) {
                if (item == null || empty) {
                    this.setText("");
                    this.setGraphic(null);
                } else {
                    this.setText(item.getBaseName());
                    if (item instanceof Rom) {
                        this.setGraphic((Node)new ImageView(this.romSmall));
                    } else if (item instanceof Disk) {
                        this.setGraphic((Node)new ImageView(this.drive));
                    } else if (item instanceof Sample) {
                        this.setGraphic((Node)new ImageView(this.sound));
                    }
                }
                this.setFont(new Font(10.0));
            }
        });
        this.tableEntityName.setCellValueFactory(this.tableEntityStatus.getCellValueFactory());
        this.tableEntitySize.setMinWidth(this.getWidth(12));
        this.tableEntitySize.setPrefWidth(this.tableEntitySize.getMinWidth());
        this.tableEntitySize.setCellFactory(p -> new TableCell<EntityBase, Long>(this){

            protected void updateItem(Long item, boolean empty) {
                if (item == null || empty) {
                    this.setText("");
                } else {
                    this.setText(item.toString());
                }
                this.setFont(new Font(10.0));
                this.setTextAlignment(TextAlignment.RIGHT);
                this.setAlignment(Pos.CENTER_RIGHT);
                this.setGraphic(null);
            }
        });
        this.tableEntitySize.setCellValueFactory(p -> new ObservableValueBase<Long>(this){

            public Long getValue() {
                Object object = p.getValue();
                if (object instanceof Rom) {
                    Rom r = (Rom)object;
                    return r.getSize();
                }
                return null;
            }
        });
        this.tableEntityCRC.setMinWidth(this.getWidth(10, monospaced));
        this.tableEntityCRC.setPrefWidth(this.tableEntityCRC.getMinWidth());
        this.tableEntityCRC.setCellFactory(p -> new TableCell<EntityBase, String>(this){

            protected void updateItem(String item, boolean empty) {
                if (item == null || empty) {
                    this.setText("");
                } else {
                    this.setText(item);
                }
                this.setFont(monospaced);
                this.setGraphic(null);
            }
        });
        this.tableEntityCRC.setCellValueFactory(p -> new ObservableValueBase<String>(this){

            public String getValue() {
                Object object = p.getValue();
                if (object instanceof Rom) {
                    Rom r = (Rom)object;
                    return r.getCrc();
                }
                object = p.getValue();
                if (object instanceof Disk) {
                    Disk d = (Disk)object;
                    return d.getCrc();
                }
                return null;
            }
        });
        this.tableEntityMD5.setMinWidth(this.getWidth(34, monospaced));
        this.tableEntityMD5.setPrefWidth(this.tableEntityMD5.getMinWidth());
        this.tableEntityMD5.setCellFactory(p -> new TableCell<EntityBase, String>(this){

            protected void updateItem(String item, boolean empty) {
                if (item == null || empty) {
                    this.setText("");
                } else {
                    this.setText(item);
                }
                this.setFont(monospaced);
                this.setGraphic(null);
            }
        });
        this.tableEntityMD5.setCellValueFactory(p -> new ObservableValueBase<String>(this){

            public String getValue() {
                Object object = p.getValue();
                if (object instanceof Rom) {
                    Rom r = (Rom)object;
                    return r.getMd5();
                }
                object = p.getValue();
                if (object instanceof Disk) {
                    Disk d = (Disk)object;
                    return d.getMd5();
                }
                return null;
            }
        });
        this.tableEntitySHA1.setMinWidth(this.getWidth(42, monospaced));
        this.tableEntitySHA1.setPrefWidth(this.tableEntitySHA1.getMinWidth());
        this.tableEntitySHA1.setCellFactory(p -> new TableCell<EntityBase, String>(this){

            protected void updateItem(String item, boolean empty) {
                if (item == null || empty) {
                    this.setText("");
                } else {
                    this.setText(item);
                }
                this.setFont(monospaced);
                this.setGraphic(null);
            }
        });
        this.tableEntitySHA1.setCellValueFactory(p -> new ObservableValueBase<String>(this){

            public String getValue() {
                Object object = p.getValue();
                if (object instanceof Rom) {
                    Rom r = (Rom)object;
                    return r.getSha1();
                }
                object = p.getValue();
                if (object instanceof Disk) {
                    Disk d = (Disk)object;
                    return d.getSha1();
                }
                return null;
            }
        });
        this.tableEntityMergeName.setCellValueFactory(p -> new ObservableValueBase<String>(this){

            public String getValue() {
                Object object = p.getValue();
                if (object instanceof Rom) {
                    Rom r = (Rom)object;
                    return r.getMerge();
                }
                object = p.getValue();
                if (object instanceof Disk) {
                    Disk d = (Disk)object;
                    return d.getMerge();
                }
                return null;
            }
        });
        this.tableEntityDumpStatus.setCellFactory(p -> new TableCell<EntityBase, Entity.Status>(this){
            private static final Image verified = MainFrame.getIcon("/jrm/resicons/icons/star.png");
            private static final Image good = MainFrame.getIcon("/jrm/resicons/icons/tick.png");
            private static final Image baddump = MainFrame.getIcon("/jrm/resicons/icons/delete.png");
            private static final Image nodump = MainFrame.getIcon("/jrm/resicons/icons/error.png");

            protected void updateItem(Entity.Status item, boolean empty) {
                if (item == null || empty) {
                    this.setText("");
                    this.setGraphic(null);
                } else {
                    this.setGraphic((Node)new ImageView(switch (item) {
                        case Entity.Status.baddump -> baddump;
                        case Entity.Status.good -> good;
                        case Entity.Status.nodump -> nodump;
                        case Entity.Status.verified -> verified;
                        default -> null;
                    }));
                }
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                this.setFont(new Font(10.0));
            }
        });
        this.tableEntityDumpStatus.setCellValueFactory(p -> new ObservableValueBase<Entity.Status>(this){

            public Entity.Status getValue() {
                Object object = p.getValue();
                if (object instanceof Rom) {
                    Rom r = (Rom)object;
                    return r.getDumpStatus();
                }
                object = p.getValue();
                if (object instanceof Disk) {
                    Disk d = (Disk)object;
                    return d.getDumpStatus();
                }
                return null;
            }
        });
        this.toggleEntityUnknown.setGraphic((Node)new ImageView(bulletBlack));
        this.toggleEntityKO.setGraphic((Node)new ImageView(bulletRed));
        this.toggleEntityOK.setGraphic((Node)new ImageView(bulletGreen));
        this.menuEntity.setOnShowing(e -> {
            boolean has_selected_entity = this.tableEntity.getSelectionModel().getSelectedItem() != null;
            this.mntmCopyCrc.setDisable(!has_selected_entity);
            this.mntmCopySha1.setDisable(!has_selected_entity);
            this.mntmCopyName.setDisable(!has_selected_entity);
            this.mntmSearchWeb.setDisable(!has_selected_entity);
        });
    }

    private void getMameArgsMachine(Anyware ware, Profile profile, ProfileNFOMame mame, ArrayList<String> args) {
        ArrayList<String> rompaths = new ArrayList<String>(Collections.singletonList(profile.getProperty(ProfileSettingsEnum.roms_dest_dir)));
        if (Boolean.TRUE.equals(profile.getProperty(ProfileSettingsEnum.disks_dest_dir_enabled, Boolean.class))) {
            rompaths.add(profile.getProperty(ProfileSettingsEnum.disks_dest_dir));
        }
        args.add(mame.getFile().getAbsolutePath());
        args.add(ware.getBaseName());
        args.add("-homepath");
        args.add(mame.getFile().getParent());
        args.add("-rompath");
        args.add(rompaths.stream().collect(Collectors.joining(";")));
    }

    private void getMameArgsSofware(Anyware ware, Profile profile, ProfileNFOMame mame, ArrayList<String> args) throws HeadlessException {
        ArrayList<String> rompaths = new ArrayList<String>(Collections.singletonList(profile.getProperty(ProfileSettingsEnum.roms_dest_dir)));
        if (Boolean.TRUE.equals(profile.getProperty(ProfileSettingsEnum.swroms_dest_dir_enabled, Boolean.class))) {
            rompaths.add(profile.getProperty(ProfileSettingsEnum.swroms_dest_dir));
        }
        if (Boolean.TRUE.equals(profile.getProperty(ProfileSettingsEnum.disks_dest_dir_enabled, Boolean.class))) {
            rompaths.add(profile.getProperty(ProfileSettingsEnum.disks_dest_dir));
        }
        if (Boolean.TRUE.equals(profile.getProperty(ProfileSettingsEnum.swdisks_dest_dir_enabled, Boolean.class))) {
            rompaths.add(profile.getProperty(ProfileSettingsEnum.swdisks_dest_dir));
        }
        Log.debug(() -> ((Software)ware).getSl().getBaseName() + ", " + ((Software)ware).getCompatibility());
        ChoiceDialog machines = new ChoiceDialog(null, (Collection)profile.getMachineListList().getSortedMachines(((Software)ware).getSl().getBaseName(), ((Software)ware).getCompatibility()));
        Optional machine = machines.showAndWait();
        machine.ifPresent(m -> {
            StringBuilder device = new StringBuilder();
            for (Device dev : m.getDevices()) {
                if (!Objects.equals(((Software.Part)((Software)ware).getParts().get(0)).getIntrface(), dev.getIntrface()) || dev.getInstance() == null) continue;
                device.append("-" + dev.getInstance().getName());
                break;
            }
            Log.debug(() -> "-> " + m.getBaseName() + " " + String.valueOf(device) + " " + ware.getBaseName());
            args.add(mame.getFile().getAbsolutePath());
            args.add(m.getBaseName());
            args.add(device.toString());
            args.add(ware.getBaseName());
            args.add("-homepath");
            args.add(mame.getFile().getParent());
            args.add("-rompath");
            args.add(rompaths.stream().collect(Collectors.joining(";")));
        });
    }

    private void launchMame(Anyware ware, Profile profile) throws HeadlessException {
        ProfileNFOMame mame = profile.getNfo().getMame();
        ArrayList<String> args = new ArrayList<String>();
        if (ware instanceof Software) {
            this.getMameArgsSofware(ware, profile, mame, args);
        } else {
            this.getMameArgsMachine(ware, profile, mame, args);
        }
        if (!args.isEmpty()) {
            ProcessBuilder pb = new ProcessBuilder(args).directory(mame.getFile().getParentFile()).redirectErrorStream(true).redirectOutput(new File(mame.getFile().getParentFile(), "JRomManager.log"));
            try {
                pb.start().waitFor();
            }
            catch (IOException e1) {
                Dialogs.showError(e1);
            }
            catch (InterruptedException e1) {
                Dialogs.showError(e1);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void initTableW() {
        this.tableW.setFixedCellSize(18.0);
        this.tableWMStatus.setResizable(false);
        this.tableWMStatus.setSortable(false);
        this.tableWMStatus.setPrefWidth(20.0);
        this.tableWMStatus.setCellFactory(p -> new TableCell<Anyware, Anyware>(this){

            protected void updateItem(Anyware item, boolean empty) {
                if (item == null || empty) {
                    this.setGraphic(null);
                } else {
                    this.setGraphic((Node)new ImageView(ProfileViewerController.getStatusIcon(item.getStatus())));
                }
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                this.setText("");
            }
        });
        this.tableWMStatus.setCellValueFactory(p -> new ObservableValueBase<Anyware>(this){

            public Anyware getValue() {
                return (Anyware)p.getValue();
            }
        });
        this.tableWMName.setMinWidth(50.0);
        this.tableWMName.setPrefWidth(100.0);
        this.tableWMName.setCellFactory(p -> {
            TableCell<Anyware, Machine> cell = new TableCell<Anyware, Machine>(this){
                private static final Image applicationOSXTerminal = MainFrame.getIcon("/jrm/resicons/icons/application_osx_terminal.png");
                private static final Image computer = MainFrame.getIcon("/jrm/resicons/icons/computer.png");
                private static final Image wrench = MainFrame.getIcon("/jrm/resicons/icons/wrench.png");
                private static final Image joystick = MainFrame.getIcon("/jrm/resicons/icons/joystick.png");

                protected void updateItem(Machine item, boolean empty) {
                    if (empty) {
                        this.setText("");
                        this.setGraphic(null);
                    } else {
                        this.setText(item.getBaseName());
                        this.setUserData(item);
                        this.setTooltip(new Tooltip(item.getName()));
                        if (item.isIsbios()) {
                            this.setGraphic((Node)new ImageView(applicationOSXTerminal));
                        } else if (item.isIsdevice()) {
                            this.setGraphic((Node)new ImageView(computer));
                        } else if (item.isIsmechanical()) {
                            this.setGraphic((Node)new ImageView(wrench));
                        } else {
                            this.setGraphic((Node)new ImageView(joystick));
                        }
                    }
                    this.setFont(new Font(10.0));
                }
            };
            cell.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
                TableCell c;
                Object patt1$temp;
                Object patt0$temp;
                if (event.getClickCount() > 1 && (patt0$temp = event.getSource()) instanceof TableCell && (patt1$temp = (c = (TableCell)patt0$temp).getUserData()) instanceof Machine) {
                    Machine ware = (Machine)patt1$temp;
                    if (ware.getStatus() == AnywareStatus.COMPLETE) {
                        if (this.session.getCurrProfile() != null) {
                            Profile profile = this.session.getCurrProfile();
                            if (profile.getNfo().getMame().getStatus() == ProfileNFOMame.MameStatus.UPTODATE) {
                                this.launchMame((Anyware)ware, profile);
                            } else {
                                Dialogs.showAlert(String.format(Messages.getString((String)"ProfileViewer.MameNotAvailableOrObsolete"), profile.getNfo().getMame().getStatus()));
                            }
                        } else {
                            Dialogs.showAlert(Messages.getString((String)"ProfileViewer.NoProfile"));
                        }
                    } else {
                        Dialogs.showAlert(String.format(Messages.getString((String)"ProfileViewer.CantLaunchIncompleteSet"), ware.getStatus()));
                    }
                }
            });
            return cell;
        });
        this.tableWMName.setCellValueFactory(p -> new ObservableValueBase<Machine>(this){

            public Machine getValue() {
                Object object = p.getValue();
                if (object instanceof Machine) {
                    Machine m = (Machine)object;
                    return m;
                }
                return null;
            }
        });
        this.tableWMName.setSortable(true);
        this.tableWMDescription.setMinWidth(100.0);
        this.tableWMDescription.setPrefWidth(200.0);
        this.tableWMDescription.setCellFactory(p -> new TableCell<Anyware, String>(this){

            protected void updateItem(String item, boolean empty) {
                if (empty) {
                    this.setText("");
                } else {
                    this.setText(item);
                    this.setTooltip(new Tooltip(item));
                }
                this.setFont(new Font(10.0));
                this.setGraphic(null);
            }
        });
        this.tableWMDescription.setCellValueFactory(p -> new ObservableValueBase<String>(this){

            public String getValue() {
                return ((Anyware)p.getValue()).getDescription().toString();
            }
        });
        this.tableWMDescription.setSortable(true);
        this.tableWMHave.setResizable(false);
        this.tableWMHave.setSortable(false);
        this.tableWMHave.setPrefWidth(45.0);
        this.tableWMHave.setCellFactory(p -> new TableCell<Anyware, String>(this){

            protected void updateItem(String item, boolean empty) {
                if (empty) {
                    this.setText("");
                } else {
                    this.setText(item);
                }
                this.setFont(new Font(10.0));
                this.setTextAlignment(TextAlignment.CENTER);
                this.setAlignment(Pos.CENTER);
                this.setGraphic(null);
            }
        });
        this.tableWMHave.setCellValueFactory(p -> new ObservableValueBase<String>(this){

            public String getValue() {
                Object object = p.getValue();
                if (object instanceof Machine) {
                    Machine machine = (Machine)object;
                    return String.format(ProfileViewerController.D_OF_D_FMT, machine.countHave(), machine.countAll());
                }
                return null;
            }
        });
        this.tableWMCloneOf.setSortable(false);
        this.tableWMCloneOf.setMinWidth(50.0);
        this.tableWMCloneOf.setPrefWidth(100.0);
        this.tableWMCloneOf.setCellFactory(p -> {
            TableCell<Anyware, Object> cell = new TableCell<Anyware, Object>(this){

                protected void updateItem(Object item, boolean empty) {
                    if (item == null || empty) {
                        this.setText("");
                        this.setGraphic(null);
                    } else if (item instanceof Anyware) {
                        Anyware aw = (Anyware)item;
                        this.setGraphic((Node)new ImageView(ProfileViewerController.getStatusIcon(aw.getStatus())));
                        this.setUserData(aw);
                        this.setText(aw.getBaseName());
                    } else {
                        this.setGraphic((Node)new ImageView(folderClosedGray));
                        this.setText(item.toString());
                    }
                    this.setFont(new Font(10.0));
                }
            };
            cell.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
                TableCell c;
                Object patt1$temp;
                Object patt0$temp;
                if (event.getClickCount() > 1 && (patt0$temp = event.getSource()) instanceof TableCell && (patt1$temp = (c = (TableCell)patt0$temp).getUserData()) instanceof Anyware) {
                    Anyware ware = (Anyware)patt1$temp;
                    TableView.TableViewSelectionModel sm = this.tableW.getSelectionModel();
                    sm.clearSelection();
                    sm.select((Object)ware);
                    this.tableW.scrollTo((Object)ware);
                }
            });
            return cell;
        });
        this.tableWMCloneOf.setCellValueFactory(p -> new ObservableValueBase<Object>(){

            public Object getValue() {
                AnywareList machineList = (AnywareList)ProfileViewerController.this.tableWL.getSelectionModel().getSelectedItem();
                return Optional.ofNullable(((Anyware)p.getValue()).getCloneof()).map(cloneof -> machineList.containsName(cloneof) ? machineList.getByName(cloneof) : cloneof).orElse(null);
            }
        });
        this.tableWMRomOf.setSortable(false);
        this.tableWMRomOf.setMinWidth(50.0);
        this.tableWMRomOf.setPrefWidth(100.0);
        this.tableWMRomOf.setCellFactory(this.tableWMCloneOf.getCellFactory());
        this.tableWMRomOf.setCellValueFactory(p -> new ObservableValueBase<Object>(){

            public Object getValue() {
                Object object = p.getValue();
                if (object instanceof Machine) {
                    Machine m = (Machine)object;
                    AnywareList machineList = (AnywareList)ProfileViewerController.this.tableWL.getSelectionModel().getSelectedItem();
                    return Optional.ofNullable(m.getRomof()).filter(romof -> !romof.equals(m.getCloneof())).map(romof -> machineList.containsName(romof) ? machineList.getByName(romof) : romof).orElse(null);
                }
                return null;
            }
        });
        this.tableWMSampleOf.setSortable(false);
        this.tableWMSampleOf.setMinWidth(50.0);
        this.tableWMSampleOf.setPrefWidth(100.0);
        this.tableWMSampleOf.setCellFactory(p -> new TableCell<Anyware, Object>(this){

            protected void updateItem(Object item, boolean empty) {
                if (item == null || empty) {
                    this.setText("");
                    this.setGraphic(null);
                } else if (item instanceof Samples) {
                    Samples s = (Samples)item;
                    this.setGraphic((Node)new ImageView(ProfileViewerController.getStatusIcon(s.getStatus())));
                    this.setText(s.getBaseName());
                } else {
                    this.setGraphic((Node)new ImageView(folderClosedGray));
                    this.setText(item.toString());
                }
                this.setFont(new Font(10.0));
            }
        });
        this.tableWMSampleOf.setCellValueFactory(p -> new ObservableValueBase<Object>(){

            public Object getValue() {
                Object object = p.getValue();
                if (object instanceof Machine) {
                    Machine m = (Machine)object;
                    AnywareList awList = (AnywareList)ProfileViewerController.this.tableWL.getSelectionModel().getSelectedItem();
                    if (awList instanceof MachineList) {
                        MachineList machineList = (MachineList)awList;
                        return Optional.ofNullable(m.getSampleof()).map(sampleof -> machineList.samplesets.containsName(sampleof) ? machineList.samplesets.getByName(sampleof) : sampleof).orElse(null);
                    }
                }
                return null;
            }
        });
        this.tableWMSelected.setResizable(false);
        this.tableWMSelected.setSortable(false);
        this.tableWMSelected.setPrefWidth(20.0);
        this.tableWMSelected.setCellValueFactory(p -> {
            Anyware aw = (Anyware)p.getValue();
            CheckBox checkBox = new CheckBox();
            checkBox.selectedProperty().setValue(Boolean.valueOf(aw.isSelected()));
            checkBox.selectedProperty().addListener((ov, oldVal, newVal) -> aw.setSelected(newVal.booleanValue()));
            return new SimpleObjectProperty((Object)checkBox);
        });
        this.tableWSStatus.setResizable(false);
        this.tableWSStatus.setSortable(false);
        this.tableWSStatus.setPrefWidth(20.0);
        this.tableWSStatus.setCellFactory(this.tableWMStatus.getCellFactory());
        this.tableWSStatus.setCellValueFactory(this.tableWMStatus.getCellValueFactory());
        this.tableWSName.setSortable(true);
        this.tableWSName.setMinWidth(50.0);
        this.tableWSName.setPrefWidth(100.0);
        this.tableWSName.setCellFactory(this.tableWMDescription.getCellFactory());
        this.tableWSName.setCellValueFactory(p -> new ObservableValueBase<String>(this){

            public String getValue() {
                return ((Anyware)p.getValue()).getBaseName();
            }
        });
        this.tableWSDescription.setSortable(true);
        this.tableWSDescription.setMinWidth(200.0);
        this.tableWSDescription.setPrefWidth(400.0);
        this.tableWSDescription.setCellFactory(this.tableWMDescription.getCellFactory());
        this.tableWSDescription.setCellValueFactory(this.tableWMDescription.getCellValueFactory());
        this.tableWSHave.setResizable(false);
        this.tableWSHave.setSortable(false);
        this.tableWSHave.setPrefWidth(45.0);
        this.tableWSHave.setCellFactory(this.tableWMHave.getCellFactory());
        this.tableWSHave.setCellValueFactory(p -> new ObservableValueBase<String>(this){

            public String getValue() {
                Object object = p.getValue();
                if (object instanceof Software) {
                    Software software = (Software)object;
                    return String.format(ProfileViewerController.D_OF_D_FMT, software.countHave(), software.countAll());
                }
                return null;
            }
        });
        this.tableWSCloneOf.setSortable(false);
        this.tableWSCloneOf.setMinWidth(50.0);
        this.tableWSCloneOf.setPrefWidth(100.0);
        this.tableWSCloneOf.setCellFactory(this.tableWMCloneOf.getCellFactory());
        this.tableWSCloneOf.setCellValueFactory(p -> new ObservableValueBase<Object>(){

            public Object getValue() {
                AnywareList softwareList = (AnywareList)ProfileViewerController.this.tableWL.getSelectionModel().getSelectedItem();
                return ((Anyware)p.getValue()).getCloneof() != null ? softwareList.getByName(((Anyware)p.getValue()).getCloneof()) : null;
            }
        });
        this.tableWSSelected.setResizable(false);
        this.tableWSSelected.setSortable(false);
        this.tableWSSelected.setPrefWidth(20.0);
        this.tableWSSelected.setCellValueFactory(this.tableWMSelected.getCellValueFactory());
        this.tableW.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.reloadE((Anyware)newValue));
        this.toggleWUnknown.setGraphic((Node)new ImageView(folderClosedGray));
        this.toggleWMissing.setGraphic((Node)new ImageView(folderClosedRed));
        this.toggleWPartial.setGraphic((Node)new ImageView(folderClosedOrange));
        this.toggleWComplete.setGraphic((Node)new ImageView(folderClosedGreen));
        this.search.textProperty().addListener((observable, oldValue, newValue) -> this.filteredData.setPredicate(this.searchPredicate((String)newValue)));
    }

    private Predicate<? super Anyware> searchPredicate(String newValue) {
        return t -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lcase = newValue.toLowerCase();
            return t.getBaseName().toLowerCase().contains(lcase) || t.getDescription().toString().toLowerCase().contains(lcase);
        };
    }

    private void initTableWL() {
        this.tableWL.setFixedCellSize(18.0);
        this.tableWLName.setCellFactory(p -> new TableCellWLName());
        this.tableWLName.setCellValueFactory(ValueWLName::new);
        this.tableWLName.setSortable(true);
        this.tableWLDesc.setCellFactory(p -> new TableCellWLDesc());
        this.tableWLDesc.setCellValueFactory(ValueWLDesc::new);
        this.tableWLHave.setCellFactory(p -> new TableCellWLHave());
        this.tableWLHave.setCellValueFactory(x$0 -> new ValueWLHave((TableColumn.CellDataFeatures<AnywareList<? extends Anyware>, String>)x$0));
        this.tableWL.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.reloadW((AnywareList<? extends Anyware>)newValue));
        this.toggleWLUnknown.setGraphic((Node)new ImageView(diskMultipleGray));
        this.toggleWLMissing.setGraphic((Node)new ImageView(diskMultipleRed));
        this.toggleWLPartial.setGraphic((Node)new ImageView(diskMultipleOrange));
        this.toggleWLComplete.setGraphic((Node)new ImageView(diskMultipleGreen));
        this.menuWL.setOnShowing(e -> {
            boolean has_machines = this.session.getCurrProfile().getMachineListList().getList().stream().mapToInt(ml -> ml.getList().size()).sum() > 0;
            boolean has_filtered_machines = this.session.getCurrProfile().getMachineListList().getFilteredStream().mapToInt(m -> (int)m.countAll()).sum() > 0;
            boolean has_selected_swlist = this.tableWL.getSelectionModel().getSelectedItems().size() == 1 && this.tableWL.getSelectionModel().getSelectedItem() instanceof SoftwareList;
            this.mntmAllAsMameDat.setDisable(!has_machines);
            this.mntmAllAsLogiqxDat.setDisable(!has_machines);
            this.mntmAllAsSoftwareLists.setDisable(this.session.getCurrProfile().getMachineListList().getSoftwareListList().isEmpty());
            this.mntmFilteredAsMameDat.setDisable(!has_filtered_machines);
            this.mntmFilteredAsLogiqxDat.setDisable(!has_filtered_machines);
            this.mntmFilteredAsSoftwareLists.setDisable(this.session.getCurrProfile().getMachineListList().getSoftwareListList().getFilteredStream().count() == 0L);
            this.mntmSelectedAsSoftwareLists.setDisable(!has_selected_swlist);
            this.mntmSelectedFilteredAsSoftwareLists.setDisable(!has_selected_swlist);
        });
    }

    private void reloadE(Anyware newValue) {
        ObservableList list = FXCollections.observableArrayList();
        if (newValue != null) {
            newValue.resetCache();
            for (EntityBase e : newValue.getEntities()) {
                list.add((Object)e);
            }
        }
        this.tableEntity.setItems(list);
    }

    private void reloadW(AnywareList<? extends Anyware> newValue) {
        this.tableW.getColumns().clear();
        ObservableList list = FXCollections.observableArrayList();
        if (newValue != null) {
            newValue.resetCache();
            if (newValue instanceof MachineList) {
                MachineList ml = (MachineList)newValue;
                this.tableW.getColumns().add(this.tableWMStatus);
                this.tableW.getColumns().add(this.tableWMName);
                this.tableW.getColumns().add(this.tableWMDescription);
                this.tableW.getColumns().add(this.tableWMHave);
                this.tableW.getColumns().add(this.tableWMCloneOf);
                this.tableW.getColumns().add(this.tableWMRomOf);
                this.tableW.getColumns().add(this.tableWMSampleOf);
                this.tableW.getColumns().add(this.tableWMSelected);
                for (Machine w : ml.getFilteredList()) {
                    list.add((Object)w);
                }
            } else if (newValue instanceof SoftwareList) {
                SoftwareList sl = (SoftwareList)newValue;
                this.tableW.getColumns().add(this.tableWSStatus);
                this.tableW.getColumns().add(this.tableWSName);
                this.tableW.getColumns().add(this.tableWSDescription);
                this.tableW.getColumns().add(this.tableWSHave);
                this.tableW.getColumns().add(this.tableWSCloneOf);
                this.tableW.getColumns().add(this.tableWSSelected);
                for (Software w : sl.getFilteredList()) {
                    list.add((Object)w);
                }
            }
        }
        this.filteredData = new FilteredList(list, this.searchPredicate(this.search.getText()));
        this.tableW.setItems(this.filteredData);
        this.tableW.getSelectionModel().select(0);
    }

    @FXML
    void diskMultipleFilter(ActionEvent e) {
        this.setFilterWL(this.toggleWLUnknown.isSelected(), this.toggleWLMissing.isSelected(), this.toggleWLPartial.isSelected(), this.toggleWLComplete.isSelected());
    }

    @FXML
    void folderFilter(ActionEvent e) {
        this.setFilterW(this.toggleWUnknown.isSelected(), this.toggleWMissing.isSelected(), this.toggleWPartial.isSelected(), this.toggleWComplete.isSelected());
    }

    @FXML
    void bulletFilter(ActionEvent e) {
        this.setFilterE(this.toggleEntityUnknown.isSelected(), this.toggleEntityKO.isSelected(), this.toggleEntityOK.isSelected());
    }

    private void setFilterWL(boolean unknown, boolean missing, boolean partial, boolean complete) {
        EnumSet<AnywareStatus> filter = EnumSet.noneOf(AnywareStatus.class);
        if (unknown) {
            filter.add(AnywareStatus.UNKNOWN);
        }
        if (missing) {
            filter.add(AnywareStatus.MISSING);
        }
        if (partial) {
            filter.add(AnywareStatus.PARTIAL);
        }
        if (complete) {
            filter.add(AnywareStatus.COMPLETE);
        }
        this.session.getCurrProfile().setFilterListLists(filter);
        this.reset(this.session.getCurrProfile());
    }

    private void setFilterW(boolean unknown, boolean missing, boolean partial, boolean complete) {
        EnumSet<AnywareStatus> filter = EnumSet.noneOf(AnywareStatus.class);
        if (unknown) {
            filter.add(AnywareStatus.UNKNOWN);
        }
        if (missing) {
            filter.add(AnywareStatus.MISSING);
        }
        if (partial) {
            filter.add(AnywareStatus.PARTIAL);
        }
        if (complete) {
            filter.add(AnywareStatus.COMPLETE);
        }
        this.session.getCurrProfile().setFilterList(filter);
        AnywareList item = (AnywareList)this.tableWL.getSelectionModel().getSelectedItem();
        if (item != null) {
            this.reloadW((AnywareList<? extends Anyware>)item);
        }
    }

    private void setFilterE(boolean unknown, boolean missing, boolean complete) {
        EnumSet<EntityStatus> filter = EnumSet.noneOf(EntityStatus.class);
        if (unknown) {
            filter.add(EntityStatus.UNKNOWN);
        }
        if (missing) {
            filter.add(EntityStatus.KO);
        }
        if (complete) {
            filter.add(EntityStatus.OK);
        }
        this.session.getCurrProfile().setFilterEntities(filter);
        Anyware item = (Anyware)this.tableW.getSelectionModel().getSelectedItem();
        if (item != null) {
            this.reloadE(item);
        }
    }

    private static Image getStatusIcon(AnywareStatus status) {
        return switch (status) {
            case AnywareStatus.COMPLETE -> folderClosedGreen;
            case AnywareStatus.PARTIAL -> folderClosedOrange;
            case AnywareStatus.MISSING -> folderClosedRed;
            case AnywareStatus.UNKNOWN -> folderClosedGray;
            default -> folderClosedGray;
        };
    }

    private double getWidth(int digits) {
        return this.getWidth(digits, null);
    }

    private double getWidth(int digits, Font font) {
        String format = "%0" + digits + "d";
        Text text = new Text(String.format(format, 0));
        text.setFont(font == null ? new Font(10.0) : font);
        return text.getBoundsInLocal().getWidth();
    }

    void clear() {
        this.tableEntity.setItems(FXCollections.observableArrayList());
        this.tableW.setItems(FXCollections.observableArrayList());
        this.tableWL.setItems(FXCollections.observableArrayList());
        this.haveCache.clear();
    }

    void reload() {
        this.tableWL.refresh();
        this.haveCache.clear();
        this.tableW.refresh();
        this.tableEntity.refresh();
    }

    void reset(Profile profile) {
        AnywareList selected = (AnywareList)this.tableWL.getSelectionModel().getSelectedItem();
        this.clear();
        ObservableList wl = FXCollections.observableArrayList();
        profile.getMachineListList().resetCache();
        for (MachineList w : profile.getMachineListList().getFilteredList()) {
            wl.add((Object)w);
        }
        profile.getMachineListList().getSoftwareListList().resetCache();
        for (MachineList w : profile.getMachineListList().getSoftwareListList().getFilteredList()) {
            wl.add((Object)w);
        }
        this.tableWL.setItems(wl);
        if (selected != null) {
            int index = this.tableWL.getItems().indexOf((Object)selected);
            if (index >= 0) {
                this.tableWL.getSelectionModel().select(index);
            }
        } else {
            this.tableWL.getSelectionModel().select(0);
        }
        this.tableWL.refresh();
    }

    @FXML
    private void selectByKeywords(ActionEvent e) {
        AnywareList lst = (AnywareList)this.tableWL.getSelectionModel().getSelectedItem();
        new KW().filter(lst);
    }

    @FXML
    private void selectNone(ActionEvent e) {
        this.tableW.getItems().forEach(ware -> ware.setSelected(false));
        this.tableW.refresh();
    }

    @FXML
    private void selectAll(ActionEvent e) {
        this.tableW.getItems().forEach(ware -> ware.setSelected(true));
        this.tableW.refresh();
    }

    @FXML
    private void selectInvert(ActionEvent e) {
        this.tableW.getItems().forEach(ware -> ware.setSelected(!ware.isSelected()));
        this.tableW.refresh();
    }

    @FXML
    private void copyCrc(ActionEvent e) {
        Object object;
        if (this.tableEntity.getSelectionModel().getSelectedItem() != null && (object = this.tableEntity.getSelectionModel().getSelectedItem()) instanceof Entity) {
            Entity entity = (Entity)object;
            ClipboardContent content = new ClipboardContent();
            content.putString(entity.getCrc());
            Clipboard.getSystemClipboard().setContent((Map)content);
        }
    }

    @FXML
    private void copySha1(ActionEvent e) {
        Object object;
        if (this.tableEntity.getSelectionModel().getSelectedItem() != null && (object = this.tableEntity.getSelectionModel().getSelectedItem()) instanceof Entity) {
            Entity entity = (Entity)object;
            ClipboardContent content = new ClipboardContent();
            content.putString(entity.getSha1());
            Clipboard.getSystemClipboard().setContent((Map)content);
        }
    }

    @FXML
    private void copyName(ActionEvent e) {
        Object object;
        if (this.tableEntity.getSelectionModel().getSelectedItem() != null && (object = this.tableEntity.getSelectionModel().getSelectedItem()) instanceof Entity) {
            Entity entity = (Entity)object;
            ClipboardContent content = new ClipboardContent();
            content.putString(entity.getName());
            Clipboard.getSystemClipboard().setContent((Map)content);
        }
    }

    @FXML
    private void searchWeb(ActionEvent e) {
        Object object;
        if (this.tableEntity.getSelectionModel().getSelectedItem() != null && (object = this.tableEntity.getSelectionModel().getSelectedItem()) instanceof Entity) {
            Entity entity = (Entity)object;
            try {
                String name = entity.getName();
                String crc = entity.getCrc();
                String sha1 = entity.getSha1();
                String hash = Optional.ofNullable(Optional.ofNullable(crc).orElse(sha1)).map(h -> "+" + h).orElse("");
                MainFrame.getApplication().getHostServices().showDocument(new URI("https://www.google.com/search?q=" + URLEncoder.encode("\"" + name + "\"", "UTF-8") + hash).toString());
            }
            catch (IOException | URISyntaxException e1) {
                Log.err((String)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    @FXML
    private void exportFilteredAsLogiqxDat(ActionEvent e) {
        this.export(Export.ExportType.DATAFILE, true, null);
    }

    @FXML
    private void exportFilteredAsMameDat(ActionEvent e) {
        this.export(Export.ExportType.MAME, true, null);
    }

    @FXML
    private void exportFilteredAsSoftwareLists(ActionEvent e) {
        this.export(Export.ExportType.SOFTWARELIST, true, null);
    }

    @FXML
    private void exportAllAsLogiqxDat(ActionEvent e) {
        this.export(Export.ExportType.DATAFILE, false, null);
    }

    @FXML
    private void exportAllAsMameDat(ActionEvent e) {
        this.export(Export.ExportType.MAME, false, null);
    }

    @FXML
    private void exportAllAsSoftwareLists(ActionEvent e) {
        this.export(Export.ExportType.SOFTWARELIST, false, null);
    }

    @FXML
    private void exportSelectedFilteredAsSoftwareLists(ActionEvent e) {
        Object object = this.tableWL.getSelectionModel().getSelectedItem();
        if (object instanceof SoftwareList) {
            SoftwareList sl = (SoftwareList)object;
            this.export(Export.ExportType.SOFTWARELIST, true, sl);
        }
    }

    @FXML
    private void exportSelectedAsSoftwareLists(ActionEvent e) {
        Object object = this.tableWL.getSelectionModel().getSelectedItem();
        if (object instanceof SoftwareList) {
            SoftwareList sl = (SoftwareList)object;
            this.export(Export.ExportType.SOFTWARELIST, false, sl);
        }
    }

    private void export(final Export.ExportType type, final boolean filtered, final SoftwareList selection) {
        FileChooser chooser = new FileChooser();
        Optional.ofNullable(this.session.getUser().getSettings().getProperty("MainFrame.ChooseExeOrDatToExport", (String)null)).map(File::new).ifPresent(arg_0 -> ((FileChooser)chooser).setInitialDirectory(arg_0));
        chooser.setTitle(Messages.getString((String)"ProfileViewer.ChooseDestinationFile"));
        FileChooser.ExtensionFilter fnef = new FileChooser.ExtensionFilter(Messages.getString((String)"MainFrame.DatFile"), new String[]{"xml", "dat"});
        chooser.getExtensionFilters().add((Object)fnef);
        chooser.setSelectedExtensionFilter(fnef);
        final File chosen = chooser.showSaveDialog(this.tableWL.getScene().getWindow());
        if (chosen != null) {
            try {
                Thread thread = new Thread((Runnable)((Object)new ProgressTask<Void>((Stage)this.tableWL.getScene().getWindow()){

                    protected Void call() throws Exception {
                        Export.export((Profile)ProfileViewerController.this.session.getCurrProfile(), (File)chosen, (Export.ExportType)type, (boolean)filtered, (SoftwareList)selection, (ProgressHandler)this);
                        return null;
                    }

                    protected void succeeded() {
                        this.close();
                    }

                    protected void failed() {
                        this.close();
                        if (this.getException() instanceof BreakException) {
                            Dialogs.showAlert("Cancelled");
                        } else {
                            Optional.ofNullable(this.getException().getCause()).ifPresentOrElse(cause -> {
                                Log.err((String)cause.getMessage(), (Throwable)cause);
                                Dialogs.showError(cause);
                            }, () -> {
                                Log.err((String)this.getException().getMessage(), (Throwable)this.getException());
                                Dialogs.showError(this.getException());
                            });
                        }
                    }
                }));
                thread.setDaemon(true);
                thread.start();
            }
            catch (IOException | URISyntaxException e) {
                Log.err((String)e.getMessage(), (Throwable)e);
                Dialogs.showError(e);
            }
        }
    }

    private class KW
    extends jrm.profile.filter.Keywords {
        private KW() {
        }

        protected void showFilter(String[] keywords, Keywords.KFCallBack callback) {
            try {
                new Keywords((ProfileViewer)ProfileViewerController.this.tableWL.getScene().getWindow(), keywords, (AnywareList<? extends Anyware>)((AnywareList)ProfileViewerController.this.tableWL.getSelectionModel().getSelectedItem()), callback);
            }
            catch (IOException | URISyntaxException e1) {
                e1.printStackTrace();
            }
        }

        protected void updateList() {
            ProfileViewerController.this.tableW.refresh();
        }
    }

    private final class ValueWLHave
    extends ObservableValueBase<String> {
        private final TableColumn.CellDataFeatures<AnywareList<? extends Anyware>, String> p;

        private ValueWLHave(TableColumn.CellDataFeatures<AnywareList<? extends Anyware>, String> p) {
            this.p = p;
        }

        public String getValue() {
            return ProfileViewerController.this.haveCache.computeIfAbsent(((AnywareList)this.p.getValue()).getName(), k -> {
                long[] ht = new long[]{0L, 0L};
                ((AnywareList)this.p.getValue()).getFilteredStream().forEach(t -> {
                    if (t.getStatus() == AnywareStatus.COMPLETE) {
                        ht[0] = ht[0] + 1L;
                    }
                    ht[1] = ht[1] + 1L;
                });
                return String.format(ProfileViewerController.D_OF_D_FMT, ht[0], ht[1]);
            });
        }
    }

    private static final class TableCellWLHave
    extends TableCell<AnywareList<? extends Anyware>, String> {
        private TableCellWLHave() {
        }

        protected void updateItem(String item, boolean empty) {
            if (empty) {
                this.setText("");
            } else {
                this.setText(item);
            }
            this.setFont(new Font(10.0));
            this.setTextAlignment(TextAlignment.CENTER);
            this.setAlignment(Pos.CENTER);
            this.setGraphic(null);
        }
    }

    private static final class TableCellWLDesc
    extends TableCell<AnywareList<? extends Anyware>, String> {
        private TableCellWLDesc() {
        }

        protected void updateItem(String item, boolean empty) {
            if (empty) {
                this.setText("");
            } else {
                this.setText(item);
            }
            this.setTooltip(new Tooltip(this.getText()));
            this.setFont(new Font(10.0));
            this.setGraphic(null);
        }
    }

    private static final class TableCellWLName
    extends TableCell<AnywareList<? extends Anyware>, AnywareList<? extends Anyware>> {
        private TableCellWLName() {
        }

        protected void updateItem(AnywareList<? extends Anyware> item, boolean empty) {
            if (empty) {
                this.setText("");
                this.setGraphic(null);
            } else {
                this.setGraphic((Node)new ImageView(switch (item.getStatus()) {
                    case AnywareStatus.COMPLETE -> diskMultipleGreen;
                    case AnywareStatus.PARTIAL -> diskMultipleOrange;
                    case AnywareStatus.MISSING -> diskMultipleRed;
                    case AnywareStatus.UNKNOWN -> diskMultipleGray;
                    default -> diskMultipleGray;
                }));
                if (item instanceof SoftwareList) {
                    SoftwareList sl = (SoftwareList)item;
                    this.setText(sl.getName());
                } else if (item instanceof MachineList) {
                    this.setText(Messages.getString((String)"MachineListListRenderer.*"));
                }
            }
            this.setTooltip(new Tooltip(this.getText()));
            this.setFont(new Font(10.0));
        }
    }

    private static final class ValueWLName
    extends ObservableValueBase<AnywareList<? extends Anyware>> {
        private final TableColumn.CellDataFeatures<AnywareList<? extends Anyware>, AnywareList<? extends Anyware>> p;

        private ValueWLName(TableColumn.CellDataFeatures<AnywareList<? extends Anyware>, AnywareList<? extends Anyware>> p) {
            this.p = p;
        }

        public AnywareList<? extends Anyware> getValue() {
            return (AnywareList)this.p.getValue();
        }
    }

    private static final class ValueWLDesc
    extends ObservableValueBase<String> {
        private final TableColumn.CellDataFeatures<AnywareList<? extends Anyware>, String> p;

        private ValueWLDesc(TableColumn.CellDataFeatures<AnywareList<? extends Anyware>, String> p) {
            this.p = p;
        }

        public String getValue() {
            Object object = this.p.getValue();
            if (object instanceof SoftwareList) {
                SoftwareList sl = (SoftwareList)object;
                return sl.getDescription().toString();
            }
            return Messages.getString((String)"MachineListList.AllMachines");
        }
    }
}

