/*
 * Decompiled with CFR 0.152.
 */
package jrm.fx.ui.profile.manager;

import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import jrm.profile.manager.ProfileNFOStats;

public final class HaveNTotalCellFactory<T>
extends TableCell<T, ProfileNFOStats.HaveNTotal> {
    protected void updateItem(ProfileNFOStats.HaveNTotal hnt, boolean empty) {
        this.setAlignment(Pos.CENTER);
        this.setGraphic(null);
        this.setStyle("");
        if (hnt == null || empty) {
            this.setText("");
        } else if (hnt.getHave() == null) {
            if (hnt.getTotal() == null) {
                this.setTextFill((Paint)(this.getTableRow().isSelected() ? Color.LIGHTGRAY : Color.GRAY));
                this.setText("?/?");
            } else {
                TextFlow tf = new TextFlow();
                Text have = new Text("?");
                Text total = new Text(String.format("/%d", hnt.getTotal()));
                have.setFill((Paint)(this.getTableRow().isSelected() ? Color.LIGHTGRAY : Color.GRAY));
                total.setFill((Paint)(this.getTableRow().isSelected() ? Color.WHITE : Color.BLACK));
                tf.getChildren().add((Object)have);
                tf.getChildren().add((Object)total);
                tf.setMinWidth(Double.NEGATIVE_INFINITY);
                tf.setPrefWidth(-1.0);
                tf.setTextAlignment(TextAlignment.CENTER);
                tf.setPrefHeight(10.0);
                this.setGraphic((Node)tf);
            }
        } else {
            TextFlow tf = new TextFlow();
            Text have = new Text(hnt.getHave().toString());
            Text total = new Text(String.format("/%d", hnt.getTotal()));
            total.setFill((Paint)(this.getTableRow().isSelected() ? Color.WHITE : Color.BLACK));
            if (hnt.getHave() == 0L && hnt.getTotal() > 0L) {
                have.setFill((Paint)(this.getTableRow().isSelected() ? Color.web((String)"#ffaaaa") : Color.web((String)"#cc0000")));
            } else if (hnt.getHave().equals(hnt.getTotal())) {
                have.setFill((Paint)(this.getTableRow().isSelected() ? Color.web((String)"#aaffaa") : Color.web((String)"#00aa00")));
            } else {
                have.setFill((Paint)(this.getTableRow().isSelected() ? Color.web((String)"#ffaa88") : Color.web((String)"#cc8800")));
            }
            tf.getChildren().addAll((Object[])new Node[]{have, total});
            tf.setMinWidth(Double.NEGATIVE_INFINITY);
            tf.setPrefWidth(-1.0);
            tf.setTextAlignment(TextAlignment.CENTER);
            tf.setPrefHeight(10.0);
            this.setGraphic((Node)tf);
        }
    }
}

